' MIDI and MCI API
Declare Function mciExecute Lib "mmsystem.dll" (ByVal a$) As Integer
Declare Function mciSendString Lib "mmsystem.dll" (ByVal lpstrCommand$, ByVal lpstrRtnString$, ByVal wRtnLength As Integer, ByVal hCallback As Integer) As String

Global FullFilePath As String
Global SongFileOpened As Integer
Global SongTempo As Integer
Global SongLength As Integer

'Current MIDI Out Port that is selected
Global MidiOutPort As Integer

' Booleans
Global Const MODAL = 1

Sub GetSongLength ()
    Dim RtnString As String
    Dim Action As String

    RtnString = Space(32)
    Action = "Status " + "MCIMidi " + "length"
    Action = mciSendString(Action, RtnString, 100, 0)
    SongLength = Int(Val(RtnString) / 4)
    SongPlayer.LabelSongLength.Caption = "Total Length " + Str$(Int((60 / SongTempo) * SongLength / 60)) + ":" + Format$(Int((60 / SongTempo) * SongLength) Mod 60, "00")
End Sub

Sub GetSongTempo ()
    Dim RtnString As String
    Dim Action As String

    RtnString = Space(32)
    Action = "Status " + "MCIMidi " + "tempo"
    Action = mciSendString(Action$, RtnString, 100, 0)
    SongTempo = Val(RtnString)
End Sub

Sub OpenSongFile ()
    Dim I As Integer
    Screen.MousePointer = 11
	    
    SongPlayer.CMDialog1.DialogTitle = "Open Song File"
    ' Set the "Open File..." dialog to display *.mid files.
    SongPlayer.CMDialog1.Filter = "MIDI File (*.mid)|*.mid"
	    

    ' Display the File Open... dialog.
    SongPlayer.CMDialog1.FilterIndex = 1
    SongPlayer.CMDialog1.Flags = OFN_READONLY Or OFN_FILEMUSTEXIST
    SongPlayer.CMDialog1.CancelError = True
    SongPlayer.CMDialog1.Filename = ""
    On Error Resume Next
    SongPlayer.CMDialog1.Action = 1

    If Err <> 0 Then
	' No file selected from the "Open File..." dialog.
	Screen.MousePointer = 0
	Exit Sub
    End If

    SongPlayer.Caption = "MCI Song Player - " + SongPlayer.CMDialog1.Filetitle
    If SongFileOpened = True Then
	' Close previous song file
	Action$ = "Close " + "MCIMidi"
	I = mciExecute(Action$)
    End If
    
    ' Open selected song file
    Action$ = "Open " + SongPlayer.CMDialog1.Filename + " alias " + "MCIMidi"
    I = mciExecute(Action$)

    On Error GoTo 0
    
    SongFileOpened = True
    
    RewindFlag = True
    SongPlayer.Label1.Caption = " 0:00"
    SongPlayer.MeasureScroll.Value = 0

    ' Get song tempo
    GetSongTempo
    SongPlayer.TempoLabel.Text = Str$(SongTempo)
    
    ' Get song length
    GetSongLength
	
    ' Setup Measure Scroll Bar
    SongPlayer.MeasureScroll.Max = SongLength
    
    'Enable the play control once SMF is loaded
    SongPlayer.Cmd_Play.Enabled = True
    SongPlayer.Cmd_Stop.Enabled = False
    SongPlayer.Cmd_Rewind.Enabled = True
    SongPlayer.MeasureScroll.Enabled = True
    SongPlayer.VSliderTempo.Enabled = True
    SongPlayer.TempoLabel.Enabled = True

    Screen.MousePointer = 0
End Sub

Sub SetTempo ()
    Dim I As Integer

    If SongFileOpened = True Then
	'Set song tempo
	Action$ = "SET " + "MCIMidi " + "TEMPO " + Str$(SongTempo)
	I = mciExecute(Action$)
	SongPlayer.LabelSongLength.Caption = "Total Length " + Str$(Int((60 / SongTempo) * SongLength / 60)) + ":" + Format$(Int((60 / SongTempo) * SongLength) Mod 60, "00")
    End If
End Sub

