Option Explicit

Global Const modal = 1
Global Const CASCADE = 0
Global Const TILE_HORIZONTAL = 1
Global Const TILE_VERTICAL = 2
Global Const ARRANGE_ICONS = 3


Global Const REPLACE_CANCEL = 0
Global Const REPLACE_YES = 1
Global Const REPLACE_NO = 2
Global Const REPLACE_ONE = 3
Global Const REPLACE_ALL = 4


' globals used to manage MDI child windows...
Type FormState
    Deleted As Integer
    Color As Long
End Type
Global FState()  As FormState
Global document() As New frmNotePad
Global ArrayNum As Integer

Global gfInsertMode As Integer ' insert mode : True=insert, False=Overwrite
Global gfBlockType As Integer ' block type : 0=Stream, 1=Line, 2=Column
Global gfRecursiveSearch As Integer


' API functions used to read and write to EMEDIT.INI.
' Used for handling the recent files list.
Declare Function GetPrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer, ByVal lpFileName As String) As Integer
Declare Function WritePrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lpString As String, ByVal lplFileName As String) As Integer

Global Const SM_CXBORDER = 5
Declare Function GetSystemMetrics Lib "User" (ByVal nIndex As Integer) As Integer



' Key Codes
Global Const KEY_LBUTTON = &H1
Global Const KEY_RBUTTON = &H2
Global Const KEY_CANCEL = &H3
Global Const KEY_MBUTTON = &H4    ' NOT contiguous with L & RBUTTON
Global Const KEY_BACK = &H8
Global Const KEY_TAB = &H9
Global Const KEY_CLEAR = &HC
Global Const KEY_RETURN = &HD
Global Const KEY_SHIFT = &H10
Global Const KEY_CONTROL = &H11
Global Const KEY_MENU = &H12
Global Const KEY_PAUSE = &H13
Global Const KEY_CAPITAL = &H14
Global Const KEY_ESCAPE = &H1B
Global Const KEY_SPACE = &H20
Global Const KEY_PRIOR = &H21
Global Const KEY_NEXT = &H22
Global Const KEY_END = &H23
Global Const KEY_HOME = &H24
Global Const KEY_LEFT = &H25
Global Const KEY_UP = &H26
Global Const KEY_RIGHT = &H27
Global Const KEY_DOWN = &H28
Global Const KEY_SELECT = &H29
Global Const KEY_PRINT = &H2A
Global Const KEY_EXECUTE = &H2B
Global Const KEY_SNAPSHOT = &H2C
Global Const KEY_INSERT = &H2D
Global Const KEY_DELETE = &H2E
Global Const KEY_HELP = &H2F

' KEY_A thru KEY_Z are the same as their ASCII equivalents: 'A' thru 'Z'
' KEY_0 thru KEY_9 are the same as their ASCII equivalents: '0' thru '9'

Global Const KEY_NUMPAD0 = &H60
Global Const KEY_NUMPAD1 = &H61
Global Const KEY_NUMPAD2 = &H62
Global Const KEY_NUMPAD3 = &H63
Global Const KEY_NUMPAD4 = &H64
Global Const KEY_NUMPAD5 = &H65
Global Const KEY_NUMPAD6 = &H66
Global Const KEY_NUMPAD7 = &H67
Global Const KEY_NUMPAD8 = &H68
Global Const KEY_NUMPAD9 = &H69
Global Const KEY_MULTIPLY = &H6A
Global Const KEY_ADD = &H6B
Global Const KEY_SEPARATOR = &H6C
Global Const KEY_SUBTRACT = &H6D
Global Const KEY_DECIMAL = &H6E
Global Const KEY_DIVIDE = &H6F
Global Const KEY_F1 = &H70
Global Const KEY_F2 = &H71
Global Const KEY_F3 = &H72
Global Const KEY_F4 = &H73
Global Const KEY_F5 = &H74
Global Const KEY_F6 = &H75
Global Const KEY_F7 = &H76
Global Const KEY_F8 = &H77
Global Const KEY_F9 = &H78
Global Const KEY_F10 = &H79
Global Const KEY_F11 = &H7A
Global Const KEY_F12 = &H7B
Global Const KEY_F13 = &H7C
Global Const KEY_F14 = &H7D
Global Const KEY_F15 = &H7E
Global Const KEY_F16 = &H7F

Global Const KEY_NUMLOCK = &H90

'File Open/Save Dialog Flags
Global Const OFN_READONLY = &H1&
Global Const OFN_OVERWRITEPROMPT = &H2&
Global Const OFN_HIDEREADONLY = &H4&
Global Const OFN_NOCHANGEDIR = &H8&
Global Const OFN_SHOWHELP = &H10&
Global Const OFN_NOVALIDATE = &H100&
Global Const OFN_ALLOWMULTISELECT = &H200&
Global Const OFN_EXTENTIONDIFFERENT = &H400&
Global Const OFN_PATHMUSTEXIST = &H800&
Global Const OFN_FILEMUSTEXIST = &H1000&
Global Const OFN_CREATEPROMPT = &H2000&
Global Const OFN_SHAREAWARE = &H4000&
Global Const OFN_NOREADONLYRETURN = &H8000&

Function AnyPadsLeft () As Integer
    Dim I As Integer

    ' Cycle throught the document array.
    ' Return True if there is at least one
    ' open document remaining.
    For I = 1 To UBound(document)
	If Not FState(I).Deleted Then
	    AnyPadsLeft = True
	    Exit Function
	End If
    Next

End Function

Sub CenterForm (frmParent As Form, frmChild As Form)
' This procedure centers a child form over a parent form.
' Calling this routine loads the dialog. Use the Show method
' to display the dialog after calling this routine ( ie MyFrm.Show 1)

Dim l, t
  ' get left offset
  l = frmParent.Left + ((frmParent.Width - frmChild.Width) / 2)
  If (l + frmChild.Width > screen.Width) Then
    l = screen.Width = frmChild.Width
  End If

  ' get top offset
  t = frmParent.Top + ((frmParent.Height - frmChild.Height) / 2)
  If (t + frmChild.Height > screen.Height) Then
    t = screen.Height - frmChild.Height
  End If

  ' center the child formfv
  frmChild.Move l, t

End Sub

Sub DisplayError ()
    MsgBox Error$, 48, App.Title ' 48=MB_OK+MB_ICONEXCLAMATION
End Sub

Sub EditClearAllProc ()

    frmMDI.ActiveForm.Text1.Redraw = False

    ' Mark a block that starts with the first character in the first line and
    ' ends with the last character in the last line...
    frmMDI.ActiveForm.Text1.SelMark = 1 'make a stream block
    frmMDI.ActiveForm.Text1.SelStartX = 1
    frmMDI.ActiveForm.Text1.SelStartY = 1
    frmMDI.ActiveForm.Text1.SelEndY = frmMDI.ActiveForm.Text1.Count
    frmMDI.ActiveForm.Text1.TextIndex = frmMDI.ActiveForm.Text1.Count
    frmMDI.ActiveForm.Text1.SelEndX = Len(frmMDI.ActiveForm.Text1.TextIndex) + 1

    frmMDI.ActiveForm.Text1.Action = 4  'clear

    frmMDI.ActiveForm.Text1.Redraw = True
    
End Sub

Sub EditCopyProc ()
    ' copy selection to clipboard
    frmMDI.ActiveForm.Text1.Action = 1

    ' Alternatively, we could cut selected text to
    ' Clipboard by sending a Control-Insert key to the
    ' active window...
    'SendKeys "^{INSERT}", True 'wait for text to be cut
End Sub

Sub EditCutProc ()
    ' cut selection to clipboard
    frmMDI.ActiveForm.Text1.Action = 3
End Sub

Sub EditDeleteProc ()
    ' cut selection to clipboard
    frmMDI.ActiveForm.Text1.Action = 4 'clear
End Sub

Sub EditPasteProc ()
    ' Place text from Clipboard into active control.
    frmMDI.ActiveForm.Text1.Action = 2 ' paste selection
End Sub

Sub EditUndoProc ()
    ' undo the last edit
    frmMDI.ActiveForm.Text1.Action = 6 'undo
End Sub

Sub EditWrapAutomaticallyProc ()
    Dim bAuto As Integer
    bAuto = Not frmMDI.ActiveForm.Text1.WrapAutomatically
    frmMDI.ActiveForm.Text1.WrapAutomatically = bAuto
End Sub

Sub EditWrapFormatProc ()
    ' wrap any selected text to fit the current window
    frmMDI.ActiveForm.Text1.WrapX = -1 'wrap to current window size
    frmMDI.ActiveForm.Text1.Action = 5 'wrap selection
End Sub

Sub FileNew ()
    Dim fIndex As Integer

    fIndex = FindFreeIndex()
    document(fIndex).Tag = fIndex
    document(fIndex).Caption = "Untitled:" & fIndex
    document(fIndex).Show

    UpdateToolBar
End Sub

Function FindFreeIndex () As Integer
    Static NotFirstTime As Integer
    If NotFirstTime Then
	Dim I As Integer
	Dim ArrayCount As Integer
    
	ArrayCount = UBound(document)
    
	' Cycle throught the document array. If one of the
	' documents has been deleted, then return that
	' index.
	For I = 1 To ArrayCount
	    If FState(I).Deleted Then
		FindFreeIndex = I
		FState(I).Deleted = False
		document(I).Tag = I
		Exit Function
	    End If
	Next
    
	' If none of the elements in the document array have
	' been deleted, then increment the document and the
	' state arrays by one and return the index to the
	' new element.
    
	ReDim Preserve document(ArrayCount + 1)
	ReDim Preserve FState(ArrayCount + 1)
	Dim FreeIndex As Integer
	FreeIndex = UBound(document)
	document(FreeIndex).Tag = FreeIndex
	FindFreeIndex = FreeIndex
    Else
	'Initialize document form arrays, and show first document.
	ReDim document(1)
	ReDim FState(1)
	document(1).Tag = 1
	FindFreeIndex = 1
	NotFirstTime = True
    End If
End Function

Function FindIt (TargetText As String, MatchCase As Integer, WholeWordOnly As Integer, UpDirection As Integer, BeginScope As Integer, NewText As String, fReplace As Integer) As Integer
    FindIt = False

    'make sure the current form's display is up to date...
    frmMDI.ActiveForm.Refresh

    ' change mousepointer to an hourglass
    Dim OldMousePointer As Integer
    OldMousePointer = screen.MousePointer
    screen.MousePointer = 11

    ' If we wern't given a string to look for then don't do anything...
    If TargetText = "" Then Exit Function

    frmMDI.ActiveForm.Text1.SearchReplacement = NewText
    frmMDI.ActiveForm.Text1.SearchTarget = TargetText

    If BeginScope Then
      frmMDI.ActiveForm.Text1.SearchOrigin = 1 'search entire scope
    Else
      frmMDI.ActiveForm.Text1.SearchOrigin = 0 'search from cursor
    End If

    If UpDirection Then
      frmMDI.ActiveForm.Text1.SearchTo = 0 'search to top of file
    Else
      frmMDI.ActiveForm.Text1.SearchTo = 1 'search to bottom of file
    End If

    If MatchCase Then
      frmMDI.ActiveForm.Text1.SearchCaseSensitive = True
    Else
      frmMDI.ActiveForm.Text1.SearchCaseSensitive = False
    End If

    If WholeWordOnly Then
      frmMDI.ActiveForm.Text1.SearchWholeWordsOnly = True
    Else
      frmMDI.ActiveForm.Text1.SearchWholeWordsOnly = False
    End If

    
    If fReplace Then
       frmMDI.ActiveForm.Text1.Action = 10 'replace
    Else
       frmMDI.ActiveForm.Text1.Action = 9 'search
    End If


    ' reset mouse pointer
    screen.MousePointer = OldMousePointer

    ' If string is found
    If frmMDI.ActiveForm.Text1.SearchResult Then
	FindIt = True
    Else
	Dim Msg As String, response As Integer
	Msg = "Cannot find " & Chr(34) & TargetText & Chr(34)
	response = MsgBox(Msg, 0, App.Title)
    End If

    UpdateStatusLine

End Function

Sub FindNextProc ()
    'make sure the current form's display is up to date...
    frmMDI.ActiveForm.Refresh

    ' change mousepointer to an hourglass
    Dim OldMousePointer As Integer
    OldMousePointer = screen.MousePointer
    screen.MousePointer = 11

    frmMDI.ActiveForm.Text1.Action = 11 'repeat

    ' reset mouse pointer
    screen.MousePointer = OldMousePointer

    ' If string is found
    If frmMDI.ActiveForm.Text1.SearchResult = 0 Then
	Dim Msg As String, response As Integer
	Msg = "Cannot find " & Chr(34) & frmMDI.ActiveForm.Text1.SearchTarget & Chr(34)
	response = MsgBox(Msg, 0, App.Title)
    End If

    UpdateStatusLine
End Sub

Sub FindProc ()

    ' 1st, before displaying the dialog that collects search parameters,
    ' initialize the text that will be displayed in the Find form's
    ' combo box...
    If frmMDI.ActiveForm!Text1.SelMark <> 0 And frmMDI.ActiveForm!Text1.SelStartY = frmMDI.ActiveForm!Text1.SelEndY Then
	Dim start As Long, length As Long
	start = frmMDI.ActiveForm!Text1.SelStartX
	length = frmMDI.ActiveForm!Text1.SelEndX - start
	frmMDI.ActiveForm!Text1.TextIndex = frmMDI.ActiveForm!Text1.SelStartY
	frmFind!comboText.Text = RTrim(Mid(frmMDI.ActiveForm!Text1.Text, start, length))
    Else
	frmFind!comboText.Text = frmMDI.ActiveForm!Text1.SearchTarget
    End If

    ' Collect search parameters.  After the user presses the OK button
    ' the Find dialog calls FindIt..
    frmFind.Show
End Sub

Sub FlipInsertMode ()
    If gfInsertMode = True Then
	gfInsertMode = False
    Else
	gfInsertMode = True
    End If
    SetInsertMode
End Sub

Sub GetRecentFiles ()
  Dim RetVal, key, I, J
  Dim IniString As String

  ' This variable must be large enough to hold the return string
  ' from the GetPrivateProfileString API.
  IniString = String(255, 0)

  ' Get recent file strings from EMEDIT.INI
  For I = 1 To 4
    key = "RecentFile" & I
    RetVal = GetPrivateProfileString("Recent Files", key, "Not Used", IniString, Len(IniString), "EMEDIT.INI")
    If RetVal And Left(IniString, 8) <> "Not Used" Then
      ' Update the MDI form's menu.
      frmMDI.mnuRecentFile(0).Visible = True
      frmMDI.mnuRecentFile(I).Caption = IniString
      frmMDI.mnuRecentFile(I).Visible = True
  
      ' Iterate through all the notepads and update each menu.
      For J = 1 To UBound(document)
	If Not FState(J).Deleted Then
	  document(J).mnuRecentFile(0).Visible = True
	  document(J).mnuRecentFile(I).Caption = IniString
	  document(J).mnuRecentFile(I).Visible = True
	End If
      Next J
    End If
  Next I

End Sub

Sub InitMDINOTE ()

    'Initialize document form arrays, and show first document.
'    ReDim document(1)
'    ReDim FState(1)
'    document(1).Tag = 1
'    document(1).Show

    gfInsertMode = True ' default is to insert text
    gfBlockType = 1 'block type = Stream
End Sub

Function IsBlankString (DaString As String) As Integer
    Dim DaStringLen As Long, I As Long
    DaStringLen = Len(DaString)
    IsBlankString = True
    For I = 1 To DaStringLen
	If Mid(DaString, I, 1) <> " " And Mid(DaString, I, 1) <> Chr(9) Then
	    IsBlankString = False
	    Exit For
	End If
    Next
End Function

Function IsWholeWord (SourceText As String, FoundX As Long, FoundLength As Long) As Integer
    Dim BeginWholeWord As Integer
    IsWholeWord = False
    If FoundX <= 1 Then
	BeginWholeWord = True
    ElseIf IsBlankString(Mid(SourceText, FoundX - 1, 1)) Then
	BeginWholeWord = True
    End If
    
    If BeginWholeWord Then
	If Len(SourceText) <= FoundX + FoundLength Then
	    IsWholeWord = True
	ElseIf IsBlankString(Mid(SourceText, FoundX + FoundLength, 1)) Then
	    IsWholeWord = True
	End If
    End If
End Function

Sub OptionsToolbarProc (CurrentForm As Form)
    CurrentForm.mnuOToolbar.Checked = Not CurrentForm.mnuOToolbar.Checked
    If TypeOf CurrentForm Is MDIForm Then
    Else
	frmMDI.mnuOToolbar.Checked = CurrentForm.mnuOToolbar.Checked
    End If
    If CurrentForm.mnuOToolbar.Checked Then
	frmMDI.picToolbar.Visible = True
    Else
	frmMDI.picToolbar.Visible = False
    End If
End Sub

Sub ReleaseDocument (fIndex As Integer)
    FState(fIndex).Deleted = True
End Sub

Sub ReplaceProc ()
    ' 1st, before displaying the dialog that collects search parameters,
    ' initialize the text that will be displayed in the Find form's
    ' combo box...
    If frmMDI.ActiveForm!Text1.SelMark <> 0 And frmMDI.ActiveForm!Text1.SelStartY = frmMDI.ActiveForm!Text1.SelEndY Then
	Dim start As Long, length As Long
	start = frmMDI.ActiveForm!Text1.SelStartX
	length = frmMDI.ActiveForm!Text1.SelEndX - start
	frmMDI.ActiveForm!Text1.TextIndex = frmMDI.ActiveForm!Text1.SelStartY
	frmReplace!comboText.Text = RTrim(Mid(frmMDI.ActiveForm!Text1.Text, start, length))
    Else
	frmReplace!comboText.Text = frmMDI.ActiveForm!Text1.SearchTarget
    End If

    ' Collect search parameters.  After the user presses the OK button
    ' the Find dialog calls FindIt..
    frmReplace.Show
End Sub

Sub SetBlockType (fBlockType As Integer)
    If fBlockType = gfBlockType Then
      Exit Sub
    End If
    On Error GoTo SetBlockTypeError
    frmMDI.ActiveForm.Text1.SelDefaultType = fBlockType
    gfBlockType = fBlockType
    GoTo EndSetBlockType
SetBlockTypeError:
    DisplayError
    Resume EndSetBlockType:
EndSetBlockType:
    
End Sub

Sub SetFontProc ()
    'set cancel to true
    frmMDI.CMFontDialog.CancelError = True
    On Error GoTo SetFontErrHandler

    ' set the CF_BOTH and CF_EFFECTS flags
    frmMDI.CMFontDialog.Flags = &H3& Or &H100&
    frmMDI.CMFontDialog.FontName = frmMDI.ActiveForm.Text1.FontName
    frmMDI.CMFontDialog.FontSize = frmMDI.ActiveForm.Text1.FontSize
    frmMDI.CMFontDialog.FontBold = frmMDI.ActiveForm.Text1.FontBold
    frmMDI.CMFontDialog.FontItalic = frmMDI.ActiveForm.Text1.FontItalic
    frmMDI.CMFontDialog.FontUnderLine = frmMDI.ActiveForm.Text1.FontUnderline
    frmMDI.CMFontDialog.FontStrikeThru = frmMDI.ActiveForm.Text1.FontStrikethru
    frmMDI.CMFontDialog.Color = frmMDI.ActiveForm.Text1.ForeColor

    'display the dialog box
    frmMDI.CMFontDialog.Action = 4

    'set the properties according to the user's selections...
    frmMDI.ActiveForm.Text1.Visible = False
    frmMDI.ActiveForm.Text1.FontName = frmMDI.CMFontDialog.FontName
    frmMDI.ActiveForm.Text1.FontSize = frmMDI.CMFontDialog.FontSize
    frmMDI.ActiveForm.Text1.FontBold = frmMDI.CMFontDialog.FontBold
    frmMDI.ActiveForm.Text1.FontItalic = frmMDI.CMFontDialog.FontItalic
    frmMDI.ActiveForm.Text1.FontUnderline = frmMDI.CMFontDialog.FontUnderLine
    frmMDI.ActiveForm.Text1.FontStrikethru = frmMDI.CMFontDialog.FontStrikeThru
    frmMDI.ActiveForm.Text1.ForeColor = frmMDI.CMFontDialog.Color
    frmMDI.ActiveForm.Text1.Visible = True

SetFontErrHandler: ' user pressed cancel button
    Exit Sub
End Sub

Sub SetInsertMode ()
    'set insert mode
    frmMDI.ActiveForm.Text1.InsertMode = gfInsertMode

    'change caret width based on insert mode
    Dim CaretWidth%
    CaretWidth% = -1
    If Not gfInsertMode Then
	CaretWidth% = GetSystemMetrics(SM_CXBORDER)
	If CaretWidth% < 2 Then CaretWidth% = 2
	CaretWidth% = CaretWidth% * 2
    End If
    frmMDI.ActiveForm.Text1.CaretWidth = CaretWidth%

    UpdateStatusLine
End Sub

Sub UpdateComboList (comboCtrl As ComboBox, strTxt As String)
' If the given string does not exist in the control then
'   Add the string to the beginning of the control's list
' otherwise
'   Move the string to the beginning of the string's list
    If strTxt <> "" Then
    
	Dim fTxtExists As Integer
	fTxtExists = False
    
	'check to see if the given string is alreay in the list...
	If 0 < comboCtrl.ListCount Then
	    Dim I As Integer
	    For I = 0 To comboCtrl.ListCount - 1
		If comboCtrl.List(I) = strTxt Then
		    If I = 0 Then
			fTxtExists = True
		    Else
			' The string exists in the list, so move it to the top
			' of the list if necessary
			comboCtrl.RemoveItem I
		    End If
		    Exit For
		End If
	    Next
	End If
    
	'if not already in list then add string to top of list...
	If fTxtExists = False Then
	    comboCtrl.AddItem strTxt, 0
	End If
    End If
End Sub

Sub UpdateStatusLine ()
    
    'Hide toolbar edit buttons if no notepad windows
    If Not AnyPadsLeft() Then
	frmMDI!labelInsert = ""
	frmMDI!labelPosition = ""
    Else
	If gfInsertMode = False Then
	    frmMDI.labelInsert = "Overwrite"
	Else
	    frmMDI.labelInsert = "Insert"
	End If

	Dim xpos As String, ypos As String, ysize As String
	xpos = CStr(frmMDI.ActiveForm.Text1.CaretX)
	ypos = CStr(frmMDI.ActiveForm.Text1.CaretY)
	ysize = CStr(frmMDI.ActiveForm.Text1.Count)
	frmMDI.labelPosition = "Line=" & ypos & " of " & ysize & " Column=" & xpos
    End If

End Sub

Sub UpdateToolBar ()
    
    'Hide toolbar edit buttons if no notepad windows
    If Not AnyPadsLeft() Then
	frmMDI!imgCutButton.Visible = False
	frmMDI!imgCopyButton.Visible = False
	frmMDI!imgPasteButton.Visible = False
	frmMDI!imgStreamButton.Visible = False
	frmMDI!imgColumnButton.Visible = False
	frmMDI!imgLineButton.Visible = False
	frmMDI!imgUndoButton.Visible = False
	frmMDI!imgLookButton.Visible = False
	frmMDI!imgNextButton.Visible = False
    End If

    Select Case gfBlockType
    Case 0 'none
	frmMDI.imgStreamButton.Picture = frmMDI.imgStreamButtonUp.Picture
	frmMDI.imgLineButton.Picture = frmMDI.imgLineButtonUp.Picture
	frmMDI.imgColumnButton.Picture = frmMDI.imgColumnButtonUp.Picture
    Case 1 'stream block
	frmMDI.imgStreamButton.Picture = frmMDI.imgStreamButtonPushed.Picture
	frmMDI.imgLineButton.Picture = frmMDI.imgLineButtonUp.Picture
	frmMDI.imgColumnButton.Picture = frmMDI.imgColumnButtonUp.Picture
    Case 2 'line block
	frmMDI.imgStreamButton.Picture = frmMDI.imgStreamButtonUp.Picture
	frmMDI.imgLineButton.Picture = frmMDI.imgLineButtonPushed.Picture
	frmMDI.imgColumnButton.Picture = frmMDI.imgColumnButtonUp.Picture
    Case 3 'column block
	frmMDI.imgStreamButton.Picture = frmMDI.imgStreamButtonUp.Picture
	frmMDI.imgLineButton.Picture = frmMDI.imgLineButtonUp.Picture
	frmMDI.imgColumnButton.Picture = frmMDI.imgColumnButtonPushed.Picture
    End Select

    If AnyPadsLeft() Then
	' Make sure toolbar edit buttons are visible
	frmMDI!imgCutButton.Visible = True
	frmMDI!imgCopyButton.Visible = True
	frmMDI!imgPasteButton.Visible = True
	frmMDI!imgStreamButton.Visible = True
	frmMDI!imgColumnButton.Visible = True
	frmMDI!imgLineButton.Visible = True
	frmMDI!imgUndoButton.Visible = True
	frmMDI!imgLookButton.Visible = True
	frmMDI!imgNextButton.Visible = True
    End If

End Sub

Sub WriteRecentFiles (OpenFileName)
  Dim I, J, key, RetVal
  Dim IniString As String
  IniString = String(255, 0)

  ' Copy RecentFile1 to RecentFile2, etc.
  For I = 3 To 1 Step -1
    key = "RecentFile" & I
    RetVal = GetPrivateProfileString("Recent Files", key, "Not Used", IniString, Len(IniString), "EMEDIT.INI")
    If RetVal And Left(IniString, 8) <> "Not Used" Then
      key = "RecentFile" & (I + 1)
      RetVal = WritePrivateProfileString("Recent Files", key, IniString, "EMEDIT.INI")
    End If
  Next I
  
  ' Write openfile to first Recent File.
    RetVal = WritePrivateProfileString("Recent Files", "RecentFile1", OpenFileName, "EMEDIT.INI")

End Sub

