Option Explicit

Global Const gDefaultPrintHeader$ = "&f"
Global Const gDefaultPrintFooter$ = "Page &p"
Global Const gDefaultPrintLeftLogicalMargin# = .75
Global Const gDefaultPrintTopLogicalMargin# = 1
Global Const gDefaultPrintRightPixelMargin# = .75
Global Const gDefaultPrintBottomPixelMargin# = 1

Global gPrintHeader$
Global gPrintFooter$

Global gPrintLeftLogicalMargin#
Global gPrintTopLogicalMargin#
Global gPrintRightPixelMargin#
Global gPrintBottomPixelMargin#

Sub FilePageSetup ()
    frmPageSetup.txtHeader.Text = gPrintHeader$
    frmPageSetup.txtFooter.Text = gPrintFooter$

    frmPageSetup.txtLeft.Text = CStr(gPrintLeftLogicalMargin#)
    frmPageSetup.txtTop.Text = CStr(gPrintTopLogicalMargin#)
    frmPageSetup.txtRight.Text = CStr(gPrintRightPixelMargin#)
    frmPageSetup.txtBottom.Text = CStr(gPrintBottomPixelMargin#)

    frmPageSetup.Show 1 'modal
    If InStr(frmPageSetup.cmdOK.Tag, "OK") Then
        gPrintHeader$ = frmPageSetup.txtHeader.Text
        gPrintFooter$ = frmPageSetup.txtFooter.Text
    
        gPrintLeftLogicalMargin# = CDbl(frmPageSetup.txtLeft.Text)
        gPrintTopLogicalMargin# = CDbl(frmPageSetup.txtTop.Text)
        gPrintRightPixelMargin# = CDbl(frmPageSetup.txtRight.Text)
        gPrintBottomPixelMargin# = CDbl(frmPageSetup.txtBottom.Text)
    End If
    Unload frmPageSetup
End Sub

'It is assumed here that this function has been invoked
'by the PCANCEL form.
'This function uses an editor on the main form to find out
'how many lines will fit on a printer page and also to wrap
'text so that it fits the Printer.
'This function will print out text like Windows Notepad, with margins
'and, optionally, a header and a footer.
Function FilePrint () As Integer
    '1st, set the font in the printer to the current editor's font
    'and resize the editor so that it fits the Printer (taking
    'margins into account also).
    SetPrinterFont2ActiveFont
    frmMDI.Editor4Printing.FontName = Printer.FontName
    frmMDI.Editor4Printing.FontSize = Printer.FontSize
    frmMDI.Editor4Printing.FontBold = Printer.FontBold
    frmMDI.Editor4Printing.FontItalic = Printer.FontItalic
    frmMDI.Editor4Printing.Width = Printer.Width - 1440 * (gPrintLeftLogicalMargin# + gPrintRightPixelMargin#)
    frmMDI.Editor4Printing.Height = Printer.Height - 1440 * (gPrintTopLogicalMargin# + gPrintBottomPixelMargin#)

    ' the # of lines that will fit on a page
    Dim LinesPerPage&
    LinesPerPage& = frmMDI.Editor4Printing.FullLinesPerWindow
    If gPrintHeader$ <> "" Then LinesPerPage& = LinesPerPage& - 1
    If gPrintFooter$ <> "" Then LinesPerPage& = LinesPerPage& - 1

    Dim Count& ' the # of lines in our source editor
    Count& = frmMDI.ActiveForm.Text1.Count

    Dim Header$ ' line to print at top of page
    Header$ = GetFullHeader()

    Dim I&, K&, nPage&
    nPage& = 1
    K = 1
    I = 1
    Do While K <= Count

        ' find out if the user has pressed the cancel
        ' button, if so then exit
        DoEvents
        If PCANCEL.Tag <> "" Then Exit Do

        ' clear all the text
        frmMDI.Editor4Printing.SelMark = 1 'make a stream block
        frmMDI.Editor4Printing.SelStartX = 1
        frmMDI.Editor4Printing.SelStartY = 1
        frmMDI.Editor4Printing.SelEndY = frmMDI.Editor4Printing.Count
        frmMDI.Editor4Printing.TextIndex = frmMDI.Editor4Printing.Count
        frmMDI.Editor4Printing.SelEndX = Len(frmMDI.Editor4Printing.Text) + 1
        frmMDI.Editor4Printing.Action = 4  'clear

        'load exacly one complete line from the current editor into the
        'editor used for printing
        Do
            frmMDI.ActiveForm.Text1.TextIndex = K
            frmMDI.Editor4Printing.SelText = frmMDI.ActiveForm.Text1.Text
            K = K + 1
            If frmMDI.ActiveForm.Text1.IsEndOfParagraph Then Exit Do
        Loop

        Dim J&
        For J = 1 To frmMDI.Editor4Printing.Count

            ' if we're at the top of the page
            If (I - 1) Mod LinesPerPage = 0 Then
                'insert space for the top margin
                Printer.CurrentY = 1440 * gPrintTopLogicalMargin#
    
                'then print the header, centered
                If Header$ <> "" Then
                    Dim HeaderWidth%
                    HeaderWidth% = Printer.TextWidth(Header$)
                    If HeaderWidth% < Printer.Width Then
                        Printer.CurrentX = (Printer.Width - HeaderWidth%) / 2
                    End If
                    Printer.Print Header$
                End If

                I = I + 1
            End If
    
            ' print the next line of text
            Printer.CurrentX = 1440 * gPrintLeftLogicalMargin#
            frmMDI.Editor4Printing.TextIndex = J
            Printer.Print frmMDI.Editor4Printing.Text
    
            ' if we're at the bottom of the page then print the footer
            If (Count& < K Or I Mod LinesPerPage = 0) And gPrintFooter$ <> "" Then
                Dim footer$
                footer$ = GetFullFooter(nPage)
    
                ' If printing the footer for the last page and the whole page
                ' has not been filled up yet then print blank lines until the
                ' page is full(this way the footer is always at the bottom of
                ' the page).
                Do While I Mod LinesPerPage <> 0
                    Printer.Print ""
                    I = I + 1
                Loop
    
                Dim FooterWidth%
                FooterWidth% = Printer.TextWidth(footer$)
                If FooterWidth% < Printer.Width Then
                    Printer.CurrentX = (Printer.Width - FooterWidth%) / 2
                End If
                Printer.Print footer$
                Printer.NewPage
                nPage& = nPage& + 1
            End If

            I = I + 1
        Next
    Loop

    ' if the user canceled the print operation then
    ' return False, otherwise return True.
    If PCANCEL.Tag = "" Then
        FilePrint = True
    Else
        FilePrint = False
    End If
End Function

Sub FilePrintSetup ()
    'set cancel to true
    frmMDI.CMFontDialog.CancelError = True
    On Error GoTo FilePrintSetupHandler

    frmMDI.CMFontDialog.Flags = &H40 'display print setup dialog

    'display the dialog box
    frmMDI.CMFontDialog.Action = 5

FilePrintSetupHandler: ' user pressed cancel button
    Exit Sub
End Sub

Function GetFullFooter (nPage&) As String
    Dim Pos%
    Pos% = InStr(gPrintFooter$, "&p")
    If Pos% Then
        GetFullFooter = Left$(gPrintFooter$, Pos% - 1) & CStr(nPage&) & Mid$(gPrintFooter$, Pos% + 2)
    Else
        GetFullFooter = gPrintFooter$
    End If
End Function

Function GetFullHeader () As String
    Dim FileNamePos%
    FileNamePos% = InStr(gPrintHeader$, "&f")
    If FileNamePos% Then
        GetFullHeader = Left$(gPrintHeader$, FileNamePos% - 1) & frmMDI.ActiveForm.Caption & Mid$(gPrintHeader$, FileNamePos% + 2)
    Else
        GetFullHeader = gPrintHeader$
    End If
End Function

Sub InitializePrinterModule ()
    gPrintHeader$ = gDefaultPrintHeader$
    gPrintFooter$ = gDefaultPrintFooter$

    gPrintLeftLogicalMargin# = gDefaultPrintLeftLogicalMargin#
    gPrintTopLogicalMargin# = gDefaultPrintTopLogicalMargin#
    gPrintRightPixelMargin# = gDefaultPrintRightPixelMargin#
    gPrintBottomPixelMargin# = gDefaultPrintBottomPixelMargin#
End Sub

'For reasons I don't understand setting the Printer font to "MS Serif"
'or "MS Sans Serif generates an error, therefore this function is used
'to set the Printer font.  If the Printer font can be set to the font
'in the currently active window then that's just peachy keen otherwise
'the Printer font is just left alone.
Sub SetPrinterFont2ActiveFont ()
On Error GoTo SetPrinterFontError
    Printer.FontName = frmMDI.ActiveForm.Text1.FontName
    Printer.FontSize = frmMDI.ActiveForm.Text1.FontSize
    Printer.FontBold = frmMDI.ActiveForm.Text1.FontBold
    Printer.FontItalic = frmMDI.ActiveForm.Text1.FontItalic

GoTo SetPrinterFontExit
SetPrinterFontError:
Resume SetPrinterFontExit
SetPrinterFontExit:
End Sub

