/************************************************************************
 *
 *     Project:  Edit control with a private DS
 *
 *     Module:  generic.c
 *
 *     Copyright (c) 1991 Microsoft Corporation. All rights reserved.
 *
 ************************************************************************/

#include <windows.h>
#include "generic.h"

#define SEGMENT  4096  // size of initial buffer.  Will grow if necessary.

HANDLE        hInst;
FARPROC       lpOldListProc, lpOldEditProc;
GLOBALHANDLE  ghEditDS;
HWND          hwndEdit, hwndMain;

/************************************************************************
 *  int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
 *                     LPSTR lpCmdLine, int nCmdShow)
 ************************************************************************/

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
                   LPSTR lpCmdLine, int nCmdShow)
{
   MSG    msg;
   HANDLE hAccel;

  if (!hPrevInstance)
      if (!InitApplication(hInstance))
         return FALSE;

   if (!InitInstance(hInstance, nCmdShow))
      return FALSE;

  hAccel = LoadAccelerators(hInstance, "Accel");

  while (GetMessage(&msg, NULL, 0, 0))
     {
     if (TranslateAccelerator(hwndMain, hAccel, &msg) == 0)
        {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
        }
     }
  return msg.wParam;

} /* end of WinMain() */

/***********************************************************************/

BOOL InitApplication(hInstance)
HANDLE hInstance;
{
   WNDCLASS  wc;

   wc.style = NULL;
   wc.lpfnWndProc = MainWndProc;
   wc.cbClsExtra = 0;
   wc.cbWndExtra = 0;
   wc.hInstance = hInstance;
   wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
   wc.hCursor = LoadCursor(NULL, IDC_ARROW);
   wc.hbrBackground = COLOR_WINDOW + 1;
   wc.lpszMenuName = "GenericMenu";
   wc.lpszClassName = "GenericWClass";

   RegisterClass(&wc);

   return TRUE;

}  /* end of InitApplication */

/************************************************************************/

BOOL InitInstance(hInstance, nCmdShow)
HANDLE  hInstance;
int     nCmdShow;
{
   HWND  hWnd;

   hInst = hInstance;

   hWnd = CreateWindow("GenericWClass", "Generic Sample Application",
                       WS_OVERLAPPEDWINDOW, CW_USEDEFAULT, CW_USEDEFAULT,
                       CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL,
                       hInstance, NULL);
   if (!hWnd)
      return FALSE;

   ShowWindow(hWnd, nCmdShow);
   UpdateWindow(hWnd);

   hwndMain = hWnd;

   return TRUE;

} /* end of InitInstance */

/**************************************************************************/

long FAR PASCAL MainWndProc( hWnd, message, wParam, lParam )
HWND      hWnd;
unsigned  message;
WORD      wParam;
LONG      lParam;
{
   FARPROC       lpProcAbout;
   LPVOID        lpPtr;

   switch (message)
      {
   case WM_CREATE:
      /*
       *  Allocate space for the new DS.
       */
      ghEditDS = GlobalAlloc(GMEM_DDESHARE | GMEM_MOVEABLE | GMEM_ZEROINIT,
                                 SEGMENT);
      if (ghEditDS == NULL)
         {
         MessageBox(hWnd, "Buffer failed!", "Edit buffer", MB_OK);
         ghEditDS = hInst;
         }
      else
         {
         /*
          *  Initialize the new segment.
          *  Although we unlock the segment, it is still locked by
          *  our global lock.
          */
         lpPtr = GlobalLock(ghEditDS);
         LocalInit(HIWORD((LONG)lpPtr), 0, (WORD)(GlobalSize(ghEditDS) - 16));
         UnlockSegment(HIWORD((LONG)lpPtr));
         }

      /*
       *  Create the edit control. Note that the allocated segment
       *  handle is passed in the CreateWindow call as the hInstance
       *  parameter.
       */
      hwndEdit = CreateWindow("edit", NULL,
                 WS_CHILD | WS_VISIBLE | WS_BORDER | WS_HSCROLL | WS_VSCROLL
                 | ES_MULTILINE | ES_AUTOHSCROLL | ES_AUTOVSCROLL | ES_LEFT,
                 200, 20, 250, 200, hWnd, 2, HIWORD((LONG)lpPtr), NULL);

      /*
       *  The EM_LIMITTEXT function will allow the edit field to
       *  hold more than 32K.  The default for an edit field is
       *  approximately 32K, but by sending a 0, 0L through as
       *  the parameters, the default then becomes all available
       *  memory or 64K which comes first.
       */
      SendMessage(hwndEdit, EM_LIMITTEXT, 0, 0L);

      return 0;

   case WM_SETFOCUS:
      SetFocus(hwndEdit);
      return 0;

   case WM_INITMENU:
      /*
       *  Check to see if Undo buffer is available.
       *  If so, activate menu item; otherwise, gray
       *  and disable it.
       */
      if (SendMessage(hwndEdit, EM_CANUNDO, 0, 0L))
         EnableMenuItem(GetMenu(hWnd), IDM_UNDO, MF_ENABLED);
      else
         EnableMenuItem(GetMenu(hWnd), IDM_UNDO, MF_DISABLED | MF_GRAYED);
      break;

   case WM_COMMAND:
      switch (wParam)
         {
      case IDM_ABOUT:
         lpProcAbout = MakeProcInstance(AboutDlgProc, hInst);
         DialogBox(hInst, "AboutBox", hWnd, lpProcAbout);
         FreeProcInstance(lpProcAbout);
         break;

      case IDM_COPY:
         /*
          *  Copy highlighted contents to clipboard.
          */
         SendMessage(hwndEdit, WM_COPY, 0, 0L);
         break;

      case IDM_CUT:
         /*
          *  Cut highlighted contents to clipboard.
          */
         SendMessage(hwndEdit, EM_EMPTYUNDOBUFFER, 0, 0L);
         SendMessage(hwndEdit, WM_CUT, 0, 0L);
         break;

      case IDM_PASTE:
         /*
          *  Paste from the clipboard to the edit field.
          */
         SendMessage(hwndEdit, WM_PASTE, 0, 0L);
         break;

      case IDM_UNDO:
         /*
          *  Undo previous editing command.  Note that the
          *  undo buffer is allocated by USER, and does not
          *  come out of the buffer this application created.
          */
         SendMessage(hwndEdit, EM_UNDO, 0, 0L);
         break;

      case IDM_CLEAR:
         /*
          *  Delete highlighted items.
          */
         SendMessage(hwndEdit, EM_EMPTYUNDOBUFFER, 0, 0L);
         SendMessage(hwndEdit, WM_CLEAR, 0, 0L);
         break;

      case IDM_SELECTALL:
         /*
          *  Select every character in the edit control.
          */
         SendMessage(hwndEdit, EM_SETSEL, 0, 65534);
         break;

      default:
         return DefWindowProc(hWnd, message, wParam, lParam);
         }
      break;

   case WM_DESTROY:
      PostQuitMessage(0);
      break;

   default:
      return DefWindowProc(hWnd, message, wParam, lParam);
      }
   return NULL;

}  /* end of MainWndProc */

/*************************************************************************/

BOOL FAR PASCAL AboutDlgProc(hDlg, message, wParam, lParam)
HWND      hDlg;
unsigned  message;
WORD      wParam;
LONG      lParam;
{
   switch (message)
      {
   case WM_INITDIALOG:
      return TRUE;

   case WM_COMMAND:
      if (wParam == IDOK || wParam == IDCANCEL)
         {
         EndDialog(hDlg, TRUE);
         return TRUE;
         }
      break;
      }

   return FALSE;
} /* end of AboutDlgProc */

/* End of File: generic.c */
