{
  Program: RedGreen
  Date: 20/2/1995
  Purpose: To create a custom control (vbx) for Visual Basic or Delphi
}
Library RedGreen;
{$R RedGreen}
Uses WinTypes,WinProcs,VBApi;
{ Custom control data and structs }
Type PRedGreen=^TRedGreen;
     TRedGreen=Record
      About:Enum;
      Value:Bool;
     End;
Const 
{ Declare Property }
      Property_About:TPROPINFO=(
      npszName:NPnt(PChar('(About)'));
      fl:DT_ENUM or PF_fGetData or PF_fSetData or PF_fSetMsg;
      offsetData:Byte(0);
      infoData:0;
      dataDefault:0;
      npszEnumList:Npnt(PChar('Click on "..." for About Box'+#0+#0));
      enumMax:0);
      Property_Value:TPROPINFO=(
      npszName:NPnt(PChar('Value'));
      fl:DT_BOOL or PF_fGetData or PF_fSaveData or PF_fSetData or PF_fSetMsg;
      offsetData:Byte(1);
      infoData:0;
      dataDefault:0;
      npszEnumList:Npnt(PChar(+#0+#0));
      enumMax:0);
{ Declare Events }
{ Property List }
      PropListRedGreen:array[0..11] of PPropInfo=(
      PPropInfo_Std_CTLNAME,
      PPropInfo_Std_HWND,
      PPropInfo_Std_INDEX,
      PPropInfo(@Property_About),
      PPropInfo_Std_ENABLED,
      PPropInfo_Std_HEIGHT,
      PPropInfo_Std_LEFT,
      PPropInfo_Std_TOP,
      PPropInfo_Std_VISIBLE,
      PPropInfo_Std_WIDTH,
      PPropInfo(@Property_Value),0);
{ Event List }
      EventListRedGreen:array[0..1] of PEventInfo=(
      PEventInfo_Std_MOUSEMOVE,0);
{ This routine handles the 'About' Dialog messages }
function AboutDlgProc(Dlg:HWnd;Msg,wParam:Word;lParam:LongInt):Bool; export;
begin
  AboutDlgProc:=False;
  case Msg of
    WM_Create:AboutDlgProc:=True;
    WM_InitDialog:Exit;
    WM_Command:if (wParam=id_OK)or(wParam=id_Cancel) then EndDialog(Dlg,0);
  end;{End of Case}
end;
{ Constans and Variables }
var RG:hBitmap;
{ Control Procedure }
{ This routine is called for all VB and Windows Messages }
function RedGreenCtlProc(Control:hCtl;Wnd:hWnd;Msg,wParam:Word;lParam:LongInt):LongInt; Export;
var Value:Bool;
    TP:TPaintStruct;
    hBrOld,hBR:hBrush;
    MemDC:hDC;
begin
  case Msg of
    WM_PAINT:
    begin
      BeginPaint(Wnd,TP);
      hBR:=GetBrushOrg(TP.hDC);
      if Bool(hbr) then hbrOld:=SelectObject(TP.hDC,hBR);
      MemDC:=CreateCompatibleDC(TP.hDC);
      SelectObject(MemDC,RG);
      VBGetControlProperty(Control,10,@Value);
      if Value then BitBlt(TP.hDC,0,0,29,16,MemDC,0,0,SrcCopy)
      else BitBlt(TP.hDC,0,0,29,16,MemDC,0,16,SrcCopy);
      SelectObject(TP.hDC,hbrOld);
      DeleteDC(MemDC);
      EndPaint(Wnd,TP);
    end;
    VBM_SETPROPERTY:if wParam=10 then Invalidaterect(Wnd,nil,False);
    WM_USER:VBDialogBoxParam(hInstance,'ABOUT',@AboutDlgProc,0);WM_USER+1:VBDialogBoxParam(hInstance,'ABOUT',@AboutDlgProc,0);
    VBM_INITPROPPOPUP:if wParam=3 then
    begin
      RedGreenCtlProc:=LoWord(lParam+1);
      PostMessage(Wnd,WM_USER,0,0);
      Exit;
    end;
  end;    { End of case Msg }
  RedGreenCtlProc:=VBDefControlProc(Control,Wnd,Msg,wParam,lParam);
end; {End of Control function}
{ Model struct                               }
{ Define the control model                   }
{ (using the event and property structures). }
Const ModelRedGreen:TModel=(
      UsVersion:VB300_VERSION;    { VB version used by control }
      Fl:0;
      CtlProc:TFarProc(@RedGreenCtlProc);
      FsClassStyle:0 or cs_HRedraw or cs_VRedraw;
      FlWndStyle:0;
      CbCtlExtra:SizeOf(TRedGreen);
      IdBmpPalette:8000;          { Bitmap ID for tool palette }
      DefCtlName:NPnt(PChar('RedGreen'));
      ClassName:NPnt(PChar('RedGreen'));
      ParentClassName:0;
      PropList:Ofs(PropListRedGreen);
      EventList:Ofs(EventListRedGreen);
      NDefProp:0;                 { Index of default property }
      NDefEvent:0);               { Index of default event }
{ Register custom control.                     }
{ This routine is called by VB when the custom }
{ control DLL is loaded for use.               }
function VBInitCC(usVersion:Word;fRunTime:Boolean):Boolean; Export;
begin
  RG:=LoadBitmap(hInstance,'REDGREEN');
  VBInitCC:=VBRegisterModel(hInstance,ModelRedGreen);
end;
Exports
  VBInitCC         index 2,
  RedGreenCtlProc index 3,
  AboutDlgProc;
Begin
End. { End of Custom Control }