VERSION 2.00
Begin Form telnet_form 
   BackColor       =   &H00FFFFFF&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Telnet"
   ClientHeight    =   4020
   ClientLeft      =   1380
   ClientTop       =   2580
   ClientWidth     =   6135
   DrawMode        =   16  'Whiteness
   FontBold        =   0   'False
   FontItalic      =   0   'False
   FontName        =   "Host Presenter"
   FontSize        =   9
   FontStrikethru  =   0   'False
   FontUnderline   =   0   'False
   Height          =   4710
   Left            =   1320
   LinkMode        =   1  'Source
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4020
   ScaleWidth      =   6135
   Top             =   1950
   Width           =   6255
   Begin WinSock WinSock1 
      Client_or_Server=   0  'Client
      Interval        =   0
      IPName          =   ""
      Left            =   600
      LicDate         =   0
      License1        =   ""
      License2        =   ""
      Licensed        =   0
      Linger          =   0   'False
      Port            =   0
      RecvBufSize     =   0
      SendBufSize     =   0
      Top             =   60
   End
   Begin Timer cursor_timer 
      Interval        =   300
      Left            =   90
      Top             =   60
   End
   Begin Menu telnet_file_menu 
      Caption         =   "&File"
      Begin Menu menu_connect 
         Caption         =   "&Connect"
      End
      Begin Menu menu_disconnect 
         Caption         =   "&Disconnect"
      End
      Begin Menu menu_exit 
         Caption         =   "&Exit"
      End
   End
   Begin Menu font_menu 
      Caption         =   "Fonts"
      Begin Menu font_7_menu 
         Caption         =   "7 Point"
         Checked         =   -1  'True
      End
      Begin Menu font_9_menu 
         Caption         =   "9 Point"
      End
   End
End
Dim insert_mode As Integer
Dim parm(9) As Integer
Dim pno As Integer
Dim row As Integer
Dim col As Integer
Dim save_row As Integer
Dim save_col As Integer
Dim comm_buffer(23) As String * 80

Dim control_on As Integer

Dim cursor_is_on As Integer

Dim tabno As Integer
Dim tab_table(20) As Integer

Dim txth As Integer
Dim txtw As Integer

Dim graphics As Integer
Dim graph_chars As String
Dim attributes As Integer

Const ATTR_BOLD = 1
Const ATTR_REVERSE = 2

Dim parsedata(10) As Integer
Dim ppno As Integer

Dim sw_ugoahead As Integer
Dim sw_igoahead As Integer
Dim sw_echo As Integer
Dim sw_linemode As Integer
Dim sw_termsent As Integer
Dim substate As Integer

Const GO_NORM = 0
Const GO_ESC1 = 1
Const GO_ESC2 = 2
Const GO_ESC3 = 3
Const GO_ESC4 = 4
Const GO_ESC5 = 5
Const GO_IAC1 = 6
Const GO_IAC2 = 7
Const GO_IAC3 = 8
Const GO_IAC4 = 9
Const GO_IAC5 = 10
Const GO_IAC6 = 11

Const SUSP = 237
Const ABORT = 238
Const SE = 240
Const NOP = 241
Const DM = 242
Const break = 243
Const IP = 244
Const AO = 245
Const AYT = 246
Const EC = 247
Const EL = 248
Const GOAHEAD = 249
Const SB = 250
Const WILLTEL = 251
Const WONTTEL = 252
Const DOTEL = 253
Const DONTTEL = 254
Const IAC = 255

'Const BINARY = 0
Const ECHO = 1
Const RECONNECT = 2
Const SGA = 3
Const AMSN = 4
Const STATUS = 5
Const TIMING = 6
Const RCTAN = 7
Const OLW = 8
Const OPS = 9
Const OCRD = 10
Const OHTS = 11
Const OHTD = 12
Const OFFD = 13
Const OVTS = 14
Const OVTD = 15
Const OLFD = 16
Const XASCII = 17
Const LOGOUT = 18
Const BYTEM = 19
Const DET = 20
Const SUPDUP = 21
Const SUPDUPOUT = 22
Const SENDLOC = 23
Const TERMTYPE = 24
Const EOR = 25
Const TACACSUID = 26
Const OUTPUTMARK = 27
Const TERMLOCNUM = 28
Const REGIME3270 = 29
Const X3PAD = 30
Const NAWS = 31
Const TERMSPEED = 32
Const TFLOWCNTRL = 33
Const LINEMODE = 34
                           
Const MODE = 1
'Const EDIT = 1
Const TRAPSIG = 2
Const MODE_ACK = 4
Const SOFT_TAB = 8
Const LIT_ECHO = 16

Const FORWARDMASK = 2

Const SLC = 3
Const NO_SUPPORT = 0
Const CANTCHANGE = 1
Const SLC_VALUE = 2
Const SLC_DEFAULT = 3
Const SLC_LEVELBITS = 3
Const SLC_ACK = 128
Const SLC_SYNCH = 1
Const SLC_BRK = 2
Const SLC_IP = 3
Const SLC_AO = 4
Const SLC_AYT = 5
Const SLC_EOR = 6
Const SLC_ABORT = 7
Const SLC_EOF = 8
Const SLC_SUSP = 9
Const SLC_EC = 10
Const SLC_EL = 11
Const SLC_EW = 12
Const SLC_RP = 13
Const SLC_LNEXT = 14
Const SLC_XON = 15
Const SLC_XOFF = 16
Const SLC_FORW1 = 17
Const SLC_FORW2 = 18
Const SLC_MCL = 19
Const SLC_MCR = 20
Const SLC_MCWL = 21
Const SLC_MCWR = 22
Const SLC_MCBOL = 23
Const SLC_MCEOL = 24
Const SLC_INSRT = 25
Const SLC_OVER = 26
Const SLC_ECR = 27
Const SLC_EWR = 28
Const SLC_EBOL = 29
Const SLC_EEOL = 30
Const XDISPLOC = 35
Const XOPTIONS = 255

Const Negotiate = 1

' Key Codes

Const KEY_LBUTTON = &H1
Const KEY_RBUTTON = &H2
Const KEY_CANCEL = &H3
Const KEY_MBUTTON = &H4    ' NOT contiguous with L & RBUTTON
Const KEY_BACK = &H8
Const KEY_TAB = &H9
Const KEY_CLEAR = &HC
Const KEY_RETURN = &HD
Const KEY_SHIFT = &H10
Const KEY_CONTROL = &H11
Const KEY_MENU = &H12
Const KEY_PAUSE = &H13
Const KEY_CAPITAL = &H14
Const KEY_ESCAPE = &H1B
Const KEY_SPACE = &H20
Const KEY_PRIOR = &H21
Const KEY_NEXT = &H22
Const KEY_END = &H23
Const KEY_HOME = &H24
Const KEY_LEFT = &H25
Const KEY_UP = &H26
Const KEY_RIGHT = &H27
Const KEY_DOWN = &H28
Const KEY_SELECT = &H29
Const KEY_PRINT = &H2A
Const KEY_EXECUTE = &H2B
Const KEY_SNAPSHOT = &H2C
Const KEY_INSERT = &H2D
Const KEY_DELETE = &H2E
Const KEY_HELP = &H2F

' KEY_A thru KEY_Z are the same as their ASCII equivalents: 'A' thru 'Z'
' KEY_0 thru KEY_9 are the same as their ASCII equivalents: '0' thru '9'

Const KEY_NUMPAD0 = &H60
Const KEY_NUMPAD1 = &H61
Const KEY_NUMPAD2 = &H62
Const KEY_NUMPAD3 = &H63
Const KEY_NUMPAD4 = &H64
Const KEY_NUMPAD5 = &H65
Const KEY_NUMPAD6 = &H66
Const KEY_NUMPAD7 = &H67
Const KEY_NUMPAD8 = &H68
Const KEY_NUMPAD9 = &H69
Const KEY_MULTIPLY = &H6A
Const KEY_ADD = &H6B
Const KEY_SEPARATOR = &H6C
Const KEY_SUBTRACT = &H6D
Const KEY_DECIMAL = &H6E
Const KEY_DIVIDE = &H6F
Const KEY_F1 = &H70
Const KEY_F2 = &H71
Const KEY_F3 = &H72
Const KEY_F4 = &H73
Const KEY_F5 = &H74
Const KEY_F6 = &H75
Const KEY_F7 = &H76
Const KEY_F8 = &H77
Const KEY_F9 = &H78
Const KEY_F10 = &H79
Const KEY_F11 = &H7A
Const KEY_F12 = &H7B
Const KEY_F13 = &H7C
Const KEY_F14 = &H7D
Const KEY_F15 = &H7E
Const KEY_F16 = &H7F

Const KEY_NUMLOCK = &H90

Sub cursor_timer_Timer ()

  draw_cursor

End Sub

Sub draw_cursor ()

Dim x As Integer
Dim y As Integer

    If cursor_is_on Then
      cursor_is_on = False
    Else
      cursor_is_on = True
    End If
      
    If cursor_is_on Then
      x = col * txtw
      y = row * txth
      telnet_form.DrawMode = 6
      telnet_form.Line (x, y)-(x + txtw, y + txth), , BF
      telnet_form.DrawMode = 16
    End If

End Sub

Function esc1 (ch As String) As Integer
    
  esc1 = GO_NORM             ' default return value is normal character

  Select Case ch
    Case Chr$(8)             ' embedded backspace
      col = col - 1
    Case "7"                 ' save cursor
      save_row = row
      save_col = col
    Case "8"                 ' restore cursor
      row = save_row
      col = save_col
    Case "c"                 ' look at VSIreset()
    Case "D"                 ' cursor down
      row = row + 1
    Case "E"                 ' next line
      row = row + 1
      col = 0
    Case "H"                 ' set tab
      tab_table(tabno) = col
      tabno = tabno + 1
    Case "I"                 ' look at bp_ESC_I()
    Case "M"                 ' cursor up
      row = row - 1
    Case "Z"                 ' send ident
    Case "["                 ' requires further processing
      Erase parm
      pno = 0
      esc1 = GO_ESC2
    Case ">"                 ' DECPAM off
    Case "="                 ' DECPAM on
    Case "#"                 ' requires further processing
      Erase parm
      pno = 0
      esc1 = GO_ESC3
    Case "("                 ' requires further processing
      Erase parm
      pno = 0
      esc1 = GO_ESC4
    Case ")"                 ' requires further processing
      Erase parm
      pno = 0
      esc1 = GO_ESC5
  End Select

End Function

Function esc2 (ch As String) As Integer
    
  ' handle ESC [ sequences

  esc2 = GO_NORM

  Select Case ch
    Case Chr$(8)             ' backspace
      col = col - 1
      esc2 = GO_ESC2
    Case "0" To "9"          ' numeric parameters
      parm(pno) = parm(pno) * 10 + Val(ch$)
      esc2 = GO_ESC2
    Case "?"                 ' default (no) parameter
      parm(pno) = -2
      pno = pno + 1
      esc2 = GO_ESC2
    Case ";"                 ' parameter separator
      pno = pno + 1
      esc2 = GO_ESC2
    Case "A"                 ' cursor back n rows
      If parm(0) < 1 Then
         row = row - 1
      Else
        row = row - parm(0)
      End If
    Case "B"                 ' cursor forward n rows
      If parm(0) < 1 Then
        row = row + 1
      Else
        row = row + parm(0)
      End If
    Case "C"                 ' cursor forward n cols
      If parm(0) < 1 Then
        col = col + 1
      Else
        col = col + parm(0)
      End If
    Case "D"                 ' cursor back n columns
      If parm(0) < 1 Then
        col = col - 1
      Else
        col = col - parm(0)
      End If
    Case "H"                 ' set cursor address
      row = parm(0) - 1
      col = parm(1) - 1
    Case "J"
      test_bounds
      Select Case parm(0)
        Case -1, 0           ' erase from cursor to end of screen
          telnet_form.Line (col * txtw, row * txth)-(telnet_form.Width, (row + 1) * txth), , BF
          telnet_form.Line (0, (row + 1) * txth)-(telnet_form.Width, telnet_form.Height), , BF
          comm_buffer(row) = Left$(comm_buffer(row), col)
          For y = row + 1 To 23
            comm_buffer(y) = ""
          Next y
        Case 1               ' erase from screen begin to cursor
          telnet_form.Line (0, 0)-(telnet_form.Width, row * txth), , BF
          telnet_form.Line (0, row * txth)-(col * txtw, (row + 1) * txth), , BF
          comm_buffer(row) = Space$(col) + Right$(comm_buffer(row), Len(comm_buffer(row)) - col)
          For y = 0 To row - 1
            comm_buffer(y) = ""
          Next y
        Case 2               ' erase entire screen
          telnet_form.Cls
          For y = 0 To 23
            comm_buffer(y) = ""
          Next y
      End Select
    Case "K"
      test_bounds
      Select Case parm(0)
        Case -1, 0           ' erase from cursor to end of line
          telnet_form.Line (col * txtw, row * txth)-(telnet_form.Width, (row + 1) * txth), , BF
          comm_buffer(row) = Left$(comm_buffer(row), col)
        Case 1               ' erase from begin of line to cursor
          telnet_form.Line (0, row * txth)-((col + 1) * txtw, (row + 1) * txth), , BF
          comm_buffer(row) = Space$(col) + Right$(comm_buffer(row), Len(comm_buffer(row)) - col)
        Case 2               ' erase entire line
          telnet_form.Line (0, row * txth)-(Width, (row + 1) * txth), , BF
          comm_buffer(row) = ""
      End Select
    Case "L"                 ' insert lines
    Case "M"                 ' delete lines
    Case "P"                 ' delete characters
    Case "c"                 ' look at VTsendident()
    Case "f"
      row = parm(0) - 1
      col = parm(1) - 1
    Case "g"                 ' clear tabs
    Case "h"                 ' look at VSIsetoption(1)
    Case "i"                 ' print though mode
    Case "l"                 ' look at VSIsetoption(0)
    Case "m"
      For y = 0 To pno
        Select Case parm(y)
          Case Is < 1       ' reset attributes
            attributes = 0
          Case 1            ' bold
            attributes = attributes Or ATTR_BOLD
          Case 4            ' underline
          Case 5            ' blink
          Case 6            ' blink
          Case 7            ' reverse
            attributes = attributes Or ATTR_REVERSE
        End Select
      Next y
    Case "n"
      Select Case parm(0)
        Case 5               ' look at VTsendstat()
        Case 6               ' look at VTsendpos
      End Select
    Case "q"
    Case "r"                 ' set window bounds (top, bottom)
  End Select

End Function

Function esc3 (ch As String) As Integer

  ' handle ESC # sequences

  esc3 = GO_NORM

  Select Case ch
    Case Chr$(8)
      col = col - 1
      esc3 = GO_ESC3
    Case "8"                 ' look at VTalign()
  End Select

End Function

Function esc4 (ch As String) As Integer
    
  ' handle ESC ( sequences

  esc4 = GO_NORM

  Select Case ch
    Case Chr$(8)
      col = col - 1
      esc4 = GO_ESC4
    Case "A", "B", "1"       ' select text character set
      graphics = False
    Case "0", "2"            ' select graphic character set
      graphics = True
  End Select

End Function

Function esc5 (ch As String) As Integer
    
  ' handle ESC ) sequences

  esc5 = GO_NORM
    
  Select Case ch
    Case Chr$(8)
      col = col - 1
      esc5 = GO_ESC5
    Case "A", "B", "1"       ' select text character set
      graphics = False
    Case "0", "2"            ' select graphic character set
      graphics = True
  End Select

End Function

Sub font_7_menu_Click ()
  
  telnet_form.FontSize = 7.5

  font_7_menu.Checked = True
  font_9_menu.Checked = False
  
  txth = telnet_form.TextHeight("A")
  txtw = telnet_form.TextWidth("A")

  telnet_form.Height = txth * 30
  telnet_form.Width = txtw * 82
  telnet_form.Left = 500
  telnet_form.Top = 500
End Sub

Sub font_9_menu_Click ()

  telnet_form.FontSize = 9

  font_7_menu.Checked = False
  font_9_menu.Checked = True

  txth = telnet_form.TextHeight("A")
  txtw = telnet_form.TextWidth("A")

  telnet_form.Height = txth * 30
  telnet_form.Width = txtw * 82
  telnet_form.Left = 0
  telnet_form.Top = 0

End Sub

Sub Form_KeyDown (KeyCode As Integer, Shift As Integer)
  
  Dim ch As String
    
  ch = Chr$(0)
    
  Select Case KeyCode
    Case KEY_RETURN
      cursor_timer.Enabled = False
      x = col * txtw
      y = row * txth
      DrawMode = 16
      Line (x, y)-(x + txtw, y + txth), , BF
    Case KEY_CONTROL
      control_on = True
    Case KEY_END
      ch = Chr$(27) + "[K"
    Case KEY_HOME
      ch = Chr$(27) + "[H"
    Case KEY_LEFT
      ch = Chr$(27) + "[D"
    Case KEY_UP
      ch = Chr$(27) + "[A"
    Case KEY_RIGHT
      ch = Chr$(27) + "[C"
    Case KEY_DOWN
      ch = Chr$(27) + "[B"
    Case KEY_F1
      ch = Chr$(27) + "OP"
    Case KEY_F2
      ch = Chr$(27) + "OQ"
    Case KEY_F3
      ch = Chr$(27) + "OR"
    Case KEY_F4
      ch = Chr$(27) + "OS"
    Case Else
      If control_on And KeyCode > 63 Then
        ch = Chr$(KeyCode - 64)
      End If
  End Select

  If ch > Chr$(0) And WinSock1.Open Then
    WinSock1.Send = ch
  End If

End Sub

Sub Form_KeyPress (KeyAscii As Integer)
  
Dim ch As String
    
  ch = Chr$(KeyAscii)
  
  If control_on Then
    If KeyAscii > 63 Then
      ch = Chr$(KeyAscii - 64)
    Else
      ch = Chr$(0)
    End If
  End If
  
  If ch > Chr$(0) And WinSock1.Open Then
    WinSock1.Send = ch
  End If

End Sub

Sub Form_KeyUp (KeyCode As Integer, Shift As Integer)
    
    Select Case KeyCode
      Case KEY_CONTROL
        control_on = False
    End Select

End Sub

Sub Form_Load ()

    'telnet_form.windowstate = MAXIMIZED
     
    cursor_timer.Enabled = False
  
    telnet_form.FontSize = 7.5
    font_7_menu.Checked = True
    font_9_menu.Checked = False

    txth = telnet_form.TextHeight("A")
    txtw = telnet_form.TextWidth("A")

    telnet_form.Left = 500
    telnet_form.Top = 500
    telnet_form.Height = txth * 30
    telnet_form.Width = txtw * 82

    row = 0
    col = 0
    save_row = 0
    save_col = 0
    tabno = 0
    graphics = False
    sw_echo = True
    
    For x = 0 To 23
      comm_buffer(x) = ""
    Next x
    
    For x = 0 To 19
      tab_table(x) = 0
    Next x

    graph_chars = "ABCDEFGHI" + Chr$(217) + Chr$(191) + Chr$(218) + Chr$(192) + "NOP" + Chr$(196) + "RSTUVW" + Chr$(179) + "YZ"
    
    If Command$ = "" Then
      menu_connect_click
    Else
      WinSock1.IPName = Trim$(Command$)
      WinSock1.Port = 23
      WinSock1.Open = True
      msg$ = Chr$(IAC) + Chr$(DOTEL) + Chr$(ECHO)
      msg$ = msg$ + Chr$(IAC) + Chr$(DOTEL) + Chr$(SGA)
      msg$ = msg$ + Chr$(IAC) + Chr$(WILLTEL) + Chr$(NAWS)
      WinSock1.Send = msg$
      menu_connect.Enabled = False
    End If

End Sub

Sub Form_Unload (Cancel As Integer)

  If WinSock1.Open = True Then
    WinSock1.Open = False
  End If

End Sub

Function iac1 (ch As String) As Integer
      
  iac1 = GO_NORM
  
  Select Case Asc(ch)
    Case DOTEL
      Debug.Print "DO ";
      iac1 = GO_IAC2
    Case DONTTEL
      Debug.Print "DONT "
    Case WILLTEL
      Debug.Print "WILL ";
      iac1 = GO_IAC3
    Case WONTTEL
      Debug.Print "WONT ";
      iac1 = GO_IAC4
    Case SB
      Debug.Print "SB ";
      iac1 = GO_IAC5
      pno = 0
      substate = 0
    Case SE
      Debug.Print "SE "
      ' End of negotiation string, string is in parsedata()
      Select Case parsedata(0)
        Case TERMTYPE
          If parsedata(1) = 1 Then
            Debug.Print "SENT: SB TERMTYPE VT100"
            telnet_form.WinSock1.Send = Chr$(IAC) + Chr$(SB) + Chr$(TERMTYPE) + "vt100" + Chr$(0) + Chr$(IAC) + Chr$(SE)
          End If
      End Select
  End Select
  
End Function

Function iac2 (ch As String) As Integer
      
  'DO Processing
  
  iac2 = GO_NORM

  Select Case Asc(ch)
    Case SGA
      Debug.Print "SGA"
      If Not sw_igoahead Then
        telnet_form.WinSock1.Send = Chr$(IAC) + Chr$(WILLTEL) + Chr$(SGA)
        sw_igoahead = True
      End If
    Case TERMTYPE
      Debug.Print "TERMTYPE"
      If Not sw_termsent Then
        sw_termsent = True
        telnet_form.WinSock1.Send = Chr$(IAC) + Chr$(WILLTEL) + Chr$(TERMTYPE)
      End If
    Case NAWS
      Debug.Print "NAWS"
      telnet_form.WinSock1.Send = Chr$(IAC) + Chr$(SB) + Chr$(NAWS) + Chr$(0) + Chr$(80) + Chr$(0) + Chr$(24) + Chr$(IAC) + Chr$(SE)
    Case Else
      Debug.Print "OTHER"
      telnet_form.WinSock1.Send = Chr$(IAC) + Chr$(WONTTEL) + ch
  End Select

End Function

Function iac3 (ch As String) As Integer
      
  ' WILL Processing
  
  iac3 = GO_NORM
      
  Select Case Asc(ch)
    Case SGA
      Debug.Print "SGA"
      If Not sw_ugoahead Then
        sw_ugoahead = True
        telnet_form.WinSock1.Send = Chr$(IAC) + Chr$(DOTEL) + Chr$(SGA)
        Debug.Print "SENT: DO SGA"
      End If
    Case ECHO
      Debug.Print "ECHO"
      If Not sw_echo Then
        sw_echo = True
        telnet_form.WinSock1.Send = Chr$(IAC) + Chr$(DOTEL) + Chr$(ECHO)
        Debug.Print "SENT: DO ECHO"
      End If
    Case TIMING
      Debug.Print "TIMING"
      sw_timing = 0
    Case Else
      Debug.Print "SENT:  DONT OTHER"
      telnet_form.WinSock1.Send = Chr$(IAC) + Chr$(DONTTEL) + ch
  End Select

End Function

Function iac4 (ch As String) As Integer

  ' WONT Processing
  
  iac4 = GO_NORM
  
  Select Case Asc(ch)
    Case ECHO
      Debug.Print "ECHO"
      If sw_echo Then
        sw_echo = False
        telnet_form.WinSock1.Send = Chr$(IAC) + Chr$(DONTTEL) + Chr$(ECHO)
        Debug.Print "SENT: DONT ECHO"
      End If
    Case TIMING
      Debug.Print "TIMING"
      sw_timing = 0
    Case Else
      Debug.Print "SENT: DONT OTHER"
      telnet_form.WinSock1.Send = Chr$(IAC) + Chr$(DONT) + ch
  End Select

End Function

Function iac5 (ch As String) As Integer

  ' Collect parms after SB and until another IAC
  
  ich = Asc(ch)
  
  If ich = IAC Then
    iac5 = GO_IAC1
    Exit Function
  End If

  Debug.Print "SUBPARM ";
  parsedata(ppno) = ich
  ppno = ppno + 1

  iac5 = GO_IAC5

End Function

Function iac6 (ch As String) As Integer
  
  ' End of negotiation string, string is in parsedata()

  Select Case parsedata(0)
    Case TERMTYPE
      If parsedata(1) = 1 Then
        Debug.Print "SENT: SB TERMTYPE VT100"
        telnet_form.WinSock1.Send = Chr$(IAC) + Chr$(SB) + Chr$(TERMTYPE) + "vt100" + Chr$(0) + Chr$(IAC) + Chr$(SE)
      End If
  End Select

End Function

Sub menu_connect_click ()

  If WinSock1.Open = True Then
    WinSock1.Open = False
  End If

  connect_form.Show 1
  Unload connect_form
  If WinSock1.IPName <> "" And WinSock1.Port <> 0 And WinSock1.Open = False Then
    WinSock1.Open = True
    msg$ = Chr$(IAC) + Chr$(DOTEL) + Chr$(ECHO)
    msg$ = msg$ + Chr$(IAC) + Chr$(DOTEL) + Chr$(SGA)
    msg$ = msg$ + Chr$(IAC) + Chr$(WILLTEL) + Chr$(NAWS)
    WinSock1.Send = msg$
    Debug.Print "SENT: DO ECHO"
    Debug.Print "SENT: DO SGA"
    Debug.Print "SENT: WILL NAWS"
  End If

End Sub

Sub menu_disconnect_Click ()

  If WinSock1.Open = True Then
    WinSock1.Open = False
    draw_cursor
    menu_connect_click
  End If

End Sub

Sub menu_exit_Click ()

  If WinSock1.Open Then
    WinSock1.Open = False
  End If
  End

End Sub

Function norm_char (ch As String) As Integer

Dim ich As Integer
Dim x As Integer
Dim y As Integer

  If ch < Chr$(32) Then
    ich = Asc(ch)
    Select Case ich
      Case 7                 ' bell
        Beep
      Case 8                 ' backspace
        col = col - 1
      Case 9                 ' tab
        For y = 0 To 19
          If col < tab_table(y) Then
            Exit For
          End If
        Next y
        col = tab_table(y)
      Case 10                ' line feed
        row = row + 1
      Case 11                ' vertical tab
        row = row + 1
      Case 12                ' form feed
        row = row + 1
      Case 13                ' carriage return
        col = 0
      Case 14                ' set graphics mode
      Case 15                ' set character mode
      Case 27
        norm_char = GO_ESC1
    End Select
  ElseIf ch = Chr$(IAC) Then
    norm_char = GO_IAC1
  Else
    test_bounds
    
    If graphics Then
      ch = Mid$(graph_chars, Asc(UCase$(ch)) - 64, 1)
    End If
      
    x = col * txtw
    y = row * txth
    telnet_form.Line (x, y)-(x + txtw, y + txth), , BF
    telnet_form.CurrentX = x
    telnet_form.CurrentY = y
    telnet_form.Print ch;
      
    If attributes And ATTR_BOLD Then
      telnet_form.CurrentX = x + 8
      telnet_form.CurrentY = y
      telnet_form.Print ch;
    End If
      
    If attributes And ATTR_REVERSE Then
      telnet_form.CurrentX = x
      telnet_form.CurrentY = y
      telnet_form.DrawMode = 6
      telnet_form.Line (x, y)-(x + txtw, y + txth), , BF
      telnet_form.DrawMode = 16
    End If
      
    Mid$(comm_buffer(row), col + 1, 1) = ch
    col = col + 1
      
  End If

End Function

Sub test_bounds ()
    
Dim y As Integer

  If row < 0 Then
    row = 0
  End If

  If col < 0 Then
    col = 0
  ElseIf col > 79 Then
    col = 0
    row = row + 1
  End If

  ' test for next row past the botton of the screen.  if it is
  ' scroll the entire screen up one row.  this is a good place
  ' to add logic for a scroll back buffer

  If row > 23 Then
    telnet_form.Cls
    For row = 0 To 22
      comm_buffer(row) = comm_buffer(row + 1)
      blk$ = blk$ + comm_buffer(row) + Chr$(13) + Chr$(10)
    Next row
    telnet_form.Print blk$
    comm_buffer(23) = ""
    row = 23
  End If
   
End Sub

Sub WinSock1_Recv ()
    
Dim x As Integer
Dim y As Integer
Dim ch As String * 1

Static cmd As Integer

  cursor_timer.Enabled = False
  x = col * txtw
  y = row * txth
  DrawMode = 16
  Line (x, y)-(x + txtw, y + txth), , BF

  msg$ = WinSock1.Recv
  
  For x = 1 To Len(msg$)
    ch = Mid$(msg$, x, 1)
    Select Case cmd
      Case GO_NORM
        cmd = norm_char(ch)
      Case GO_ESC1
        cmd = esc1(ch)
      Case GO_ESC2
        cmd = esc2(ch)
      Case GO_ESC3
        cmd = esc3(ch)
      Case GO_ESC4
        cmd = esc4(ch)
      Case GO_ESC5
        cmd = esc5(ch)
      
      Case GO_IAC1
        cmd = iac1(ch)
      Case GO_IAC2
        cmd = iac2(ch)
      Case GO_IAC3
        cmd = iac3(ch)
      Case GO_IAC4
        cmd = iac4(ch)
      Case GO_IAC5
        cmd = iac5(ch)
      Case GO_IAC6
        cmd = iac6(ch)
      Case Else
        MsgBox "Invalid 'next (" + Str$(cmd) + ")' processing routine in cmd loop"
    End Select
  Next x
  
  cursor_timer.Enabled = True

End Sub

