VERSION 2.00
Begin Form Form1 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Wave VBX Action Sample"
   ClientHeight    =   2550
   ClientLeft      =   1650
   ClientTop       =   1920
   ClientWidth     =   4095
   Height          =   2955
   Left            =   1590
   LinkTopic       =   "Form1"
   ScaleHeight     =   2550
   ScaleWidth      =   4095
   Top             =   1575
   Width           =   4215
   Begin TextBox txtFileLength 
      Height          =   285
      Left            =   240
      TabIndex        =   6
      Top             =   1200
      Width           =   3615
   End
   Begin MabryWave Wave1 
      Exclusive       =   0   'False
      FileLength      =   -1
      Filename        =   ""
      Left            =   3480
      Loop            =   0   'False
      Loop            =   0   'False
      PlayEnd         =   -1
      PlayStart       =   -1
      Top             =   0
   End
   Begin TextBox txtFilename 
      Height          =   285
      Left            =   240
      TabIndex        =   3
      Text            =   "C:\WINDOWS\RINGOUT.WAV"
      Top             =   480
      Width           =   3615
   End
   Begin CommandButton btnStop 
      Caption         =   "Stop"
      Height          =   615
      Left            =   2640
      TabIndex        =   2
      Top             =   1680
      Width           =   1215
   End
   Begin CommandButton btnPause 
      Caption         =   "Resume"
      Height          =   615
      Left            =   1440
      TabIndex        =   1
      Top             =   1680
      Width           =   1215
   End
   Begin CommandButton btnPlay 
      Caption         =   "Play"
      Height          =   615
      Left            =   240
      TabIndex        =   0
      Top             =   1680
      Width           =   1215
   End
   Begin Label Label2 
      BackColor       =   &H00C0C0C0&
      Caption         =   "File Length:"
      Height          =   255
      Left            =   240
      TabIndex        =   5
      Top             =   960
      Width           =   2415
   End
   Begin Label Label1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Filename:"
      Height          =   255
      Left            =   240
      TabIndex        =   4
      Top             =   240
      Width           =   1935
   End
End
Option Explicit

Dim fChanged As Integer ' flag: has filename changed?

Sub btnPause_Click ()
    ' if the user wants to pause
    If btnPause.Caption = "Pause" Then
        ' pause
        Wave1.Action = 2
    Else
        ' resume
        Wave1.Action = 3
    End If

    EnableButtons
End Sub

Sub btnPlay_Click ()
    ' make sure the filename is up to date
    SetFilename

    ' play the file
    Wave1.Action = 1
    EnableButtons
End Sub

Sub btnStop_Click ()
    ' stop playing
    Wave1.Action = 4

    ' update buttons
    EnableButtons
End Sub

Sub EnableButtons ()
    Select Case Wave1.Status
        Case 1: ' playing
            If btnPause.Caption <> "Pause" Then
                btnPause.Caption = "Pause"
            End If

            btnStop.Enabled = True
            btnPause.Enabled = True

        Case 2: ' paused
            If btnPause.Caption <> "Resume" Then
                btnPause.Caption = "Resume"
            End If

            btnStop.Enabled = True
            btnPause.Enabled = True

        Case 4: ' stopped
            If btnPause.Caption <> "Pause" Then
                btnPause.Caption = "Pause"
            End If

            btnStop.Enabled = False
            btnPause.Enabled = False
    End Select
End Sub

Sub Form_Load ()
    fChanged = True
    EnableButtons
End Sub

Sub SetFilename ()
    ' if the filename has changed, tell Wave VBX
    If fChanged Then
        ' changed no more
        fChanged = False
        Wave1.Filename = txtFilename

        ' set the file length field
        txtFileLength = Format(Wave1.FileLength / 1000, "0.000") & " seconds"
    End If
End Sub

Sub txtFilename_Change ()
    fChanged = True
End Sub

Sub Wave1_PlayDone ()
    EnableButtons
End Sub

