/*
//	SCCS Id: "@(#)bitlist.h		(C) Yves Roumazeilles	94/03/01";
//
//	Version: 1.01
*/

#ifndef	__BITLIST_H__
#define	__BITLIST_H__

#ifndef	T_BASE_TYPE
# define	T_BASE_TYPE	unsigned long
#endif
#define	SZ_BASE_TYPE		sizeof(T_BASE_TYPE)
#define	BITS_BASE_TYPE		(SZ_BASE_TYPE*8)
#define	NUM_BASE_ELEM(x)	(x)->Size


#define	T_BIT_LIST	\
		struct {\
			int			Size;\
			HANDLE			hBits;\
			T_BASE_TYPE FAR*	Bits;\
		}
typedef T_BIT_LIST	BLIST;



/* Basic operations declaration */

#define	INDEX_BIT(n)	((n) / BITS_BASE_TYPE)
#define	MASQUE_BIT(n)	(1L << ((n) % BITS_BASE_TYPE))


#define	BSET(t, n)	(t).Bits[INDEX_BIT(n)] |= MASQUE_BIT(n)
#define	BCHG(t, n)	(t).Bits[INDEX_BIT(n)] ^= MASQUE_BIT(n)
#define	BCLR(t, n)	(t).Bits[INDEX_BIT(n)] &= ~MASQUE_BIT(n)
#define	BTST(t, n)	((t).Bits[INDEX_BIT(n)] & MASQUE_BIT(n))


#ifdef	BITLIST_BUILD
#define	BLCALL	FAR PASCAL
#else
#define	BLCALL	FAR
#endif
extern void BLCALL	BitListDebugOutput(BLIST FAR *x);
extern void BLCALL	BitListClr(BLIST FAR *x);
extern void BLCALL	BitListSet(BLIST FAR *x);
extern void BLCALL	BitListChg(BLIST FAR *x);
extern int BLCALL	BitListCtorClr(BLIST FAR *x, int n);
#define	BitListCtor(x,n)	BitListCtorClr(x,n);
extern int BLCALL	BitListCtorSet(BLIST FAR *x, int n);
extern int BLCALL	BitListEmpty(BLIST FAR *x);
extern void BLCALL	BitListCopy(BLIST FAR *x, BLIST FAR *y);
extern int BLCALL	BitListCopyCtor(BLIST FAR *x, BLIST FAR *y, int n);
extern void BLCALL	BitListLShift(BLIST FAR *x, int n);
extern void BLCALL	BitListRShift(BLIST FAR *x, int n);
extern void BLCALL	BitListOr(BLIST FAR *x, BLIST FAR *y);
extern void BLCALL	BitListCopyOr(BLIST FAR *x, BLIST FAR *y, BLIST FAR *z);
extern void BLCALL	BitListAnd(BLIST FAR *x, BLIST FAR *y);
extern void BLCALL	BitListCopyAnd(BLIST FAR *x, BLIST FAR *y, BLIST FAR *z);
extern void BLCALL	BitListAndNot(BLIST FAR *x, BLIST FAR *y);
extern void BLCALL	BitListOrNot(BLIST FAR *x, BLIST FAR *y);
extern void BLCALL	BitListNot(BLIST FAR *x);
extern void BLCALL	BitListAdd(BLIST FAR *x, BLIST FAR *y);
extern void BLCALL	BitListSub(BLIST FAR *x, BLIST FAR *y);
extern int BLCALL	BitListEqual(BLIST FAR *x, BLIST FAR *y);
extern int BLCALL	BitListEqualZero(BLIST FAR *x);
extern int BLCALL	BitListCompare(BLIST FAR *x, BLIST FAR *y);
extern int BLCALL	BitListLock(BLIST FAR *x);
extern int BLCALL	BitListUnlock(BLIST FAR *x);

#endif	/* __BITLIST_H__ */
