/*
//	SCCS Id: "@(#)bitlist.h		(C) Yves Roumazeilles	94/05/27";
//
//	Version: 1.02a
*/

#ifndef	__BITLIST_H__
#define	__BITLIST_H__

#include	<memory.h>
#include	<string.h>

#ifndef	T_BASE_TYPE
# define	T_BASE_TYPE	unsigned long
#endif
#define	SZ_BASE_TYPE		sizeof(T_BASE_TYPE)
#define	BITS_BASE_TYPE		(SZ_BASE_TYPE*8)
#define	NUM_BASE_ELEM(x)	(x)->Size


typedef	struct tagBList {
	int			Size;
#ifdef	WINVER
	HANDLE			hBits;
	T_BASE_TYPE FAR*	Bits;
#else
	T_BASE_TYPE*		Bits;
#endif
} BLIST;
#ifdef	WINVER
typedef	BLIST FAR*	LPBLIST;
#else
typedef	BLIST*		LPBLIST;
#endif



/* Basic operations declaration */

#define	INDEX_BIT(n)	((n) / BITS_BASE_TYPE)
#define	MASQUE_BIT(n)	(1L << ((n) % BITS_BASE_TYPE))


#define	BSET(t, n)	(t).Bits[INDEX_BIT(n)] |= MASQUE_BIT(n)
#define	BCHG(t, n)	(t).Bits[INDEX_BIT(n)] ^= MASQUE_BIT(n)
#define	BCLR(t, n)	(t).Bits[INDEX_BIT(n)] &= ~MASQUE_BIT(n)
#define	BTST(t, n)	((t).Bits[INDEX_BIT(n)] & MASQUE_BIT(n))
#define	BSET_unlocked(t, n)	BitListLock(&t);\
				(t).Bits[INDEX_BIT(n)] |= MASQUE_BIT(n);\
				BiTListUnlock(&t)
#define	BCHG_unlocked(t, n)	BitListLock(&t);\
				(t).Bits[INDEX_BIT(n)] ^= MASQUE_BIT(n);\
				BiTListUnlock(&t)
#define	BCLR_unlocked(t, n)	BitListLock(&t);\
				(t).Bits[INDEX_BIT(n)] &= ~MASQUE_BIT(n);\
				BiTListUnlock(&t)
#define	BTST_unlocked(t, n)	BitListLock(&t);\
				((t).Bits[INDEX_BIT(n)] & MASQUE_BIT(n));\
				BiTListUnlock(&t)

#ifdef	WINVER
#ifdef	BITLIST_BUILD
#define	BLCALL	FAR PASCAL
#else
#define	BLCALL	FAR
#endif
#else
#define	BLCALL
#endif
extern void BLCALL	BitListDebugOutput(LPBLIST x);
extern void BLCALL	BitListClr(LPBLIST x);
extern void BLCALL	BitListSet(LPBLIST x);
extern void BLCALL	BitListChg(LPBLIST x);
extern int BLCALL	BitListCtorClr(LPBLIST x, int n);
#define	BitListCtor(x,n)	BitListCtorClr(x,n);
extern int BLCALL	BitListCtorSet(LPBLIST x, int n);
extern int BLCALL	BitListEmpty(LPBLIST x);
extern void BLCALL	BitListCopy(LPBLIST x, LPBLIST y);
extern int BLCALL	BitListCopyCtor(LPBLIST x, LPBLIST y, int n);
extern void BLCALL	BitListLShift(LPBLIST x, int n);
extern void BLCALL	BitListRShift(LPBLIST x, int n);
extern void BLCALL	BitListOr(LPBLIST x, LPBLIST y);
extern void BLCALL	BitListCopyOr(LPBLIST x, LPBLIST y, LPBLIST z);
extern void BLCALL	BitListAnd(LPBLIST x, LPBLIST y);
extern void BLCALL	BitListCopyAnd(LPBLIST x, LPBLIST y, LPBLIST z);
extern void BLCALL	BitListAndNot(LPBLIST x, LPBLIST y);
extern void BLCALL	BitListOrNot(LPBLIST x, LPBLIST y);
extern void BLCALL	BitListNot(LPBLIST x);
extern void BLCALL	BitListAdd(LPBLIST x, LPBLIST y);
extern void BLCALL	BitListSub(LPBLIST x, LPBLIST y);
extern void BLCALL	BitListMultiply(LPBLIST x, LPBLIST y);	/* not implemented */
extern void BLCALL	BitListDivide(LPBLIST x, LPBLIST y);	/* not implemented */
extern int BLCALL	BitListEqual(LPBLIST x, LPBLIST y);
extern int BLCALL	BitListEqualZero(LPBLIST x);
extern int BLCALL	BitListCompare(LPBLIST x, LPBLIST y);
#ifdef	WINVER
extern int BLCALL	BitListLock(LPBLIST x);
extern int BLCALL	BitListUnlock(LPBLIST x);
#else
#define	BitListLock(x)
#define	BitListUnlock(x)
#endif

#endif	/* __BITLIST_H__ */
