// barvw.cpp : implementation of the CBarView class
//

// (c) Copyright 1994 HEX TECHNOLOGY. All rights reserved.
// This sample code is provided as a example implementation
// using barcodes.dll.  You may only distribute or modify this
// code if you purchase a license for barcodes.dll.


#include "stdafx.h"
#include "bartest.h"

#include "bardoc.h"
#include "barvw.h"  
#include "barcodes.h"  
#include "ctl3d.h"  

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBarView

IMPLEMENT_DYNCREATE(CBarView, CFormView)

BEGIN_MESSAGE_MAP(CBarView, CFormView)
	//{{AFX_MSG_MAP(CBarView)
	ON_BN_CLICKED(IDC_BACKGROUND, OnBackground)
	ON_BN_CLICKED(IDC_BARCOLOR, OnBarcolor)
	ON_EN_KILLFOCUS(IDC_DATA, OnKillfocus)
	ON_BN_CLICKED(IDC_HORIZONTAL, OnClicked)
	ON_WM_DRAWITEM()
	ON_CBN_SELCHANGE(IDC_STYLE, OnSelchangeStyle)
	ON_EN_KILLFOCUS(IDC_FONTFACE, OnKillfocus)
	ON_BN_CLICKED(IDC_BOLD, OnClicked)
	ON_BN_CLICKED(IDC_CHECK, OnClicked)
	ON_BN_CLICKED(IDC_ITALIC, OnClicked)
	ON_CBN_SELCHANGE(IDC_RATIO, OnClicked)
	ON_BN_CLICKED(IDC_SHOWTEXT, OnClicked)
	ON_BN_CLICKED(IDC_SWITCH, OnClicked)
	ON_EN_KILLFOCUS(IDC_TEXT, OnKillfocus)
	ON_EN_KILLFOCUS(IDC_TWEAK, OnKillfocus)
	ON_BN_CLICKED(IDC_VERTICAL, OnClicked)
	ON_EN_KILLFOCUS(IDC_HEIGHT, OnKillfocus)
	ON_EN_KILLFOCUS(IDC_WIDTH, OnKillfocus)
	ON_CBN_KILLFOCUS(IDC_STYLE, OnKillfocus)
	ON_BN_CLICKED(IDC_SPACER, OnClicked)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CFormView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CFormView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBarView construction/destruction

CBarView::CBarView()
	: CFormView(CBarView::IDD)
{
	CString settings("Settings");
	//{{AFX_DATA_INIT(CBarView)
	m_sData = "";
	m_sText = "";
	m_bBold = FALSE;
	m_bCheck = FALSE;
	m_sFontFace = "";
	m_bHorizontal = FALSE;
	m_bItalic = FALSE;
	m_iRatio = 0;
	m_bShowData = FALSE;
	m_bSwitch = FALSE;
	m_iFontAdjust = 0;
	m_bVertical = FALSE;
	m_sStyle = AfxGetApp()->GetProfileString("Settings","StyleName", "EAN 8,11");
	m_iWidth = 0;
	m_iHeight = 0;
	m_bSpacer = FALSE;
	//}}AFX_DATA_INIT
	// TODO: add construction code here
	m_bCentreBarcode = TRUE;
}

CBarView::~CBarView()
{   
	AfxGetApp()->WriteProfileString("Settings","StyleName", m_sStyle);

}

void CBarView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CBarView)
	DDX_Control(pDX, IDC_PREVIEW, m_Preview);
	DDX_Text(pDX, IDC_DATA, m_sData);
	DDX_Text(pDX, IDC_TEXT, m_sText);
	DDX_Check(pDX, IDC_BOLD, m_bBold);
	DDX_Check(pDX, IDC_CHECK, m_bCheck);
	DDX_Text(pDX, IDC_FONTFACE, m_sFontFace);
	DDX_Check(pDX, IDC_HORIZONTAL, m_bHorizontal);
	DDX_Check(pDX, IDC_ITALIC, m_bItalic);
	DDX_CBIndex(pDX, IDC_RATIO, m_iRatio);
	DDX_Check(pDX, IDC_SHOWTEXT, m_bShowData);
	DDX_Check(pDX, IDC_SWITCH, m_bSwitch);
	DDX_Text(pDX, IDC_TWEAK, m_iFontAdjust);
	DDX_Check(pDX, IDC_VERTICAL, m_bVertical);
	DDX_CBString(pDX, IDC_STYLE, m_sStyle);
	DDX_Text(pDX, IDC_WIDTH, m_iWidth);
	DDX_Text(pDX, IDC_HEIGHT, m_iHeight);
	DDX_Check(pDX, IDC_SPACER, m_bSpacer);
	//}}AFX_DATA_MAP
}

void CBarView::OnUpdate(CView*, LPARAM, CObject*)
{             
	CBarDoc *pDoc = GetDocument();
    m_sData = pDoc->m_sData;
	m_sText = pDoc->m_sText;
	m_bBold = pDoc->m_bBold;
	m_iFontAdjust = pDoc->m_iFontAdjust;
	m_sFontFace = pDoc->m_sFontFace;
	m_bItalic = pDoc->m_bItalic;
	m_iRatio = pDoc->m_iRatio;
	m_iStyle = pDoc->m_iStyle;
	m_iWidth = pDoc->m_iWidth;
	m_iHeight = pDoc->m_iHeight;
	m_bCheck = (pDoc->m_iDisplayFlags & FLAG_CheckDigit) != 0;
	m_bHorizontal = (pDoc->m_iDisplayFlags & FLAG_WBearerBar) != 0;
	m_bShowData = (pDoc->m_iDisplayFlags & FLAG_ShowData) != 0;
	m_bSwitch = (pDoc->m_iDisplayFlags & FLAG_SwitchText) != 0;
	m_bVertical = (pDoc->m_iDisplayFlags & FLAG_HBearerBar) != 0; 
	m_bSpacer = (pDoc->m_iDisplayFlags & FLAG_ShowSpacer) != 0;  
      
    UpdateData(FALSE);  // set the data into the controls   
                
};

void CBarView::OnDataChange()
{             
	UpdateData(TRUE);  // get values from dialog
	
	CBarDoc *pDoc = GetDocument();
    
    pDoc->m_sData = m_sData;   // save to document variables
	pDoc->m_sText = m_sText;
	pDoc->m_bBold = m_bBold;
	pDoc->m_iFontAdjust = m_iFontAdjust;
	pDoc->m_bItalic = m_bItalic;
	pDoc->m_iRatio = m_iRatio;
	pDoc->m_iStyle = m_iStyle;
	pDoc->m_sFontFace = m_sFontFace;
    pDoc->m_iHeight = m_iHeight;
    pDoc->m_iWidth = m_iWidth;
           
    pDoc->m_iDisplayFlags = 0;
	pDoc->m_iDisplayFlags |= (m_bCheck ? FLAG_CheckDigit : 0);
	pDoc->m_iDisplayFlags |= (m_bHorizontal ? FLAG_WBearerBar : 0);
	pDoc->m_iDisplayFlags |= (m_bShowData ? FLAG_ShowData : 0);
	pDoc->m_iDisplayFlags |= (m_bSwitch ? FLAG_SwitchText : 0);
	pDoc->m_iDisplayFlags |= (m_bVertical  ? FLAG_HBearerBar : 0);  
	pDoc->m_iDisplayFlags |= (m_bSpacer  ? FLAG_ShowSpacer : 0);  
	
      
};


void CBarView::OnInitialUpdate() {

   CFormView::OnInitialUpdate();

   ResizeParentToFit(FALSE);
   Ctl3dSubclassDlg(m_hWnd, CTL3D_ALL); 
};

/////////////////////////////////////////////////////////////////////////////
// CBarView printing

BOOL CBarView::OnPreparePrinting(CPrintInfo* pInfo)
{
	pInfo->SetMaxPage(1);
	pInfo->SetMinPage(1);
	return DoPreparePrinting(pInfo);
}

void CBarView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CBarView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

void CBarView::OnPrint(CDC* pDC, CPrintInfo* pInfo)
{

	CRect rect( pInfo->m_rectDraw);
	
	m_bCentreBarcode = TRUE;
	
	DrawBarcodePrivate( pDC, rect);     

 	
}                          


// DrawBarcodePrivate()
// This function is a do-all function to draw the barcode on the screen
// or to the printer DC... 

BOOL CBarView::DrawBarcodePrivate( CDC *pDC, CRect rect ) {

	HMETAFILE hmf;						// holds pointer to barcode metafile 

										// set by call to dll->DrawBarcode
  	int entireWidth, entireHeight, barcodeWidth, barcodeHeight;
	
	int fontFlags = (m_bBold ? FONT_BOLD : 0) + ( m_bItalic ? FONT_ITALIC : 0);
	
    pDC->SaveDC();
    
    // Call to barcode.dll function with parameters
  	hmf = DrawBarcode( 		pDC->m_hDC, 
  							(int) m_iStyle,
  						    (LPSTR) (const char *) m_sData,
  						    (LPSTR) (const char *)m_sText,
  						     GetDocument()->m_iDisplayFlags,
  						     m_iRatio, 
  						     (LPSTR)(const char *)m_sFontFace,
  						     fontFlags,  
  						     m_iFontAdjust,
  						      GetDocument()->m_cBarColor,
  						      GetDocument()->m_cBackgroundColor,
  						      (int far *) &entireWidth, 		// dll sets these four values
  						      (int far *) &entireHeight,        // on return
  						      (int far *) &barcodeWidth,
  						      (int far *) &barcodeHeight);
  						      
 
     pDC->SetMapMode( MM_ANISOTROPIC);		// so we can scale the extents
  
    if( hmf == NULL)						// if NULL then invalid data string
    	return FALSE; 
 
    // widthOption, heightOption
    // 1 = Scaled to size in millimetres specified by m_iWidth and m_iHeight
    // 0 = Scaled on a percentage basis of returned barcode size.
      
     int widthOption = 1, heightOption = 1;	
    
     // scaleWidth, scaleHeight
     // Since the desired size ( m_Width and m_Height) relate to the actual
     // bars of the barcode and not the space taken by the text
     // we must calculate the size of the entire barcode metafile so that the
     // internal barcode m_iHeight and m_iWidth are as desired.
     // therefore we increase them in proportion to the fraction
     // (entireW/H / barcodeW/H )
     // if percentage basis ( option = 0) then calculate percentage scaling
     // of the entire value eg: ( entire * ( percent / 100 ))
      
     float scaleWidth = 
     		((widthOption == 1) ? 
     	  		(m_iWidth * (float)(entireWidth  / (float)barcodeWidth)) 
				: (entireWidth * (m_iWidth / 100.0F))) ;
 	  
	 float scaleHeight = 
 	 	 	( heightOption == 1) ?
	 	 	 (m_iHeight * (float)(entireHeight / (float)barcodeHeight))    
      		: ( entireHeight * (float) ( m_iHeight / 100.0F));
 
 	
 	// How many (device units) pixels do we require to fill the desired 
 	// scaleWidth and scaleHeight
   
 	float barWidthPixel=  
 			(widthOption == 1 ) ? 
 				((float)scaleWidth /   pDC->GetDeviceCaps(HORZSIZE)) * (float)pDC->GetDeviceCaps(HORZRES)
 			 : scaleWidth;

 	float barHeightPixel= 
 			(heightOption == 1) ? 
 				((float)scaleHeight /   pDC->GetDeviceCaps(VERTSIZE)) * (float)pDC->GetDeviceCaps(VERTRES) 
 			: scaleHeight;
    

	// little bit of extra code to centre barcode in window

    if( m_bCentreBarcode ) {  
		int xoff, yoff;
	    xoff = (int) ((rect.Width() - barWidthPixel) / 2.0);
	    yoff = (int) ((rect.Height() - barHeightPixel) / 2.0);
	    if( xoff < 0)
   		     xoff = 0;
	     if( yoff < 0)
   		     yoff = 0;
	 	 pDC->OffsetViewportOrg( xoff, yoff);   
    } 
    
     // HIMETRIC 1000, 1000...
     pDC->SetWindowExt(1000,1000); 
      
     int xratio =   (int) ((barWidthPixel / (float)entireWidth) * 1000.0F);
     int yratio = (int) ((barHeightPixel / (float)entireHeight) * 1000.0F);
    
     // xratio, yratio are 1000  + or - some value to scale up or scale down
     // the size of the metafile to get desired size.	
    
    pDC->SetViewportExt(xratio, yratio);

	// and after all that .. we finally get to see something !!!                            
    pDC->PlayMetaFile(hmf);

	// remember to always delete the Metafile
    DeleteMetaFile(hmf);  

	// tidy up
	pDC->RestoreDC(-1);  // for SaveDC
  
	return TRUE;  
};



/////////////////////////////////////////////////////////////////////////////
// CBarView diagnostics

#ifdef _DEBUG
void CBarView::AssertValid() const
{
	CFormView::AssertValid();
}

void CBarView::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}

CBarDoc* CBarView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CBarDoc)));
	return (CBarDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CBarView message handlers

void CBarView::OnBackground()
{
	CColorDialog dlg( GetDocument()->m_cBackgroundColor); 
	if( dlg.DoModal() == IDOK)
		 GetDocument()->m_cBackgroundColor = dlg.GetColor();                                       
	UpdatePreview();
	
}

void CBarView::OnBarcolor()  
{
	CColorDialog dlg( GetDocument()->m_cBarColor); 
	if( dlg.DoModal() == IDOK)
		 GetDocument()->m_cBarColor = dlg.GetColor();                                       
	UpdatePreview();	
} 

void CBarView::UpdatePreview() {

  OnDataChange();
  m_Preview.Invalidate();
};

void CBarView::OnKillfocus()
{
   	UpdatePreview();
}

void CBarView::OnClicked()
{
	UpdatePreview();
} 


 
// OnDrawItem
// Called by Windows when barcode preview windows needs redrawing..
void CBarView::OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct)
{
	if( nIDCtl == IDC_PREVIEW) {
	
	CDC * dc = CDC::FromHandle( lpDrawItemStruct->hDC);
	CRect rect(&(lpDrawItemStruct->rcItem));
	
	// clear the preview window first
	dc->PatBlt( rect.left,rect.top, rect.right, rect.bottom, WHITENESS );
	if( ! DrawBarcodePrivate( dc, rect) ) 
	  dc->DrawText("Invalid Data for Style", 22, rect, DT_SINGLELINE | DT_CENTER | DT_VCENTER);
	
  	}
	 else
		CFormView::OnDrawItem(nIDCtl, lpDrawItemStruct);
}

void CBarView::OnSelchangeStyle()
{
	UpdateData(TRUE);
    SaveStyle();   
    UpdatePreview();
} 


// SaveStyle
// the style combo box stores the style in the form name,styleNum
// we want the styleNum part only....
// ideally this combo should be an ownerdrawn box so you don't have
// to display the style num within the combo box items.
void CBarView::SaveStyle() {                           
	// grab everything after the comma
     CString index =  m_sStyle.Right( m_sStyle.GetLength() - m_sStyle.Find(',') - 1);	
     // convert to integer and store in m_iStyle
     sscanf((const char *) index , "%i", & m_iStyle);
};
