#include <windows.h>
#include <windowsx.h>
#include "app.h"
#include "dll.h"

//=============================================================
LRESULT CALLBACK _export WndProc( HWND, UINT, WPARAM, LPARAM );


//=============================================================
static char szMenuName[]  = "MainMenu";
static char szClassName[] = "SampleApp";
static char szTitle[]     = "Sample Application";


//=============================================================
int PASCAL WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpCmdLine,  int nCmdShow )
{
    MSG  msg;
    HWND hwnd;
    WNDCLASS wc;

    if ( !hPrevInstance )
    {
        wc.style            = NULL;
        wc.lpfnWndProc      = WndProc;
        wc.cbClsExtra       = 0;
        wc.cbWndExtra       = 0;
        wc.hInstance        = hInstance;
        wc.hIcon            = LoadIcon( NULL, IDI_APPLICATION );
        wc.hCursor          = LoadCursor( NULL, IDC_ARROW );
        wc.hbrBackground    = ( HBRUSH )( COLOR_WINDOW + 1 );
        wc.lpszMenuName     = szMenuName;
        wc.lpszClassName    = ( LPSTR )szClassName;
        if ( !RegisterClass( &wc ) )
            return( FALSE );
    }

    hwnd = CreateWindow( szClassName,
                         szTitle,
                         WS_OVERLAPPEDWINDOW,
                         CW_USEDEFAULT,
                         CW_USEDEFAULT,
                         CW_USEDEFAULT,
                         CW_USEDEFAULT,
                         NULL,
                         NULL,
                         hInstance,
                         NULL );

    ShowWindow( hwnd, nCmdShow );
    UpdateWindow( hwnd );

    while ( GetMessage( &msg, NULL, NULL, NULL) )
	{
        TranslateMessage( &msg );
        DispatchMessage( &msg );
    }
    return( msg.wParam );
}



//=============================================================
void MainHwnd_OnDestroy( HWND hwnd )
{
    PostQuitMessage( 0 );
}



//=============================================================
void MainHwnd_OnCommand( HWND hwnd, int id, HWND hwndCtl, 
                         UINT codeNotify )
{
    switch( id  )
    {
        case IDM_GRAPHWIN:
             ShowGraphWindow( hwnd );
             break;

        default:
            break;
    }
}



//=============================================================
LRESULT CALLBACK _export WndProc( HWND hwnd, UINT msg,
                                  WPARAM wParam, LPARAM lParam )
{
    switch ( msg )
    {
        HANDLE_MSG( hwnd, WM_DESTROY, MainHwnd_OnDestroy);
        HANDLE_MSG( hwnd, WM_COMMAND, MainHwnd_OnCommand );

        default:
             return DefWindowProc( hwnd, msg, wParam, lParam );
    }
    return ( 0L );
}
