
/* *************************************************************** */
/*                                                                 */
/*                                                                 */
/*                                                                 */
/*    FTP4W.DLL  (Version 1.1)                                     */
/*                                                                 */
/*                                                                 */
/*                                   By Ph. Jounin (SNCF 71-26-12) */
/*                                        Internet ark@ifh.sncf.fr */
/*                                        Thanks to Santanu Lahiri */
/* *************************************************************** */


#ifndef WFTP_API

#include <winsock.h>

#ifdef DEBUG
#  define  FTP_DATABUFFER  256                 /* slown down the transfer */
#else
#  define  FTP_DATABUFFER  1450 /* a good value for X25/Ethernet/Token Ring */
#endif



/* ----------------------------------------------------------- */

/* ASCII or binary tranfser */
#define   TYPE_A   'A'
#define   TYPE_I   'I'


/* ----------------------------------------------------------- */
/*              Return codes of FTP functions                  */
/* ----------------------------------------------------------- */
/* success */
#define   FTPERR_OK                    0 /* succesful function                */
#define   FTPERR_ENTERPASSWORD         1 /* userid need a password            */
#define   FTPERR_ACCOUNTNEEDED         2 /* user/pass OK but account required */
#define   FTPERR_CANCELBYUSER         -1 /* Transfer aborted by user FtpAbort */
/* user's or programmer's Errors  */
#define   FTPERR_INVALIDPARAMETER   1000 /* Error in parameters               */
#define   FTPERR_SESSIONUSED        1001 /* User has already a FTP session    */
#define   FTPERR_NOTINITIALIZED     1002 /* FtpInit has not been call         */
#define   FTPERR_NOTCONNECTED       1003 /* User is not connected to a server */
#define   FTPERR_CANTOPENFILE       1004 /* can not open specified file       */
#define   FTPERR_CANTWRITE          1005 /* can't write into file (disk full?)*/
#define   FTPERR_NOACTIVESESSION    1006 /* FtpRelease without FtpInit        */
#define   FTPERR_STILLCONNECTED     1007 /* FtpRelease without any Close      */
#define   FTPERR_SERVERCANTEXECUTE  1008 /* file action not taken             */
#define   FTPERR_LOGINREFUSED       1009 /* Server rejects usrid/passwd       */
#define   FTPERR_NOREMOTEFILE       1010 /* server can not open file          */
#define   FTPERR_TRANSFERREFUSED    1011 /* Host refused the transfer         */
#define   FTPERR_WINSOCKNOTUSABLE   1012 /* A winsock.DLL ver 1.1 is required */
/* TCP errors */
#define   FTPERR_UNKNOWNHOST        2001 /* can not resolve host adress       */
#define   FTPERR_NOREPLY            2002 /* host does not send an answer      */
#define   FTPERR_CANTCONNECT        2003 /* Error during connection           */
#define   FTPERR_CONNECTREJECTED    2004 /* host has no FTP server            */
#define   FTPERR_SENDREFUSED        2005 /* can't send data (network down)    */
#define   FTPERR_DATACONNECTION     2006 /* connection on data-port failed    */
#define   FTPERR_TIMEOUT            2007 /* timeout occured                   */
/* FTP errors */
#define   FTPERR_UNEXPECTEDANSWER   3001  /* answer was not expected          */
#define   FTPERR_CANNOTCHANGETYPE   3002  /* host rejects the TYPE command    */
/* Resource errors */
#define   FTPERR_CANTCREATEWINDOW   5002  /* Insufficent free resources       */
#define   FTPERR_INSMEMORY          5003  /* Insuffisent Heap memory          */
#define   FTPERR_CANTCREATESOCKET   5004  /* no more socket                   */
#define   FTPERR_CANTBINDSOCKET     5005  /* bind is not succesful            */


/* ----------------------------------------------------------- */

struct S_FtpData
{
   SOCKET   ctrl_socket;    /* control stream      init INVALID_SOCKET */
   SOCKET   data_socket;    /* data stream         init INVALID_SOCKET */
   SOCKET   listen_socket;  /* listen socket       init INVALID_SOCKET */
   char     cType;          /* type (ASCII/binary) init TYPE_A         */
   BOOL     bVerbose;       /* verbose mode        init FALSE          */ 
   unsigned nPort;          /* connexion Port      init FTP_DEFPORT    */
   unsigned nTimeOut;       /* TimeOut in seconds  init FTP_DEFTIMEOUT */
   char     szInBuf [1024]; /* incoming Buffer                         */
   char     szOutBuf [512]; /* outgoing buffer                         */
   struct sockaddr_in saSockAddr;   
   struct sockaddr_in saAcceptAddr;
}; /* struct S_FtpData */


struct S_FileTrf 
{
   HFILE    hf;         /* handle of the file which is being transfered */
   unsigned nCount;     /* number of writes/reads made on a file        */
   unsigned nAsyncAlone;/* pause each N frame in Async mode  (Def 40)   */
   unsigned nAsyncMulti;/* Idem but more than one FTP sssion (Def 10)   */
   unsigned nDelay;     /* time of the pause in milliseconds            */
   BOOL     bAborted;   /* data transfer has been canceled              */
   char     szBuf[FTP_DATABUFFER]; /* Data buffer                       */
   BOOL     bNotify;    /* application receives a msg each data packet  */
   BOOL     bAsyncMode; /* synchronous or asynchronous Mode             */
   LONG     lPos;       /* Bytes transfered                             */
   LONG     lTotal;     /* bytes to be transfered                       */
}; /* struct S_FileTrf */

struct S_Msg
{
   HWND          hParentWnd;        /* window which the msg is to be passed   */
   UINT          nCompletedMessage; /* msg to be sent at end of the function  */
};  /* struct S_Msg */


struct S_Verbose
{
   HWND          hVerboseWnd;  /* window which the message is to be passed    */
   UINT          nVerboseMsg;  /* msg to be sent each time a line is received */
};

/* global structure */
struct S_ProcData
{  
   /* task data */
   HTASK      hTask;              /* Task Id                              */
   HWND       hFtpWnd;            /* Handle of the internal window        */
   HWND       hParentWnd;         /* handle given to the FtpInit function */
   HINSTANCE  hInstance;          /* Task Instance                        */

   /* Mesasge information */
   struct S_Msg      Msg;      
   struct S_Verbose  VMsg;      
                                                               
   /* File information */
   struct S_FileTrf  File;  

   /* Ftp information */
   struct S_FtpData   ftp;
   
   /* Linked list */
   struct S_ProcData far *Next;
   struct S_ProcData far *Prev;
}; /* struct S_ProcData */

typedef struct S_ProcData far * LPProcData;
typedef struct S_FtpData far *  LPFtpData;

/* **************************************************************** */
/*                                                                  */
/*   Parameters                                                     */
/*                                                                  */
/* **************************************************************** */

#define  FtpBytesTransfered()       FtpDataPtr()->File.lPos
#define  FtpBytesToBeTransfered()   FtpDataPtr()->File.lTotal

#define  FtpSetDefaultTimeOut(x)    FtpDataPtr()->ftp.nTimeOut=x /* x seconds */
#define  FtpSetDefaultPort(x)       FtpDataPtr()->ftp.nPort=x
#define  FtpSetAsynchronousMode()   FtpDataPtr()->File.bAsyncMode=TRUE
#define  FtpSetSynchronousMode()    FtpDataPtr()->File.bAsyncMode=FALSE
#define  FtpIsAsynchronousMode()   (FtpDataPtr()->File.bAsyncMode)
#define  FtpSetNewDelay(x)          FtpDataPtr()->File.nDelay=x /* x millisec */
#define  FtpSetNewSlices(x,y)       FtpDataPtr()->File.nAsyncAlone=x, \
                                    FtpDataPtr()->File.nAsyncAlone=y


/* **************************************************************** */
/*                                                                  */
/*                    P R O T O T Y P E S                           */
/*                                                                  */
/* **************************************************************** */

/* Utilities functions */
LPProcData PASCAL FAR  FtpDataPtr (void);
int PASCAL FAR WEP (int nType);
int PASCAL FAR FtpSetVerboseMode (BOOL bVerboseMode, HWND hVerboseWnd, UINT wMsg);

/* Init functions */
int PASCAL FAR FtpRelease (void);
int PASCAL FAR FtpInit (HWND hParentWnd);

/* Connection */
int PASCAL FAR FtpLogin (LPSTR szHost, LPSTR szUser, LPSTR szPasswd,
                         HWND hParentWnd, UINT wMsg);
int PASCAL FAR FtpOpenConnection (LPSTR szHost);
int PASCAL FAR FtpCloseConnection (void);
int PASCAL FAR FtpLocalClose (void);

/* authentification */
int PASCAL FAR  FtpSendUserName (LPSTR szUserName);
int PASCAL FAR  FtpSendPasswd (LPSTR szPasswd);

/* commands */
int PASCAL FAR FtpHelp  (LPSTR szArg, LPSTR szBuf, UINT uBufSize);
int PASCAL FAR FtpCWD   (LPSTR szPath);
int PASCAL FAR FtpQuote (LPSTR szCmd, LPSTR szReplyBuf, UINT uBufSize);
int PASCAL FAR FtpSetType  (char cType);

/* file transfer */
int PASCAL FAR FtpAbort (void);
int PASCAL FAR FtpSendFile (LPSTR szLocal, LPSTR szRemote, char cType, 
                            BOOL bNotify, HWND hParentWnd, UINT wMsg);
int PASCAL FAR FtpRecvFile (LPSTR szRemote, LPSTR szLocal, char cType, 
                            BOOL bNotify, HWND hParentWnd, UINT wMsg);


DWORD PASCAL FAR FtpGetFileSize (void);

/* Directory */
int PASCAL FAR FtpDir (LPSTR szDef, LPSTR szLocalFile,
                       BOOL  bLongDir, HWND  hParentWnd, UINT wMsg);

/* _______________________________________________________________ */

#define WFTP_API loaded
#endif /* ifndef WFTP_API */

