//---------------------------------------------------------------------------
//		Copyright (C) 1993, Microsoft Corporation
//
// You have a royalty-free right to use, modify, reproduce and distribute
// the Sample Custom Control Files (and/or any modified version) in any way
// you find useful, provided that you agree that Microsoft has no warranty,
// obligation or liability for any Custom Control File.
//---------------------------------------------------------------------------
// gener.c
//---------------------------------------------------------------------------
// Contains control procedure for GENERIC control
//---------------------------------------------------------------------------

#include <windows.h>
#include <vbapi.h>
#include "gener.h"
#include "genfun.h"

//---------------------------------------------------------------------------
// Global Variables
//---------------------------------------------------------------------------
BOOL bDevTimeInit = FALSE;
HANDLE hModDLL;
HBITMAP HBitmap;
WORD cVBXusers = 0;
USHORT bmWidth;
USHORT bmHeight;

/***  Function prototypes  ***/
VOID PASCAL PaintControl(HWND hwnd);


/****************************************************************************
 *
 *  FUNCTION:  GenericCtlProc(HCTL, HWND, USHORT, USHORT, LONG)
 *
 *  PURPOSE:   This routine is the subclassed window procedure.  Visual Basic
 *             passes VBM_, VBN_, and WM_ messages to this routine.
 *             The custom control determines which messages to process.
 *             Any messages that are not processed need to passed on to the
 *             default message processing routine VBDefControlProc().
 *
 ******************************************************************************/

LONG FAR PASCAL _export GenericCtlProc(HCTL hctl, HWND hwnd, USHORT msg,
			USHORT wp, LONG lp)
{
	PGENERIC		pGeneric;
	LPSTR			lpStr;

    switch (msg) {
        case WM_SIZE:
			/*
			 *	Set the sizing border of the control to the exact size
			 *	of the bitmap.
			 */
			SetWindowPos(hwnd, NULL, 0, 0, bmWidth, bmHeight,
				SWP_NOMOVE | SWP_NOZORDER);
			break;

        case VBM_CREATED:
			/*
			 *	The Generic custom control is an invisible control.  If we
			 *	are in design mode, display it; if we are not in design mode,
			 *	don't allow the control to be displayed.
			 */
			if (VBGetMode() == MODE_RUN)
				return 0L;
	
			break;

        case VBM_SETPROPERTY:
			/*
			 *	When the Action property is set to a valid value, execute the
			 *	the specified action based on other property values.  The
			 *	Action property acts as a pseudo-method.
			 */
			pGeneric = (PGENERIC)VBDerefControl(hctl);
		
			switch (wp) {
				case IPROP_GENERIC_ACTION:
					switch ((USHORT)lp) {
						case GEN_STRLEN:
							lpStr = VBDerefHsz(pGeneric->hszStringValue);
							pGeneric->usIntegerValue =	GenStrlen(lpStr);
							break;
					}

					pGeneric->usAction = (USHORT)lp;
				   	return 0L;
			}
			break;

        case WM_PAINT:
			/*
			 *	The Generic custom control must do it's own painting.
			 *	Since the control is never created in run mode, painting
			 *	only occurs in design mode.
			 */
			PaintControl(hwnd);
            break;
    }

    return VBDefControlProc(hctl, hwnd, msg, wp, lp);
}


/****************************************************************************
 *
 *  FUNCTION:  PaintControl(HWND)
 *
 *  PURPOSE:   This routine handles the painting of the control by creating
 *             a memory image of the bitmap and BitBlt'ing it to the screen.
 *
 ******************************************************************************/

VOID PASCAL PaintControl(HWND hwnd)
{
    HDC		hdcMem;
	PAINTSTRUCT ps;
	
	/*
	 *	Set up the display space for the bitmap.
	 */
	BeginPaint(hwnd, &ps);
    hdcMem = CreateCompatibleDC(ps.hdc);
	if (!hdcMem)
		return;

   	SelectObject(hdcMem, HBitmap);

	/*
	 *	Display the bitmap in the sizing rectangle.
	 */
    BitBlt(ps.hdc, 0, 0, bmWidth, bmHeight, hdcMem, 0, 0, SRCCOPY);

   	DeleteDC(hdcMem);
	EndPaint(hwnd, &ps);
}


/****************************************************************************
 *
 *  FUNCTION:  LibMain(HANDLE, WORD, WORD, LPSTR)
 *
 *  PURPOSE:   Initialize library. This routine is called when the
 *             first client loads the DLL.
 *
 ******************************************************************************/

int FAR PASCAL LibMain(HANDLE hModule, WORD wDataSeg, WORD cbHeapSize,
						LPSTR  lpszCmdLine)
{
    // Avoid warnings on unused (but required) formal parameters
    wDataSeg	= wDataSeg;
    cbHeapSize	= cbHeapSize;
    lpszCmdLine = lpszCmdLine;

    hModDLL = hModule;

    return 1;
}


/****************************************************************************
 *
 *  FUNCTION:  VBINITCC(USHORT, BOOL)
 *
 *  PURPOSE:   Register custom control.  This routine is called by Visual Basic
 *             or the Visual Basic emulation layer when the custom control DLL
 *             is loaded for use.
 *
 ******************************************************************************/

BOOL FAR PASCAL _export VBINITCC(USHORT usVersion, BOOL fRuntime)
{
	BITMAP bmp;
	
	/*
	 *	Count the number of hosts using this VBX.  A host can be VB.EXE,
	 *	any .EXE compiled from Visual Basic which uses this custom control,
	 *	or any other program which loads and uses VBX files.
	 */
    ++cVBXusers;

    /*
	 *	Load the bitmap resource so that it can be used by WM_PAINT.
	 */
    if (!fRuntime && !bDevTimeInit) {
		HBitmap = LoadBitmap(hModDLL, MAKEINTRESOURCE(IDBMP_GENERIC_UP));
		if (HBitmap == (HANDLE)NULL)
			return 0L;

	    GetObject(HBitmap, sizeof(BITMAP), (LPSTR)&bmp);
		bmWidth = (USHORT)bmp.bmWidth;
		bmHeight = (USHORT)bmp.bmHeight;

		// We successfully initialized the stuff we need at dev time
		bDevTimeInit = TRUE;
	}

    // Register control(s)
    return VBRegisterModel(hModDLL, &modelGeneric);
}

//---------------------------------------------------------------------------
// Unregister custom control.  This routine is called by Visual Basic when
// the custom control DLL (VBX) is being unloaded.
//---------------------------------------------------------------------------
VOID FAR PASCAL _export VBTERMCC(VOID)
{
    --cVBXusers;

    if (cVBXusers == 0 && bDevTimeInit) {
		// Free any resources created for Dev environment
		DeleteObject(HBitmap);
	}
}

//---------------------------------------------------------------------------
// WEP
//---------------------------------------------------------------------------
// C7 and QCWIN provide default a WEP:
//---------------------------------------------------------------------------
#if (_MSC_VER < 610)

int FAR PASCAL WEP(int fSystemExit);

//---------------------------------------------------------------------------
// For Windows 3.0 it is recommended that the WEP function reside in a
// FIXED code segment and be exported as RESIDENTNAME.  This is
// accomplished using the alloc_text pragma below and the related EXPORTS
// and SEGMENTS directives in the .DEF file.
//
// Read the comments section documenting the WEP function in the Windows
// 3.1 SDK "Programmers Reference, Volume 2: Functions" before placing
// any additional code in the WEP routine for a Windows 3.0 DLL.
//---------------------------------------------------------------------------
#pragma alloc_text(WEP_TEXT,WEP)

//---------------------------------------------------------------------------
// Performs cleanup tasks when the DLL is unloaded.  WEP() is
// called automatically by Windows when the DLL is unloaded (no
// remaining tasks still have the DLL loaded).	It is strongly
// recommended that a DLL have a WEP() function, even if it does
// nothing but returns success (1), as in this example.
//---------------------------------------------------------------------------
int FAR PASCAL WEP
(
    int fSystemExit
)
{
    // Avoid warnings on unused (but required) formal parameters
    fSystemExit = fSystemExit;

    return 1;
}
#endif // C6

//---------------------------------------------------------------------------

