//---------------------------------------------------------------------------
//		Copyright (C) 1993, Microsoft Corporation
//
// You have a royalty-free right to use, modify, reproduce and distribute
// the Sample Custom Control Files (and/or any modified version) in any way
// you find useful, provided that you agree that Microsoft has no warranty,
// obligation or liability for any Custom Control File.
//---------------------------------------------------------------------------
// gener.h
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Resource Information
//---------------------------------------------------------------------------
// Toolbox bitmap resource IDs numbers.
//---------------------------------------------------------------------------
#define IDBMP_GENERIC_UP    8000
#define IDBMP_GENERIC_DOWN  8001
#define IDBMP_GENERIC_MONO  8003
#define IDBMP_GENERIC_EGA   8006

//---------------------------------------------------------------------------
// Change these for each new VBX file
//---------------------------------------------------------------------------
#define VBX_COMPANYNAME 	   "Microsoft Corporation\0"
#define VBX_FILEDESCRIPTION	   "Visual Basic Pix Custom Control Example\0"
#define VBX_INTERNALNAME	   "PIX\0"
#define VBX_LEGALCOPYRIGHT	   "Copyright \251 Microsoft Corp. 1991-93\0"
#define VBX_LEGALTRADEMARKS	   "Microsoft\256 is a registered trademark of Microsoft Corporation. Visual Basic\231 is a trademark of Microsoft Corporation. Windows\231 is a trademark of Microsoft Corporation.\0"
#define VBX_ORIGINALFILENAME	   "PIX.VBX\0"
#define VBX_PRODUCTNAME 	   "Microsoft\256 Visual Basic\231 for Windows\231\0"


//---------------------------------------------------------------------------
// Update these fields for each build.
//---------------------------------------------------------------------------
#define VBX_VERSION		    3,00,0,00
#define VBX_VERSION_STR 	   "3.00.000\0"

#define OFFSETIN(struc, field)	((USHORT)&( ((struc *)0)->field ))

typedef struct tagGENERIC {
	BOOL	bBooleanValue;
	USHORT	usIntegerValue;
	ULONG	ulLongValue;
	ENUM	usEnumValue;
    HSZ		hszStringValue;
	USHORT	usAction;
} GENERIC, FAR *PGENERIC;

LONG FAR PASCAL _export GenericCtlProc(HCTL, HWND, USHORT, USHORT, LONG);

PROPINFO Property_BooleanValue =
{
    "BooleanValue",
    DT_BOOL | PF_fGetData | PF_fSetData | PF_fSaveData, 
    OFFSETIN(GENERIC, bBooleanValue),
	0, 0, NULL, 0
};

PROPINFO Property_IntegerValue =
{
    "IntegerValue",
    DT_SHORT | PF_fGetData | PF_fSetData | PF_fSaveData, 
    OFFSETIN(GENERIC, usIntegerValue),
	0, 0, NULL, 0
};

PROPINFO Property_LongValue =
{
    "LongValue",
    DT_LONG | PF_fGetData | PF_fSetData | PF_fSaveData, 
    OFFSETIN(GENERIC, ulLongValue),
	0, 0, NULL, 0
};

#define ENUM_VALUES1    "0 - Dasher\0" "1 - Dancer\0" "2 - Prancer\0" "3 - Vixen\0"
#define ENUM_VALUES2    "4 - Comet\0" "5 - Cupid\0" "6 - Donner\0" "7 - Blitzen\0"

PROPINFO Property_EnumValue =
{
    "EnumValue",
    DT_ENUM | PF_fGetData | PF_fSetData | PF_fSaveData, 
    OFFSETIN(GENERIC, usEnumValue),
	0,
	0,
	ENUM_VALUES1 ENUM_VALUES2,
	8
};

PROPINFO Property_StringValue =
{
    "StringValue",
    DT_HSZ | PF_fGetData | PF_fSetData | PF_fSaveData,
    OFFSETIN(GENERIC, hszStringValue),
	0, 0, NULL, 0
};

PROPINFO Property_Action =
{
    "Action",
    DT_SHORT | PF_fGetData | PF_fSetMsg | PF_fNoShow,
    OFFSETIN(GENERIC, usAction),
	0, 0, NULL, 0
};

#define IPROP_GENERIC_CTLNAME		 0
#define IPROP_GENERIC_TAG            1
#define IPROP_GENERIC_LEFT           2
#define IPROP_GENERIC_TOP            3
#define IPROP_GENERIC_BOOLEANVALUE   4
#define IPROP_GENERIC_INTEGERVALUE   5
#define IPROP_GENERIC_LONGVALUE      6
#define IPROP_GENERIC_ENUMVALUE      7
#define IPROP_GENERIC_STRINGVALUE    8
#define IPROP_GENERIC_ACTION         9

PPROPINFO Generic_Properties[] =
{
    PPROPINFO_STD_CTLNAME,
    PPROPINFO_STD_TAG,
    PPROPINFO_STD_LEFT,
    PPROPINFO_STD_TOP,
    &Property_BooleanValue,
    &Property_IntegerValue,
    &Property_LongValue,
    &Property_EnumValue,
    &Property_StringValue,
    &Property_Action,
    NULL
};

#define MODEL_FLAGS		MODEL_fInitMsg | MODEL_fLoadMsg

MODEL modelGeneric =
{
    VB_VERSION, 				// VB version being used
    MODEL_FLAGS,				// MODEL flags
    (PCTLPROC)GenericCtlProc,	// Control procedures
    CS_VREDRAW | CS_HREDRAW,	// Class style
    WS_CHILD | WS_BORDER,		// Default Windows style
    sizeof(GENERIC),			// Size of PIX structure
    IDBMP_GENERIC_UP,           // Palette bitmap ID
    "Generic",					// Default control name
    "Generic",					// Visual Basic class name
    NULL,						// Parent class name
    Generic_Properties,			// Property information table
    NULL        				// Event information table
};


#define	GEN_STRLEN		1
