Unit Linked;{Lists}

interface

type
  PLinkedList = ^TLinkedList;
  TLinkedList = Object
    Next : PLinkedList;
    Prev : PLinkedList;
    constructor Init;
    destructor done; virtual;
    procedure AddFirst(Item:PLinkedList);
    procedure AddLast(Item:PLinkedList);
    procedure AddAt(Item:PLinkedList);
    procedure Swap(Two:PLinkedList);
    procedure Delete;
    function Count:Word;
    function MyPos:Word;
    Function Compare(Item:PLinkedList):Integer; virtual;
  end;

Procedure AddItem(FromItem:PLinkedList; var ToItem);
Function KillItem(Item:PLinkedList):PLinkedList;
Function IsFirstItem(Item:PLinkedList):Boolean;
Function IsLastItem(Item:PLinkedList):Boolean;
Procedure SortList(Item:PLinkedList);
Procedure DestroyList(Item:PLinkedList);
Procedure Next(var Item);
Procedure Prev(var Item);
Procedure VerifyFirst(var Item);
Procedure VerifyLast(var Item);

implementation

uses strings;

Function KillItem(Item:PLinkedList):PLinkedList;
var
  next:plinkedlist;
begin
  if item^.next<>nil then
    next:=item^.next
  else
    next:=item^.prev;
  dispose(item,done);
  if next<>nil then verifyfirst(next);
  KillItem:=next;
end;

{TLinked list stuff:}
constructor TLinkedList.Init;
begin
  next:=nil;
  prev:=nil;
end;

destructor TLinkedList.done;
begin
  if Prev<>nil then Prev^.Next := Next;
  if Next<>nil then Next^.Prev := Prev;
end;

procedure TLinkedList.AddFirst(Item:PLinkedList);
begin
  if item<>nil then
  begin {Add to existing linked list}
    while Item^.Prev<>nil do
      Item := Item^.Prev; {Go back to first item in list}
    Prev := nil;
    Next := Item;
    Item^.Prev := @Self;
  end;
end;

procedure TLinkedList.AddLast(Item:PLinkedList);
begin
  if item<>nil then
  begin {Add self to item list.}
    while Item^.Next<>nil do
      Item := Item^.Next; {Go back to first item in list}
    Next := nil;
    Prev := Item;
    Item^.Next:= @Self;
  end;
end;

{Adds self to the location after the passed node.  For example:
   A.AddAt(P)
 adds the new node called 'A' to the list 'MNOPQRS' after location 'P'.
 The resulting list looks like 'MNOPAQRS'}
procedure TLinkedList.AddAt(Item:PLinkedList);
var
  NextLink:PLInkedList;
begin
  if item<>nil then
  begin {Add to existing linked list}
    NextLink:=Item^.Next;
    Item^.Next:=@Self;
    Next:=NextLink;
    Prev:=Item;
    if NextLink<>nil then NextLink^.Prev:=@Self;
  end;
end;

procedure TLinkedList.Swap(Two:PLinkedList);
var
  OnePrev,OneNext : PLinkedList;
  TwoPrev,TwoNext : PLinkedList;
  One : PLinkedList;
begin
  One := @Self;
  if Two = nil then exit;

  OnePrev := One^.Prev;
  OneNext := One^.Next;
  TwoPrev := Two^.Prev;
  TwoNext := Two^.Next;

  if One^.Prev<>nil then
    One^.Prev^.Next := Two;
  if One^.Next<>nil then
    One^.Next^.Prev := Two;
  One^.Next := TwoNext;
  One^.Prev := TwoPrev;

  if Two^.Prev<>nil then
    Two^.Prev^.Next := One;
  if Two^.Next<>nil then
    Two^.Next^.Prev := One;
  Two^.Next := OneNext;
  Two^.Prev := OnePrev;

  if OneNext = Two then
  begin
    if twonext<>nil then twonext^.prev := one;
    two^.next:=one;
    one^.prev:=two;
    one^.next:=twonext;
  end
    else if TwoNext = One then
    begin
      if onenext<>nil then onenext^.prev := two;
      one^.next:=two;
      two^.prev:=one;
      two^.next:=onenext;
    end;
end;

procedure TLinkedList.Delete;
begin
  done;
end;

function TLinkedList.MyPos:Word;
var
  node:PLinkedList;
  c:Word;
begin
  Node:=@Self;
  c:=0;
  while Node^.Prev<>nil do
    Node := Node^.Prev;
  while (Node<>@Self) and (Node<>nil) do
  begin
    Node := Node^.Next;
    inc(c);
  end;
  inc(c);
  MyPos:=c;
end;

function TLinkedList.Count:Word;
var
  node:PLinkedList;
  c:Word;
begin
  Node:=@Self;
  c:=0;
  while Node^.Prev<>nil do
    Node := Node^.Prev;
  while Node^.Next<>nil do
  begin
    Node := Node^.Next;
    inc(c);
  end;
  inc(c);
  Count:=c;
end;

Function TLinkedList.Compare(Item:PLinkedList):Integer;
begin
  Compare := 0;
end;

Function IsFirstItem(Item:PLinkedList):Boolean;
begin
  IsFirstItem:=(Item^.Prev = nil);
end;

Function IsLastItem(Item:PLinkedList):Boolean;
begin
  IsLastItem:=(Item^.Next = nil);
end;

Procedure SortList(Item:PLinkedList);

  Procedure Sort(Item:PLinkedList);
  var
    root:PLinkedList;
    c:word;
    n,t:word;
  begin
    if Item=nil then exit;
    while Item^.Prev<>nil do
      Item:=Item^.Prev;
    Root:=Item;
    c:=Item^.Count;
    while c>1 do
    begin
      for n:=1 to c-1 do
      begin
        if item^.Compare(item^.Next)>0 then
          item^.Swap(item^.Next);
        if item^.next<>nil then item:=item^.next;
      end;
      dec(c);
      Item:=Root;
    end;
  end;
begin
  Sort(Item);
  Sort(Item);
end;

Procedure DestroyList(Item:PLinkedList);
var
  Temp:PLinkedList;
begin
  if Item<>nil then
  begin
    while Item^.Prev<>nil do
      Item:=Item^.Prev;
    While Item<>nil do
    begin
      Temp:=Item;
      Item:=Item^.Next;
      Dispose(Temp,Done);
    end;
  end;
end;

Procedure Next(var Item);
begin
  if pointer(Item)<>nil then pointer(Item):=PLinkedList(Item)^.Next;
end;

Procedure Prev(var Item);
begin
  if pointer(Item)<>nil then pointer(Item):=PLinkedList(Item)^.Prev;
end;

Procedure VerifyFirst(var Item);
begin
  while not IsFirstItem(PLinkedList(Item)) do Prev(Item);
end;

Procedure VerifyLast(var Item);
begin
  while not IsLastItem(PLinkedList(Item)) do Next(Item);
end;

Procedure AddItem(FromItem:PLinkedList; var ToItem);
begin
  if pointer(ToItem)=nil then
    pointer(ToItem):=FromItem
  else
    FromItem^.AddLast(plinkedlist(ToItem));
end;

end.
