{
  OWL Interface to MAGMAED.DLL.

  Version 0.1

  See MAGMAOWL.TXT for usage explanation, and MAGMAOWL.PAS for a sample application.

  Note:  I haven't yet completed support for the owner draw style in these objects, or
  put sample owner draw in the demo application.  This will be competed soon.
}
Unit MagmaEd;

interface

uses wintypes,odialogs,owindows,linked;

const
  LFFACESIZE = 32; {From windows.h.  Not in wintypes for some reason.}

{
  ES_WANTTAB
    This is used when an edit control is part of a dialog box. The editor
    examines this style when it processes the WM_GETDLGCODE message in
    order to let the Windows dialog manager know whether it want to keep
    the tabs.
}
  ES_WANTTAB = $8000;

{
  ES_OWNERDRAW
    Used to allow the application to render a line of the edit control
}
  ES_OWNERDRAW = $4000;
  ES_HASSTRINGS = $200;
  ODT_EDIT = 99;

{
  This is the structure used for searching and replacing
}
  MAXPATTERNLEN = 128;

{
    Flags for search & replace operation
}
  SEARCH_CASE_INSENSITIVE    = $0001;  { case insensitive search }
  SEARCH_NO_REGEXP           = $0002;  { don't treat pattern as regex }
  SEARCH_SELECTMATCH         = $0004;  { highlight the matched text }
  SEARCH_WHOLE_WORD_ONLY     = $0008;  { match a whole word only }
  SEARCH_PROMPT_ON_REPLACE   = $0100;  { prompt before replacing }
  SEARCH_REPLACE_ALL         = $0200;  { global substitution     }
  SEARCH_BACKWARD            = $1000;  { search backwards }
  SEARCH_USE_VARWIDTH_PATTERN= $2000;

  ES_USEFORMATTING = $2000;

  {
    Editor messages
  }
  WM_BASE  = (WM_USER + 1313);

  ME_SELFINSERT     = WM_BASE+0;
  ME_FSEARCH        = WM_BASE+1;
  ME_BSEARCH        = WM_BASE+2;
  ME_FREPLACE       = WM_BASE+3;
  ME_BREPLACE       = WM_BASE+4;

  ME_DELLINE        = WM_BASE+5;
  ME_APPENDLINE     = WM_BASE+6;
  ME_INSERTLINE     = WM_BASE+7;
  ME_CUT            = WM_BASE+8;
  ME_CUTAPPEND      = WM_BASE+9;
  ME_RESETMARK      = WM_BASE+10;
  ME_COPY           = WM_BASE+11;
  ME_DUPLINE        = WM_BASE+12;
  ME_PASTE          = WM_BASE+13;
  ME_BACKSPACE      = WM_BASE+14;
  ME_DELWORD        = WM_BASE+15;
  ME_DELCHAR        = WM_BASE+16;
  ME_DELEOL         = WM_BASE+17;
  ME_TOGGLEINSERT   = WM_BASE+18;
  INSERTMODE_TOGGLE = 0;
  INSERTMODE_ON     = 1;
  INSERTMODE_OFF    = 2;
  ME_TAB            = WM_BASE+19;
  ME_BACKTAB        = WM_BASE+20;
  ME_UNDO           = WM_BASE+21;
  ME_REDO           = WM_BASE+22;
  ME_SEARCHAGAIN    = WM_BASE+23;
  ME_REPLACEAGAIN   = WM_BASE+24;

  ME_MOVEUP         = WM_BASE+30;
  ME_MOVEDOWN       = WM_BASE+31;
  ME_MOVELEFT       = WM_BASE+32;
  ME_MOVERIGHT      = WM_BASE+33;
  ME_MOVEBOL        = WM_BASE+34;
  ME_MOVEEOL        = WM_BASE+35;
  ME_MOVENEXTWORD   = WM_BASE+36;
  ME_MOVEPREVWORD   = WM_BASE+37;
  ME_MOVENEXTPARA   = WM_BASE+38;
  ME_MOVEPREVPARA   = WM_BASE+39;
  ME_MOVETOPOFWINDOW= WM_BASE+40;
  ME_MOVEBOTOFWINDOW= WM_BASE+41;
  ME_MOVENEXTPAGE   = WM_BASE+42;
  ME_MOVEPREVPAGE   = WM_BASE+43;
  ME_MOVETOPOFBUFFER= WM_BASE+44;
  ME_MOVEBOTOFBUFFER= WM_BASE+45;
  ME_MOVETOBOOKMARK = WM_BASE+46;
  ME_SETBOOKMARK    = WM_BASE+47;
  ME_GOTOLINE       = WM_BASE+48;
  GOTOLINE_ABS  = 1;
  GOTOLINE_LAST = 2;
  GOTOLINE_NEXT = 3;
  GOTOLINE_PREV = 4;
  ME_REMOVEBOOKMARK = WM_BASE+49;
  BOOKMARK_REMOVEALL = -1;

  ME_MATCHBRACE     = WM_BASE+50;
  ME_MARKLINE       = WM_BASE+51;
  ME_MARKLINERANGE  = WM_BASE+52;
  ME_INSERTCHAR     = WM_BASE+53;
  ME_UNDOLINES      = WM_BASE+54;
  ME_STREAMMARK     = WM_BASE+55;
  ME_RECTMARK       = WM_BASE+56;
  ME_CASELOWER      = WM_BASE+57;
  ME_CASEUPPER      = WM_BASE+58;

  ME_OPENFILE       = WM_BASE+60;
  ME_WRITEFILE      = WM_BASE+61;
  {
    Return codes for EM_WRITEFILE
  }
  EN_ERRCREATING = (-1);
  EN_ERRWRITING  = (-2);

  {
    Options and settings
  }
  ME_SETBKCOLOR     = WM_BASE+70;
  ME_SETTEXTCOLOR   = WM_BASE+71;
  ME_SETOPTION      = WM_BASE+72;
  ME_QUERYOPTION    = WM_BASE+73;
  ME_OPTIONDLG      = WM_BASE+74;
  ME_SETFONT        = WM_BASE+75;
  ME_TOGGLEWORDWRAP = WM_BASE+76;
  WORDWRAP_OFF    = 0;
  WORDWRAP_ON     = 1;
  WORDWRAP_TOGGLE = 2;
  ME_SETHIGHLIGHTCOLOR       = WM_BASE+77;
  ME_SETHIGHLIGHTTEXTCOLOR   = WM_BASE+78;

  ME_HELPONWORD    =  WM_BASE+80;
  ME_GETCURRWORD   =  WM_BASE+81;

  ME_KEYMACDEFINE  =  WM_BASE+90;
  ME_KEYMACPLAY    =  WM_BASE+91;
  ME_KEYMACPAUSE   =  WM_BASE+92;
  ME_PROGFROMKEYMAC = WM_BASE+93;

  {
    Misc
  }
  ME_QUERYSEARCHSTRING  = WM_BASE+100;
  ME_QUERYSTATUS        = WM_BASE+101;
  ME_INSERTSTRING       = WM_BASE+102;
  ME_INSERT_MODE      =0;
  ME_OVERSTRIKE_MODE  =1;
  ME_GETITEMDATA        = WM_BASE+103;
  ME_SETITEMDATA        = WM_BASE+104;
  ME_GETITEMHEIGHT      = WM_BASE+105;
  ME_SETITEMHEIGHT      = WM_BASE+106;
  ME_QUERYNUMWORDS      = WM_BASE+107;
  ME_TRIMTEXT           = WM_BASE+108;
  TRIM_LEADING_BLANKS   =$0001;
  TRIM_TRAILING_BLANKS  =$0002;
  TRIM_COMPRESS_BLANKS  =$0004;
  ME_CENTER             = WM_BASE+109;
  ME_REFORMAT           = WM_BASE+110;
  ME_REFORMATALL        = WM_BASE+111;
  ME_QUERYBOOKMARK      = WM_BASE+112;
  ME_INSERTPICTURE      = WM_BASE+113;
  ME_DUMPUNDOINFO       = WM_BASE+114;

{
  Owner-drawn messages sent by the editor control
}
  ME_DRAWITEM           = WM_BASE+115;
  ME_DELETEITEM         = WM_BASE+116;
  ME_MEASUREITEM        = WM_BASE+117;

  ME_SETREADNOTIFICATION= WM_BASE+118;
  ME_READNOTIFY         = WM_BASE+119;
  READNOTIFY_START    =0;
  READNOTIFY_READING  =1;
  READNOTIFY_END      =2;

  ME_SETCOLUMN          = WM_BASE+120;

  WM_BASE_LAST_MSG      = WM_BASE+200;


  {
    Notification messages
  }
  MEN_UPDATE            = WM_BASE+200;

  {
    Test bed for messages
  }
  WM_MSGTESTBASE        = WM_BASE+900;


  {
    The following messages are compatible with the Chicago RTF edit control
  }
  EM_CHARFROMPOS       = (WM_USER + 1213);
  EM_EXGETSEL          = (WM_USER + 1214);
  EM_EXLINEFROMCHAR    = (WM_USER + 1215);
  EM_EXSETSEL          = (WM_USER + 1216);
  EM_GETSELTEXT        = (WM_USER + 1217);
  EM_GETTEXTRANGE      = (WM_USER + 1218);
  EM_POSFROMCHAR       = (WM_USER + 1219);
  EM_SELECTIONTYPE     = (WM_USER + 1220);
  EM_SETBKGNDCOLOR     = (WM_USER + 1221);
  EM_GETCHARFORMAT     = (WM_USER + 1222);
  EM_SETCHARFORMAT     = (WM_USER + 1223);
  SCF_SELECTION   =$0001;
  SCF_WORD        =$0002;


  CFM_BOLD       = $00000001;
  CFM_ITALIC     = $00000002;
  CFM_UNDERLINE  = $00000004;
  CFM_STRIKEOUT  = $00000008;
  CFM_PROTECTED  = $00000010;
  CFM_SIZE       = $80000000;
  CFM_COLOR      = $40000000;
  CFM_FACE       = $20000000;
  CFM_OFFSET     = $10000000;
  CFM_BITMAP     = $08000000;   { Magma specific }

  CFE_BOLD       = $00000001;
  CFE_ITALIC     = $00000002;
  CFE_UNDERLINE  = $00000004;
  CFE_STRIKEOUT  = $00000008;
  CFE_PROTECTED  = $00000010;
  CFE_AUTOCOLOR  = $40000000;
  CFE_BITMAP     = $08000000;   { Magma specific }
  {
    Structures related to formatting
  }

type
  TlineNumber = Longint;
  TColNumber = word;

  tagCharFormat = record
    dwMask : longint;
    dwEffects : longint;
    yHeight : longint;                 { height of line in twips (1/1440")    }
    yOffset : longint;                 { >0 for superscript, <0 for subscript }
    crTextColor : TColorRef;             { Text color }
    bPitchAndFamily : Byte;         { same as LOGFONT's chPitchAndFamily }
    szFaceName : Array[0..LFFACESIZE - 1] of byte; { same as LOGFONT's lfFacename       }

    { These are in the Magma Editor DLL but not in Chicago }
    hObject : THandle;                 { generic object - Bitmap, font, MF  }
  end;

{
  Read notification structure... passed in the lParam when the
  ME_READNOTIFY message is sent to an app

  The following values are passed in wParam
    READNOTIFY_START    Sent when the reading is just about to start
    READNOTIFY_READING  Sent when a certain increment of lines has been read
    READNOTIFY_END      Sent when the reading has been completed
}
  PReadNotifyInfo = ^TReadNotifyInfo;
  TReadNotifyInfo = record
    nPercent : integer;      { percent of file read, 0-100 }
    nPrevPercent : integer;  { the prev value of nPercent  }
    nBytesRead : longint;    { number of bytes read so far }
    nTotalBytes : longint;   { total # of bytes to be read }
    nLinesRead : tlinenumber;    { number of lines read so far }
  end;

  PSearchArg = ^TSearchArg;
  TSearchArg = record
    fFlags : Word;
    {
      This is the search pattern. The array is MAXPATTERNLEN chars long,
      unless SEARCH_USE_VARWIDTH_PATTERN is specified. In that case,
      the replacement pattern follows the NULL character in the search
      pattern.
    }
    szPattern : array[0..MAXPATTERNLEN - 1] of char;

    {
      This is the replacement pattern
    }
    szReplacement : array[0..MAXPATTERNLEN - 1] of char;

  end;


  {
  Structure used for the ME_QUERYBOOKMARK message
  }
  PBookmarkInfo = ^TBookmarkInfo;
  TBookmarkInfo = record
    lineNum : Longint;
    colNum : Longint;
    chBookmark : integer;   { 'A' through 'Z' }
  end;

  PCharRange = ^TCharRange;
  TCharRange = record
    cpMin : longint;
    cpMax : longint;
  end;


  PMeStatus = ^TMeStatus;
  TMeStatus = record
    bInsert : Bool;
    column : Word;
    row : longint;
    currLineNum : longint;
    nTotalLines : longint;
  end;

  PMEDRAWITEMSTRUCT = ^TMEDRAWITEMSTRUCT;
  TMEDRAWITEMSTRUCT = record
    CtlType : Word;
    CtlID : Word;
    itemID : Word;
    itemAction : Word;
    itemState : Word;
    hwndItem : hWnd;
    hDC : hDC;
    rcItem : TRect;
    itemData : Longint;
    lpText : PChar;
    lineNumber : TLineNumber;
    colLeft : TColNumber;
    idxLeft : TColNumber;
    pixLeft : Integer;
  end;

  PMEDELETEITEMSTRUCT = ^TMEDELETEITEMSTRUCT;
  TMEDELETEITEMSTRUCT = record
    CtlType : Word;
    CtlID : Word;
    itemID : Word;
    hwndItem : hWnd;
    itemData : Longint;
    lpText : PChar;
  end;

  PMEMEASUREITEMSTRUCT = ^TMEMEASUREITEMSTRUCT;
  TMEMEASUREITEMSTRUCT = record
    CtlType : Word;
    CtlID : Word;
    itemID : Word;
    itemWidth : Word;
    itemHeight : Word;
    itemData : Longint;
    lpText : PChar;
  end;

const
  cm_FileNew       = 101;
  cm_FileOpen      = 102;
  cm_FileSave      = 103;
  cm_FileSaveAs    = 104;
  cm_FileExit      = 105;
  cm_EditUndo      = 201;
  cm_EditRedo      = 202;
  cm_EditCut       = 203;
  cm_EditCopy      = 204;
  cm_EditPaste     = 205;
  cm_EditAppend    = 206;
  cm_EditOptions   = 207;
  cm_SearchFind    = 301;
  cm_SearchReplace = 302;
  cm_SearchAgain   = 303;

type
  pmagmaedit=^tmagmaedit;
  tmagmaedit=object(tedit)
    SearchDown,
    FindNext,
    Matchcase,
    WholeWord : Boolean;
    function getclassname:pchar; virtual;
    {Magma Edit functions}
    function MoveUp : Boolean; virtual;
    function MoveDown : Boolean; virtual;
    function MoveLeft : Boolean; virtual;
    function MoveRight : Boolean; virtual;
    function MoveBOL : Boolean; virtual;
    function MoveEOL : Boolean; virtual;
    function MoveNextWord : Boolean; virtual;
    function MovePrevWord : Boolean; virtual;
    function MoveNextPara : Boolean; virtual;
    function MovePrevPara : Boolean; virtual;
    function MoveTopOfWindow : Boolean; virtual;
    function MoveBotOfWindow : Boolean; virtual;
    function MoveNextPage : Boolean; virtual;
    function MovePrevPage : Boolean; virtual;
    function MoveTopOfBuffer : Boolean; virtual;
    function MoveBotOfBuffer : Boolean; virtual;
    function GotoLine(movetype:word; linenum:longint):boolean; virtual;
    function MatchBrace:boolean; virtual;
    procedure setcolumn(colnum:word); virtual;
    function MoveToBookmark(BookMark:char):boolean; virtual;
    function QueryBookmark(Bookmark:char; info:PBookmarkInfo):Word; virtual;
    function RemoveBookmark(Bookmark:char):boolean; virtual;
    function SetBookmark(Bookmark:char):Boolean; virtual;
    Procedure BackSpace; virtual;
    Procedure DelChar; virtual;
    Procedure DelEOL; virtual;
    Procedure DelWord; virtual;
    Procedure InsertChar(txt:char); virtual;
    function InsertString(Overstrike:boolean; txt:string):boolean; virtual;
    function InsertPChar(Overstrike:boolean; txt:pchar):boolean; virtual;
    procedure ToggleInsert(InsertMode:word); virtual;
    procedure ToggleWordwrap(WrapMode: word); virtual;
    function OpenFile(Handle:Word; fname:pchar):boolean; virtual;
    function OpenFileStr(fname:string):boolean; virtual;
    Procedure SetReadNotification(NotifyCode:integer); virtual;
    function WriteFile(handle:word; fname:pchar):boolean; virtual;
    function WriteFileStr(fname:string):boolean; virtual;
    function FSearch(SearchInfo:PSearchArg):Boolean; virtual;
    function BSearch(SearchInfo:PSearchArg):Boolean; virtual;
    function FReplace(SearchInfo:PSearchArg):Boolean; virtual;
    function BReplace(SearchInfo:PSearchArg):Boolean; virtual;
    function SearchAgain:boolean; virtual;
    function ReplaceAgain:boolean; virtual;
    function QuerySearchString(str:pchar; maxlen:word):word; virtual;
    procedure AppendLine; virtual;
    procedure CaseLower; virtual;
    procedure CaseUpper; virtual;
    procedure Copy; virtual;
    procedure Cut; virtual;
    procedure CutAppend; virtual;
    procedure DelLine; virtual;
    procedure DupLine; virtual;
    procedure InsertLine; virtual;
    procedure MarkLine; virtual;
    procedure MarkLineRange; virtual;
    procedure MagmaPaste; virtual;
    procedure RectMark; virtual;
    procedure ResetMark; virtual;
    procedure StreamMark; virtual;
    procedure Tab; virtual;
    procedure BackTab; virtual;
    procedure Center; virtual;
    procedure Reformat; virtual;
    procedure ReformatAll; virtual;
    procedure TrimText(TrimType:Word;TrimTxt:PChar); virtual;
    procedure Redo; virtual;
    procedure Undo; virtual;
    procedure OptionDlg; virtual;
    procedure SetOption(option:pchar; newval:word); virtual;
    function QueryOption(option:pchar):word; virtual;
    procedure SetTextColor(Color:TColorRef); virtual;
    procedure SetBkColor(Color:TColorRef); virtual;
    function SetBkgndColor(System:Bool; Color:TColorRef):TColorRef; virtual;
    function GetItemData(linenum:longint):longint; virtual;
    function SetItemData(linenum:word; data:longint):Longint; virtual;
    function GetItemHeight(linenum:longint):longint; virtual;
    function SetItemHeight(linenum:word; height:longint):longint; virtual;
    function GetCurrWord(txt:pchar; maxlen:word):longint; virtual;
    function QueryNumWords:Longint; virtual;
    function QueryStatus(info:PMEStatus):boolean; virtual;
    procedure KeyMacDefine; virtual;
    procedure KeyMacPlay; virtual;
    function HelpOnWord(helpfile:pchar):boolean; virtual;
  end;

  PMagmaHighlightEdit = ^TMagmaHighlightEdit;
  TMagmaHighlightEdit = Object(TMagmaEdit)
    constructor Init(AParent: PWindowsObject; AnId: Integer; ATitle: PChar;
      X,Y,W,H: Integer; ATextLen: Integer; Multiline : Boolean);
  end;

  PStatusWindow = ^TStatusWindow;
  TStatusWindow = Object(TWindow)
    Percent:Word;
    constructor Init(AParent: PWindowsObject; ATitle: PChar);
    procedure DrawIt(DC:hDC);
    procedure Paint(PaintDC: HDC; var PaintInfo: TPaintStruct); virtual;
    procedure SetPercent(APercent:Word); virtual;
  end;

  PMagmaWindow = ^TMagmaWindow;
  TMagmaWindow = Object(TWindow)
    statuswnd:PStatusWindow;
    Edit : PMagmaEdit;
    FileName:Pchar;
    Filemenu:hMenu;
    EditMenu:hMenu;
    MainMenu:hMenu;
    SearchMenu:hMenu;
    function DrawItem(DC:hDC;lpText:PChar;itemData:Longint;lineNumber:TLineNumber;
      idxLeft:TColNumber;item:PMEDrawItemStruct):Longint; virtual;
    procedure setupwindow; virtual;
    procedure CreateEditor; virtual;
    function CanClose: Boolean; virtual;
    procedure wmsize(var msg:tmessage);
      virtual wm_first + wm_size;
    procedure wmsetfocus(var msg:tmessage);
      virtual wm_first + wm_setfocus;
    procedure meReadNotify(var msg:tmessage);
      virtual wm_first + me_ReadNotify;
    procedure meMeasureItem(var msg:tmessage);
      virtual wm_first + me_MeasureItem;
    procedure meDeleteItem(var msg:tmessage);
      virtual wm_first + me_DeleteItem;
    procedure meDrawItem(var msg:tmessage);
      virtual wm_first + me_drawitem;
    procedure AddToMenu(var menu:hmenu; id:word; txt:pchar; header:pchar);
    procedure AddFileMenu; virtual;
    procedure AddToFileMenu(id:word; txt:pchar);
    procedure AddEditMenu; virtual;
    procedure AddToEditMenu(id:word; txt:pchar);
    procedure AddSearchMenu; virtual;
    procedure AddToSearchMenu(id:word; txt:pchar);
    Function ShowStatusWin:Boolean; virtual;
    procedure SetFileName(fname:pchar);
    procedure GetFileName(fname:pchar; maxsz:word);
    function GetLoadName(caption:pchar):boolean; virtual;
    function GetSaveName(caption:pchar):boolean; virtual;
    procedure QuerySaveFile; virtual;
    procedure ClearFileName;
    procedure Save; virtual;
    procedure SaveAs; virtual;
    procedure Load; virtual;
    procedure cmFileNew(var msg:tmessage);
      virtual cm_first + cm_FileNew;
    procedure cmFileOpen(var msg:tmessage);
      virtual cm_first + cm_FileOpen;
    procedure cmFileSave(var msg:tmessage);
      virtual cm_first + cm_FileSave;
    procedure cmFileSaveAs(var msg:tmessage);
      virtual cm_first + cm_FileSaveAs;
    procedure cmFileExit(var msg:tmessage);
      virtual cm_first + cm_FileExit;
    procedure cmEditUndo(var msg:tmessage);
      virtual cm_first + cm_EditUndo;
    procedure cmEditRedo(var msg:tmessage);
      virtual cm_first + cm_EditRedo;
    procedure cmEditCut(var msg:tmessage);
      virtual cm_first + cm_EditCut;
    procedure cmEditCopy(var msg:tmessage);
      virtual cm_first + cm_EditCopy;
    procedure cmEditPaste(var msg:tmessage);
      virtual cm_first + cm_EditPaste;
    procedure cmEditAppend(var msg:tmessage);
      virtual cm_first + cm_EditAppend;
    procedure cmEditOptions(var msg:tmessage);
      virtual cm_first + cm_EditOptions;
    procedure cmSearchFind(var msg:tmessage);
      virtual cm_first + cm_SearchFind;
    procedure cmSearchReplace(var msg:tmessage);
      virtual cm_first + cm_SearchReplace;
    procedure cmSearchAgain(var msg:tmessage);
      virtual cm_first + cm_SearchAgain;
  end;

  {I am using a linked list to hold lists of words which highlight to a given colour.  I use
  a hash value to make searches faster, but should really go to a binary tree to improve
  speed.  Bye the way, I just made up the hashing function, so I'm sure it isn't half as good
  as it could be.}
  PWordList=^TWordList;
  TWordList=Object(TLinkedList)
    Txt:Pchar;
    Hash:Longint;
    constructor init(Text:PChar);
    destructor done; virtual;
    function ismatch(str:pchar; casesense:boolean):boolean;
  end;

  PHighlightGroup = ^THighlightGroup;
  THighlightGroup = Object(TLinkedList)
    Font: hFont;
    Colour:TColorRef;
    WordList : PWordList;
    constructor init(afont:hfont; acolour:TColorRef; aWordList:PWordList);
    destructor done; virtual;
  end;

  PMagmaHighlight = ^TMagmaHighlight;
  TMagmaHighlight = Object(TMagmaWindow)
    Highlight:PHighlightGroup;
    casesense:boolean;
    constructor Init(AParent: PWindowsObject; ATitle: PChar; acasesense:boolean);
    destructor done; virtual;
    function GetDefaultFont:hFont; virtual;
    function CreateWordGroup(font:hfont; colour:TColorRef):PHighlightGroup;
    procedure AppendWordList(var List:PWordList; aWord:PChar);
    function DrawItem(DC:hDC;lpText:PChar;itemData:Longint;lineNumber:TLineNumber;
      idxLeft:TColNumber;item:PMEDrawItemStruct):longint; virtual;
  end;

implementation

uses winprocs,strings,commdlg;

function iswhitespace(c:char):boolean;
begin
  iswhitespace:=(c in [' ','.',',',#9,';',':','!','@','#','$','%','^','&','*','(',')',
                       '-','+','=','|','\','`','~','"',#39,'<','>','/','?']);
end;

function stripwhite(s:string; upper:boolean):string;
begin
  while (length(s)>0) and iswhitespace(s[length(s)]) do
    dec(s[0]);
  while (length(s)>0) and iswhitespace(s[1]) do
    system.delete(s,1,1);
  if upper then
  begin
    s[length(s)+1]:=#0;
    strupper(@s[1]);
  end;
  stripwhite:=s;
end;

function Hashit(str:pchar; casesense:boolean):longint;
var
  res:longint;
  n:integer;
  s:string;
begin
  s:=strpas(str);
  s:=stripwhite(s,not casesense);
  n:=1;
  res:=0;
  while n<=length(s) do
  begin
    inc(res,ord(s[n]));
    inc(n);
  end;
  res:=res shl 8;
  res:=res xor n;
  hashit:=res;
end;

{Quick longint to string converter used by TStatusWindow}
Function LongStr(l:LongInt):String;
var
  s:string;
begin
  str(l,s);
  LongStr:=s
end;

function tmagmaedit.getclassname:pchar;
begin
  getclassname:='MagmaEdit';
end;

function tmagmaedit.MoveUp : Boolean;
begin
  MoveUp:=(sendmessage(hWindow,me_moveup,0,0)<>0);
end;

function tmagmaedit.MoveDown : Boolean;
begin
  MoveDown:=(sendmessage(hWindow,me_movedown,0,0)<>0);
end;

function tmagmaedit.MoveLeft : Boolean;
begin
  MoveLeft:=(sendmessage(hWindow,me_moveleft,0,0)<>0);
end;

function tmagmaedit.MoveRight : Boolean;
begin
  MoveRight:=(sendmessage(hWindow,me_moveright,0,0)<>0);
end;

function tmagmaedit.MoveBOL : Boolean;
begin
  MoveBOL:=(sendmessage(hWindow,me_movebol,0,0)<>0);
end;

function tmagmaedit.MoveEOL : Boolean;
begin
  MoveEOL:=(sendmessage(hWindow,me_moveeol,0,0)<>0);
end;

function tmagmaedit.MoveNextWord : Boolean;
begin
  MoveNextWord:=(sendmessage(hWindow,me_movenextword,0,0)<>0);
end;

function tmagmaedit.MovePrevWord : Boolean;
begin
  MovePrevWord:=(sendmessage(hWindow,me_moveprevword,0,0)<>0);
end;

function tmagmaedit.MoveNextPara : Boolean;
begin
  MoveNextPara:=(sendmessage(hWindow,me_movenextpara,0,0)<>0);
end;

function tmagmaedit.MovePrevPara : Boolean;
begin
  MovePrevPara:=(sendmessage(hWindow,me_moveprevpara,0,0)<>0);
end;

function tmagmaedit.MoveTopOfWindow : Boolean;
begin
  MoveTopOfWindow:=(sendmessage(hWindow,me_movetopofwindow,0,0)<>0);
end;

function tmagmaedit.MoveBotOfWindow : Boolean;
begin
  MovebotOfWindow:=(sendmessage(hWindow,me_movebotofwindow,0,0)<>0);
end;

function tmagmaedit.MoveNextPage : Boolean;
begin
  MoveNextPage:=(sendmessage(hWindow,me_MoveNextPage,0,0)<>0);
end;

function tmagmaedit.MovePrevPage : Boolean;
begin
  MovePrevPage:=(sendmessage(hWindow,me_MovePrevPage,0,0)<>0);
end;

function tmagmaedit.MoveTopOfBuffer : Boolean;
begin
  MoveTopOfBuffer:=(sendmessage(hWindow,me_moveTopOfBuffer,0,0)<>0);
end;

function tmagmaedit.MoveBotOfBuffer : Boolean;
begin
  MoveBotOfBuffer:=(sendmessage(hWindow,me_movebotofbuffer,0,0)<>0);
end;

function tmagmaedit.GotoLine(movetype:word; linenum:longint):boolean;
begin
  GotoLine:=(sendmessage(hWindow,me_gotoline,MoveType,LineNum)<>0);
end;

function tmagmaedit.MatchBrace:boolean;
begin
  MatchBrace:=(sendmessage(hWindow,me_matchbrace,0,0)<>0);
end;

procedure tmagmaedit.setcolumn(colnum:word);
begin
  sendmessage(hWindow,me_setcolumn,colnum,0);
end;

function tmagmaedit.MoveToBookmark(BookMark:char):boolean;
begin
  sendmessage(hWindow,me_movetobookmark,ord(BookMark),0);
end;

function tmagmaedit.QueryBookmark(Bookmark:char; info:PBookmarkInfo):Word;
begin
  sendmessage(hWindow,me_querybookmark,ord(BookMark),longint(info));
end;

function tmagmaedit.RemoveBookmark(Bookmark:char):boolean;
begin
  sendmessage(hWindow,me_removebookmark,ord(BookMark),0);
end;

function tmagmaedit.SetBookmark(Bookmark:char):Boolean;
begin
  sendmessage(hWindow,me_setbookmark,ord(Bookmark),0);
end;

procedure tmagmaedit.BackSpace;
begin
  sendmessage(hWindow,me_backspace,0,0);
end;

procedure tmagmaedit.DelChar;
begin
  sendmessage(hWindow,me_delchar,0,0);
end;

procedure tmagmaedit.DelEOL;
begin
  sendmessage(hWindow,me_deleol,0,0);
end;

procedure tmagmaedit.DelWord;
begin
  sendmessage(hWindow,me_delword,0,0);
end;

procedure tmagmaedit.InsertChar(txt:char);
begin
  sendmessage(hWindow,me_insertchar,ord(txt),0);
end;

function tmagmaedit.InsertString(Overstrike:boolean; txt:string):boolean;
begin
  txt:=txt+#0;
  InsertPChar(Overstrike,@txt[1]);
end;

function tmagmaedit.InsertPChar(Overstrike:boolean; txt:pchar):boolean;
var
  wParam:word;
begin
  if Overstrike then
    wParam:=ME_OVERSTRIKE_MODE
  else
    wParam:=ME_INSERT_MODE;
  sendmessage(hWindow,me_insertstring,wParam,longint(txt));
end;

procedure tmagmaedit.ToggleInsert(InsertMode:word);
begin
  sendmessage(hWindow,me_toggleinsert,InsertMode,0);
end;

procedure tmagmaedit.ToggleWordwrap(WrapMode: word);
begin
  sendmessage(hWindow,me_togglewordwrap,WrapMode,0);
end;

function tmagmaedit.OpenFile(Handle:Word; fname:pchar):boolean;
begin
  sendmessage(hWindow,me_openfile,Handle,longint(fname));
end;

function tmagmaedit.OpenFileStr(fname:string):boolean;
begin
  fname:=fname+#0;
  OpenFile(0,@fname[1]);
end;

procedure tmagmaedit.SetReadNotification(NotifyCode:integer);
begin
  sendmessage(hWindow,me_setreadnotification,word(NotifyCode),0);
end;

function tmagmaedit.WriteFile(handle:word; fname:pchar):boolean;
begin
  WriteFile:=(sendmessage(hWindow,me_writefile,handle,longint(fname))<>0);
end;

function tmagmaedit.WriteFileStr(fname:string):boolean;
begin
  fname:=fname+#0;
  WriteFileStr:=WriteFile(0,@fname[1]);
end;

function tmagmaedit.FSearch(SearchInfo:PSearchArg):Boolean;
begin
  FSearch:=(sendmessage(hWindow,me_fsearch,0,longint(Searchinfo))<>0);
end;

function tmagmaedit.BSearch(SearchInfo:PSearchArg):Boolean;
begin
  BSearch:=(sendmessage(hWindow,me_bsearch,0,longint(Searchinfo))<>0);
end;

function tmagmaedit.FReplace(SearchInfo:PSearchArg):Boolean;
begin
  FReplace:=(sendmessage(hWindow,me_freplace,0,longint(Searchinfo))<>0);
end;

function tmagmaedit.BReplace(SearchInfo:PSearchArg):Boolean;
begin
  BReplace:=(sendmessage(hWindow,me_breplace,0,longint(Searchinfo))<>0);
end;

function tmagmaedit.SearchAgain:boolean;
begin
  SearchAgain:=(sendmessage(hWindow,me_searchagain,0,0)<>0);
end;

function tmagmaedit.ReplaceAgain:boolean;
begin
  ReplaceAgain:=(sendmessage(hWindow,me_replaceagain,0,0)<>0);
end;

function tmagmaedit.QuerySearchString(str:pchar; maxlen:word):word;
begin
  QuerySearchString:=sendmessage(hWindow,me_querysearchstring,0,0);
end;

procedure tmagmaedit.AppendLine;
begin
  sendmessage(hWindow,me_appendline,0,0);
end;

procedure tmagmaedit.CaseLower;
begin
  sendmessage(hWindow,me_caselower,0,0);
end;

procedure tmagmaedit.CaseUpper;
begin
  sendmessage(hWindow,me_caseupper,0,0);
end;

procedure tmagmaedit.Copy;
begin
  sendmessage(hWindow,me_copy,0,0);
end;

procedure tmagmaedit.Cut;
begin
  sendmessage(hWindow,me_cut,0,0);
end;

procedure tmagmaedit.CutAppend;
begin
  sendmessage(hWindow,me_cutappend,0,0);
end;

procedure tmagmaedit.DelLine;
begin
  sendmessage(hWindow,me_delline,0,0);
end;

procedure tmagmaedit.DupLine;
begin
  sendmessage(hWindow,me_dupline,0,0);
end;

procedure tmagmaedit.InsertLine;
begin
  sendmessage(hWindow,me_insertline,0,0);
end;

procedure tmagmaedit.MarkLine;
begin
  sendmessage(hWindow,me_markline,0,0);
end;

procedure tmagmaedit.MarkLineRange;
begin
  sendmessage(hWindow,me_marklinerange,0,0);
end;

procedure tmagmaedit.MagmaPaste;
begin
  sendmessage(hWindow,me_paste,0,0);
end;

procedure tmagmaedit.RectMark;
begin
  sendmessage(hWindow,me_rectmark,0,0);
end;

procedure tmagmaedit.ResetMark;
begin
  sendmessage(hWindow,me_ResetMark,0,0);
end;

procedure tmagmaedit.StreamMark;
begin
  sendmessage(hWindow,me_StreamMark,0,0);
end;

procedure tmagmaedit.Tab;
begin
  sendmessage(hWindow,me_tab,0,0);
end;

procedure tmagmaedit.BackTab;
begin
  sendmessage(hWindow,me_BackTab,0,0);
end;

procedure tmagmaedit.Center;
begin
  sendmessage(hWindow,me_Center,0,0);
end;

procedure tmagmaedit.Reformat;
begin
  sendmessage(hWindow,me_Reformat,0,0);
end;

procedure tmagmaedit.ReformatAll;
begin
  sendmessage(hWindow,me_ReformatAll,0,0);
end;

procedure tmagmaedit.TrimText(TrimType:Word;TrimTxt:PChar);
begin
  sendmessage(hWindow,me_TrimText,TrimType,longint(TrimTxt));
end;

procedure tmagmaedit.Redo;
begin
  sendmessage(hWindow,me_Redo,0,0);
end;

procedure tmagmaedit.Undo;
begin
  sendmessage(hWindow,me_Undo,0,0);
end;

procedure tmagmaedit.OptionDlg;
begin
  sendmessage(hWindow,me_OptionDlg,0,0);
end;

procedure tmagmaedit.SetOption(option:pchar; newval:word);
begin
  sendmessage(hWindow,me_SetOption,newval,longint(option));
end;

function tmagmaedit.QueryOption(option:pchar):word;
begin
  QueryOption:=sendmessage(hWindow,me_QueryOption,0,longint(option));
end;

procedure tmagmaedit.SetTextColor(Color:TColorRef);
begin
  sendmessage(hWindow,me_SetTextColor,0,Color);
end;

procedure tmagmaedit.SetBkColor(Color:TColorRef);
begin
  sendmessage(hWindow,me_SetBkColor,0,Color);
end;

function tmagmaedit.SetBkgndColor(System:Bool; Color:TColorRef):TColorRef;
begin
  SetBkgndColor:=sendmessage(hWindow,em_SetBkgndColor,word(System),Color);
end;

function tmagmaedit.GetItemData(linenum:longint):longint;
begin
  GetItemData:=sendmessage(hWindow,me_GetItemdata,0,linenum);
end;

function tmagmaedit.SetItemData(linenum:word; data:longint):Longint;
begin
  SetItemData:=sendmessage(hWindow,me_SetItemData,linenum,data);
end;

function tmagmaedit.GetItemHeight(linenum:longint):longint;
begin
  GetItemHeight:=sendmessage(hWindow,me_GetItemHeight,0,linenum);
end;

function tmagmaedit.SetItemHeight(linenum:word; height:longint):longint;
begin
  SetItemheight:=sendmessage(hWindow,me_SetItemheight,linenum,height);
end;

function tmagmaedit.GetCurrWord(txt:pchar; maxlen:word):longint;
begin
  GetCurrWord:=sendmessage(hWindow,me_GetCurrWord,maxlen,longint(txt));
end;

function tmagmaedit.QueryNumWords:Longint;
begin
  QueryNumWords:=sendmessage(hWindow,me_QueryNumWords,0,0);
end;

function tmagmaedit.QueryStatus(info:PMEStatus):boolean;
begin
  QueryStatus:=(sendmessage(hWindow,me_QueryStatus,0,longint(info))<>0);
end;

procedure tmagmaedit.KeyMacDefine;
begin
  sendmessage(hWindow,me_KeyMacDefine,0,0);
end;

procedure tmagmaedit.KeyMacPlay;
begin
  sendmessage(hWindow,me_KeyMacPlay,0,0);
end;

function tmagmaedit.HelpOnWord(helpfile:pchar):boolean;
begin
  sendmessage(hWindow,me_HelpOnWord,0,longint(helpfile));
end;

constructor TStatusWindow.Init(AParent: PWindowsObject; ATitle: PChar);
begin
  inherited init(AParent,ATitle);
  Percent:=0;
  with attr do
  begin
    x:=100; {These x,y coordinates are arbirary and can be changed by child init constructors}
    y:=100; {The paint proc works fine when the size is changed, so position as you please.}
    w:=400;
    h:=50;
    style:=ws_popup or ws_border or ws_caption;
  end;
end;

procedure TStatusWindow.DrawIt(DC:hDC);
var
  p:hdc;
  r:TRect;
  fillbrush:hbrush;
  midpt:integer;
  old:integer;
  bmp,obmp:hbitmap;
  s:string;
  invdc:hdc;
  invbmp,oinvbmp:hbitmap;
begin
  {Draw status bar...}
  getclientrect(hWindow,r);
  p:=createcompatibledc(dc);
  bmp:=createcompatiblebitmap(dc,r.right,r.bottom);
  obmp:=selectobject(p,bmp);
  fillrect(p,r,getstockobject(LTGRAY_BRUSH));
  inflaterect(r,-5,-5);
  fillrect(p,r,getstockobject(DKGRAY_BRUSH));
  inc(r.top); inc(r.left);
  fillrect(p,r,getstockobject(WHITE_BRUSH));
  fillbrush:=createsolidbrush(rgb(0,0,128));
  dec(r.bottom); dec(r.right);
  midpt:=((r.right - r.left) * percent) div 100;
  inc(midpt,r.left);
  old:=r.right;
  r.right:=midpt;
  fillrect(p,r,fillbrush);
  DeleteObject(FillBrush);
  {Draw percent done...}
  getclientrect(hWindow,r);
  invdc:=createcompatibledc(dc);
  invbmp:=createcompatiblebitmap(dc,r.right,r.bottom);
  oinvbmp:=selectobject(invdc,invbmp);
  fillrect(invdc,r,getstockobject(WHITE_BRUSH));
  s:=longstr(percent)+'%'+#0;
  drawtext(invdc,@s[1],-1,r,DT_SINGLELINE or DT_CENTER or DT_VCENTER);
  bitblt(p,0,0,r.right,r.bottom,invdc,0,0,SRCINVERT);
  bitblt(p,0,0,r.right,r.bottom,invdc,0,0,DSTINVERT);
  selectobject(invdc,oinvbmp);
  deleteobject(invbmp);
  deletedc(invdc);

  bitblt(dc,0,0,r.right,r.bottom,p,0,0,SRCCOPY);
  selectobject(p,obmp);
  deleteobject(bmp);
  deletedc(p);
end;

procedure TStatusWindow.Paint(PaintDC: HDC; var PaintInfo: TPaintStruct);
begin
  DrawIt(PaintDC);
end;

procedure TStatusWindow.SetPercent(APercent:Word);
var
  DC:hDC;
begin
  Percent:=APercent;
  DC:=GetDC(hWindow);
  DrawIt(DC); {Don't invalidate rect, just paint it.  Chances are that during the operation
               being executed, messages are not being processed, so invalidate rect wouldn't work}
  ReleaseDC(hWindow,DC);
end;

procedure TMagmaWindow.setupwindow;
begin
  edit:=nil;
  inherited setupwindow;
  CreateEditor;
  application^.makewindow(edit);
  edit^.show(sw_shownormal);
  FileName:=nil;
  Filemenu:=0;
  EditMenu:=0;
  MainMenu:=0;
  SearchMenu:=0;
  if ShowStatusWin then
  begin
    edit^.SetReadNotification(-5);
  end;
end;

procedure TMagmaWindow.CreateEditor;
begin
  edit:=new(pmagmaedit,init(@self,100,'',0,0,100,100,32000,true));
  if edit=nil then
    messagebox(0,'Unable to create Magma edit control!','Error',mb_iconexclamation);
end;

function TMagmaWindow.CanClose: Boolean;
begin
  QuerySaveFile;
end;

procedure TMagmaWindow.wmsetfocus(var msg:tmessage);
begin
  if edit<>nil then
    setfocus(edit^.hWindow);
  defwndproc(msg);
end;

procedure TMagmaWindow.wmsize(var msg:tmessage);
var
  extent:tpoint;
begin
  longint(extent):=msg.lparam;
  movewindow(edit^.hWindow,0,0,extent.x,extent.y,true);
  inherited wmsize(msg);
end;

procedure TMagmaWindow.meReadNotify(var msg:tmessage);
begin
  statuswnd^.SetPercent(PReadNotifyInfo(msg.lparam)^.nPercent);
  msg.result:=longint(true);
end;

procedure TMagmaWindow.meMeasureItem(var msg:tmessage);
begin
  msg.result:=0;
end;

procedure TMagmaWindow.meDeleteItem(var msg:tmessage);
begin
  msg.result:=0;
end;

procedure TMagmaWindow.meDrawItem(var msg:tmessage);
var
  item:PMEDrawItemStruct;
begin
  item:=pointer(msg.lparam);
  with item^ do
    msg.result:=DrawItem(hDC,lpText,itemData,lineNumber,idxLeft,item);
end;

function TMagmaWindow.DrawItem(DC:hDC;lpText:PChar;itemData:Longint;lineNumber:TLineNumber;
  idxLeft:TColNumber;item:PMEDrawItemStruct):longint;
begin
  drawitem:=0;
end;

procedure TMagmaWindow.SetFileName(fname:pchar);
begin
  if filename<>nil then strdispose(filename);
  filename:=strnew(fname);
end;

procedure TMagmaWindow.GetFileName(fname:pchar; maxsz:word);
begin
  strlcopy(fname,filename,maxsz);
end;

function TMagmaWindow.GetLoadName(caption:pchar):boolean;
var
  fn:topenfilename;
  buffer:array[0..255] of char;
  res:boolean;
begin
  fillchar(fn,sizeof(fn),0);
  strcopy(buffer,'*.*');
  with fn do
  begin
    lStructSize:=sizeof(fn);
    hWndOwner:=hWindow;
    lpstrfile:=buffer;
    nMaxFile:=255;
    lpstrtitle:=caption;
    flags:=ofn_createprompt or ofn_hidereadonly ;
  end;
  res:=(word(GetOpenFileName(fn))<>0);
  if res then
  begin
    clearfilename;
    filename:=strnew(buffer);
  end;
  GetLoadName:=res;
end;

function TMagmaWindow.GetSaveName(caption:pchar):boolean;
var
  fn:topenfilename;
  buffer:array[0..255] of char;
  res:boolean;
begin
  fillchar(fn,sizeof(fn),0);
  strcopy(buffer,'*.*');
  with fn do
  begin
    lStructSize:=sizeof(fn);
    hWndOwner:=hWindow;
    lpstrfile:=buffer;
    nMaxFile:=255;
    lpstrtitle:=caption;
    flags:=ofn_hidereadonly or ofn_overwriteprompt;
  end;
  res:=(word(GetSaveFileName(fn))<>0);
  if res then
  begin
    clearfilename;
    filename:=strnew(buffer);
  end;
  GetSaveName:=res;
end;

procedure TMagmaWindow.QuerySaveFile;
var
  clear:boolean;
begin
  clear:=(sendmessage(edit^.hWindow,em_getmodify,0,0)=0);
  if not clear then
  begin
    if (messagebox(hWindow,'Save changes to text?','Query',mb_iconquestion or
      mb_yesno)=idYes) then save;
  end;
end;

procedure TMagmaWindow.ClearFileName;
begin
  if filename<>nil then strdispose(filename);
  filename:=nil;
end;

procedure TMagmaWindow.Save;
begin
  inline($cc);
  if filename=nil then GetSaveName('Save As...');
  edit^.WriteFile(0, filename);
end;

procedure TMagmaWindow.SaveAs;
begin
  GetSaveName('Save As...');
  edit^.WriteFile(0, filename);
end;

procedure TMagmaWindow.Load;
var
  s:string;
  oldfilename,newfilename:pchar;
begin
  if filename<>nil then
    oldfilename:=strnew(filename)
  else
    oldfilename:=nil;
  if FileName=nil then GetLoadName('Open File...');
  if filename<>nil then
  begin
    newfilename:=filename;
    filename:=oldfilename;
    sendmessage(hWindow,WM_COMMAND,CM_FILENEW,0);
    filename:=newfilename;
    if oldfilename<>nil then
      strdispose(oldfilename);
    if ShowStatusWin then
    begin
      s:='Loading '+strpas(filename)+'...'+#0;
      statuswnd:=new(PStatusWindow,init(@self,@s[1]));
      application^.makewindow(statuswnd);
      statuswnd^.show(sw_shownormal);
    end;
    edit^.OpenFile(0, filename);
    if ShowStatusWin then
      statuswnd^.closewindow;
    sendmessage(edit^.hWindow,em_setmodify,word(false),0);
  end;
end;

procedure TMagmaWindow.cmFileNew(var msg:tmessage);
var
  clear:boolean;
begin
  QuerySaveFile;
  setwindowtext(edit^.hWindow,'');
end;

procedure TMagmaWindow.cmFileOpen(var msg:tmessage);
begin
  clearfilename;
  load;
end;

procedure TMagmaWindow.cmFileSave(var msg:tmessage);
begin
  save;
end;

procedure TMagmaWindow.cmFileSaveAs(var msg:tmessage);
begin
  saveas;
end;

procedure TMagmaWindow.cmFileExit(var msg:tmessage);
begin
  closewindow;
end;

procedure TMagmaWindow.cmEditUndo(var msg:tmessage);
begin
  edit^.undo;
end;

procedure TMagmaWindow.cmEditRedo(var msg:tmessage);
begin
  edit^.redo;
end;

procedure TMagmaWindow.cmEditCut(var msg:tmessage);
begin
  edit^.cut;
end;

procedure TMagmaWindow.cmEditCopy(var msg:tmessage);
begin
  edit^.copy;
end;

procedure TMagmaWindow.cmEditPaste(var msg:tmessage);
begin
  edit^.paste;
end;

procedure TMagmaWindow.cmEditAppend(var msg:tmessage);
begin
  edit^.cutappend;
end;

procedure TMagmaWindow.cmEditOptions(var msg:tmessage);
begin
  edit^.optiondlg;
end;

procedure TMagmaWindow.cmSearchFind(var msg:tmessage);
begin
  edit^.fsearch(nil);
end;

procedure TMagmaWindow.cmSearchReplace(var msg:tmessage);
begin
  edit^.freplace(nil);
end;

procedure TMagmaWindow.cmSearchAgain(var msg:tmessage);
begin
  edit^.SearchAgain;
end;

procedure TMagmaWindow.AddFileMenu;
begin
  if FileMenu=0 then
  begin
    AddToFilemenu(cm_FileNew,'&New');
    AddToFilemenu(cm_FileOpen,'&Open...');
    AddToFilemenu(cm_FileSave,'&Save');
    AddToFilemenu(cm_FileSaveAs,'Save &As...');
    AddToFilemenu(0,nil);
    AddToFilemenu(cm_FileExit,'E&xit');
  end;
end;

procedure TMagmaWindow.AddToMenu(var menu:hmenu; id:word; txt:pchar; header:pchar);
begin
  if MainMenu=0 then MainMenu:=CreateMenu;
  if menu=0 then
  begin
    menu:=createmenu;
    if header<>nil then
      appendmenu(mainmenu,MF_POPUP,menu,header);
  end;
  if menu<>0 then
  begin
    if id<>0 then
      appendmenu(menu,mf_string,id,txt)
    else
      appendmenu(menu,mf_separator,0,nil);
    Setmenu(hWindow,MainMenu);
  end;
end;

procedure TMagmaWindow.AddToFileMenu(id:word; txt:pchar);
begin
  AddToMenu(FileMenu,id,txt,'&File');
end;

procedure TMagmaWindow.AddEditMenu;
begin
  if EditMenu=0 then
  begin
    AddToEditmenu(cm_EditUndo,'&Undo');
    AddToEditmenu(cm_EditRedo,'&Redo');
    AddToEditMenu(0,nil); {separator}
    AddToEditmenu(cm_EditCut,'&Cut');
    AddToEditmenu(cm_EditCopy,'C&opy');
    AddToEditmenu(cm_EditPaste,'&Paste');
    AddToEditmenu(cm_EditAppend,'Cut &Append');
    AddToEditMenu(0,nil); {separator}
    AddToEditmenu(cm_EditOptions,'Op&tions');
  end;
end;

procedure TMagmaWindow.AddSearchMenu;
begin
  if SearchMenu=0 then
  begin
    AddToSearchMenu(cm_SearchFind,'&Find...');
    AddToSearchMenu(cm_SearchReplace,'&Replace...');
    AddToSearchMenu(cm_SearchAgain,'&Again');
  end;
end;

procedure TMagmaWindow.AddToSearchMenu(id:word; txt:pchar);
begin
  AddToMenu(SearchMenu,id,txt,'&Search');
end;

procedure TMagmaWindow.AddToEditMenu(id:word; txt:pchar);
begin
  AddToMenu(EditMenu,id,txt,'&Edit');
end;

Function TMagmaWindow.ShowStatusWin:Boolean;
begin
  ShowStatusWin:=False;
end;


constructor THighlightGroup.init(afont:hfont; acolour:TColorRef; aWordList:PWordList);
begin
  inherited init;
  font:=afont;
  Colour:=acolour;
  wordlist:=awordlist;
end;

destructor THighlightGroup.done;
begin
  if wordlist<>nil then
    dispose(wordlist,done);
  if font<>0 then deleteobject(font);
end;

constructor TMagmaHighlight.Init(AParent: PWindowsObject; ATitle: PChar; acasesense:boolean);
begin
  inherited init(aparent,atitle);
  highlight:=nil;
  casesense:=acasesense;
end;

destructor TMagmaHighlight.done;
begin
  inherited done;
  if highlight<>nil then
    dispose(highlight,done);
end;

function TMagmaHighlight.GetDefaultFont:hFont;
begin
  GetDefaultFont:=getStockobject(ANSI_VAR_FONT);
end;

function TMagmaHighlight.CreateWordGroup(font:hfont; Colour:TColorRef):PHighlightGroup;
var
  list:PHighlightGroup;
begin
  list:=new(PHighlightGroup,Init(Font,Colour,nil));
  linked.additem(list,Highlight);
  CreateWordGroup:=list;
end;

procedure TMagmaHighlight.AppendWordList(var List:PWordList; aWord:PChar);
begin
  if not casesense then
    strupper(aword);
  Linked.AddItem(new(PWordList,Init(aWord)),list);
end;

function TMagmaHighlight.DrawItem(DC:hDC;lpText:PChar;itemData:Longint;lineNumber:TLineNumber;
      idxLeft:TColNumber;item:PMEDrawItemStruct):longint;
var
  cp:pchar; {Current position within lpText}
  blk:pchar; {Text block to draw}
  font,oldfont:hfont; {current font}

  function GetNextWord(var pc:pchar):pchar;
  {This function takes a string, and returns the first word (including white-space)
  in the string.  It then updates the passed pchar to the next character of the string,
  or nil if at the end.}
  var
    wrd:pchar;    {Resultant word}
    wrdoffs:word; {Number of chars in resultant word}

    procedure addchar(c:char);
    begin
      if (wrdoffs<1024) or (c=#0) then
        wrd[wrdoffs]:=c;
      if (wrdoffs<1024) then
      begin
        inc(wrdoffs);
        inc(pc);
      end;
    end;

  begin
    if pc[0]=#0 then
    begin
      pc:=nil;
      getNextWord:=nil;
    end
    else
    begin
      wrdoffs:=0;
      getmem(wrd,1024); {One word can be up to 1K in size}
      while (pc[0]<>#0) and iswhitespace(pc[0]) do
        addchar(pc[0]);
      while (pc[0]<>#0) and (not iswhitespace(pc[0])) do
        addchar(pc[0]);
      while (pc[0]<>#0) and iswhitespace(pc[0]) do
        addchar(pc[0]);
      addchar(#0);
      dec(pc); {Don't add #0 as though it were part of the input string}
      GetNextWord:=Strnew(wrd);
      freemem(wrd,1024);
    end;
  end;

  procedure getfont(pc:pchar; var font:hFont; var colour:TColorRef);
  var
    group:PHighlightGroup;
    wrd:PWordList;
    hash:longint;
  begin
    font:=0;
    colour:=0;
    group:=Highlight;
    hash:=hashit(pc,casesense);
    while group<>nil do
    begin
      wrd:=group^.wordlist;
      while wrd<>nil do
      begin
        if (wrd^.hash=hash) and wrd^.ismatch(pc,casesense) then
        begin
          font:=group^.font;
          colour:=group^.colour;
          wrd:=nil;
          group:=nil; {early exit of loop}
        end;
        linked.next(wrd);
      end;
      linked.next(group);
    end;
    if font=0 then Font:=GetDefaultFont
  end;

var
  fillrc:trect;
  MemDC:hDC;
  OldBMP,MemBMP:hBitmap;
  Colour,OldColour:TColorRef;
  pixLeft:TPoint;
begin
  MemDC:=CreateCompatibleDC(DC);
  with item^.rcItem do
    MemBMP:=CreateCompatibleBitmap(DC,right-left,bottom-top);
  OldBmp:=SelectObject(MemDC,MemBMP);
  settextalign(memdc,ta_left or ta_top or ta_updatecp);
  moveto(memdc,0,0);
  with item^.rcitem do
  begin
    fillrc:=item^.rcItem;
    with fillrc do
      offsetrect(fillrc,-left,-top);
    fillrect(MemDC,fillrc,getstockobject(white_brush));
  end;
  longint(pixLeft):=GetTextExtent(MemDC,lpText,idxLeft);
  cp:=lpText;
  while cp<>nil do
  begin
    blk:=getnextword(cp);
    if blk<>nil then
    begin
      getfont(blk,font,Colour);
      oldfont:=selectobject(memdc,font);
      oldcolour:=settextcolor(memdc,colour);
      textout(memdc,0,0,blk,strlen(blk));
      settextcolor(memdc,oldcolour);
      selectobject(memdc,oldfont);
      strdispose(blk);
    end;
  end;
  with item^.rcitem do
    bitblt(dc,left-pixLeft.x,top,right-left,bottom-top,MemDC,0,0,SRCCOPY);
  selectobject(MemDC,OldBmp);
  DeleteObject(MemBmp);
  deleteDC(memdc);
  DrawItem:=1;
end;

constructor TWordList.init(Text:PChar);
begin
  inherited init;
  txt:=strnew(text);
  hash:=hashit(txt,true);
end;

destructor TWordList.done;
begin
  inherited done;
  strdispose(txt);
end;

function TWordList.ismatch(str:pchar; casesense:boolean):boolean;
var
  s:string;
begin
  s:=stripwhite(strpas(str),not casesense)+#0;
  ismatch:=(strcomp(@s[1],txt)=0);
end;

constructor TMagmaHighlightEdit.Init(AParent: PWindowsObject; AnId: Integer;
  ATitle: PChar; X,Y,W,H: Integer; ATextLen: Integer; Multiline : Boolean);
begin
  inherited init(aparent,anid,atitle,x,y,w,h,atextlen,multiline);
  with attr do
    style:=style or es_ownerdraw or es_hasstrings;
end;

begin
  if loadlibrary('MAGMAED.DLL')<32 then
    messagebox(0,'Couldn''t load MAGMAED.DLL.','Windows Error',mb_iconexclamation);
end.