{Test application for MAGMAED.DLL and MAGMAED.PAS.  Define HIGHLIGHT to test syntax highlighting
with pascal style key-words.}

{ $DEFINE HIGHLIGHT}
Program MagmaEditor;

uses wintypes,owindows,magmaed;

type
  papp=^tapp;
  tapp=object(tapplication)
    procedure initmainwindow; virtual;
  end;

  pmainwin=^tmainwin;
{$IFDEF HIGHLIGHT}
  tmainwin=object(tmagmahighlight)
{$ELSE}
  tmainwin=object(tmagmawindow)
{$ENDIF}
    procedure setupwindow; virtual;
    Function ShowStatusWin:Boolean; virtual;
    procedure CreateEditor; virtual;
  end;

procedure tmainwin.setupwindow;
{$IFDEF HIGHLIGHT}
var
  group:PHighlightGroup;
{$ENDIF}
begin
  inherited setupwindow;
  addfilemenu;
  addeditmenu;
  addsearchmenu;
{$IFDEF HIGHLIGHT}
  sendmessage(edit^.hWindow,wm_setfont,getstockobject(ANSI_VAR_FONT),0);
  group:=CreateWordGroup(getstockobject(ANSI_VAR_FONT),RGB(0,0,255));
  appendwordlist(group^.wordlist,'procedure');
  appendwordlist(group^.wordlist,'function');
  appendwordlist(group^.wordlist,'var');
  appendwordlist(group^.wordlist,'type');
  appendwordlist(group^.wordlist,'const');
  appendwordlist(group^.wordlist,'begin');
  appendwordlist(group^.wordlist,'end');
  group:=CreateWordGroup(getstockobject(ANSI_VAR_FONT),RGB(0,255,0));
  appendwordlist(group^.wordlist,'char');
  appendwordlist(group^.wordlist,'string');
  appendwordlist(group^.wordlist,'longint');
  appendwordlist(group^.wordlist,'integer');
  appendwordlist(group^.wordlist,'word');
  appendwordlist(group^.wordlist,'byte');
  appendwordlist(group^.wordlist,'real');
{$ENDIF}
end;

Function Tmainwin.ShowStatusWin:Boolean;
begin
  ShowStatusWin:=true;
end;

procedure TMainWin.CreateEditor;
begin
  edit:=new(PMagmaHighlightEdit,init(@self,100,'',0,0,100,100,32000,true));
  if edit=nil then
    messagebox(0,'Unable to create Magma edit control!','Error',mb_iconexclamation);
end;

procedure tapp.initmainwindow;
begin
{$IFDEF HIGHLIGHT}
  mainwindow:=new(pmainwin,init(nil,'Magma Edit for Pascal',true));
{$ELSE}
  mainwindow:=new(pmainwin,init(nil,'Magma Edit for Pascal'));
{$ENDIF}
end;

var
  app:papp;
begin
  app:=new(papp,init('Magma Test'));
  app^.run;
  dispose(app,done);
end.