Attribute VB_Name = "basMAIN"
Option Explicit
'  MetaGif converts Windows Metafiles to CompuServe Gif files. This
'  32 bit DLL allows image resizeing without distortion. With this
'  library you can create WEB documents on the fly, from your Windows
'  application. With MetaGif you can create a Gif file that is larger
'  than the screen.
'
'  The main() program is a simple example of how to use MetaGif. The program
'  will convert the two Windows (placeable) Metafiles to CompuServe Gif
'  files. You can use Microsoft Word to view the metafiles and the gif file
'  results.
'
'  See the MetaGif function declaration for a full description of usage.  MetaGif
'  is a Shareware program, see the readme.txt file for registration
'  information.
'
'  There are now two MetaGif DLLs, a 16 bit and 32 bit library.  This example uses
'  the 32 bit DLL with VB 4.0.
'
'  THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS
'  OR IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE
'  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
'  PARTICULAR PURPOSE.
'
'  Author:
'     David E. Suffield
'     Eckler Software
'     620 101st Court
'     Vancouver, WA 98664
'     dsuffiel@worldaccess.com
'
Declare Function LoadLibrary Lib "Kernel32" Alias "LoadLibraryA" (ByVal lpLibFileName As String) As Long
Declare Function FreeLibrary Lib "Kernel32" (ByVal hLibModule As Long) As Long

' Function: MetaGif()
'
' Purpose: Convert Placeable Metafiles to Gif files.
'
' Parameters:
'          szWmf    placeable metafile file name (input)
'          szGif    gif file name (output)
'          scaleX   scale factor percentage (100 = width*1)
'          scaleY   scale factor percentage (150 = height*1.5)
'
' Returns:
'          -3    could not open placeable metafile
'          -2    could not write gif file
'          -1    not a placeable metafile
'           0    not enough memory
'           1    ok
Declare Function MetaGif Lib "METAGIF32.DLL" (ByVal szWmf As String, ByVal szGif As String, ByVal scaleX As Integer, ByVal scaleY As Integer) As Integer

Global stopit As Integer

Sub main()
   Dim r As Integer, i As Integer, hInst As Long
   Dim exePath As String
  
   Screen.MousePointer = 11   ' Change pointer to hourglass.

   frmTest.txtMax = 10
   frmTest.txtCnt = 0
   frmTest.Show
   frmTest.Refresh

   If (Right$(App.Path, 1) <> "\") Then
      exePath = App.Path + "\"
   Else
      exePath = App.Path   'probably app.path="A:\"
   End If

'   hInst = LoadLibrary(exePath + "metagif32.dll")
   stopit = False

   For i = 1 To 10
      'Convert metafile to gif file, output is 50% bigger.
      r = MetaGif(exePath + "anchor.wmf", exePath + "anchor.gif", 150, 150)
      
      'Convert metafile to gif file, output is 50% smaller.
      r = MetaGif(exePath + "coins.wmf", exePath + "coins.gif", 50, 50)
      
      frmTest.txtCnt = i
      r = DoEvents()
      If (stopit) Then Exit For
   Next
   
'   r = FreeLibrary(hInst)
   Unload frmTest
   Screen.MousePointer = 0

End Sub

