unit Wmix; {WaveMix DLL import module May 1995 by Gavin R. Kujawa}

interface

type
    TWMixInfo = record           {Storage record for WMixGetInfo}
            Size: word;            {Record size}
            Vmajor: byte;          {'Major' version # (i.e. '#.')}
            Vminor: byte;          {'Minor' version # (i.e. '.#')}
            Date: array[0..11] of char;{Compilation date as 'mmm dd yyyy[null]'}
            Formats: longint;      {PCM formats supported as flags}
    end;

type
    TWMixConfig = record         {Storage record for WMixConfigure}
              Size: word;          {Record size}
              Flags: longint;      {Flags (see below). Must OR with both...}
              Channels: word;      {1(mono) or 2(stereo) And ...}
              SampRate: word;      {11, 22, or 44 kHz}
    end;

type
    TWMixParams = record         {Storage record for WMixPlay}
              Size: word;          {Record size}
              Session: word;       {WaveMix session handle}
              Channel: integer;    {Play on channel(0 to 7)}
              Wave: Pointer;       {Memory pointer to Wave file}
              Notify: word;        {Handle to send MM_WOM_DONE message to}
              Flags: longint;      {Play flags (see below)}
              Loops: word;         {# of times to loop ($FFFF = indefinite)}
    end;

type
    TWMixMessage = record        {Message record used by WMixPlay}
                 Msg: integer;     {Message #: $03BD (MM_WOM_DONE)}
                 Channel: integer; {Channel # just played}
                 Wave: pointer;    {Pointer to Wave file in memory}
                 Result: longint;  {Not used (?) by WaveMix}
    end;

const                                {WaveMix bit flags}
     WMix_File: longint = $0001;       {WMixOpen: from disk file}
     WMix_Resource: longint = $0002;   {WMixOpen: from system resource file}
     WMix_Memory: longint = $0004;     {WMixOpen: from memory}
     WMix_OpenSingle: longint = $0000; {WMixChannel: open one Play channel}
     WMix_OpenAll: longint = $0001;    {WMixChannel: open ALL eight channels}
     WMix_OpenCount: longint = $0002;  {WMixChannel: open # channels}
     WMix_FlushAll: longint = $0001;   {WMixFlush & Close: do ALL channels}
     WMix_NoRemix: longint = $0002;    {WMixFlush: don't remix sound data}
     WMix_Channels: longint = $0001;   {WMixConfigure: set channels}
     WMix_SamplingRate: longint = $0002;{WMixConfigure: set playback rate}
     WMix_QueueWave: longint = $0000;  {WMixPlay: play when previous finishes}
     WMix_ClearQueue: longint = $0001; {WMixPlay: play sound immediately}
     WMix_UseLRUChannel: longint = $0002;{WMixPlay: play on next available chan}
     WMix_HiPriority: longint = $0004; {WMixPlay: remix play buffer immediately}
     WMix_Wait: longint = $0008;       {WMixPlay: hold until next 'Play'}
     MM_WOM_DONE: integer = $03BD;     {Message used by WMixPlay when done}

function WMixInit: word; far;
         {WaveMixInit: returns WaveMix session handle}
function WMixConfigure(Config: TWMixConfig): word; far;
         {WaveMixConfigureInit: also returns WaveMix session handle}
procedure WMixActivate(Session: word; Activate: boolean);
          {WaveMixActivate: gains/releases Wave player}
function WMixWave(Session: word; Wave: PChar; Instance: word; Flags: longint): Pointer; far;
         {WaveMixOpenWave: returns pointer to WaveMix Wave data}
procedure WMixChannel(Session: word; Channel: integer; Flags: longint);
          {WaveMixOpenChannel: opens play channels}
procedure WMixPlay(Params: TWMixParams);
          {WaveMixPlay: plays file using Params (see above)}
procedure WMixFlush(Session: word; Channel: integer; Flags: longint);
          {WaveMixFlushChannel: clears selected channel}
procedure WMixClose(Session: word; Channel: integer; Flags: longint);
          {WaveMixCloseChannel: closes selected channel}
procedure WMixFree(Session: word; Wpointer: Pointer);
          {WaveMixFreeWave: clears Wave file from memory}
procedure WMixExit(Session: word);
          {WaveMixCloseSession: stops & unloads WaveMix DLL}
procedure WMixPump;
          {WaveMixPump: play next mixing buffer}
function WMixGetInfo(Info: TWMixInfo): word; far;
         {WaveMixGetInfo: fills in Info record (see above)}

implementation  {Define WMix functions from WaveMix DLL}

function WMixInit; external 'wavemix' name 'WaveMixInit';
function WMixConfigure; external 'wavemix' name 'WaveMixConfigureInit';
procedure WMixActivate; external 'wavemix' name 'WaveMixActivate';
function WMixWave; external 'wavemix' name 'WaveMixOpenWave';
procedure WMixChannel; external 'wavemix' name 'WaveMixOpenChannel';
procedure WMixPlay; external 'wavemix' name 'WaveMixPlay';
procedure WMixFlush; external 'wavemix' name 'WaveMixFlushChannel';
procedure WMixClose; external 'wavemix' name 'WaveMixCloseChannel';
procedure WMixFree; external 'wavemix' name 'WaveMixFreeWave';
procedure WMixExit; external 'wavemix' name 'WaveMixCloseSession';
procedure WMixPump; external 'wavemix' name 'WaveMixPump';
function WMixGetInfo; external 'wavemix' name 'WaveMixGetInfo';

end.
