VERSION 2.00
Begin Form Form1 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "CompressIT/VBX"
   ClientHeight    =   3735
   ClientLeft      =   1140
   ClientTop       =   1425
   ClientWidth     =   6435
   Height          =   4140
   Left            =   1080
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   3735
   ScaleWidth      =   6435
   Top             =   1080
   Width           =   6555
   Begin CMPRSVBX comprsit1 
      EncryptionKey   =   ""
      Left            =   4440
      Top             =   240
   End
   Begin CommandButton cmd_start 
      Caption         =   "Start Decompression!"
      Height          =   615
      Left            =   240
      TabIndex        =   4
      Top             =   1800
      Width           =   2295
   End
   Begin TextBox Text2 
      Height          =   375
      Left            =   120
      TabIndex        =   1
      Top             =   1200
      Width           =   2775
   End
   Begin TextBox Text1 
      Height          =   375
      Left            =   120
      TabIndex        =   0
      Top             =   360
      Width           =   2775
   End
   Begin Label Label9 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Output Decompressed Data:"
      Height          =   195
      Left            =   2640
      TabIndex        =   13
      Top             =   2160
      Width           =   2415
   End
   Begin Label lbl_compressed 
      AutoSize        =   -1  'True
      BackColor       =   &H00C0C0C0&
      Height          =   195
      Left            =   5280
      TabIndex        =   12
      Top             =   2160
      Width           =   1095
   End
   Begin Label Label7 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Data sent for Decompression:"
      Height          =   195
      Left            =   2640
      TabIndex        =   11
      Top             =   1920
      Width           =   2535
   End
   Begin Label lbl_sent 
      AutoSize        =   -1  'True
      BackColor       =   &H00C0C0C0&
      Height          =   195
      Left            =   5280
      TabIndex        =   10
      Top             =   1920
      Width           =   1095
   End
   Begin Label lbl_ratio 
      AutoSize        =   -1  'True
      BackColor       =   &H00C0C0C0&
      Height          =   195
      Left            =   5280
      TabIndex        =   9
      Top             =   1680
      Width           =   375
   End
   Begin Label Label6 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Compression Ratio:"
      Height          =   195
      Left            =   3480
      TabIndex        =   8
      Top             =   1680
      Width           =   1650
   End
   Begin Label Label5 
      Alignment       =   2  'Center
      BackColor       =   &H00C0C0C0&
      Caption         =   "With CompressIT/VBX/OCX you have total control and no File I/O is required.  This application is a programming example that creates the original decompressed file from a compressed source file data.  Look at all the CompressIT events where all the Event Driven Decompression occurs."
      Height          =   975
      Left            =   120
      TabIndex        =   7
      Top             =   2640
      Width           =   6255
   End
   Begin Label lbl_percent 
      AutoSize        =   -1  'True
      BackColor       =   &H00C0C0C0&
      Height          =   195
      Left            =   5280
      TabIndex        =   6
      Top             =   1440
      Width           =   375
   End
   Begin Label Label3 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Percent Completion:"
      Height          =   195
      Left            =   3480
      TabIndex        =   5
      Top             =   1440
      Width           =   1725
   End
   Begin Label Label2 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Output Decompressed File Name:"
      Height          =   195
      Left            =   120
      TabIndex        =   3
      Top             =   960
      Width           =   2850
   End
   Begin Label Label1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Source Compressed File Name:"
      Height          =   195
      Left            =   120
      TabIndex        =   2
      Top             =   120
      Width           =   2655
   End
End
' This is a sample demo Visual Basic 3.0 application showing how the CompressIT/VBX can be used
' You can modify this application at your will.
' Sylvain Faust Inc. (SFI)
' Technical support: 819 778-5045  Fax: 819 778-7943  BBS: 819 778-8556
Option Explicit
DefInt A-Z
Const ProgName$ = "CompressIT/VBX Decompression Example"
Dim zip_new%
Dim TotalLength&, LengthRemain&, TotalRead&, TotalWritten&
Dim cratio%, dtype%

Sub cmd_start_Click ()
    Open text1.Text For Binary Access Read As #1
    Open text2.Text For Binary Access Write As #2
    TotalLength& = LOF(1)
    If TotalLength& = 0 Then
	MsgBox "Input file " & text1.Text & " is empty!", 48, ProgName$
	Close #1
	Close #2
	Exit Sub
    End If
    LengthRemain& = TotalLength&
    Screen.MousePointer = 11

    TotalRead& = 0
    TotalWritten& = 0
    ' Tell CompressIT to Start Decompressiong Events!!!
    COMPRSIT1.Action = 1

    Close #1
    Close #2

    Screen.MousePointer = 0
    If COMPRSIT1.Status <> 0 Then MsgBox "Error in Decompression:" + Str$(COMPRSIT1.Status), 48, "CompressIT! Demo"
End Sub

Sub comprsit1_DecompressRead (DeCompressBuffer As String, DeCompressBufferBytes As Integer)
    ' This event is generated by CompressIT so you can start feeding the Decompression Engine.
    ' CompressIT will request data for decompression until you return an empty ("") string in
    ' the DeCompressBuffer parameter.
    ' As soon as decompressed data is available, CompressIT will generate "DecompressWrite" events.
    '
    ' In this example, we read data from a source file for decompression.  In reality, the
    ' source data can be taken from a Modem communication, or from a database, or else, at your will.
    Dim x%, Buffer$
    If Not EOF(1) Then
	If LengthRemain& > DeCompressBufferBytes Then
	    x% = DeCompressBufferBytes
	Else
	    x% = LengthRemain&
	End If
	Buffer$ = Space$(x%)
	Get #1, , Buffer$
	DeCompressBuffer = Buffer$
	DeCompressBufferBytes = x%
	LengthRemain& = LengthRemain& - x%
	' Update the number of bytes read on Window
	TotalRead& = TotalRead& + x%
	Lbl_Sent.Caption = Str$(TotalRead&)
	Lbl_Sent.Refresh
    End If

End Sub

Sub comprsit1_DecompressWrite (DeCompressBuffer As String)
    ' This event is generated when CompressIT has decompressed data ready for you.
    ' This event will be generated as many time as necessary so you get all the available
    ' decompressed data "on the fly" asynchronously with the "decompressRead" event.
    ' In this example we write to a file the decompressed data as soon as it is available.
    ' In reality, you can keep it in memory, send it to a Modem or save it to a database, or anything
    ' else you want, at your will.
    Dim DoneInPercent%
    ' Put available compressed data to disk (or elsewhere)
    Put #2, , DeCompressBuffer
    ' Compute % Completion
    DoneInPercent% = ((TotalLength& - LengthRemain&) / TotalLength&) * 100
    lbl_Percent.Caption = Str$(DoneInPercent%)
    lbl_Percent.Refresh
    ' Update Decompressed bytes on Window
    TotalWritten& = TotalWritten& + Len(DeCompressBuffer)
    lbl_Compressed.Caption = Str$(TotalWritten&)
    lbl_Compressed.Refresh
    ' Compute Compression ratio so far
    lbl_Ratio.Caption = Str$(Int(((TotalWritten& - TotalRead&) / TotalWritten&) * 100))
    lbl_Ratio.Refresh
End Sub

Sub Form_Load ()
    ' Center Form
    Move (Screen.Width - Form1.Width) \ 2, (Screen.Height - Form1.Height) \ 3
    Form1.Caption = ProgName$
End Sub

