VERSION 4.00
Begin VB.Form Form1 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Time Sample Program"
   ClientHeight    =   3510
   ClientLeft      =   1575
   ClientTop       =   2370
   ClientWidth     =   7470
   Height          =   3915
   Left            =   1515
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3510
   ScaleWidth      =   7470
   Top             =   2025
   Width           =   7590
   Begin VB.CommandButton cmdExit 
      Caption         =   "Exit Time Sample"
      Height          =   375
      Left            =   5160
      TabIndex        =   8
      Top             =   1440
      Width           =   2055
   End
   Begin VB.CommandButton cmdGetTimeBlocking 
      Caption         =   "Get Time (Blocking)"
      Height          =   375
      Left            =   5160
      TabIndex        =   7
      Top             =   840
      Width           =   2055
   End
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Interval        =   100
      Left            =   6360
      Top             =   2040
   End
   Begin VB.CommandButton cmdGetTimeNonBlocking 
      Caption         =   "Get Time (Non-Blocking)"
      Height          =   375
      Left            =   5160
      TabIndex        =   2
      Top             =   360
      Width           =   2055
   End
   Begin VB.TextBox txtHostName 
      Height          =   285
      Left            =   240
      TabIndex        =   0
      Top             =   480
      Width           =   4575
   End
   Begin GethostLibCtl.GetAdrs GetAdrs1 
      Left            =   5160
      Top             =   2040
      _Version        =   262144
      _ExtentX        =   847
      _ExtentY        =   847
      _StockProps     =   0
   End
   Begin TimeLibCtl.Time Time1 
      Left            =   5760
      Top             =   2040
      _Version        =   262144
      _ExtentX        =   847
      _ExtentY        =   847
      _StockProps     =   0
   End
   Begin VB.Label Label3 
      Caption         =   $"time.frx":0000
      Height          =   975
      Left            =   240
      TabIndex        =   9
      Top             =   2280
      Width           =   4575
   End
   Begin VB.Label lblCurrentTime 
      BorderStyle     =   1  'Fixed Single
      Height          =   285
      Left            =   240
      TabIndex        =   6
      Top             =   1800
      Width           =   4575
   End
   Begin VB.Label lblErrorNumber 
      BorderStyle     =   1  'Fixed Single
      Height          =   285
      Left            =   240
      TabIndex        =   4
      Top             =   1200
      Width           =   4575
   End
   Begin VB.Label Label4 
      Caption         =   "Current Time:"
      Height          =   255
      Left            =   240
      TabIndex        =   3
      Top             =   1560
      Width           =   2055
   End
   Begin VB.Label Label1 
      Caption         =   "Host Name:"
      Height          =   255
      Left            =   240
      TabIndex        =   1
      Top             =   240
      Width           =   2055
   End
   Begin VB.Label Label2 
      Caption         =   "Error Code:"
      Height          =   255
      Left            =   240
      TabIndex        =   5
      Top             =   960
      Width           =   2055
   End
End
Attribute VB_Name = "Form1"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit

Const CONNECTING = 1
Const SENDING_REQUEST = 2
Const WAITING_FOR_RESPONSE = 3
Const RECEIVING_INFORMATION = 4
Const WAITING_FOR_ACTION = 5

Const BaseTitleBar = "Time Sample Program"

Dim Blocking As Boolean
Function ErrorNumberString(ErrorNumber As Integer)
   ' Translate an error code into something better
   ' suited for human consumption.
   Select Case ErrorNumber
      Case 0:     ErrorNumberString = "No error."
      Case 4:     ErrorNumberString = "System level interrupt interrupted socket operation."
      Case 9:     ErrorNumberString = "Generic error for invalid format (bad format)."
      Case 13:    ErrorNumberString = "Generic error for access violation."
      Case 14:    ErrorNumberString = "Generic error for fault."
      Case 22:    ErrorNumberString = "Generic error for invalid format, entry, etc."
      Case 24:    ErrorNumberString = "Generic file error."
      Case 25:    ErrorNumberString = "The IP address provided is not valid or the host specified by the IP address does not exist."
      Case 38:    ErrorNumberString = "Invalid socket or not connected to remote."
      Case 48:    ErrorNumberString = "The specified address is already in use."
      Case 49:    ErrorNumberString = "The specified address is not available."
      Case 50:    ErrorNumberString = "The connected network is not available."
      Case 51:    ErrorNumberString = "The connected network is not reachable."
      Case 52:    ErrorNumberString = "The connected network connection has been reset."
      Case 53:    ErrorNumberString = "The current connection has been aborted by the network or intermediate services."
      Case 54:    ErrorNumberString = "The current socket connection has been reset."
      Case 57:    ErrorNumberString = "The current socket has not been connected."
      Case 58:    ErrorNumberString = "The connection has been shutdown."
      Case 60:    ErrorNumberString = "The current connection has timed-out."
      Case 61:    ErrorNumberString = "The requested connection has been refused by the remote host."
      Case 63:    ErrorNumberString = "Specified host name is too long."
      Case 64:    ErrorNumberString = "Remote host is currently unavailable."
      Case 65:    ErrorNumberString = "Remote host is currently unreachable."
      Case 91:    ErrorNumberString = "Remote system is not ready."
      Case 92:    ErrorNumberString = "Current socket version is not supported by the application."
      Case 93:    ErrorNumberString = "Socket API is not initialized."
      Case 101:   ErrorNumberString = "Socket has been disconnected."
      Case 110:   ErrorNumberString = "A restart marker has been received from the remote host."
      Case 120:   ErrorNumberString = "FTP service will be ready later."
      Case 125:   ErrorNumberString = "FTP data connection is already open."
      Case 150:   ErrorNumberString = "FTP file status is OK."
      Case 200:   ErrorNumberString = "FTP command is OK."
      Case 202:   ErrorNumberString = "FTP command is not implemented."
      Case 210:   ErrorNumberString = "No mail connection is available."
      Case 211:   ErrorNumberString = "Originating e-mail address is invalid."
      Case 212:   ErrorNumberString = "Destination e-mail address is invalid."
      Case 213:   ErrorNumberString = "Domain name provided to SMTP is invalid."
      Case 214:   ErrorNumberString = "Cannot send e-mail data."
      Case 215:   ErrorNumberString = "Cannot end the transmission of e-mail."
      Case 216:   ErrorNumberString = "Unable to end the e-mail session."
      Case 217:   ErrorNumberString = "CC address(es) are invalid."
      Case 220:   ErrorNumberString = "FTP service is ready for new user."
      Case 221:   ErrorNumberString = "POP statistics unavailable."
      Case 222:   ErrorNumberString = "POP e-mail list is unavailable."
      Case 223:   ErrorNumberString = "Invalid POP account user name."
      Case 224:   ErrorNumberString = "Invalid POP account user password."
      Case 225:   ErrorNumberString = "Unable to logoff of POP server."
      Case 226:   ErrorNumberString = "Unable to delete mail."
      Case 227:   ErrorNumberString = "Unable to get mail."
      Case 228:   ErrorNumberString = "Unable to undelete mail."
      Case 229:   ErrorNumberString = "Unable to retrieve UIDL information."
      Case 230:   ErrorNumberString = "Unable to log into FTP server."
      Case 250:   ErrorNumberString = "Requested file action OK, completed."
      Case 257:   ErrorNumberString = "Path created."
      Case 331:   ErrorNumberString = "Invalid FTP password."
      Case 332:   ErrorNumberString = "Invalid FTP account."
      Case 350:   ErrorNumberString = "File aciton pending further information."
      Case 400:   ErrorNumberString = "Service disconnected."
      Case 411:   ErrorNumberString = "No such newsgroup."
      Case 412:   ErrorNumberString = "No newsgroup selected for operation."
      Case 420:   ErrorNumberString = "No article has been selected."
      Case 421:   ErrorNumberString = "No next article available in selected group."
      Case 422:   ErrorNumberString = "No previous article available in selected group."
      Case 423:   ErrorNumberString = "No such article available in selected group."
      Case 425:   ErrorNumberString = "Cannot open data connection."
      Case 426:   ErrorNumberString = "Connection closed; transfer aborted."
      Case 430:   ErrorNumberString = "No such article available in selected group."
      Case 435:   ErrorNumberString = "Article not wanted, do not send to server."
      Case 436:   ErrorNumberString = "Transfer failed, try again later."
      Case 437:   ErrorNumberString = "Article rejected, do no resend."
      Case 440:   ErrorNumberString = "Posting of articles not allowed."
      Case 441:   ErrorNumberString = "Posting of the article failed."
      Case 450:   ErrorNumberString = "Requested file action not taken."
      Case 451:   ErrorNumberString = "Local error in processing."
      Case 452:   ErrorNumberString = "Insufficient storage space in system."
      Case 500:   ErrorNumberString = "Syntax error, command unrecognized."
      Case 501:   ErrorNumberString = "Syntax error in arguments."
      Case 502:   ErrorNumberString = "Access is restricted or denied."
      Case 503:   ErrorNumberString = "Program fault, operation not performed."
      Case 504:   ErrorNumberString = "FTP command not implemented."
      Case 530:   ErrorNumberString = "Not logged into remote host."
      Case 532:   ErrorNumberString = "Need account on remote host to store files."
      Case 550:   ErrorNumberString = "Requested action not taken."
      Case 551:   ErrorNumberString = "Page type unknown."
      Case 552:   ErrorNumberString = "Exceeded storage allocation."
      Case 553:   ErrorNumberString = "File name not allowed."
      Case 926:   ErrorNumberString = "Local file is invalid."
      Case 927:   ErrorNumberString = "Local file is invalid."
      Case 1001:  ErrorNumberString = "Host not found."
      Case 1002:  ErrorNumberString = "Not authorized, host not found."
      Case 1003:  ErrorNumberString = "Non-recoverable error."
      Case 1004:  ErrorNumberString = "No data available for request."
      Case 1010:  ErrorNumberString = "Query requires an output file."
      Case 1011:  ErrorNumberString = "Unable to execute application."
      Case 1012:  ErrorNumberString = "Unable to send data."
      Case 1013:  ErrorNumberString = "Unable to connect to remote."
      Case 1100:  ErrorNumberString = "Invalid or unsupported attachment."
      Case 11000: ErrorNumberString = "Requested operation already being executed.  Retry the request or continue."
      Case Else:  ErrorNumberString = "Unknown error code."
      End Select
   End Function




Private Sub cmdExit_Click()
   ' Get out.
   End
   End Sub


Private Sub cmdGetTimeBlocking_Click()
   Dim HostAddress
   
   Blocking = True
   
   ' Clear results boxes.
   lblErrorNumber.Caption = ""
   lblCurrentTime.Caption = ""
   DoEvents
   
   ' Start showing the state.
   Timer1.Enabled = True

   ' Get the IP address of the host.
   HostAddress = GetAdrs1.GetHostAddress(txtHostName.Text)
   
   ' If there's a problem getting the host address ...
   If GetAdrs1.ErrorNumber <> 0 Then
      ' Tell the user and go no further.
      lblErrorNumber = GetAdrs1.ErrorNumber & " - " & ErrorNumberString(GetAdrs1.ErrorNumber)
   Else
      ' Otherwise, get the time from the server.
      lblCurrentTime = Time1.GetTime(HostAddress)
      lblErrorNumber = Time1.ErrorNumber & " - " & ErrorNumberString(Time1.ErrorNumber)
      End If
   End Sub

Private Sub cmdGetTimeNonBlocking_Click()
   ' Clear results boxes.
   lblErrorNumber.Caption = ""
   lblCurrentTime.Caption = ""
   
   Blocking = False
   
   ' Start showing the state.
   Timer1.Enabled = True

   ' Get the IP address of the host.
   GetAdrs1.HostName = txtHostName.Text
   End Sub


Private Sub Form_Load()
   Me.Caption = BaseTitleBar
   End Sub

Private Sub GetAdrs1_EndGetHostAddress(ByVal IPAddress As String, ByVal ErrorNumber As Integer)
   ' If we're doing a blocking mode query, don't rely on the
   ' event procedure.
   If Blocking Then
      Exit Sub
      End If
      
   ' If there's a problem getting the host address ...
   If ErrorNumber <> 0 Then
      ' Tell the user and go no further.
      lblErrorNumber = ErrorNumber & " - " & ErrorNumberString(ErrorNumber)
   Else
      ' Otherwise, get the time from the server.
      Time1.HostAddress = IPAddress
      End If
   End Sub

Private Sub Time1_EndGetTime(ByVal GMTTime As String, ByVal ErrorNumber As Integer)
   ' If we're doing a blocking mode query, don't rely on the
   ' event procedure.
   If Blocking Then
      Exit Sub
      End If
      
   ' Stop getting the status from the Time control.
   Timer1.Enabled = False
   
   ' Display the new time.
   lblCurrentTime.Caption = GMTTime
   
   ' Display any error.
   lblErrorNumber.Caption = ErrorNumber & " - " & ErrorNumberString(ErrorNumber)
   
   Me.Caption = BaseTitleBar
   End Sub


Private Sub Timer1_Timer()
   ' Show current state on title bar.'
   Select Case Time1.CurrentState
      Case CONNECTING
         Me.Caption = BaseTitleBar & " - Connecting"
      Case SENDING_REQUEST
         Me.Caption = BaseTitleBar & " - Requesting Time"
      Case WAITING_FOR_RESPONSE
         Me.Caption = BaseTitleBar & " - Waiting for Response"
      Case RECEIVING_INFORMATION
         Me.Caption = BaseTitleBar & " - Receiving Time"
      Case WAITING_FOR_ACTION
         Me.Caption = BaseTitleBar
      End Select
   End Sub


