#define VERSION  "Version 3.19"

/* My own Button IDs, for edit dialog box */
#define ID_OK           1
#define ID_CANCEL       2
#define ID_SUFS         100
#define ID_SUFED        101
#define ID_SUFER        102
#define ID_SUFING       103
#define ID_SUFEN        104
#define ID_SUFY         105
#define ID_SUFLY        106
#define ID_SUFEST       107
#define ID_SUFISH       108
#define ID_SUFERS       109
#define ID_SUFINGS      110
#define ID_SUF111       111
#define ID_SUF112       112
#define ID_SUF113       113
#define ID_SUF114       114
#define ID_SUF115       115
#define ID_FIRSTSUF     ID_SUFS
#define ID_LASTSUF      ID_SUFINGS
#define ID_DELETE       116
#define ID_FREQ         117
#define ID_PREV         118
#define ID_NEXT         119
#define ID_WMSG         120
#define ID_FMSG         121

#define ID_RMSG         140
#define ID_WORD         141
#define ID_VIRGIN       142

#define ID_FIRSTEDIT    ID_SUFS
#define ID_LASTEDIT     ID_FMSG

/* General input dialog box */
#define ID_INPUT        100
#define ID_IMSG         101

/* ID's for my windows */

#define ID_USERWORDS    (WM_USER)
#define ID_CPLAY        (WM_USER+1)
#define ID_GT           (WM_USER+2)
#define ID_PLIST        (WM_USER+3)
#define ID_PROBOX       (WM_USER+4)
#define ID_ENTER        (WM_USER+5)
#define ID_STOP         (WM_USER+6)

#define ID_FIRSTCUBE    (WM_USER+8)
/* must leave enough space for 25 cubes */
#define ID_LASTCUBE     (WM_USER+33)

/* My own messages */
#define EGGM_SET        (WM_USER+35)
#define EGGM_START      (WM_USER+36)
#define EGGM_STOP       (WM_USER+37)
#define BAGOM_ENDGAME   (WM_USER+38)
#define BAGOM_INIT      (WM_USER+39)
#define BAGOM_CUBEDN    (WM_USER+40)
#define BAGOM_CUBEUP    (WM_USER+41)
#define BAGOM_TAB       (WM_USER+42)

#define PRO_INIT        (WM_USER+50)
#define PRO_SETPOS      (WM_USER+51)

#define MN_DD_GAME      (WM_USER+100)
#define MN_DD_OPTIONS   (WM_USER+200)
#define MN_DD_DICT      (WM_USER+300)
#define MN_DD_HELP      (WM_USER+400)
#define MN_REWARDS      (WM_USER+500)

#define MN_SEL_0        0
#define MN_SEL_1        1
#define MN_SEL_2        2
#define MN_SEL_3        3
#define MN_SEL_4        4
#define MN_SEL_5        5
#define MN_SEL_6        6
#define MN_SEL_7        7
#define MN_SEL_8        8
#define MN_SEL_9        9

/* Game menu */
#define MN_GAM_PLAY     0
#define MN_GAM_END      1
#define MN_GAM_STATS    2
#define MN_GAM_CSTATS   3
#define MN_GAM_LOAD     4
#define MN_GAM_SAVE     5
#define MN_GAM_TOURN    6
#define MN_GAM_QUIT     7

/* Option menu */
#define MN_OPT_LEVEL    0
#define MN_OPT_SOUND    1
#define MN_OPT_GTIME    2
#define MN_OPT_TIMER    3
#define MN_OPT_LEARN    4
#define MN_OPT_CPLAY    5
#define MN_OPT_ROTATE   6
#define MN_OPT_REWARDS  7

/* Dictionary menu */
#define MN_DIC_LOAD     0
#define MN_DIC_SAVE     1
#define MN_DIC_SHOW     2
#define MN_DIC_EDIT     3
#define MN_DIC_OPT      4
#define MN_DIC_CULL     5
#define MN_DIC_RFREQ    6

/* Help menu */
#define MN_HLP_REFCARD  0
#define MN_HLP_INDEX    1
#define MN_HLP_ABOUT    2

/* Resource numbers */
#define STARBMP 100
#define A0BMP   101
#define B0BMP   102
#define C0BMP   103
#define D0BMP   104
#define E0BMP   105
#define F0BMP   106
#define G0BMP   107
#define H0BMP   108
#define I0BMP   109
#define J0BMP   110
#define K0BMP   111
#define L0BMP   112
#define M0BMP   113
#define N0BMP   114
#define O0BMP   115
#define P0BMP   116
#define Q0BMP   117
#define R0BMP   118
#define S0BMP   119
#define T0BMP   120
#define U0BMP   121
#define V0BMP   122
#define W0BMP   123
#define X0BMP   124
#define Y0BMP   125
#define Z0BMP   126
#define A1BMP   127
#define B1BMP   128
#define C1BMP   129
#define D1BMP   130
#define E1BMP   131
#define F1BMP   132
#define G1BMP   133
#define H1BMP   134
#define I1BMP   135
#define J1BMP   136
#define K1BMP   137
#define L1BMP   138
#define M1BMP   139
#define N1BMP   140
#define O1BMP   141
#define P1BMP   142
#define Q1BMP   143
#define R1BMP   144
#define S1BMP   145
#define T1BMP   146
#define U1BMP   147
#define V1BMP   148
#define W1BMP   149
#define X1BMP   150
#define Y1BMP   151
#define Z1BMP   152
#define A2BMP   153
#define B2BMP   154
#define C2BMP   155
#define D2BMP   156
#define E2BMP   157
#define F2BMP   158
#define G2BMP   159
#define H2BMP   160
#define I2BMP   161
#define J2BMP   162
#define K2BMP   163
#define L2BMP   164
#define M2BMP   165
#define N2BMP   166
#define O2BMP   167
#define P2BMP   168
#define Q2BMP   169
#define R2BMP   170
#define S2BMP   171
#define T2BMP   172
#define U2BMP   173
#define V2BMP   174
#define W2BMP   175
#define X2BMP   176
#define Y2BMP   177
#define Z2BMP   178
#define A3BMP   179
#define B3BMP   180
#define C3BMP   181
#define D3BMP   182
#define E3BMP   183
#define F3BMP   184
#define G3BMP   185
#define H3BMP   186
#define I3BMP   187
#define J3BMP   188
#define K3BMP   189
#define L3BMP   190
#define M3BMP   191
#define N3BMP   192
#define O3BMP   193
#define P3BMP   194
#define Q3BMP   195
#define R3BMP   196
#define S3BMP   197
#define T3BMP   198
#define U3BMP   199
#define V3BMP   200
#define W3BMP   201
#define X3BMP   202
#define Y3BMP   203
#define Z3BMP   204

#define UPBMP   300
#define DOWNBMP 301
#define EYESBMP 302
#define ENTERUPBMP      303
#define ENTERDNBMP      304
#define STOPUPBMP       305
#define STOPDNBMP       306
#define SHADEBMP        307
#define REWARD1BMP      309
#define REWARD2BMP      310
#define REWARD3BMP      311
#define REWARD4BMP      312

#define BAGOCUR 400

#define BAGOICON        500
#define BIKINIICON      501

#define BAGOMENU        600
#define BAGOACCEL       601

#define ABOUTBOX        700
#define INPUTDIALOG     701
#define EDITWORDBOX     702

/* RGB values */
#define  BLACK                (LONG)0x00000000
#define  RED                  (LONG)0x000000FF
#define  GREEN                (LONG)0x0000FF00
#define  BLUE                 (LONG)0x00FF0000
#define  YELLOW               (LONG)0x0000FFFF
#define  MAGENTA              (LONG)0x00FF00FF
#define  CYAN                 (LONG)0x00FFFF00
#define  WHITE                (LONG)0x00FFFFFF
#define  GRAY0                (LONG)0x00C0C0C0
#define  GRAY1                (LONG)0x00808080
#define  GRAY2                (LONG)0x00404040

#define  CR     0x0D
#define  LF     0x0A

/* game related items */
/* dimensions of board */
#define NROWS   5
#define NCOLS   5
/* number of dice equals NROWS*NCOLS */
#define NDICE  25
#define NFACES  6     /* faces on a die */
#define NORIENT 4     /* number of orientations of die face: upside-down, etc */

#define USERWORDLEN     1000    /* initial size of buffer for user words */

#define LINELEN         30      /* maximum string size */

#define BAGODIC     "BAGO.DIC"          /* the dictionary file */
#define BAGOINI     "BAGO.INI"          /* init file */
#define BAGONEW     "BAGO.NEW"          /* cull output file */
#define BAGOSAVE    "BAGOSAVE.TXT"      /* default save file */
#define BAGOHLP     "BAGO.HLP"          /* win format help file */

/* the playing board is an array of these records */
typedef struct tagBOARD {
    char val;  /* the character on top face of die */
    char orient;  /* its orientation (0, 90, 180, 270 degree rotation) */
    BOOL Cused;    /* true if die was used in trying to make a word */
                  /* used only by computer in trying to find words */
    BOOL Uused;   /* true if player used letter by pushing button in */
    HWND hWindow;    /* handle of control corresponding to this die */
    char r, c;          /* row and column of this die */
    struct tagBOARD *link[8];  /* links to neighboring dice, some may be NULL */
   } BOARD;

/* This record type defines a word in the program's dictionary.  It is one
 * leaf of the dictionary tree.  Note that the links to other leaves are
 * Windows memory handles, NOT pointers.
 */
typedef struct tagDW {
    char w[10];         /* the word itself */
    /* bits in the following are equal to 1 if the program knows how to apply */
    /* a particular suffix to this word */
    unsigned Suffix1;
    HANDLE gt;          /* link to word after this in collating order */
    HANDLE lt;          /* link to word before this one */
    HANDLE up;          /* up link to superior leaf in tree */
    int Freq;           /* incremented on each usage */
   } DW;

/* This is sent to the InputBox upon initialization */
typedef struct tagInputStruct {
    LPSTR Prompt;
    LPSTR OutString;
    LPINT OutI;
    BOOL IntMode;
   } INPUTSTRUCT;

/* Sent to the Pic display window upon initialization */
typedef struct tagPicStruct {
    LPSTR PicMsg;
    int PicNumber;      /* resource number of bitmap for display */
   } PICSTRUCT;

typedef DW *PDW;        /* pointer to dictionary word structure */
typedef DW FAR *LPDW;
typedef INPUTSTRUCT FAR *LPINPUTSTRUCT;
typedef PICSTRUCT FAR *LPPICSTRUCT;

/* This is used to pass a cube's coordinates in a single word */
typedef struct tagCUBELOC {
    char row;
    char col;
   } CUBELOC;

int PASCAL WinMain(HANDLE, HANDLE, LPSTR, int);
BOOL BagoInit(HANDLE);
int FAR PASCAL EnumFunc(LPLOGFONT, LPTEXTMETRIC, short, LPSTR);
long FAR PASCAL BagoWndProc(HWND, unsigned, WORD, LONG);
BOOL FAR PASCAL About(HWND, unsigned, WORD, LONG);
BOOL FAR PASCAL EditWord(HWND, unsigned, WORD, LONG);
long FAR PASCAL EggWndProc(HWND, unsigned, WORD, LONG);
long FAR PASCAL ProWndProc(HWND, unsigned, WORD, LONG);
long FAR PASCAL CubeWndProc(HWND, unsigned, WORD, LONG);
long FAR PASCAL PicWndProc(HWND, unsigned, WORD, LONG);
WORD InputBox(HWND, LPSTR, LPSTR, LPINT, BOOL);
BOOL FAR PASCAL InputDiag(HWND, unsigned, WORD, LONG);
unsigned GetButtons(HWND);
int isword(char *);
HWND CreateProBox(HWND);
CreatePicBox(HWND, int, LPSTR);
CUBELOC PopCube();
