program ChildCtl;
{
  Quick and dirty example of 
  placing controls in a child window 
  that's part of an MDI APP. Two 
  different types of windows are
  shown automatically, on startup.
}
uses
  oStdDlgs,
  OStdWnds,
  Strings,
  WinTypes,
  WinProcs,
  Odialogs,
  OWindows;

{$R MidComm}
const
  cmOpen = 101;
  cmExit   = 104;
  cmArrange = 105;
  cmTile = 106;
  cmNew = 107;
  cmModelessDialog = 108;
  cmGetActive = 109;

type
  PShowWindow = ^TShowWindow;
  TShowWindow = Object(TWindow)
      AButton: PButton;
    constructor Init(AParent: PWindowsObject; AName: PChar);
    procedure ShowChar(i: LongInt);
  end;

  {POwnerDrawButton = ^TOwnerDrawButton;
  TOwnerDrawButton = object(TButton)
    constructor Init(AParent: PWindowsObject; AnId: Integer; AText: PChar;
      X, Y, W, H: Integer; IsDefault: Boolean);
    procedure DrawButton(DC: HDC; R: TRect); virtual;
    procedure DrawFocused(DC: HDC; R: TRect); virtual;
    procedure DrawPushed(DC: HDC; R: TRect); virtual;
    procedure DrawSelf(DrawItemStruct: PDrawItemStruct);
  end; }


  TApp = object(TApplication)
    procedure InitMainWindow; virtual;
  end;

  PNoWindow = ^TNoWindow;
  TNoWIndow = Object(TWIndow)
    AButton: PButton;
    constructor Init(AParent: PWindowsObject; AName: PChar);
  end;


  PMyWindow = ^TMyWindow;
  TMyWindow = object(TMdiWindow)
      AShowWindow: PShowWindow;
    constructor Init(AName: PChar; AMenu: HMenu);
    procedure NewWindow(Name: PChar);
    procedure NewSpecialWindow(Name: PChar);
    procedure SetUpWindow; virtual;
    procedure MDIGetActive(var Msg: TMessage);
      virtual cm_First + cmGetActive;
    procedure Exit(var Msg: TMessage);
      virtual cm_First + cmExit;
    procedure Arrange(var Msg: TMessage);
      virtual cm_First + cmArrange;
    procedure Tile(var Msg: TMessage);
      virtual cm_First + cmTile;
  end;

{--------------------------------------------------}
{ TMyWindow's method implementations:              }
{--------------------------------------------------}
constructor TShowWindow.Init(AParent: PWindowsObject; AName: PChar);
begin
  TWindow.Init(AParent, AName);
  AButton := New(PButton, Init(@Self, 101, 'Sam', 10, 10, 200, 200, False));
end;

constructor TNoWindow.Init;
begin
  TWindow.Init(AParent, AName);
  AButton := New(PButton, Init(@Self, 101, 'Sam', 10, 10, 100, 100, False));
end;

procedure TShowWindow.ShowChar(i: LongInt);
var
  S: array[0..100] of Char;
  ADC: HDC;
begin
  ADC := GetDC(HWindow);
  wvsPrintf(S, '%ld', i);
  TextOut(ADC, 10, 10, S, StrLen(S));
  ReleaseDC(HWindow, ADC);
end;

constructor TMyWindow.Init(AName: PChar; AMenu: HMenu);
begin
  TMdiWindow.Init(AName, AMenu);
end;

procedure TMyWindow.SetUpWindow;
var
  Msg: TMessage;
begin
  TMdiWindow.SetUpWindow;
  NewWindow('Window 1');
  NewSpecialWindow('Window 2');
end;

procedure TMyWindow.NewWindow(Name: PChar);
var
  FileWindow: PWindow;
begin
  FileWindow := New(PNoWindow, Init(@Self, Name));
  Application^.MakeWindow(FileWindow);
  ShowWindow(FileWindow^.HWindow, sw_Normal);
end;

procedure TMyWindow.NewSpecialWindow(Name: PChar);
begin
  AShowWindow := New(PShowWindow, Init(@Self, Name));
  Application^.MakeWindow(AShowWindow);
end;

procedure TMyWindow.MDIGetActive(var Msg: TMessage);
var
  Return: LongInt;
  AHWindow,
  BHWindow: HWnd;
  function IsActive(AChild: PWindowsObject): Boolean; far;
  begin
    IsActive := AChild^.HWindow = BHWindow;
  end;
begin
  AHWindow := ClientWnd^.FocusChildHandle;
  Return := SendMessage(ClientWnd^.HWindow, wm_MDIGetActive, 0, 0);
  BHWindow := LoWord(Return);
  AShowWindow := PShowWindow(FirstThat(@IsActive));
end;

procedure TMyWindow.Exit(var Msg: TMessage);
begin
  CloseWindow;
end;


procedure TMyWindow.Arrange(var Msg: TMessage);
begin
  ArrangeIcons;
  CasCadeChildren;
end;

procedure TMyWindow.Tile(var Msg: TMessage);
begin
  TileChildren;
end;

{--------------------------------------------------}
{ TMyApplication's method implementations:         }
{--------------------------------------------------}


procedure TApp.InitMainWindow;
begin
  MainWindow := New(PMyWindow, Init(Nil, LoadMenu(HInstance, 'Menu_1')));
end;


var
  App: TApp;

{--------------------------------------------------}
{ Main program:                                    }
{--------------------------------------------------}

begin
  App.Init('MyProgram');
  App.Run;
  App.Done;
end.
