program MdiComm;
uses
  OStdDlgs,
  OStdWnds,
  Strings,
  WinTypes,
  WinProcs,
  OWindows;

{$R MdiView}
const
  cmFileOpen = 101;
  cm_GetActive = 203;

type
  TApp = object(TApplication)
    procedure InitMainWindow; virtual;
  end;

  PNoWindow = ^TNoWindow;
  TNoWIndow = Object(TWIndow)
      WindowIsIcon : Boolean;
    constructor Init(AParent: PWindowsObject; AName: PChar);
    function GetClassName: PChar; virtual;
    procedure GetWindowClass(var AWndClass: TWndClass); virtual;
    procedure WmSize(var Msg: TMessage);
      virtual wm_First + wm_Size;
    procedure Paint(PaintDC: HDC; var PaintInfo: TPaintStruct); virtual;
  end;


  PMyWindow = ^TMyWindow;
  TMyWindow = object(TMdiWindow)
      Window: PWindow;
    constructor Init(AName: PChar; AMenu: HMenu);
    function GetClassName: PChar; virtual;
    procedure GetActive(var Msg: TMessage);
      virtual cm_First + cm_GetActive;
    procedure GetWindowClass(var AWndClass: TWndClass);
      virtual;
    procedure FileOpen(var Msg: TMessage);
      virtual cm_First + cmFileOpen;
  end;

{--------------------------------------------------}
{ TMyWindow's method implementations:              }
{--------------------------------------------------}

constructor TNoWindow.Init;
begin
  TWindow.Init(AParent, AName);
  Attr.Menu := LoadMenu(HInstance, 'Menu_1');
  SetWindowText(HWindow,'Sambo');
end;

function TNoWindow.GetClassName: PChar;
begin
  GetClassName := 'TNoWindow'
end;

procedure TNoWindow.GetWindowClass(var AWndClass: TWndClass);
begin
  TWindow.GetWindowClass(AWndClass);
  AWndClass.Style := AWndClass.Style or cs_DblClks;
end;

procedure TNoWindow.WmSize(var Msg: TMessage);
begin
  TWindow.WmSize(Msg);
  if Msg.WParam = SizeIconic then begin
    WindowIsIcon := True;
  end;
  if Msg.WParam = SizeNormal then
    if WindowIsIcon then begin
      WindowIsIcon := False;
    end;
end;

procedure TNoWindow.Paint(PaintDC: HDC; var PaintInfo: TPaintStruct);
var
  ClientArea: TRect;
  OldMapMode: Integer;
begin
  GetClientRect(HWindow, ClientArea);
  OldMapMode := SetMapMode(PaintDC, mm_Anisotropic);
  with ClientArea do begin
    SetViewPortExt(PaintDC, RIght-Left, Bottom - Top);
  end;
  SetMapMode(PaintDC, OldMapMode);
end;

{=========================================}
{=========================================}
{=========================================}
constructor TMyWindow.Init(AName: PChar; AMenu: HMenu);
begin
  TMdiWindow.Init(AName, AMenu);
end;

function TMyWindow.GetClassName;
begin
  GetClassName := 'TMyWindow';
end;

procedure TMyWindow.GetWindowClass(var AWndClass: TWndClass);
begin
  TMdiWindow.GetWindowClass(AWndClass);
end;



procedure TMyWindow.GetActive(var MSg: TMessage);
begin
  SetWindowText(Window^.HWindow, 'Foo');
end;

procedure TMyWindow.FileOpen;
begin
  Window := New(PNoWindow, Init(@Self, 'Sam'));
  Application^.MakeWindow(Window);
end;

{--------------------------------------------------}
{ TMyApplication's method implementations:         }
{--------------------------------------------------}


procedure TApp.InitMainWindow;
begin
  MainWindow := New(PMyWindow, Init(Nil, LoadMenu(HInstance, 'Menu_1')));
end;

{ Add Idle loop to main message loop.       }

var
  App: TApp;

{--------------------------------------------------}
{ Main program:                                    }
{--------------------------------------------------}

begin
  App.Init('MyProgram');
  App.Run;
  App.Done;
end.
