/****************************************************************************

    PROGRAM: Demo.c

****************************************************************************/

#include "windows.h"
#include "clrbuttn.h"
#include "demo.h"

HBRUSH hFaceBrush, hShadowBrush;
LOGBRUSH bsBr;
HFONT hFixFont;

WORD hDlgItem;
int iButtonClr;
int iLabelClr;
int iLabelTxt;
int iLabelFnt;
int iLabelSty;
int iButtonSiz;
int iOn;

char szLabel1[] = "Color Button Text";
char szLabel2[] = "Button Label";

long lBaseUnits;
WORD wBUHi;
WORD wBUWi;

BOOL FAR PASCAL TestProc(HWND, unsigned, WORD, LONG);

int PASCAL WinMain(hInstance, hPrevInstance, lpCmdLine, nCmdShow)
HANDLE hInstance;
HANDLE hPrevInstance;
LPSTR lpCmdLine;
int nCmdShow;
{

   HWND hWnd;
   FARPROC lpTestProc;
   BOOL bRtn;

   lpTestProc = MakeProcInstance(TestProc, hInstance);
   lBaseUnits = GetDialogBaseUnits();
   wBUHi = HIWORD(lBaseUnits) / 8;
   wBUWi = LOWORD(lBaseUnits) / 4;
   DialogBox(hInstance, "TESTBOX", NULL, lpTestProc);
   FreeProcInstance(lpTestProc);

   return (TRUE);
}

/****************************************************************************/

BOOL FAR PASCAL TestProc(hDlg, message, wParam, lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{
    switch (message) {
   case WM_INITDIALOG:

      // Create Face Brush
         bsBr.lbStyle = BS_SOLID;
         bsBr.lbColor = RGB(255,130,120);
         hFaceBrush = CreateBrushIndirect(&bsBr);
      // Create Shadow Brush
         bsBr.lbColor = RGB(255,0,0);
         hShadowBrush = CreateBrushIndirect(&bsBr);
         iOn = iButtonClr = iLabelClr = iLabelSty = iLabelTxt = iLabelFnt = iButtonSiz = 0;
         hDlgItem = GetDlgItem(hDlg, TEST);
         hFixFont = GetStockObject(SYSTEM_FIXED_FONT);
      
      return (TRUE);

   case WM_COMMAND:
       if (wParam == IDOK) {
          EndDialog(hDlg, TRUE);
          return (TRUE);
       }

       if (wParam == BUTTON_COLOR) {
          iButtonClr++;
          if (iButtonClr > 1)
            iButtonClr = 0;
          if (iButtonClr) {
             SendMessage(hDlgItem, CRBM_SETFACEBRUSH, hFaceBrush, 0L);
             SendMessage(hDlgItem, CRBM_SETSHADOWBRUSH, hShadowBrush, 0L);
          }
          else {
             SendMessage(hDlgItem, CRBM_SETFACEBRUSH, 0, 0L);
             SendMessage(hDlgItem, CRBM_SETSHADOWBRUSH, 0, 0L);
          }
         InvalidateRect(hDlgItem, NULL, FALSE);
       }

       if (wParam == LABEL_COLOR) {
          iLabelClr++;
          if (iLabelClr > 1)
            iLabelClr = 0;
          if (iLabelClr)
             SendMessage(hDlgItem, CRBM_SETTEXTCOLOR, TRUE, RGB(255, 0, 0));
          else
             SendMessage(hDlgItem, CRBM_SETTEXTCOLOR, FALSE, 0L);
         InvalidateRect(hDlgItem, NULL, FALSE);
       }

       if (wParam == LABEL_TEXT) {
          iLabelTxt++;
          if (iLabelTxt > 1)
            iLabelTxt = 0;
          if (iLabelTxt)
            SetDlgItemText(hDlg, TEST, (LPSTR) szLabel2);
          else
            SetDlgItemText(hDlg, TEST, (LPSTR) szLabel1);
         InvalidateRect(hDlgItem, NULL, FALSE);
       }

       if (wParam == LABEL_STYLE) {
          iLabelSty++;
          if (iLabelSty > 1)
            iLabelSty = 0;
          if (iLabelSty)
             SendMessage(hDlgItem, CRBM_SETDRAWTEXTSTYLE, (DT_LEFT   | DT_WORDBREAK), 0L);
          else
             SendMessage(hDlgItem, CRBM_SETDRAWTEXTSTYLE, (DT_CENTER | DT_WORDBREAK), 0L);
         InvalidateRect(hDlgItem, NULL, FALSE);
       }

       if (wParam == BUTTON_SIZE) {
          iButtonSiz++;
          if (iButtonSiz > 1)
            iButtonSiz = 0;
            if (iButtonSiz)
             // increase width, decrease height
                MoveWindow(hDlgItem, 
                           (16 * wBUWi), 
                           (30 * wBUHi),
                           (90 * wBUWi),
                           (15 * wBUHi), TRUE);
            else
             // increase height, decrease width
                MoveWindow(hDlgItem,
                           (16 * wBUWi), 
                           (30 * wBUHi),
                           (40 * wBUWi),
                           (35 * wBUHi), TRUE);
       }

       if (wParam == LABEL_FONT) {
          iLabelFnt++;
          if (iLabelFnt > 1)
            iLabelFnt = 0;
          if (iLabelFnt)
            SendMessage(hDlgItem, CRBM_SETLABELFONT, hFixFont, 0L);
          else
            SendMessage(hDlgItem, CRBM_SETLABELFONT, 0, 0L);
          InvalidateRect(hDlgItem, NULL, FALSE);
       }

       if (wParam == ON_OFF) {
          iOn++;
          if (iOn > 1)
            iOn = 0;
          if (iOn) 
             EnableWindow(hDlgItem, FALSE);
          else
             EnableWindow(hDlgItem, TRUE);
       }

       return (TRUE);

   case WM_DESTROY:
         DeleteObject(hFaceBrush);
         DeleteObject(hShadowBrush);
         return (TRUE);
    }
    return (FALSE);

}



