/*

WINSTD.H
 
standard definitions for Windows source files

created:	STG		6/1/91
modified:

*/

/* standard dialog grouping options */

#define TABGRP	(WS_TABSTOP | WS_GROUP)

/* definition of macro to get the offset of a field in a structure */
/* standardly defined in stddef.h, included here in case stddef.h not inc'd */

#ifndef offsetof
#define offsetof(Struct, Member) \
	(unsigned int) &(((Struct NEAR *)0)->Member)
#endif

/*
the following macros allow easy access to window and class extra bytes,
based on offsets into defined a structure that "maps" onto the appropriate
array of extra bytes

Modified from:
	"Windows 3.0: A Developer's Guide", Jeffrey M. Richter, M&T Books, 1991.
*/

/* store a value in the window extra bytes of a window */

#define SET_WND_EXTRABYTES(hWnd, Struct, Member, Value) \
	((sizeof (((Struct FAR *)0)->Member) == sizeof (DWORD)) ? \
	SetWindowLong (hWnd, offsetof (Struct, Member), Value) : \
	SetWindowWord (hWnd, offsetof (Struct, Member), (WORD) Value))

/* store a value in the class extra bytes of a class */
		
#define SET_CLS_EXTRABYTES(hWnd, Struct, Member, Value) \
	((sizeof (((Struct FAR *)0)->Member) == sizeof (DWORD)) ? \
	SetClassLong (hWnd, offsetof (Struct, Member), Value) : \
	SetClassWord (hWnd, offsetof (Struct, Member), (WORD) Value))

/* retrieve a value from a window's extra bytes */
		
#define GET_WND_EXTRABYTES(hWnd, Struct, Member) \
	((sizeof (((Struct FAR *)0)->Member) == sizeof (DWORD)) ? \
	GetWindowLong (hWnd, offsetof (Struct, Member)) : \
	GetWindowWord (hWnd, offsetof (Struct, Member)))

/* retrieve a value from a class' extra bytes */
		
#define GET_CLS_EXTRABYTES(hWnd, Struct, Member) \
	((sizeof (((Struct FAR *)0)->Member) == sizeof (DWORD)) ? \
	GetClassLong (hWnd, offsetof (Struct, Member)) : \
	GetClassWord (hWnd, offsetof (Struct, Member)))
