// ObjectWindows - (C) Copyright 1992 by Borland International
// File: COPYLZ.CPP
/*  This sample uses the Windows API functions to copy a
    file from one directory to another. Explicit path is used to prevent
    finding another file of same name.
*/
#include <owl.h>
#include <dialog.h>
#include <static.h>
#include <stdlib.h>
#include <string.h>
#include <lzexpand.h>
#include "copylz.h"

char szSrc[] = "c:\\mydir\\test.exe";
char szDst[] = "d:\\test.exe";
OFSTRUCT ofStrSrc;
OFSTRUCT ofStrDest;
HFILE hfSrcFile, hfDstFile;

class TTestDialog : public TDialog
{
 PTStatic Sptr1;
 PTStatic Sptr2;
public:
  TTestDialog(PTWindowsObject AParent, LPSTR AName)
    : TDialog(AParent, AName)
    {
     Sptr1 = new TStatic( this, ID_STATIC1, 128 );
     Sptr2 = new TStatic( this, ID_STATIC2, 128 );
    };
  virtual void HandleButtonMsg(RTMessage Msg)
    = [ID_FIRST + ID_BUTTON];
  virtual void SetupWindow();
};
void TTestDialog::SetupWindow()
{
 TDialog::SetupWindow();
 Sptr1->SetText( szSrc );
}
class TTestWindow : public TWindow
{
public:
  TTestWindow(PTWindowsObject AParent, LPSTR ATitle);
  virtual void CMTest(RTMessage Msg)
    = [CM_FIRST + CM_TEST];
};

class TTestApp : public TApplication
{
public:
  TTestApp(LPSTR AName, HINSTANCE hInstance, HINSTANCE hPrevInstance,
    LPSTR lpCmdLine, int nCmdShow) :
    TApplication(AName, hInstance, hPrevInstance, lpCmdLine, nCmdShow) {};
  virtual void InitMainWindow();
};

void TTestDialog::HandleButtonMsg(RTMessage)
{
 char message[128];
 LONG retval;

  // open the source file
 hfSrcFile = LZOpenFile( szSrc, &ofStrSrc, OF_READ);
  // create the destination file
 hfDstFile = LZOpenFile( szDst, &ofStrDest, OF_CREATE);
 // copy the source file to the destination file
 retval = LZCopy( hfSrcFile, hfDstFile );
 if( retval >0  )
 {
  ltoa( retval, message, 10 );
  strcat( message, " bytes" );
  MessageBox( NULL, message, "successfully copied", MB_ICONINFORMATION ); 
 // close the files
 LZClose( hfSrcFile );
 LZClose( hfDstFile );
 Sptr2->SetText( ofStrDest.szPathName );
 }
}


TTestWindow::TTestWindow(PTWindowsObject AParent, LPSTR ATitle)
  : TWindow(AParent, ATitle)
{
  AssignMenu("COMMANDS");
}

void TTestWindow::CMTest(RTMessage)
{
  GetApplication()->ExecDialog(new TTestDialog(this, "TESTDIALOG"));
}

void TTestApp::InitMainWindow()
{
  MainWindow = new TTestWindow(NULL, Name);
}

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
  LPSTR lpCmdLine, int nCmdShow)
{
  TTestApp TestApp("Copy File", hInstance, hPrevInstance,
    lpCmdLine, nCmdShow);
  TestApp.Run();
  return (TestApp.Status);
}
