/***
	CAppl class header file.
	The is the application class. Only one of these is included
	for each application.
Revisions:
10/22/90 KM Initial coding.
***/

#include "cwind.hpp"
#include "cbuffer.hpp"

#ifndef CAppl_INC
#define CAppl_INC

class CAppl {
	public: 
			// void constructor
		CAppl(HANDLE hI, HANDLE hP, HWND hWnd);
			// Run the program.
		WORD Run();
			// Return the current instance
		HANDLE	GetInst(void) { return hInst; };
			// Return the previous instance
		HANDLE	GetPrevInst(void) { return hPrev; };
			// Set the application icon
		BOOL SetAppIcon(LPSTR pIconName);
			// Set the application Menu
		BOOL SetAppMenu(LPSTR pMenuName);
			// Set the application accelerator table
		BOOL SetAccelerator(LPSTR pAccelName);

			// Menu operations
		void EnableMenu(WORD wItem)
			{ EnableMenuItem(ApplMenu, wItem, MF_ENABLED); }
		void DisableMenu(WORD wItem)
			{ EnableMenuItem(ApplMenu, wItem, MF_DISABLED); }
		void GrayMenu(WORD wItem)
			{ EnableMenuItem(ApplMenu, wItem, MF_GRAYED); }
		void CheckMenu(WORD wItem)
			{ CheckMenuItem(ApplMenu, wItem, MF_CHECKED); }
		void UnCheckMenu(WORD wItem)
			{ CheckMenuItem(ApplMenu, wItem, MF_UNCHECKED); }
		void InsertMenuItem(WORD wPos, WORD wFlags, WORD wItem, LPSTR pText)
			{ InsertMenu(ApplMenu, wPos, wFlags, wItem, pText); }
		void AppendMenuItem(WORD wFlags, WORD wItem, LPSTR pText)
			{ AppendMenu(ApplMenu, wFlags, wItem, pText); }
        void DeleteMenuItem(WORD wPos, WORD wFlags)
			{ DeleteMenu(ApplMenu, wPos, wFlags); }

			// Handle to the top most window.
		HWND hTopWin;

			// True if Msg was a dlg msg
		static BOOL bDlgMsg;

			// Handle to menu for application
		HMENU ApplMenu;

	private :
		HANDLE	hInst;				// Handle to instance
		HANDLE	hPrev;				// Handle to prev instance
		HANDLE	hAccTable;			// Accelerator table handle

	protected :
		~CAppl();
		CBuffer *pcDlgList; 		// List of modeless dialogs active.
			// Check if message belongs to a modeless dialog.
		BOOL ChkForDlgMsg(MSG *pMsg);
};
#endif
