/***
	CWind class header file.
	Modifed WBase class from Zortech WBase class.
Revisions:
10/21/90 KM Initial coding changes from original WBase class.
***/

#ifndef CWind_INC
#define CWind_INC

typedef	LONG (FAR PASCAL *LFPTR)(HWND,unsigned,WORD,LONG);

class	CWind	{
	public: 
			// Create the Applications topmost window.
		CWind(HANDLE,HANDLE);

			// Create a child window.
		CWind(CWind *pParent, LPSTR lpClass, LPSTR lpCaption, DWORD dwStyle,
			int x, int y, int width, int height, int Id);

            // Get the window handle for the CWind class
		HANDLE GetHWnd(void) { return WhWnd; }

			// Get a DC for the window.
		HDC GetWndDC(void) { return GetDC(WhWnd); }

			// Release DC for the window.
		void ReleaseWndDC(HDC hDC) { ReleaseDC(WhWnd, hDC); }

			// Get windows client rectangle
		void GetWndClientRect(LPRECT lpRect)
			{ GetClientRect(WhWnd, lpRect); }

			// Get windows rectangle
		void GetWndRect(LPRECT lpRect)
			{ GetWindowRect(WhWnd, lpRect); }

            // Set the window's title
		void SetWndText(LPSTR lpTitle) { SetWindowText(WhWnd, lpTitle); }

			// Friend function to handle windows messages. This
			// function is defined in the .DEF file as exported
		friend	LONG FAR PASCAL Default(HWND,
						unsigned,
						WORD,
						LONG);

            // Virtual message handler for the Window.
		virtual LONG FAR PASCAL Go( HWND,
						unsigned,
						WORD,
						LONG);

            // Show the window
		void Show(void)
			{ ShowWindow(WhWnd, TRUE); }

            // Hide the window
		void Hide(void)
			{ ShowWindow(WhWnd, FALSE); }

			// Move the window
		void Move(int x, int y, int width, int height, BOOL bRepaint)
			{ MoveWindow(WhWnd, x, y, width, height, bRepaint); }

			// Center the window
		void Center(void);

			// Update all menus. Called before Windows drops menu selected
		virtual void UpdateMenus(void) { }

			// Setup the DC.
		virtual void SetupDC(HDC hDC) { }

		virtual LONG DoDefault(unsigned Message, WORD wParam, LONG lParam)
				{ return CallWindowProc(DefaultHandler, WhWnd, Message, wParam, lParam); }

		virtual LONG DoCommand(WORD wMenuId, LONG lParam)
				{  return DoDefault(WM_COMMAND, wMenuId, lParam);  }

		virtual LONG DoCreate(LPCREATESTRUCT lpCreate)
				{  return DoDefault(WM_CREATE, 0, 0l);	}

        virtual LONG DoDestroy(void)
				{ PostQuitMessage(0); return 0l; }

        virtual LONG DoKillFocus(HWND hNewWnd)
				{ return DoDefault(WM_KILLFOCUS, (WORD)hNewWnd, 0l); }

        virtual LONG DoPaint(void)
				{ return DoDefault(WM_PAINT, 0, 0l); }

        virtual LONG DoSetFocus(HWND hOldWnd)
				{ return DoDefault(WM_SETFOCUS, (WORD)hOldWnd, 0l); }

        virtual LONG DoSize(WORD wCmd, LPPOINT lpPoint)
				{ return DoDefault(WM_SIZE, wCmd, MAKELONG(lpPoint->x, lpPoint->y)); }

		virtual LONG DoSysCommand(WORD wCmd, LPPOINT lpPoint)
				{ return DoDefault(WM_SYSCOMMAND, wCmd, MAKELONG(lpPoint->x, lpPoint->y)); }

		virtual LONG DoMouseDown(unsigned Message, WORD wParam, LPPOINT lpPoint)
				{ return DoDefault(Message, wParam, MAKELONG(lpPoint->x, lpPoint->y)); }

		virtual LONG DoMouseUp(unsigned Message, WORD wParam, LPPOINT lpPoint)
				{ return DoDefault(Message, wParam, MAKELONG(lpPoint->x, lpPoint->y)); }

		virtual LONG DoMouseMove(WORD wParam, LPPOINT lpPoint)
				{ return DoDefault(WM_MOUSEMOVE, wParam, MAKELONG(lpPoint->x, lpPoint->y)); }

	private :
			// can only be called once.
		BOOL	Register(HANDLE);

	protected : 		// for later inheritance
		static HANDLE	WhInstance; 	// shared by all instances
		static BOOL 	WhRegistered;	// registered ?
		static HANDLE	WhPrev; 		// previous instance

		static short	xScreenSize;	// in pixels
		static short	yScreenSize;	// as above

		HWND			WhWnd;		// handle to window
		PAINTSTRUCT 	ps; 		// these are required
		TEXTMETRIC		tm; 		// by most Windows
		HDC 			hDC;		// instances

		FARPROC 		DefaultHandler; // default callback
		FARPROC 		NewHandler; 	// user callback

		CWind			*pParent;		// Parent window class if this is 
										// child window.

			// Constructor for non-topmost window.
		CWind() {}

			// virtual destructor
		virtual ~CWind() {}

			// set a new callback
		void SetCallBack(LFPTR);
};
#endif
