/***
	Class Wind #1.
	Used to test the inheritance of the CWind class.
Revisions:
10/21/90 KM Initial coding.
***/

#include	<windows.h>
#include	<stdio.h>

#include "cdlg1.hpp"
#include "cdlgabt.hpp"
#include "copendlg.hpp"
#include "cselprn.hpp"
#include "menudef.h"

#define BUTTONID	1000		// ID of button on main window.
#define EDITID		1001		// ID of edit class on main window.

// $HPP:Start
/***
	Test window class.
***/

#ifndef CWind1_INC
#define CWind1_INC

#include "cwind.hpp"

class   CWind1 : public CWind   {
	public:
		CWind1(HANDLE ,HANDLE);
		LONG DoCommand(WORD wMenuId, LONG lParam);
		LONG DoSize(WORD wCmd, LPPOINT lpPoint);
        ~CWind1();

		CWind *pButton;
		CWind *pList;
		int Ctr;
};
#endif
// $HPP:End

/***
	Command functions.
***/        
LONG CWind1 :: DoCommand(WORD wMenuId, LONG lParam)
{
	CDlg1 *pDlgCl;
	CDlgAbout *pDlgAbout;
	COpenDlg *pOpenDlg;
	CSelPrnterDlg *pSelPrn;
	char szBuf[50];

	switch (wMenuId) {
	case IDM_TEST:
		pDlgCl = new CDlg1;
		pDlgCl->DoDialog(WhInstance, "TEST_DIALOG", WhWnd, 0l);
		delete pDlgCl;
		break;
    case IDM_ABOUT:
		pDlgAbout = new CDlgAbout;
		pDlgAbout->DoAboutBox(WhInstance, WhWnd);
		delete pDlgAbout;
		break;
    case IDM_EXIT:
		SendMessage(WhWnd, WM_DESTROY, 0, 0l);
		break;
	case IDM_OPEN:
		pOpenDlg = new COpenDlg((LPSTR)"*.cpp", TRUE);
		pOpenDlg->DoDialog(WhInstance, "OPEN_DLG", WhWnd, 0l);
		delete pOpenDlg;
		break;
	case IDM_PRNSETUP:
		pSelPrn = new CSelPrnterDlg;
		pSelPrn->DoDialog(WhInstance, "SELPRN_DLG", WhWnd, 0l);
		delete pSelPrn;
		break;
	case BUTTONID:
		sprintf(szBuf, "%d", ++Ctr);
		pButton->SetWndText(szBuf);
		break;
	default:
		return CWind :: DoCommand(wMenuId, lParam);
	}
	return 0l;
}

LONG CWind1 :: DoSize(WORD wCmd, LPPOINT lpPoint)
{
	pButton->Move(0, lpPoint->y - 30, lpPoint->x, 30, TRUE);
	pList->Move(0, 0, lpPoint->x, lpPoint->y - 30, TRUE);
	return DoDefault(WM_SIZE, wCmd, MAKELONG(lpPoint->x, lpPoint->y));
}

CWind1 :: CWind1(HANDLE hInstance, HANDLE hPrev)
: CWind(hInstance, hPrev)
{
	RECT r;
	int width, height;

	GetWndClientRect(&r);
	width = r.right - r.left;
	height = r.bottom - r.top;
	pButton = new CWind(this, (LPSTR)"Button", (LPSTR)"0",
			WS_CHILDWINDOW, 0, r.bottom - 10, width, 10, BUTTONID);
	pList = new CWind(this, (LPSTR)"Edit", (LPSTR)NULL,
			WS_CHILDWINDOW | WS_HSCROLL | WS_VSCROLL | ES_LEFT | 
			ES_MULTILINE | ES_AUTOHSCROLL | ES_AUTOVSCROLL,
			0, 0, width, height - 10, EDITID);
}

CWind1 :: ~CWind1()
{
	delete pButton;
	delete pList;
}

