/***
	HPP Extract utility.
	This program extracts the .HPP file out of a .CPP file and compares
	it with the .HPP file already on disk. If different, the new one
	will replace the old one.
***/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define FALSE	0
#define TRUE	-1

void CheckFile(FILE *pOFile, char *pName);
void ExHpp(char *pName);
int SearchLine(register char *pbuf, register char *psrch);

    /** Global variables */
int erctr;
char buf[512];

int main(int argc, char **argv)
{
	register int i;

	if (argc < 2) {
		fprintf(stderr, "usage: exhpp <filename> <filename>....\n");
		exit(1);
	}
	puts("EXHPP : HPP Extract utility version 1.00 (c) 1990 Comptech Software,Inc.");
	erctr = 0;
	for (i = 1; i < argc; i++)
		ExHpp(argv[i]);

	return erctr;
}

/***
	Extract the HPP section for the passed file name.
***/
void ExHpp(char *pName)
{
	FILE *pFile;
	FILE *pOFile;
	int state = 0;

	pFile = fopen(pName, "r");
	if (pFile == NULL) {
		erctr++;
		fprintf(stderr, "Can't open file \"%s\"\n", pName);
		return;
	}
	pOFile = fopen("HPPEX.$$$", "w");
	if (pOFile == NULL) {
		erctr++;
		fprintf(stderr, "Can't create temp file\n");
		return;
	}
	while (fgets(buf, sizeof(buf), pFile) != NULL) {
		if (state == 0) {
			if (SearchLine(buf, "$HPP:Start") == TRUE) {
				state = 1;
			}
			continue;
		}
		else if (state == 1) {
			if (SearchLine(buf, "$HPP:End") == TRUE) {
				state = 2;
				break;
			}
		}
		fputs(buf, pOFile);
	}
	fclose(pFile);
	if (state == 0) {
		fprintf(stderr, "No HPP section found in file \"%s\"\n", pName);
	}
	else if (state == 1) {
		fprintf(stderr, "No $HPP:End section found in file \"%s\"\n", pName);
	}
	else
		CheckFile(pOFile, pName);
}

/***
	Check the file
***/
void CheckFile(FILE *pOFile, char *pName)
{
	char buf2[512];
	char fname[66];
	char *ptr;
	FILE *pHFile;
	int flag = FALSE;

	fflush(pOFile); 		/* Flush file */
	fseek(pOFile, 0l, 0);	/* Seek to beginning of file */
	strcpy(fname, pName);
	ptr = strrchr(fname, '.');
	if (ptr)
		strcpy(ptr, ".HPP");
	else
		strcat(fname, ".HPP");
	pHFile = fopen(fname, "r");
	if (pHFile == NULL) {		/* .HPP file doesn't exist */
		fclose(pOFile);
		goto DoRename;
	}
	while (fgets(buf, sizeof(buf), pHFile) != NULL) {
		if (fgets(buf2, sizeof(buf2), pOFile) == NULL) {
			flag = TRUE;
			break;
		}
		if (strcmp(buf, buf2)) {
			flag = TRUE;
			break;
		}
	}
	fclose(pOFile);
	fclose(pHFile);
	if (flag == TRUE) { 		/* Files are different */
		unlink(fname);			/* Kill old HPP file */
DoRename:
		rename("HPPEX.$$$", fname); /* rename temp file to .HPP file name */
		return;
    }
	else
		unlink("HPPEX.$$$");    /* Kill the temp name */
}

/***
	Search for the psrch string in the pbuf buffer.
	return TRUE if found.
***/
int SearchLine(register char *pbuf, register char *psrch)
{
	int i = strlen(psrch);

	while (*pbuf) {
		if (strncmp(pbuf, psrch, i) == 0)
			return TRUE;
		else
			pbuf++;
	}
	return FALSE;
}

