#include <owl.h>         // CTLBAR Adds Bar chart Custom
#include <bwcc.h>        // Controls that interfaces with the
#include <custcntl.h>    // The Resource Workshop as well as
#include <control.h>     // function as stand alone controls.
#include <static.h>
#include <edit.h>
#include <bstatic.h>
#include <commdlg.h>
#include "ctlbar.h"

PTModule CtlBarModule;
BOOL fInWorkshop;
//==================================================================
_CLASSDEF(TColorDialog)               // Class to encapsulate
class TColorDialog : public TDialog   // the Windows 3.1
  {                                   // Color Common Dialog
  public:
    DWORD dwCustClrs[16];             // Array for custom colors
    TColorDialog(PTWindowsObject AParent, // Constructor
		 DWORD * dwNewColor, LPSTR lpName, PTModule AModule);
    virtual BOOL Create();            // Create for non-modal Creation
    virtual int Execute();            // Execute for modal Execution
    virtual void CloseWindow(int ARetValue){}; // trap destruction
  protected:
    CHOOSECOLOR ccdlg;                // Color Common Dialog Structure
    DWORD *dwColor;                   // Color Variable
  };
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
TColorDialog::TColorDialog(PTWindowsObject AParent, DWORD * dwNewColor,
				   LPSTR AName,PTModule AModule = NULL)
	     :TDialog(AParent,AName,AModule) // Constructor calls base
  {
  dwColor =  dwNewColor;        //equate color address to allow updating
  int Count;                    //initialize the 16 custom colors to
  for (Count = 0; Count <= 15; Count++) // Shades of blue
    dwCustClrs[Count] = RGB(Count*(255/15),Count*(255/15),255);
  ccdlg.lStructSize    = sizeof(CHOOSECOLOR);    // initialize ccdl struct
  ccdlg.hwndOwner      = GetFocus();             // parent has the focus
  ccdlg.hInstance      = NULL;                   // Not Used for default dlg
  ccdlg.rgbResult      =  *dwNewColor;           // Color in
  ccdlg.lpCustColors   = (LPDWORD)(dwCustClrs);  // array of blue colors
  ccdlg.Flags          = CC_FULLOPEN|CC_RGBINIT; // full dialog with color in
  ccdlg.lCustData      = 0L;                     // Use Default Data
  ccdlg.lpfnHook       = (FARPROC)NULL;          // No Message trapping
  ccdlg.lpTemplateName = (LPSTR)NULL;            // Use Default dialog
  };
BOOL TColorDialog::Create()                      // Called by MakeWindow
  {
  ccdlg.hwndOwner = NULL;                        // No parent for non-Model
  ChooseColor(&ccdlg);                           // ccdlg function call
  *dwColor = ccdlg.rgbResult;                    // Color out
  return 1;                                      // Success
  }
int TColorDialog::Execute()                      // Called by CreateDialog
  {
  ChooseColor(&ccdlg);                           // ccdlg function call
  *dwColor = ccdlg.rgbResult;                    // Color out
  return 1;                                      // Success
  }
//=====================================================================
//                   TBarChart Custom Control
char szClassName[]  = "BarChart";   // class for Bar Chart custom control
//=====================================================================
#pragma argsused  // TBarChart methods prototype in header file
TBarChart::TBarChart(PTWindowsObject AParent, int AnId,
		     int X, int Y, int W, int H,
		     LPSTR ATitle,
		     WORD  ATextLen,
		     PTModule AModule)
		    :TStatic (AParent, AnId, ATitle,X,Y,W,H,
			      ATextLen,AModule){};
//------------------------------------------------------------------------
TBarChart::TBarChart(PTWindowsObject AParent, int ResourceId,
		       PTModule AModule)
		      :TStatic(AParent, ResourceId, 1, AModule){};
//---------------------------------------------------------------------
// PARSE function used by SetupWindow to pull 4 text fields out of one
//       Title field delimited by the tilde character ~
int TBarChart::Parse(int StartChar)
  {
  int Count = 0;
  while ((szTitle[StartChar] != '~')&(szTitle[StartChar] != NULL))
    {
    szBuffer[Count] = szTitle[StartChar];
    StartChar++;
    Count++;
    };
  szBuffer[Count] = NULL;
  return StartChar;
  }
//---------------------------------------------------------------------
void TBarChart::SetupWindow()
  {
  int nCharCount = 0;
  TStatic::SetupWindow();               // call base class
  GetText(szTitle,254);                 // Get Title
  nCharCount   = Parse(nCharCount);     // Parse out title
  nCharCount   = Parse(nCharCount+1);   // Parse out Red Value
  int nRed     = atoi(szBuffer);
  nCharCount   = Parse(nCharCount+1);   // Parse out Green
  int nGreen   = atoi(szBuffer);
  nCharCount   = Parse(nCharCount+1);   // Parse out Blue
  int nBlue    = atoi(szBuffer);
  DisplayColor = RGB(nRed,nGreen,nBlue); // Combine into a Color
  nCharCount   = Parse(nCharCount+1);   // Parse out Minimum value
  lMin         = atol(szBuffer);
  nCharCount   = Parse(nCharCount+1);   // Parse out Maximum
  lMax         = atol(szBuffer);
  nCharCount   = Parse(nCharCount+1);   // Parse out Current Value
  lValue       = atol(szBuffer);
  if (fInWorkshop)                               // If in Workshop
     InvalidateRect(Parent->HWindow,NULL,FALSE); // Update Parent
  }
//------------------------------------------------------------------------
#pragma argsused                   // Public interface functions
void TBarChart::WMValue(RTMessage Msg)// for TBarChart Custom control
  {                                // for prototypes in header file.
  lValue = Msg.LParam;             // Note the use of function pairs
  InvalidateRect(HWindow,NULL,FALSE);
  return;                          // to send a message from a member
  }                                // function through windows to allow
void TBarChart::Value(long NewValue)// the dummy object to access data
  {                                // in the display object.
  SendMessage(HWindow,BC_VALUE,1,NewValue);
  }
#pragma argsused
void TBarChart::WMMin(RTMessage Msg)     // Reset minimum value
  {
  lMin = Msg.LParam;
  InvalidateRect(HWindow,NULL,FALSE);
  return;
  }
#pragma argsused
void TBarChart::WMMax(RTMessage Msg)     // Reset Maximum Value
  {
  lMax = Msg.LParam;
  InvalidateRect(HWindow,NULL,FALSE);
  return;
  }
void TBarChart::Range(long lNewMin, long lNewMax)  // Reset Range
  {
  SendMessage(HWindow,BC_MIN,1,lNewMin);
  SendMessage(HWindow,BC_MAX,1,lNewMax);
  }
#pragma argsused
void TBarChart::WMColor(RTMessage Msg)         // Change Color
  {
  DisplayColor = Msg.LParam;
  InvalidateRect(HWindow,NULL,FALSE);
  return;
  }
void TBarChart::Color(COLORREF NewColor)
  {
  SendMessage(HWindow,BC_COLOR,1,NewColor);
  }
//------------------------------------------------------------------------
void TBarChart::WMPaint(RTMessage Msg)
  {
  HPEN   hPen,   hOldPen;                       // Pen Variables
  HBRUSH hBrush, hOldBrush;                     // Brush Variables
  HDC hDC = GetDC(HWindow);                     // grab the Device Context
  hPen      = CreatePen(PS_SOLID,1,DisplayColor); // Colored pen
  hOldPen   = (HPEN)SelectObject(hDC,hPen);     // use  pen
  hBrush    = (HBRUSH)CreateSolidBrush(DisplayColor); // Colored brush
  hOldBrush = (HBRUSH)SelectObject(hDC,hBrush); // use brush

  long lAdjustValue;
  if (lMin < 0) lAdjustValue = lValue - lMin;   // adjust for negative
  else lAdjustValue = lValue;                   // min
  long lRange = lMax - lMin;                    // Figure Range
  lAdjustValue = (lAdjustValue*100)/lRange; // Change value to % of Range
  int nHeight = LOWORD((Attr.H*lAdjustValue)/100); // Adjust to Rectangle
  int nXPos = (Attr.H-nHeight);                 // Adjust to top of Rect
  Rectangle(hDC,0,nXPos,Attr.W,Attr.H);         // output Colored rectangle

  SelectObject(hDC,hOldBrush);                  // restore old brush
  DeleteObject(hBrush);                         // destroy new brush
  SelectObject(hDC,hOldPen);                    // restore pen
  DeleteObject(hPen);                           // destroy new pen
  ReleaseDC(HWindow,hDC);                       // release the Device Context
  ValidateRect(HWindow,NULL);                   // Mark the window as painted
  Msg.Result = 0;                               // Success
  }
//------------------------------------------------------------------------
LPSTR TBarChart::GetClassName()
      {
      return szClassName;
      }
//------------------------------------------------------------------------
LONG FAR PASCAL _export BarChartWndProc(HWND HWindow,  // Main process
					WORD wMsg,    // registered
					WORD wParam,  // in following
					LONG lParam)  // function
  {
  if (wMsg == WM_CREATE)    // if Called by non-OWL application (RW)
    {
    PTBarChart PBarChart =  // Create an instance
      new TBarChart(CtlBarModule->GetParentObject(GetParent(HWindow)),
		     GetWindowWord(HWindow, GWW_ID),
		     CtlBarModule);
    CtlBarModule->MakeWindow(PBarChart); // hook module to a window
    }
  return DefWindowProc(HWindow, wMsg, wParam, lParam); // allow Windows
  }          // to handle messages prior to OWL hooking into the window
//------------------------------------------------------------------------
BOOL RegisterBarChartClass(HINSTANCE hInstance)  // Called by Libmain to
{                                           // register the Window Class
  WNDCLASS  wc;
  wc.style         = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS | CS_GLOBALCLASS;
  wc.lpfnWndProc   = (WNDPROC)BarChartWndProc;  // Registers Proc used by Class
  wc.cbClsExtra    = 0;
  wc.cbWndExtra    = 0;
  wc.hInstance     = hInstance;
  wc.hIcon         = NULL;
  wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
  wc.hbrBackground = (HBRUSH)(NULL_BRUSH);    //(Clear Background);
  wc.lpszMenuName  = NULL;
  wc.lpszClassName   = szClassName;
  return RegisterClass(&wc);
  }
//------------------------------------------------------------------------
_CLASSDEF(TBarChartDlg)              // Workshop Functions
class TBarChartDlg : public TDialog  // Dialog Class used by Workshop when
  {                               // The Control is double clicked
  protected:
    LPFNSTRTOID    StrToId;       // Pointers to items in workshop
    LPFNIDTOSTR    IdToStr;       // That are used in dialog
    LPCTLSTYLE     Style;
    PTEdit         pTitle;        // Control pointers
    PTEdit         pIdText;
    PTBStatic      pIdNum;
    PTEdit         pRed;
    PTEdit         pGreen;
    PTEdit         pBlue;
    PTEdit         pMin;
    PTEdit         pMax;
    PTEdit         pValue;
    char           szBuffer[80];  // Line Buffer
    WORD           wType;         // Control Type
    public:
    TBarChartDlg(PTWindowsObject AParent, LPSTR AName,
	      LPFNSTRTOID PStrToId, LPFNIDTOSTR PIdToStr,
	      LPCTLSTYLE  PStyle, PTModule AModule = NULL);
    int Parse(int StartChar);
    void SetupWindow();
    virtual void PaletteButton(RTMessage Msg) // button handler
      = [ID_FIRST + IDB_PALETTE];
    void Ok(RTMessage Msg) = [ID_FIRST + IDOK];
  };
//------------------------------------------------------------------------
TBarChartDlg::TBarChartDlg(PTWindowsObject AParent, LPSTR AName,
		     LPFNSTRTOID PStrToId, LPFNIDTOSTR PIdToStr,
		     LPCTLSTYLE  PStyle, PTModule AModule)
	  :TDialog(AParent, AName, AModule),    // Base Class
	   StrToId(PStrToId),                   // Three functions
	   IdToStr(PIdToStr),                   // in Worshop that
	   Style(PStyle)                        // are used
  {
  pTitle      = new TEdit(this,      IDD_TITLE, CTLTITLE, CtlBarModule);
  pIdText     = new TEdit(this,      IDD_IDTEXT, 255, CtlBarModule);
  pIdNum      = new TBStatic(this,   IDD_IDNUM,   18, CtlBarModule);
  pRed        = new TEdit(this,      IDD_IDRED,    4, CtlBarModule);
  pGreen      = new TEdit(this,      IDD_IDGREEN,  4, CtlBarModule);
  pBlue       = new TEdit(this,      IDD_IDBLUE,   4, CtlBarModule);
  pMin        = new TEdit(this,      IDD_IDMIN,   10, CtlBarModule);
  pMax        = new TEdit(this,      IDD_IDMAX,   10, CtlBarModule);
  pValue      = new TEdit(this,      IDD_IDVALUE, 10, CtlBarModule);
  }
//---------------------------------------------------------------------
// PARSE function used by SetupWindow to pull 4 text fields out of one
//       Title field delimited by the tilde character ~
int TBarChartDlg::Parse(int StartChar)
  {
  int Count = 0;
  while ((Style->szTitle[StartChar] != '~')&(Style->szTitle[StartChar] != NULL))
    {
    szBuffer[Count] = Style->szTitle[StartChar];
    StartChar++;
    Count++;
    };
  szBuffer[Count] = NULL;
  return StartChar;
  }
//---------------------------------------------------------------------
void TBarChartDlg::SetupWindow()
  {
  int   nCharCount = 0;
  char  buf[256];
  TDialog::SetupWindow();             // call base class
  nCharCount = Parse(nCharCount);     // Parse 4 fields out of title
  pTitle->SetText(szBuffer);          // and initialize controls
  nCharCount = Parse(nCharCount+1);
  pRed->SetText(szBuffer);
  nCharCount = Parse(nCharCount+1);
  pGreen->SetText(szBuffer);
  nCharCount = Parse(nCharCount+1);
  pBlue->SetText(szBuffer);
  nCharCount = Parse(nCharCount+1);
  pMin->SetText(szBuffer);
  nCharCount = Parse(nCharCount+1);
  pMax->SetText(szBuffer);
  nCharCount = Parse(nCharCount+1);
  pValue->SetText(szBuffer);

  IdToStr(Style->wId, buf, 255);      // Use Workshop to get ID
  pIdText->SetText(buf);              // String and store it
  itoa(Style->wId, buf, 10);          // Translate it to a Number
  pIdNum->SetText(buf);               // and Store Number
  wType = 0xFFFFL & LOWORD(Style->dwStyle); // Save control Type
  }
//----------------------------------------------------------------------
void TBarChartDlg:: PaletteButton(RTMessage)     // button activates
  {
  char szColorBuf[6];
  pRed->GetText(szColorBuf, 4);          // Get Red Mix
  int nRed  = atoi(szColorBuf);
  pGreen->GetText(szColorBuf, 4);        // Get Green Mix
  int nGreen  = atoi(szColorBuf);
  pBlue->GetText(szColorBuf, 4);         // Get Blue Mix
  int nBlue  = atoi(szColorBuf);
  DWORD dwNewColor = RGB(nRed,nGreen,nBlue); // Combine into a Color

  CtlBarModule->ExecDialog(new TColorDialog(
			    CtlBarModule->GetParentObject(HWindow),
			    &dwNewColor,"Color_Dialog",CtlBarModule));

  wsprintf (szColorBuf,"%d",GetRValue(dwNewColor));
  pRed->SetText(szColorBuf);
  wsprintf (szColorBuf,"%d",GetGValue(dwNewColor));
  pGreen->SetText(szColorBuf);
  wsprintf (szColorBuf,"%d",GetBValue(dwNewColor));
  pBlue->SetText(szColorBuf);
  }
//----------------------------------------------------------------------
#pragma argsused
void TBarChartDlg::Ok(RTMessage Msg)      // OK Button pressed
  {
  char  szBuf[256];                   // Buffer for ID string
  LONG  lRetId;                       // Id by Value
  pIdText->GetText(szBuf, 255);       // Get the Text for the Control ID
  lRetId = StrToId(szBuf);            // Convert the define to its number
  if (LOWORD(lRetId) == 0)            // if the number is blank
    {
    pIdText->SetSelection(0, 32767);  // Select a default Number
    SetFocus(pIdText->HWindow);       // Set the focus to the Control
    Msg.Result = (LONG)TRUE;          // return(TRUE);
    return;                           // Return to Dialog for more input
    }
  Style->wId = HIWORD(lRetId);             // not blank - so set the wId
  pTitle->GetText(szBuf, CTLTITLE);        // Get the Title from control
  lstrcat(szBuf,"~");                      // Add delimiter
  pRed->GetText(szBuffer, 4);              // Get Red Mix
  lstrcat(szBuf,szBuffer);                 // Append to string
  lstrcat(szBuf,"~");                      // Add delimiter
  pGreen->GetText(szBuffer, 4);            // Get Green Mix
  lstrcat(szBuf,szBuffer);                 // Append to string
  lstrcat(szBuf,"~");                      // Add delimiter
  pBlue->GetText(szBuffer, 4);             // Get Blue Mix
  lstrcat(szBuf,szBuffer);                 // Append to string
  lstrcat(szBuf,"~");                      // Add delimiter
  pMin->GetText(szBuffer, 10);             // Get Minimum Value
  lstrcat(szBuf,szBuffer);                 // Append to string
  lstrcat(szBuf,"~");                      // Add delimiter
  pMax->GetText(szBuffer, 10);             // Get Maximum Value
  lstrcat(szBuf,szBuffer);                 // Append to string
  lstrcat(szBuf,"~");                      // Add delimiter
  pValue->GetText(szBuffer, 10);           // Get Current Value
  lstrcat(szBuf,szBuffer);                 // Append to string
  lstrcat(szBuf,"~");                      // Add delimiter
  lstrcpy(Style->szTitle, szBuf);          // Copy to structure
  Style->dwStyle = WS_CHILD | WS_VISIBLE | wType ;
  CloseWindow(TRUE);                       // Close Window and update
  }                                        // Workshop Structure
//-------------------------------------------------------------------
#pragma argsused                  // displays dialog box in RW to allow
BOOL FAR PASCAL _export BarChartStyle(HWND HWindow,         // user to
				      HANDLE hCtlStyle,     // change
				      LPFNSTRTOID StrToId,  // control
				      LPFNIDTOSTR IdToStr)  // attributes
{
  PTBarChartDlg    PDlg;
  LPCTLSTYLE    PStyle  = (LPCTLSTYLE) GlobalLock(hCtlStyle);
  BOOL          fRetval = FALSE;
  if (PStyle)                // If Style locked OK
    {                        // then Display dialog box
      PDlg = new TBarChartDlg(CtlBarModule->GetParentObject(HWindow),
			 (LPSTR)MAKEINTRESOURCE(CTLBARDLG),
			 (LPFNSTRTOID)StrToId,
			 (LPFNIDTOSTR)IdToStr,
			 (LPCTLSTYLE)PStyle,
			 CtlBarModule);
    fRetval = (IDOK == CtlBarModule->ExecDialog(PDlg) );
    GlobalUnlock(hCtlStyle);  // cleanup
  }
  return fRetval;             // return Flag to RW
}
//-------------------------------------------------------------------
#pragma argsused                                   // Called by RW to
WORD FAR PASCAL _export BarChartFlags(DWORD dwStyle, // translate style
				      LPSTR szBuf,   // bits to text
				      WORD wbufLen)  // for clarity
  {
  wsprintf(szBuf,(LPSTR)"0");  // No Style bits so use
  return lstrlen(szBuf);       // the Character for zero
  }
//-------------------------------------------------------------------
HANDLE FAR PASCAL _export BarChartInfo(void)  // Info function for RW
{                                             // Default Control Settings
  HANDLE hInfo = GlobalAlloc(GMEM_SHARE | GMEM_ZEROINIT, sizeof(RWCTLINFO));
  if ( hInfo )
    {
    LPRWCTLINFO Info = (LPRWCTLINFO) GlobalLock(hInfo);
    Info->wVersion = 0x0100;             // Version 1.00 of DLL
    Info->wCtlTypes = 1;                 // Number of  controls in Function
    lstrcpy(Info->szClass, szClassName);  // for instance of control
    lstrcpy(Info->szTitle, (LPSTR)"~0~0~255~0~100~50~"); // Caption
					 // fill control structure
    Info->Type[0].wType   = 0;           // Microsoft requires 0
    Info->Type[0].wWidth  = 0x8000 | 31; // default width
    Info->Type[0].wHeight = 0x8000 | 116; // default height
    lstrcpy(Info->Type[0].szDescr, "Bar Chart");//Must be different
    Info->Type[0].dwStyle = WS_VISIBLE | WS_CHILD ;
    Info->Type[0].hToolBit =            // Bitmap for Workshop palett
      LoadBitmap(CtlBarModule->hInstance, "CTLBARBMP");
    Info->Type[0].hDropCurs =           // Cursor for Workshop
      LoadCursor(CtlBarModule->hInstance, "CTLBARCUR");
    GlobalUnlock(hInfo);                // Unlock memory
    }
  return hInfo;                         // let RW have the memory
  }

//=======================================================================//
char szClass2Name[]  = "BarGrid";   // class for new custom control
//=====================================================================
#pragma argsused  // TBarGrid methods prototype in header file
TBarGrid::TBarGrid(PTWindowsObject AParent, int AnID,
		     int X, int Y, int W, int H,
		     LPSTR ATitle, WORD  ATextLen, PTModule AModule)
		    :TStatic (AParent, AnID, ATitle,X,Y,W,H,
			      ATextLen,AModule)
  { };
//------------------------------------------------------------------------
TBarGrid::TBarGrid(PTWindowsObject AParent, int ResourceId,
		       PTModule AModule)
		      :TStatic(AParent, ResourceId, 1, AModule)
  { };
//------------------------------------------------------------------------
LPSTR TBarGrid::GetClassName()
      {
      return szClass2Name;
      }
//---------------------------------------------------------------------
// PARSE function used by SetupWindow to pull 4 text fields out of one
//       Title field delimited by the tilde character ~
int TBarGrid::Parse(int StartChar)
  {
  int Count = 0;
  while ((szTitle[StartChar] != '~')&(szTitle[StartChar] != NULL))
    {
    szBuffer[Count] = szTitle[StartChar];
    StartChar++;
    Count++;
    };
  szBuffer[Count] = NULL;
  return StartChar;
  }
//---------------------------------------------------------------------
void TBarGrid::SetupWindow()
  {
  int nCharCount = 0;
  TStatic::SetupWindow();               // call base class
  GetText(szTitle,254);                 // Get Title
  nCharCount   = Parse(nCharCount);     // Parse out title
  lstrcpy(szLine1,szBuffer);
  nCharCount   = Parse(nCharCount+1);   // Parse out Red Value
  int nRed     = atoi(szBuffer);
  nCharCount   = Parse(nCharCount+1);   // Parse out Green
  int nGreen   = atoi(szBuffer);
  nCharCount   = Parse(nCharCount+1);   // Parse out Blue
  int nBlue    = atoi(szBuffer);
  DisplayColor = RGB(nRed,nGreen,nBlue); // Combine into a Color
  nCharCount   = Parse(nCharCount+1);   // Parse out Minimum value
  lMin         = atol(szBuffer);
  nCharCount   = Parse(nCharCount+1);   // Parse out Maximum
  lMax         = atol(szBuffer);
  nCharCount   = Parse(nCharCount+1);   // Parse out Current Value
  lInterval       = atol(szBuffer);
  if (fInWorkshop)                              // If in the Workshop
    InvalidateRect(Parent->HWindow,NULL,FALSE); // Update Parent
  }
//------------------------------------------------------------------------
#pragma argsused                   // Public interface functions
void TBarGrid::WMInterval(RTMessage Msg)// for TBarChart Custom control
  {                                // for prototypes in header file.
  lInterval = Msg.LParam;             // Note the use of function pairs
  InvalidateRect(HWindow,NULL,FALSE);
  return;                          // to send a message from a member
  }                                // function through windows to allow
void TBarGrid::Interval(long NewValue)// the dummy object to access data
  {                                // in the display object.
  SendMessage(HWindow,BG_INTERVAL,1,NewValue);
  }
#pragma argsused
void TBarGrid::WMMin(RTMessage Msg)     // Reset minimum value
  {
  lMin = Msg.LParam;
  InvalidateRect(HWindow,NULL,FALSE);
  return;
  }
#pragma argsused
void TBarGrid::WMMax(RTMessage Msg)     // Reset Maximum Value
  {
  lMax = Msg.LParam;
  InvalidateRect(HWindow,NULL,FALSE);
  return;
  }
void TBarGrid::Range(long lNewMin, long lNewMax)  // Reset Range
  {
  SendMessage(HWindow,BG_MIN,1,lNewMin);
  SendMessage(HWindow,BG_MAX,1,lNewMax);
  }
#pragma argsused
void TBarGrid::WMColor(RTMessage Msg)             // Change Color
  {
  DisplayColor = Msg.LParam;
  InvalidateRect(HWindow,NULL,FALSE);
  return;
  }
void TBarGrid::Color(COLORREF NewColor)
  {
  SendMessage(HWindow,BG_COLOR,1,NewColor);
  }
//------------------------------------------------------------------------
void TBarGrid::WMPaint(RTMessage Msg)
  {
  HPEN   hPen,   hOldPen;                       // Pen Variables
  HBRUSH hBrush, hOldBrush;                     // Brush Variables
  HDC hDC = GetDC(HWindow);                     // grab the Device Context
  hPen      = CreatePen(PS_SOLID,1,DisplayColor); // Colored pen
  hOldPen   = (HPEN)SelectObject(hDC,hPen);     // use  pen
  hBrush    = (HBRUSH)CreateSolidBrush(DisplayColor); // Colored brush
  hOldBrush = (HBRUSH)SelectObject(hDC,hBrush); // use brush
  Rectangle(hDC,0,0,Attr.W,Attr.H);             // output Colored rectangle
  SelectObject(hDC,hOldBrush);                  // restore old brush
  DeleteObject(hBrush);                         // destroy new brush
  SelectObject(hDC,hOldPen);                    // restore pen
  DeleteObject(hPen);                           // destroy new pen
  RECT rcItem;                                  // Output Title centered
  rcItem.left   = 4;                            // at top of page
  rcItem.top    = 4;
  rcItem.right  = Attr.W - 4;
  rcItem.bottom = Attr.H/5 -4;
  SetBkMode(hDC,TRANSPARENT);
    DrawText(hDC, szLine1, -1, &rcItem,
	DT_CENTER | DT_VCENTER | DT_SINGLELINE);
  hPen      = CreatePen(PS_SOLID,1,RGB(0,0,0)); // Black pen
  hOldPen   = (HPEN)SelectObject(hDC,hPen);     // use black pen
  long lRange = lMax - lMin;                    // Figure Range
  int  nLineCount = LOWORD(lRange/lInterval);   // Figure Number of lines
  char szMinBuff[40];                           // Figure Width of
  char szMaxBuff[40];                           // Min and Max values
  wsprintf(szMinBuff,"%lu",lMin);               // and use it to adjust
  wsprintf(szMaxBuff,"%lu",lMax);               // line start position
  int nXPos;
  if (lstrlen(szMinBuff)>lstrlen(szMaxBuff))
    nXPos = 4 + LOWORD(GetTextExtent(hDC,szMinBuff,lstrlen(szMinBuff)));
  else
    nXPos = 4 + LOWORD(GetTextExtent(hDC,szMaxBuff,lstrlen(szMaxBuff)));
  int nYPos = Attr.H-Attr.H/8;                  // Bottom line 1/8 of
						// Rectange from bottom
  int nCharHeight = HIWORD(GetTextExtent(hDC,szMinBuff,lstrlen(szMinBuff)));
  SetTextAlign(hDC,TA_RIGHT | TA_TOP);
  long lLineLabel = lMin;
  int nCount;
  for (nCount=0;nCount<=nLineCount;nCount++)   // Output lines
    {                                          // and Line labels
    MoveTo(hDC,nXPos,nYPos);
    LineTo(hDC,Attr.W - 4,nYPos);
    wsprintf(szMinBuff,"%lu",lLineLabel);
    TextOut(hDC,nXPos,nYPos-nCharHeight/2,szMinBuff,lstrlen(szMinBuff));
    lLineLabel += lInterval;
    nYPos -= ((Attr.H-Attr.H/8-Attr.H/5)/nLineCount);
    }
  SelectObject(hDC,hOldPen);                    // restore pen
  DeleteObject(hPen);                           // destroy Black pen
  ReleaseDC(HWindow,hDC);                       // release the Device Context
  ValidateRect(HWindow,NULL);                   // Mark the window as painted
  Msg.Result = 0;                               // Success

  }
//========================================================================
LONG FAR PASCAL _export BarGridWndProc(HWND HWindow, // Main process
					WORD wMsg,   // registered
					WORD wParam, // in following
					LONG lParam) // function
  {
  if (wMsg == WM_CREATE)    // if Called by non-OWL application (RW)
    {
    PTBarGrid PBarGrid =  // Create an instance
      new TBarGrid(CtlBarModule->GetParentObject(GetParent(HWindow)),
		     GetWindowWord(HWindow, GWW_ID),CtlBarModule);
    CtlBarModule->MakeWindow(PBarGrid); // hook module to a window
    }
  return DefWindowProc(HWindow, wMsg, wParam, lParam); // allow Windows
  }          // to handle messages prior to OWL hooking into the window
//------------------------------------------------------------------------
BOOL RegisterBarGridClass(HINSTANCE hInstance)  // Called by Libmain to
{                                           // register the Window Class
  WNDCLASS  wc;
  wc.style         = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS | CS_GLOBALCLASS;
  wc.lpfnWndProc   = (WNDPROC)BarGridWndProc;  // Registers Proc used by Class
  wc.cbClsExtra    = 0;
  wc.cbWndExtra    = 0;
  wc.hInstance     = hInstance;
  wc.hIcon         = NULL;
  wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
  wc.hbrBackground = (HBRUSH)(NULL_BRUSH);    //(Clear Background);
  wc.lpszMenuName  = NULL;
  wc.lpszClassName   = szClass2Name;
  return RegisterClass(&wc);
  }
//========================================================================
_CLASSDEF(TBarGridDlg)              // Workshop Functions
class TBarGridDlg : public TDialog  // Dialog Class used by Workshop when
  {                                 // The Control is double clicked
  protected:
    LPFNSTRTOID    StrToId;         // Pointers to items in workshop
    LPFNIDTOSTR    IdToStr;         // That are used in dialog
    LPRWCTLSTYLE     Style;
    PTEdit         pTitle;          // Control pointers
    PTEdit         pIdText;
    PTBStatic      pIdNum;
    PTEdit         pRed;
    PTEdit         pGreen;
    PTEdit         pBlue;
    PTEdit         pMin;
    PTEdit         pMax;
    PTEdit         pInterval;
    char           szBuffer[80];    // Line Buffer
    WORD           wType;           // Control Type
    DWORD dwFontColor;                              // font color
    LOGFONT lfFont;                                 // font structure
  public:
    TBarGridDlg(PTWindowsObject AParent, LPSTR AName,
	      LPFNSTRTOID PStrToId, LPFNIDTOSTR PIdToStr,
	      LPRWCTLSTYLE  PStyle, PTModule AModule = NULL);
    int Parse(int StartChar);
    void SetupWindow();
    virtual void PaletteButton(RTMessage Msg) // button handler
      = [ID_FIRST + IDD_PALETTE];
    void Ok(RTMessage Msg) = [ID_FIRST + IDOK];
  };
//------------------------------------------------------------------------
TBarGridDlg::TBarGridDlg(PTWindowsObject AParent, LPSTR AName,
		     LPFNSTRTOID PStrToId, LPFNIDTOSTR PIdToStr,
		     LPRWCTLSTYLE  PStyle, PTModule AModule)
	  :TDialog(AParent, AName, AModule),    // Base Class
	   StrToId(PStrToId),                   // Three functions
	   IdToStr(PIdToStr),                   // in Worshop that
	   Style(PStyle)                        // are used
  {
  pTitle      = new TEdit(this,      IDD_TITLE, CTLTITLE, CtlBarModule);
  pIdText     = new TEdit(this,      IDD_IDTEXT, 255, CtlBarModule);
  pIdNum      = new TBStatic(this,   IDD_IDNUM,   18, CtlBarModule);
  pRed        = new TEdit(this,      IDD_RED,    4, CtlBarModule);
  pGreen      = new TEdit(this,      IDD_GREEN,  4, CtlBarModule);
  pBlue       = new TEdit(this,      IDD_BLUE,   4, CtlBarModule);
  pMin        = new TEdit(this,      IDD_MIN,   10, CtlBarModule);
  pMax        = new TEdit(this,      IDD_MAX,   10, CtlBarModule);
  pInterval   = new TEdit(this,      IDD_INC, 10, CtlBarModule);
  }
//---------------------------------------------------------------------
// PARSE function used by SetupWindow to pull 4 text fields out of one
//       Title field delimited by the tilde character ~
int TBarGridDlg::Parse(int StartChar)
  {
  int Count = 0;
  while ((Style->szTitle[StartChar] != '~')&(Style->szTitle[StartChar] != NULL))
    {
    szBuffer[Count] = Style->szTitle[StartChar];
    StartChar++;
    Count++;
    };
  szBuffer[Count] = NULL;
  return StartChar;
  }
//---------------------------------------------------------------------
void TBarGridDlg::SetupWindow()
  {
  int   nCharCount = 0;
  char  buf[256];
  TDialog::SetupWindow();             // call base class
  nCharCount = Parse(nCharCount);     // Parse fields out of title
  pTitle->SetText(szBuffer);          // and initialize controls
  nCharCount = Parse(nCharCount+1);
  pRed->SetText(szBuffer);
  nCharCount = Parse(nCharCount+1);
  pGreen->SetText(szBuffer);
  nCharCount = Parse(nCharCount+1);
  pBlue->SetText(szBuffer);
  nCharCount = Parse(nCharCount+1);
  pMin->SetText(szBuffer);
  nCharCount = Parse(nCharCount+1);
  pMax->SetText(szBuffer);
  nCharCount = Parse(nCharCount+1);
  pInterval->SetText(szBuffer);

  IdToStr(Style->wId, buf, 255);      // Use Workshop to get ID
  pIdText->SetText(buf);              // String and store it
  itoa(Style->wId, buf, 10);          // Translate it to a Number
  pIdNum->SetText(buf);               // and Store Number
  wType = 0xFFFFL & LOWORD(Style->dwStyle); // Save control Type
  }
//----------------------------------------------------------------------
void TBarGridDlg:: PaletteButton(RTMessage)     // button activates
  {
  char szColorBuf[6];
  pRed->GetText(szColorBuf, 4);          // Get Red Mix
  int nRed  = atoi(szColorBuf);
  pGreen->GetText(szColorBuf, 4);        // Get Green Mix
  int nGreen  = atoi(szColorBuf);
  pBlue->GetText(szColorBuf, 4);         // Get Blue Mix
  int nBlue  = atoi(szColorBuf);
  DWORD dwNewColor = RGB(nRed,nGreen,nBlue); // Combine into a Color

  CtlBarModule->ExecDialog(new TColorDialog(
			    CtlBarModule->GetParentObject(HWindow),
			    &dwNewColor,"Color_Dialog",CtlBarModule));

  wsprintf (szColorBuf,"%d",GetRValue(dwNewColor));
  pRed->SetText(szColorBuf);
  wsprintf (szColorBuf,"%d",GetGValue(dwNewColor));
  pGreen->SetText(szColorBuf);
  wsprintf (szColorBuf,"%d",GetBValue(dwNewColor));
  pBlue->SetText(szColorBuf);
  }
//----------------------------------------------------------------------
#pragma argsused
void TBarGridDlg::Ok(RTMessage Msg)      // OK Button pressed
  {
  char  szBuf[256];                   // Buffer for ID string
  LONG  lRetId;                       // Id by Value
  pIdText->GetText(szBuf, 255);       // Get the Text for the Control ID
  lRetId = StrToId(szBuf);            // Convert the define to its number
  if (LOWORD(lRetId) == 0)            // if the number is blank
    {
    pIdText->SetSelection(0, 32767);  // Select a default Number
    SetFocus(pIdText->HWindow);       // Set the focus to the Control
    Msg.Result = (LONG)TRUE;          // return(TRUE);
    return;                           // Return to Dialog for more input
    }
  Style->wId = HIWORD(lRetId);             // not blank - so set the wId
  pTitle->GetText(szBuf, CTLTITLE);        // Get the Title from control
  lstrcat(szBuf,"~");                      // Add delimiter
  pRed->GetText(szBuffer, 4);              // Get Red Mix
  lstrcat(szBuf,szBuffer);                 // Append to string
  lstrcat(szBuf,"~");                      // Add delimiter
  pGreen->GetText(szBuffer, 4);            // Get Green Mix
  lstrcat(szBuf,szBuffer);                 // Append to string
  lstrcat(szBuf,"~");                      // Add delimiter
  pBlue->GetText(szBuffer, 4);             // Get Blue Mix
  lstrcat(szBuf,szBuffer);                 // Append to string
  lstrcat(szBuf,"~");                      // Add delimiter
  pMin->GetText(szBuffer, 10);             // Get Minimum Value
  lstrcat(szBuf,szBuffer);                 // Append to string
  lstrcat(szBuf,"~");                      // Add delimiter
  pMax->GetText(szBuffer, 10);             // Get Maximum Value
  lstrcat(szBuf,szBuffer);                 // Append to string
  lstrcat(szBuf,"~");                      // Add delimiter
  pInterval->GetText(szBuffer, 10);           // Get Current Value
  lstrcat(szBuf,szBuffer);                 // Append to string
  lstrcat(szBuf,"~");                      // Add delimiter
  lstrcpy(Style->szTitle, szBuf);          // Copy to structure
  Style->dwStyle = WS_CHILD | WS_VISIBLE | wType ;

  CloseWindow(TRUE);                       // Close Window and update
  }                                        // Workshop Structure
//-------------------------------------------------------------------
#pragma argsused                  // displays dialog box in RW to allow
BOOL FAR PASCAL _export BarGridStyle(HWND HWindow,         // user to
				      HANDLE hCtlStyle,     // change
				      LPFNSTRTOID StrToId,  // control
				      LPFNIDTOSTR IdToStr)  // attributes
{
  PTBarGridDlg    PDlg;
  LPCTLSTYLE    PStyle  = (LPCTLSTYLE) GlobalLock(hCtlStyle);
  BOOL          fRetval = FALSE;
  if (PStyle)                // If Style locked OK
    {                        // then Display dialog box
      PDlg = new TBarGridDlg(CtlBarModule->GetParentObject(HWindow),
			 (LPSTR)MAKEINTRESOURCE(CTLGRDDLG),
			 (LPFNSTRTOID)StrToId,
			 (LPFNIDTOSTR)IdToStr,
			 (LPRWCTLSTYLE)PStyle,
			 CtlBarModule);
    fRetval = (IDOK == CtlBarModule->ExecDialog(PDlg) );
    GlobalUnlock(hCtlStyle);  // cleanup
  }
  return fRetval;             // return Flag to RW
}
//-------------------------------------------------------------------
#pragma argsused                                     // Called by RW to
WORD FAR PASCAL _export BarGridFlags(DWORD dwStyle,  // translate style
				      LPSTR szBuf,   // bits to text
				      WORD wbufLen)  // for clarity
  {
  wsprintf(szBuf,(LPSTR)"0");  // No Style bits so use
  return lstrlen(szBuf);       // the Character for zero
  }
//-------------------------------------------------------------------
HANDLE FAR PASCAL _export BarGridInfo(void)   // Info function for RW
{                                             // Default Control Settings
  HANDLE hInfo = GlobalAlloc(GMEM_SHARE | GMEM_ZEROINIT, sizeof(RWCTLINFO));
  if ( hInfo )
    {
    LPRWCTLINFO Info = (LPRWCTLINFO) GlobalLock(hInfo);
    Info->wVersion = 0x0100;             // Version 1.00 of DLL
    Info->wCtlTypes = 1;                 // Number of  controls in Function
    lstrcpy(Info->szClass, szClass2Name); // for instance of control
    lstrcpy(Info->szTitle, "~0~225~0~0~100~25~");      // Caption
					 // fill control structure
    Info->Type[0].wType   = 0;           // Microsoft requires 0
    Info->Type[0].wWidth  = 0x8000 | 275; // default width
    Info->Type[0].wHeight = 0x8000 | 175; // default height
    lstrcpy(Info->Type[0].szDescr, "Bar Grid");//Must be different
    Info->Type[0].dwStyle = WS_VISIBLE | WS_CHILD ;
    Info->Type[0].hToolBit =            // Bitmap for Workshop palett
      LoadBitmap(CtlBarModule->hInstance, "CTLGRDBMP");
    Info->Type[0].hDropCurs =           // Cursor for Workshop
      LoadCursor(CtlBarModule->hInstance, "CTLGRDCUR");
    GlobalUnlock(hInfo);                // Unlock memory
    }
  return hInfo;                         // let RW have the memory
  }
//========================================================================
#pragma argsused            // Used by RW to define controls
extern "C" HANDLE FAR PASCAL _export ListClasses(LPSTR szAppName,
				      WORD wVersion,
				      LPFNLOADRES fnLoad,
				      LPFNEDITRES fnEdit)
{
    HANDLE hClasses = GlobalAlloc(GMEM_SHARE | GMEM_ZEROINIT,
	sizeof(int) + sizeof(RWCTLCLASS));
    if ( hClasses )
    {
	LPCTLCLASSLIST Classes = (LPCTLCLASSLIST) GlobalLock(hClasses);
	Classes->nClasses = 2;
	Classes->Classes[0].fnRWInfo  = BarGridInfo;  // Three functions
	Classes->Classes[0].fnRWStyle = BarGridStyle; // Workshop Calls
	Classes->Classes[0].fnFlags   = (LPFNFLAGS)BarGridFlags;
	lstrcpy(Classes->Classes[0].szClass, szClass2Name);
	Classes->Classes[1].fnRWInfo  = BarChartInfo;  // Three functions
	Classes->Classes[1].fnRWStyle = BarChartStyle; // Workshop Calls
	Classes->Classes[1].fnFlags   = (LPFNFLAGS)BarChartFlags;
	lstrcpy(Classes->Classes[1].szClass, szClassName);
	GlobalUnlock(hClasses);
    }
    fInWorkshop = TRUE;
    return hClasses;
}
//------------------------------------------------------------------------
WORD FAR PASCAL _export CTLBARGetVersion(void)
  {
  return 0x0100;
  }
//------------------------------------------------------------------------
int FAR PASCAL _export CTLBARAbout(void)
  {
  return MessageBox(GetFocus(),"By Bob Bourbonnais",
		    "Custom Control for Bar Charts",MB_OK);
  }
//------------------------------------------------------------------------
#pragma argsused
extern "C" int FAR PASCAL _export WEP(int nParameter)
{
  return (1);
}
//------------------------------------------------------------------------
#pragma argsused
extern "C" int FAR PASCAL LibMain(HINSTANCE hInstance, WORD wDataSeg,
				 WORD cbHeapSize, LPSTR lpCmdLine)
{
  if (cbHeapSize > 0)
    UnlockData(0);
  CtlBarModule = new TModule("BarChartMod", hInstance, lpCmdLine);
  RegisterBarChartClass(CtlBarModule->hInstance);
  RegisterBarGridClass(CtlBarModule->hInstance);
  fInWorkshop = FALSE;
  return (1);
}
//=======================================================================//
