//----------------------------------------------------------------------
// Defines for Grid Dialog Box that is displayed in workshop
#define CTLGRDDLG	129
#define IDD_TITLE       130
#define IDD_IDTEXT      131
#define IDD_IDNUM       132
#define IDD_RED	        119
#define IDD_GREEN	120
#define IDD_BLUE	121
#define IDD_PALETTE	123
#define IDD_MIN	        124
#define IDD_MAX	        125
#define IDD_INC	        114
//----------------------------------------------------------------------
// Defines for Bar Dialog Box that is displayed in workshop
#define CTLBARDLG	    200
#define IDD_IDRED           240
#define IDD_IDGREEN         250
#define IDD_IDBLUE          260
#define IDB_PALETTE         270
#define IDD_IDMIN	    280
#define IDD_IDMAX           290
#define IDD_IDVALUE         300
//----------------------------------------------------------------------
// Defines for Bar Grid Messages
#define BG_INTERVAL         WM_USER
#define BG_MIN              WM_USER + 1
#define BG_MAX              WM_USER + 2
#define BG_COLOR            WM_USER + 3
//----------------------------------------------------------------------
// Defines for Bar Chart Messages
#define BC_VALUE            WM_USER
#define BC_MIN              WM_USER + 1
#define BC_MAX              WM_USER + 2
#define BC_COLOR            WM_USER + 3
//----------------------------------------------------------------------
extern "C" WORD FAR PASCAL _export CTLBARGetVersion(void);
extern "C" int FAR PASCAL  _export CTLBARAbout(void);
//----------------------------------------------------------------------
_CLASSDEF(TBarChart)                  // New Custom Control Class
class TBarChart : public TStatic      // To add a Bar Chart to
  {                                   // Resource Workshop and allow
  public:                             // Control to be used as control
    TBarChart(PTWindowsObject AParent, int AnId,
		     int X, int Y, int W, int H,
		     LPSTR ATitle = "~0~0~255~0~100~75~",
		     WORD  ATextLen = 1,
		     PTModule AModule = NULL);
    TBarChart(PTWindowsObject AParent, int ResourceId,
		     PTModule AModule = NULL);
    int Parse(int StartChar);
    void SetupWindow();


    void Value(long lNewValue);     //User callable interface funtions
    void WMValue(RTMessage Msg) = [BC_VALUE];

    void Range(long lMin,long lMax);
    void WMMin(RTMessage Msg)   = [BC_MIN];
    void WMMax(RTMessage Msg)   = [BC_MAX];

    void Color(COLORREF NewColor);
    void WMColor(RTMessage Msg) = [BC_COLOR];

    void WMPaint(RTMessage Msg) = [WM_FIRST + WM_PAINT];
    LPSTR GetClassName();
  private:
    char           szBuffer[80];     // Line Buffer
    char           szTitle[255];     // Control Title
    COLORREF       DisplayColor;     // Line Color
    long           lMin;
    long           lMax;
    long           lValue;
  };
//----------------------------------------------------------------------
_CLASSDEF(TBarGrid)                  // New Custom Control Class
class TBarGrid : public TStatic      // To add a Bar Char Grid to
  {                                  // Resource Workshop and allow
  public:                            // Control to be used as control
    TBarGrid(PTWindowsObject AParent, int AnId,
		     int X, int Y, int W, int H,
		     LPSTR ATitle = (LPSTR)"~225~225~0~0~100~25~",
		     WORD  ATextLen = 20,
		     PTModule AModule = NULL);
    TBarGrid(PTWindowsObject AParent, int ResourceId,
		     PTModule AModule = NULL);
    int Parse(int StartChar);
    void SetupWindow();
    void WMPaint(RTMessage Msg) = [WM_FIRST + WM_PAINT];
    void Interval(long lNewValue);     //User callable interface funtions
    void WMInterval(RTMessage Msg) = [BG_INTERVAL];

    void Range(long lMin,long lMax);
    void WMMin(RTMessage Msg)   = [BG_MIN];
    void WMMax(RTMessage Msg)   = [BG_MAX];

    void Color(COLORREF NewColor);
    void WMColor(RTMessage Msg) = [BG_COLOR];

    LPSTR GetClassName();
  protected:
    char           szBuffer[80];     // Line Buffer
    char           szTitle[255];     // Control Title
    char           szLine1[80];      // Display Title
    COLORREF       DisplayColor;     // Line Color
    long           lMin;
    long           lMax;
    long           lInterval;
  };
//----------------------------------------------------------------------
