#include <owl.h>         // CTLSIZE adds a Sizable Text Custom
#include <bwcc.h>        // Control that interfaces with the
#include <custcntl.h>    // The Resource Workshop as well as
#include <control.h>     // functions as a stand alone control
#include <static.h>
#include <edit.h>
#include <bstatic.h>
#include "ctlsiz.h"

PTModule CtlSizeModule;
BOOL fInWorkshop;
char szClassName[]  = "SizeText";   // class for new custom control
//=====================================================================
#pragma argsused  // TSizeText methods prototype in header file
TSizeText::TSizeText(PTWindowsObject AParent, int AnId, LPSTR ATitle,
		     int X, int Y, int W, int H,
		     WORD  ATextLen, PTModule AModule)
		    :TStatic (AParent, AnId, ATitle,X,Y,W,H,
			      ATextLen,AModule)
  {
  InvalidateRect(Parent->HWindow,NULL,FALSE); // Update Parent
  };
//------------------------------------------------------------------------
TSizeText::TSizeText(PTWindowsObject AParent, int ResourceId,
		       PTModule AModule)
		      :TStatic(AParent, ResourceId, 1, AModule)
  {
  InvalidateRect(Parent->HWindow,NULL,FALSE); // Update Parent
  };
//------------------------------------------------------------------------
LPSTR TSizeText::GetClassName()
      {
      return szClassName;
      }
//------------------------------------------------------------------------
void TSizeText::WMPaint(RTMessage Msg)
  {
  HDC hDC     = GetDC(HWindow);                 // grab the Device Contect
  LOGFONT lfFont;                               // font structure
  lfFont.lfHeight = Attr.H;                     // Fill structure with
  lfFont.lfWidth  = Attr.H * 14 / 36;           // Information for
  lfFont.lfEscapement = 0;                      // Times Font based on
  lfFont.lfOrientation = 0;                     // Bounding rectangle size
  lfFont.lfWeight = 700;
  lfFont.lfItalic = 0;
  lfFont.lfUnderline = 0;
  lfFont.lfStrikeOut = 0;
  lfFont.lfCharSet = ANSI_CHARSET;
  lfFont.lfQuality = DEFAULT_QUALITY;
  lfFont.lfPitchAndFamily = VARIABLE_PITCH | FF_DONTCARE;
  lstrcpy(lfFont.lfFaceName, "Times New Roman");
  HFONT hFont = CreateFontIndirect(&lfFont);        // create a new font
  HFONT hFontOld = (HFONT)SelectObject(hDC, hFont); // select it into display
  SetTextColor(hDC,RGB(0,0,0));                     // set the text to Black
  SetBkMode (hDC, TRANSPARENT);                     // Clear Text Background
  char szBuff[256];                                 // Buffer for text
  GetText(szBuff,255);                              // Get from title
  TextOut(hDC,0,0,szBuff,lstrlen(szBuff));          // Output string
  SelectObject(hDC,hFontOld);                       // restore old font
  DeleteObject(hFont);                              // delete font handle
  ReleaseDC(HWindow,hDC);                           // release the DC
  ValidateRect(HWindow,NULL);                       // Mark window painted
  Msg.Result = 0;                                   // Success
  }
//------------------------------------------------------------------------
LONG FAR PASCAL _export SizeTextWndProc(HWND HWindow, // Main process
					WORD wMsg,   // registered
					WORD wParam, // in following
					LONG lParam) // function
  {
  if (wMsg == WM_CREATE)    // if Called by non-OWL application (RW)
    {
    PTSizeText PSizeText =  // Create an instance
      new TSizeText(CtlSizeModule->GetParentObject(GetParent(HWindow)),
		     GetWindowWord(HWindow, GWW_ID),
		     CtlSizeModule);
    CtlSizeModule->MakeWindow(PSizeText); // hook module to a window
    }
  return DefWindowProc(HWindow, wMsg, wParam, lParam); // allow Windows
  }          // to handle messages prior to OWL hooking into the window
//------------------------------------------------------------------------
BOOL RegisterSizeTextClass(HINSTANCE hInstance)  // Called by Libmain to
{                                           // register the Window Class
  WNDCLASS  wc;
  wc.style         = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS | CS_GLOBALCLASS;
  wc.lpfnWndProc   = (WNDPROC)SizeTextWndProc;  // Registers Proc used by Class
  wc.cbClsExtra    = 0;
  wc.cbWndExtra    = 0;
  wc.hInstance     = hInstance;
  wc.hIcon         = NULL;
  wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
  wc.hbrBackground = (HBRUSH)(NULL_BRUSH);    //(Clear Background);
  wc.lpszMenuName  = NULL;
  wc.lpszClassName   = szClassName;
  return RegisterClass(&wc);
  }
//------------------------------------------------------------------------
_CLASSDEF(TSizeTextDlg)              // Workshop Functions
class TSizeTextDlg : public TDialog  // Dialog Class used by Workshop when
  {                                 // The Control is double clicked
  protected:
    LPFNSTRTOID    StrToId;         // Pointers to items in workshop
    LPFNIDTOSTR    IdToStr;         // That are used in dialog
    LPCTLSTYLE     Style;
    PTEdit         pTitle;          // Control pointers
    PTEdit         pIdText;
    PTBStatic      pIdNum;
    char           szBuffer[80];    // Line Buffer
    WORD           wType;           // Control Type
    public:
    TSizeTextDlg(PTWindowsObject AParent, LPSTR AName,
	      LPFNSTRTOID PStrToId, LPFNIDTOSTR PIdToStr,
	      LPCTLSTYLE  PStyle, PTModule AModule = NULL);
    void SetupWindow();
    void Ok(RTMessage Msg) = [ID_FIRST + IDOK];
  };
//------------------------------------------------------------------------
TSizeTextDlg::TSizeTextDlg(PTWindowsObject AParent, LPSTR AName,
		     LPFNSTRTOID PStrToId, LPFNIDTOSTR PIdToStr,
		     LPCTLSTYLE  PStyle, PTModule AModule)
	  :TDialog(AParent, AName, AModule),    // Base Class
	   StrToId(PStrToId),                   // Three functions
	   IdToStr(PIdToStr),                   // in Worshop that
	   Style(PStyle)                        // are used
  {
  pTitle      = new TEdit(this,      IDD_TITLE, CTLTITLE, CtlSizeModule);
  pIdText     = new TEdit(this,      IDD_IDTEXT, 255, CtlSizeModule);
  pIdNum      = new TBStatic(this,   IDD_IDNUM,   18, CtlSizeModule);
  }
//---------------------------------------------------------------------
void TSizeTextDlg::SetupWindow()
  {
  char  buf[256];
  TDialog::SetupWindow();             // call base class
  pTitle->SetText(Style->szTitle);    // and initialize controls
  IdToStr(Style->wId, buf, 255);      // Use Workshop to get ID
  pIdText->SetText(buf);              // String and store it
  itoa(Style->wId, buf, 10);          // Translate it to a Number
  pIdNum->SetText(buf);               // and Store Number
  wType = 0xFFFFL & LOWORD(Style->dwStyle); // Save control Type
  }
//----------------------------------------------------------------------
#pragma argsused
void TSizeTextDlg::Ok(RTMessage Msg)      // OK Button pressed
  {
  char  szBuf[256];                   // Buffer for ID string
  LONG  lRetId;                       // Id by Value
  pIdText->GetText(szBuf, 255);       // Get the Text for the Control ID
  lRetId = StrToId(szBuf);            // Convert the define to its number
  if (LOWORD(lRetId) == 0)            // if the number is blank
    {
    pIdText->SetSelection(0, 32767);  // Select a default Number
    SetFocus(pIdText->HWindow);       // Set the focus to the Control
    Msg.Result = (LONG)TRUE;          // return(TRUE);
    return;                           // Return to Dialog for more input
    }
  Style->wId = HIWORD(lRetId);             // not blank - so set the wId
  pTitle->GetText(szBuf, CTLTITLE);        // Get the Title from control
  lstrcpy(Style->szTitle, szBuf);           // Copy to structure
  Style->dwStyle = WS_CHILD | WS_VISIBLE | wType ;
  CloseWindow(TRUE);                       // Close Window and update
  }                                        // Workshop Structure
//-------------------------------------------------------------------
#pragma argsused                  // displays dialog box in RW to allow
BOOL FAR PASCAL _export SizeTextStyle(HWND HWindow,         // user to
				      HANDLE hCtlStyle,     // change
				      LPFNSTRTOID StrToId,  // control
				      LPFNIDTOSTR IdToStr)  // attributes
{
  PTSizeTextDlg    PDlg;
  LPCTLSTYLE    PStyle  = (LPCTLSTYLE) GlobalLock(hCtlStyle);
  BOOL          fRetval = FALSE;
  if (PStyle)                // If Style locked OK
    {                        // then Display dialog box
      PDlg = new TSizeTextDlg(CtlSizeModule->GetParentObject(HWindow),
			 (LPSTR)MAKEINTRESOURCE(CTLSIZDLG),
			 (LPFNSTRTOID)StrToId,
			 (LPFNIDTOSTR)IdToStr,
			 (LPCTLSTYLE)PStyle,
			 CtlSizeModule);
    fRetval = (IDOK == CtlSizeModule->ExecDialog(PDlg) );
    GlobalUnlock(hCtlStyle);  // cleanup
  }
  return fRetval;             // return Flag to RW
}
//-------------------------------------------------------------------
#pragma argsused                                     // Called by RW to
WORD FAR PASCAL _export SizeTextFlags(DWORD dwStyle,  // translate style
				      LPSTR szBuf,   // bits to text
				      WORD wbufLen)  // for clarity
  {
  wsprintf(szBuf,(LPSTR)"0");  // No Style bits so use
  return lstrlen(szBuf);       // the Character for zero
  }
//-------------------------------------------------------------------
HANDLE FAR PASCAL _export SizeTextInfo(void)   // Info function for RW
{                                             // Default Control Settings
  HANDLE hInfo = GlobalAlloc(GMEM_SHARE | GMEM_ZEROINIT, sizeof(RWCTLINFO));
  if ( hInfo )
    {
    LPRWCTLINFO Info = (LPRWCTLINFO) GlobalLock(hInfo);
    Info->wVersion = 0x0100;             // Version 1.00 of DLL
    Info->wCtlTypes = 1;                 // Number of  controls in Function
    lstrcpy(Info->szClass, szClassName); // for instance of control
    lstrcpy(Info->szTitle, "Text");      // Caption
					 // fill control structure
    Info->Type[0].wType   = 0;           // Microsoft requires 0
    Info->Type[0].wWidth  = 0x8000 | 70; // default width
    Info->Type[0].wHeight = 0x8000 | 36; // default height
    lstrcpy(Info->Type[0].szDescr, "Size Text");//Must be different
    Info->Type[0].dwStyle = WS_VISIBLE | WS_CHILD ;
    Info->Type[0].hToolBit =            // Bitmap for Workshop palett
      LoadBitmap(CtlSizeModule->hInstance, "CTLSIZBMP");
    Info->Type[0].hDropCurs =           // Cursor for Workshop
      LoadCursor(CtlSizeModule->hInstance, "CTLSIZCUR");
    GlobalUnlock(hInfo);                // Unlock memory
    }
  return hInfo;                         // let RW have the memory
  }
//========================================================================
#pragma argsused            // Used by RW to define controls
extern "C" HANDLE FAR PASCAL _export ListClasses(LPSTR szAppName,
				      WORD wVersion,
				      LPFNLOADRES fnLoad,
				      LPFNEDITRES fnEdit)
{
    HANDLE hClasses = GlobalAlloc(GMEM_SHARE | GMEM_ZEROINIT,
	sizeof(int) + sizeof(RWCTLCLASS));
    if ( hClasses )
    {
	LPCTLCLASSLIST Classes = (LPCTLCLASSLIST) GlobalLock(hClasses);
	Classes->nClasses = 1;
	Classes->Classes[0].fnRWInfo  = SizeTextInfo;  // Three functions
	Classes->Classes[0].fnRWStyle = SizeTextStyle; // Workshop Calls
	Classes->Classes[0].fnFlags   = (LPFNFLAGS)SizeTextFlags;
	lstrcpy(Classes->Classes[0].szClass, szClassName);
	GlobalUnlock(hClasses);
    }
    fInWorkshop = TRUE;
    return hClasses;
}
//------------------------------------------------------------------------
WORD FAR PASCAL _export CTLSIZGetVersion(void)
  {
  return 0x0100;
  }
//------------------------------------------------------------------------
int FAR PASCAL _export CTLSIZAbout(void)
  {
  return MessageBox(GetFocus(),"By Bob Bourbonnais",
		    "Custom Control for Drawing Resizable Text",MB_OK);
  }
//------------------------------------------------------------------------
#pragma argsused
extern "C" int FAR PASCAL _export WEP(int nParameter)
{
  return (1);
}
//------------------------------------------------------------------------
#pragma argsused
extern "C" int FAR PASCAL LibMain(HINSTANCE hInstance, WORD wDataSeg,
				 WORD cbHeapSize, LPSTR lpCmdLine)
{
  if (cbHeapSize > 0)
    UnlockData(0);
  CtlSizeModule = new TModule("SizeTextMod", hInstance, lpCmdLine);
  RegisterSizeTextClass(CtlSizeModule->hInstance);
  fInWorkshop = FALSE;
  return (1);
}
//=======================================================================//
