#include <owl.h>         // CTLCOL adds a Colored Rectangle Custom
#include <bwcc.h>        // Control that interfaces with the
#include <custcntl.h>    // The Resource Workshop as well as
#include <control.h>     // functions as a stand alone control.
#include <static.h>      // It Parses ~ delimited data added to
#include <edit.h>        // the title field to define the Rectangle's
#include <bstatic.h>     // color.  Also adds the color Common dialog
#include <commdlg.h>     // to allow a color selection from the
#include "ctlcol.h"      // resource workshop.

BOOL fInWorkshop;
PTModule CtlColModule;
//==================================================================
_CLASSDEF(TColorDialog)               // Class to encapsulate
class TColorDialog : public TDialog   // the Windows 3.1
  {                                   // Color Common Dialog
  public:
    DWORD dwCustClrs[16];             // Array for custom colors
    TColorDialog(PTWindowsObject AParent, // Constructor
		 DWORD * dwNewColor, LPSTR lpName, PTModule AModule);
    virtual BOOL Create();            // Create for non-modal Creation
    virtual int Execute();            // Execute for modal Execution
    virtual void CloseWindow(int ARetValue){}; // trap destruction
  protected:
    CHOOSECOLOR ccdlg;                // Color Common Dialog Structure
    DWORD *dwColor;                   // Color Variable
  };
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
TColorDialog::TColorDialog(PTWindowsObject AParent, DWORD * dwNewColor,
				   LPSTR AName,PTModule AModule = NULL)
	     :TDialog(AParent,AName,AModule) // Constructor calls base
  {
  dwColor =  dwNewColor;        //equate color address to allow updating
  int Count;                    //initialize the 16 custom colors to
  for (Count = 0; Count <= 15; Count++) // Shades of blue
    dwCustClrs[Count] = RGB(Count*(255/15),Count*(255/15),255);
  ccdlg.lStructSize    = sizeof(CHOOSECOLOR);    // initialize ccdl struct
  ccdlg.hwndOwner      = GetFocus();             // parent has the focus
  ccdlg.hInstance      = NULL;                   // Not Used for default dlg
  ccdlg.rgbResult      =  *dwNewColor;           // Color in
  ccdlg.lpCustColors   = (LPDWORD)(dwCustClrs);  // array of blue colors
  ccdlg.Flags          = CC_FULLOPEN|CC_RGBINIT; // full dialog with color in
  ccdlg.lCustData      = 0L;                     // Use Default Data
  ccdlg.lpfnHook       = (FARPROC)NULL;          // No Message trapping
  ccdlg.lpTemplateName = (LPSTR)NULL;            // Use Default dialog
  };
BOOL TColorDialog::Create()                      // Called by MakeWindow
  {
  ccdlg.hwndOwner = NULL;                        // No parent for non-Model
  ChooseColor(&ccdlg);                           // ccdlg function call
  *dwColor = ccdlg.rgbResult;                    // Color out
  return 1;                                      // Success
  }
int TColorDialog::Execute()                      // Called by CreateDialog
  {
  ChooseColor(&ccdlg);                           // ccdlg function call
  *dwColor = ccdlg.rgbResult;                    // Color out
  return 1;                                      // Success
  }
//=====================================================================
//                   TColRect Custom Control
char szClassName[]  = "ColRect";   // class for new custom control
//=====================================================================
#pragma argsused  // TColRect methods prototype in header file
TColRect::TColRect(PTWindowsObject AParent, int AnId,
		     int X, int Y, int W, int H,
		     LPSTR ATitle,
		     WORD  ATextLen,
		     PTModule AModule)
		    :TStatic (AParent, AnId, ATitle,X,Y,W,H,
			      ATextLen,AModule){};
//------------------------------------------------------------------------
TColRect::TColRect(PTWindowsObject AParent, int ResourceId,
		       PTModule AModule)
		      :TStatic(AParent, ResourceId, 1, AModule){};
//---------------------------------------------------------------------
// PARSE function used by SetupWindow to pull 4 text fields out of one
//       Title field delimited by the tilde character ~
int TColRect::Parse(int StartChar)
  {
  int Count = 0;
  while ((szTitle[StartChar] != '~')&(szTitle[StartChar] != NULL))
    {
    szBuffer[Count] = szTitle[StartChar];
    StartChar++;
    Count++;
    };
  szBuffer[Count] = NULL;
  return StartChar;
  }
//---------------------------------------------------------------------
void TColRect::SetupWindow()
  {
  int nCharCount = 0;
  TStatic::SetupWindow();               // call base class
  GetText(szTitle,254);                 // Get Title
  nCharCount   = Parse(nCharCount);     // Parse out title
  nCharCount   = Parse(nCharCount+1);   // Parse out Red Value
  int nRed     = atoi(szBuffer);
  nCharCount   = Parse(nCharCount+1);   // Parse out Green
  int nGreen   = atoi(szBuffer);
  nCharCount   = Parse(nCharCount+1);   // Parse out Blue
  int nBlue    = atoi(szBuffer);
  DisplayColor = RGB(nRed,nGreen,nBlue); // Combine into a Color
  if (fInWorkshop)                               // If in Workshop
     InvalidateRect(Parent->HWindow,NULL,FALSE); // Update Parent
  }
//------------------------------------------------------------------------
#pragma argsused                   // Public interface function
void TColRect::WMColor(RTMessage Msg)// for TColRect Custom control
  {                                // for prototypes in header file.
				   // Note the use of function pairs
  DisplayColor = Msg.LParam;
  InvalidateRect(HWindow,NULL,FALSE);
  return;                          // to send a message from a member
  }                                // function through windows to allow
void TColRect::Color(COLORREF NewColor)// the dummy object to access data
  {                                // in the display object.
  SendMessage(HWindow,CR_COLOR,1,NewColor);
  }
//------------------------------------------------------------------------
void TColRect::WMPaint(RTMessage Msg)
  {
  HPEN   hPen,   hOldPen;                       // Pen Variables
  HBRUSH hBrush, hOldBrush;                     // Brush Variables
  HDC hDC = GetDC(HWindow);                     // grab the Device Context
  hPen      = CreatePen(PS_SOLID,1,DisplayColor); // Colored pen
  hOldPen   = (HPEN)SelectObject(hDC,hPen);     // use  pen
  hBrush    = (HBRUSH)CreateSolidBrush(DisplayColor); // Colored brush
  hOldBrush = (HBRUSH)SelectObject(hDC,hBrush); // use brush
  Rectangle(hDC,0,0,Attr.W,Attr.H);             // output Colored rectangle
  SelectObject(hDC,hOldBrush);                  // restore old brush
  DeleteObject(hBrush);                         // destroy new brush
  SelectObject(hDC,hOldPen);                    // restore pen
  DeleteObject(hPen);                           // destroy new pen
  ReleaseDC(HWindow,hDC);                       // release the Device Context
  ValidateRect(HWindow,NULL);                   // Mark the window as painted
  Msg.Result = 0;                               // Success
  }
//------------------------------------------------------------------------
LPSTR TColRect::GetClassName()
      {
      return szClassName;
      }
//------------------------------------------------------------------------
LONG FAR PASCAL _export ColRectWndProc(HWND HWindow,  // Main process
					WORD wMsg,    // registered
					WORD wParam,  // in following
					LONG lParam)  // function
  {
  if (wMsg == WM_CREATE)    // if Called by non-OWL application (RW)
    {
    PTColRect PColRect =  // Create an instance
      new TColRect(CtlColModule->GetParentObject(GetParent(HWindow)),
		     GetWindowWord(HWindow, GWW_ID),
		     CtlColModule);
    CtlColModule->MakeWindow(PColRect); // hook module to a window
    }
  return DefWindowProc(HWindow, wMsg, wParam, lParam); // allow Windows
  }          // to handle messages prior to OWL hooking into the window
//------------------------------------------------------------------------
BOOL RegisterColRectClass(HINSTANCE hInstance)  // Called by Libmain to
{                                           // register the Window Class
  WNDCLASS  wc;
  wc.style         = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS | CS_GLOBALCLASS;
  wc.lpfnWndProc   = (WNDPROC)ColRectWndProc;  // Registers Proc used by Class
  wc.cbClsExtra    = 0;
  wc.cbWndExtra    = 0;
  wc.hInstance     = hInstance;
  wc.hIcon         = NULL;
  wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
  wc.hbrBackground = (HBRUSH)(NULL_BRUSH);    //(Clear Background);
  wc.lpszMenuName  = NULL;
  wc.lpszClassName   = szClassName;
  return RegisterClass(&wc);
  }
//------------------------------------------------------------------------
_CLASSDEF(TColRectDlg)              // Workshop Functions
class TColRectDlg : public TDialog  // Dialog Class used by Workshop when
  {                               // The Control is double clicked
  protected:
    LPFNSTRTOID    StrToId;       // Pointers to items in workshop
    LPFNIDTOSTR    IdToStr;       // That are used in dialog
    LPCTLSTYLE     Style;
    PTEdit         pTitle;        // Control pointers
    PTEdit         pIdText;
    PTBStatic      pIdNum;
    PTEdit         pRed;
    PTEdit         pGreen;
    PTEdit         pBlue;
    char           szBuffer[80];  // Line Buffer
    WORD           wType;         // Control Type
    public:
    TColRectDlg(PTWindowsObject AParent, LPSTR AName,
	      LPFNSTRTOID PStrToId, LPFNIDTOSTR PIdToStr,
	      LPCTLSTYLE  PStyle, PTModule AModule = NULL);
    int Parse(int StartChar);
    void SetupWindow();
    virtual void PaletteButton(RTMessage Msg) // button handler
      = [ID_FIRST + IDB_PALETTE];
    void Ok(RTMessage Msg) = [ID_FIRST + IDOK];
  };
//------------------------------------------------------------------------
TColRectDlg::TColRectDlg(PTWindowsObject AParent, LPSTR AName,
		     LPFNSTRTOID PStrToId, LPFNIDTOSTR PIdToStr,
		     LPCTLSTYLE  PStyle, PTModule AModule)
	  :TDialog(AParent, AName, AModule),    // Base Class
	   StrToId(PStrToId),                   // Three functions
	   IdToStr(PIdToStr),                   // in Worshop that
	   Style(PStyle)                        // are used
  {
  pTitle      = new TEdit(this,      IDD_TITLE, CTLTITLE, CtlColModule);
  pIdText     = new TEdit(this,      IDD_IDTEXT, 255, CtlColModule);
  pIdNum      = new TBStatic(this,   IDD_IDNUM,   18, CtlColModule);
  pRed        = new TEdit(this,      IDD_IDRED,    4, CtlColModule);
  pGreen      = new TEdit(this,      IDD_IDGREEN,  4, CtlColModule);
  pBlue       = new TEdit(this,      IDD_IDBLUE,   4, CtlColModule);
  }
//---------------------------------------------------------------------
// PARSE function used by SetupWindow to pull 4 text fields out of one
//       Title field delimited by the tilde character ~
int TColRectDlg::Parse(int StartChar)
  {
  int Count = 0;
  while ((Style->szTitle[StartChar] != '~')&(Style->szTitle[StartChar] != NULL))
    {
    szBuffer[Count] = Style->szTitle[StartChar];
    StartChar++;
    Count++;
    };
  szBuffer[Count] = NULL;
  return StartChar;
  }
//---------------------------------------------------------------------
void TColRectDlg::SetupWindow()
  {
  int   nCharCount = 0;
  char  buf[256];
  TDialog::SetupWindow();             // call base class
  nCharCount = Parse(nCharCount);     // Parse 4 fields out of title
  pTitle->SetText(szBuffer);          // and initialize controls
  nCharCount = Parse(nCharCount+1);
  pRed->SetText(szBuffer);
  nCharCount = Parse(nCharCount+1);
  pGreen->SetText(szBuffer);
  nCharCount = Parse(nCharCount+1);
  pBlue->SetText(szBuffer);

  IdToStr(Style->wId, buf, 255);      // Use Workshop to get ID
  pIdText->SetText(buf);              // String and store it
  itoa(Style->wId, buf, 10);          // Translate it to a Number
  pIdNum->SetText(buf);               // and Store Number
  wType = 0xFFFFL & LOWORD(Style->dwStyle); // Save control Type
  }
//----------------------------------------------------------------------
void TColRectDlg:: PaletteButton(RTMessage)     // button activates
  {
  char szColorBuf[6];
  pRed->GetText(szColorBuf, 4);          // Get Red Mix
  int nRed  = atoi(szColorBuf);
  pGreen->GetText(szColorBuf, 4);        // Get Green Mix
  int nGreen  = atoi(szColorBuf);
  pBlue->GetText(szColorBuf, 4);         // Get Blue Mix
  int nBlue  = atoi(szColorBuf);
  DWORD dwNewColor = RGB(nRed,nGreen,nBlue); // Combine into a Color

  CtlColModule->ExecDialog(new TColorDialog(
			    CtlColModule->GetParentObject(HWindow),
			    &dwNewColor,"Color_Dialog",CtlColModule));

  wsprintf (szColorBuf,"%d",GetRValue(dwNewColor));
  pRed->SetText(szColorBuf);
  wsprintf (szColorBuf,"%d",GetGValue(dwNewColor));
  pGreen->SetText(szColorBuf);
  wsprintf (szColorBuf,"%d",GetBValue(dwNewColor));
  pBlue->SetText(szColorBuf);
  }
//----------------------------------------------------------------------
#pragma argsused
void TColRectDlg::Ok(RTMessage Msg)      // OK Button pressed
  {
  char  szBuf[256];                   // Buffer for ID string
  LONG  lRetId;                       // Id by Value
  pIdText->GetText(szBuf, 255);       // Get the Text for the Control ID
  lRetId = StrToId(szBuf);            // Convert the define to its number
  if (LOWORD(lRetId) == 0)            // if the number is blank
    {
    pIdText->SetSelection(0, 32767);  // Select a default Number
    SetFocus(pIdText->HWindow);       // Set the focus to the Control
    Msg.Result = (LONG)TRUE;          // return(TRUE);
    return;                           // Return to Dialog for more input
    }
  Style->wId = HIWORD(lRetId);             // not blank - so set the wId
  pTitle->GetText(szBuf, CTLTITLE);        // Get the Title from control
  lstrcat(szBuf,"~");                      // Add delimiter
  pRed->GetText(szBuffer, 4);              // Get Red Mix
  lstrcat(szBuf,szBuffer);                 // Append to string
  lstrcat(szBuf,"~");                      // Add delimiter
  pGreen->GetText(szBuffer, 4);            // Get Green Mix
  lstrcat(szBuf,szBuffer);                 // Append to string
  lstrcat(szBuf,"~");                      // Add delimiter
  pBlue->GetText(szBuffer, 4);             // Get Blue Mix
  lstrcat(szBuf,szBuffer);                 // Append to string
  lstrcpy(Style->szTitle, szBuf);          // Copy to structure
  Style->dwStyle = WS_CHILD | WS_VISIBLE | wType ;
  CloseWindow(TRUE);                       // Close Window and update
  }                                        // Workshop Structure
//-------------------------------------------------------------------
#pragma argsused                  // displays dialog box in RW to allow
BOOL FAR PASCAL _export ColRectStyle(HWND HWindow,         // user to
				      HANDLE hCtlStyle,     // change
				      LPFNSTRTOID StrToId,  // control
				      LPFNIDTOSTR IdToStr)  // attributes
{
  PTColRectDlg    PDlg;
  LPCTLSTYLE    PStyle  = (LPCTLSTYLE) GlobalLock(hCtlStyle);
  BOOL          fRetval = FALSE;
  if (PStyle)                // If Style locked OK
    {                        // then Display dialog box
      PDlg = new TColRectDlg(CtlColModule->GetParentObject(HWindow),
			 (LPSTR)MAKEINTRESOURCE(CTLBLUDLG),
			 (LPFNSTRTOID)StrToId,
			 (LPFNIDTOSTR)IdToStr,
			 (LPCTLSTYLE)PStyle,
			 CtlColModule);
    fRetval = (IDOK == CtlColModule->ExecDialog(PDlg) );
    GlobalUnlock(hCtlStyle);  // cleanup
  }
  return fRetval;             // return Flag to RW
}
//-------------------------------------------------------------------
#pragma argsused                                   // Called by RW to
WORD FAR PASCAL _export ColRectFlags(DWORD dwStyle, // translate style
				      LPSTR szBuf,   // bits to text
				      WORD wbufLen)  // for clarity
  {
  wsprintf(szBuf,(LPSTR)"0");  // No Style bits so use
  return lstrlen(szBuf);       // the Character for zero
  }
//-------------------------------------------------------------------
HANDLE FAR PASCAL _export ColRectInfo(void)  // Info function for RW
{                                             // Default Control Settings
  HANDLE hInfo = GlobalAlloc(GMEM_SHARE | GMEM_ZEROINIT, sizeof(RWCTLINFO));
  if ( hInfo )
    {
    LPRWCTLINFO Info = (LPRWCTLINFO) GlobalLock(hInfo);
    Info->wVersion = 0x0100;             // Version 1.00 of DLL
    Info->wCtlTypes = 1;                 // Number of  controls in Function
    lstrcpy(Info->szClass, szClassName);  // for instance of control
    lstrcpy(Info->szTitle, "Rect~255~0~255"); // Caption
					 // fill control structure
    Info->Type[0].wType   = 0;           // Microsoft requires 0
    Info->Type[0].wWidth  = 0x8000 | 31; // default width
    Info->Type[0].wHeight = 0x8000 | 31; // default height
    lstrcpy(Info->Type[0].szDescr, "Color Rectangle");//Must be different
    Info->Type[0].dwStyle = WS_VISIBLE | WS_CHILD ;
    Info->Type[0].hToolBit =            // Bitmap for Workshop palett
      LoadBitmap(CtlColModule->hInstance, "CTLCOLBMP");
    Info->Type[0].hDropCurs =           // Cursor for Workshop
      LoadCursor(CtlColModule->hInstance, "CTLCOLCUR");
    GlobalUnlock(hInfo);                // Unlock memory
    }
  return hInfo;                         // let RW have the memory
  }
//========================================================================
#pragma argsused            // Used by RW to define controls
extern "C" HANDLE FAR PASCAL _export ListClasses(LPSTR szAppName,
				      WORD wVersion,
				      LPFNLOADRES fnLoad,
				      LPFNEDITRES fnEdit)
{
    HANDLE hClasses = GlobalAlloc(GMEM_SHARE | GMEM_ZEROINIT,
	sizeof(int) + sizeof(RWCTLCLASS));
    if ( hClasses )
    {
	LPCTLCLASSLIST Classes = (LPCTLCLASSLIST) GlobalLock(hClasses);
	Classes->nClasses = 1;
	Classes->Classes[0].fnRWInfo  = ColRectInfo;  // Three functions
	Classes->Classes[0].fnRWStyle = ColRectStyle; // Workshop Calls
	Classes->Classes[0].fnFlags   = (LPFNFLAGS)ColRectFlags;
	lstrcpy(Classes->Classes[0].szClass, szClassName);
	GlobalUnlock(hClasses);
    }
    fInWorkshop = TRUE;
    return hClasses;
}
//------------------------------------------------------------------------
WORD FAR PASCAL _export CTLCOLGetVersion(void)
  {
  return 0x0100;
  }
//------------------------------------------------------------------------
int FAR PASCAL _export CTLCOLAbout(void)
  {
  return MessageBox(GetFocus(),"By Bob Bourbonnais",
		    "Custom Controls for Colored Rectangles",MB_OK);
  }
//------------------------------------------------------------------------
#pragma argsused
extern "C" int FAR PASCAL _export WEP(int nParameter)
{
  return (1);
}
//------------------------------------------------------------------------
#pragma argsused
extern "C" int FAR PASCAL LibMain(HINSTANCE hInstance, WORD wDataSeg,
				 WORD cbHeapSize, LPSTR lpCmdLine)
{
  if (cbHeapSize > 0)
    UnlockData(0);
  CtlColModule = new TModule("ColRectMod", hInstance, lpCmdLine);
  RegisterColRectClass(CtlColModule->hInstance);
    fInWorkshop = FALSE;
  return (1);
}
//=======================================================================//
