#include <owl.h>         // CTLCOL adds a Digital Display Custom
#include <bwcc.h>        // Control that interfaces with the
#include <custcntl.h>    // The Resource Workshop as well as
#include <control.h>     // functions as a stand alone control.
#include <static.h>      // It Parses ~ delimited data added to
#include <edit.h>        // the title field to define the Digital Control's
#include <bstatic.h>     // color.  Also adds the color Common dialog
#include <commdlg.h>     // to allow a color selection from the
#include "ctldtl.h"      // resource workshop.

PTModule CtlDtlModule;
BOOL fInWorkshop;
//==================================================================
_CLASSDEF(TColorDialog)               // Class to encapsulate
class TColorDialog : public TDialog   // the Windows 3.1
  {                                   // Color Common Dialog
  public:
    DWORD dwCustClrs[16];             // Array for custom colors
    TColorDialog(PTWindowsObject AParent, // Constructor
		 DWORD * dwNewColor, LPSTR lpName, PTModule AModule);
    virtual BOOL Create();            // Create for non-modal Creation
    virtual int Execute();            // Execute for modal Execution
    virtual void CloseWindow(int ARetValue){}; // trap destruction
  protected:
    CHOOSECOLOR ccdlg;                // Color Common Dialog Structure
    DWORD *dwColor;                   // Color Variable
  };
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
TColorDialog::TColorDialog(PTWindowsObject AParent, DWORD * dwNewColor,
				   LPSTR AName,PTModule AModule = NULL)
	     :TDialog(AParent,AName,AModule) // Constructor calls base
  {
  dwColor =  dwNewColor;        //equate color address to allow updating
  int Count;                    //initialize the 16 custom colors to
  for (Count = 0; Count <= 15; Count++) // Shades of blue
    dwCustClrs[Count] = RGB(Count*(255/15),Count*(255/15),255);
  ccdlg.lStructSize    = sizeof(CHOOSECOLOR);    // initialize ccdl struct
  ccdlg.hwndOwner      = GetFocus();             // parent has the focus
  ccdlg.hInstance      = NULL;                   // Not Used for default dlg
  ccdlg.rgbResult      =  *dwNewColor;           // Color in
  ccdlg.lpCustColors   = (LPDWORD)(dwCustClrs);  // array of blue colors
  ccdlg.Flags          = CC_FULLOPEN|CC_RGBINIT; // full dialog with color in
  ccdlg.lCustData      = 0L;                     // Use Default Data
  ccdlg.lpfnHook       = (FARPROC)NULL;          // No Message trapping
  ccdlg.lpTemplateName = (LPSTR)NULL;            // Use Default dialog
  };
BOOL TColorDialog::Create()                      // Called by MakeWindow
  {
  ccdlg.hwndOwner = NULL;                        // No parent for non-Model
  ChooseColor(&ccdlg);                           // ccdlg function call
  *dwColor = ccdlg.rgbResult;                    // Color out
  return 1;                                      // Success
  }
int TColorDialog::Execute()                      // Called by CreateDialog
  {
  ChooseColor(&ccdlg);                           // ccdlg function call
  *dwColor = ccdlg.rgbResult;                    // Color out
  return 1;                                      // Success
  }
//=====================================================================
//                   TColRect Custom Control
char szClassName[]  = "Digital";   // class for new custom control
//=====================================================================
#pragma argsused  // TDigital methods prototype in header file
TDigital::TDigital(PTWindowsObject AParent, int AnId,
		     int X, int Y, int W, int H,
		     LPSTR ATitle,
		     WORD  ATextLen,
		     PTModule AModule)
		    :TStatic (AParent, AnId, ATitle,X,Y,W,H,
			      ATextLen,AModule){};
//------------------------------------------------------------------------
TDigital::TDigital(PTWindowsObject AParent, int ResourceId,
		       PTModule AModule)
		      :TStatic(AParent, ResourceId, 1, AModule){};
//---------------------------------------------------------------------
// PARSE function used by SetupWindow to pull 4 text fields out of one
//       Title field delimited by the tilde character ~
int TDigital::Parse(int StartChar)
  {
  int Count = 0;
  while ((szTitle[StartChar] != '~')&(szTitle[StartChar] != NULL))
    {
    szBuffer[Count] = szTitle[StartChar];
    StartChar++;
    Count++;
    };
  szBuffer[Count] = NULL;
  return StartChar;
  }
//---------------------------------------------------------------------
void TDigital::SetupWindow()
  {
  int nCharCount = 0;
  TStatic::SetupWindow();               // call base class
  GetText(szTitle,254);                 // Get Title
  nCharCount   = Parse(nCharCount);     // Parse out title
  lstrcpy(szText,szBuffer);
  nCharCount   = Parse(nCharCount+1);   // Parse out Red Value
  int nRed     = atoi(szBuffer);
  nCharCount   = Parse(nCharCount+1);   // Parse out Green
  int nGreen   = atoi(szBuffer);
  nCharCount   = Parse(nCharCount+1);   // Parse out Blue
  int nBlue    = atoi(szBuffer);
  DisplayColor = RGB(nRed,nGreen,nBlue); // Combine into a Color
  if (fInWorkshop)                               // If in Workshop
     InvalidateRect(Parent->HWindow,NULL,FALSE); // Update Parent
  }
//------------------------------------------------------------------------
#pragma argsused                   // Public interface function
void TDigital::WMColor(RTMessage Msg)// for TDigital Custom control
  {                                // for prototypes in header file.
  DisplayColor = Msg.LParam;       // Note the use of function pairs
  InvalidateRect(HWindow,NULL,FALSE);
  return;                          // to send a message from a member
  }                                // function through windows to allow
void TDigital::Color(COLORREF NewColor)// the dummy object to access data
  {                                // in the display object.
  SendMessage(HWindow,CR_COLOR,1,NewColor);
  }
//------------------------------------------------------------------------
int TDigital::DisplayChar(char cDisplayChar, int nXOffset)
  {                                // Outputs a single character
  const int Top      = 1;          // Values for parts of control
  const int Middle   = 2;
  const int Bottom   = 4;
  const int TopLeft  = 8;
  const int TopRight = 16;
  const int BotLeft  = 32;
  const int BotRight = 64;
  char      cDisplay = 0;          // Blank display
  int       nP = Attr.H / 24;      // nP is a unit of measure
  if (nP == 0) nP = 1;             // Always make it at least one pixel
  int nMovePixel = nP * 17;        // Increment in 17 units to next character
  switch (cDisplayChar)            // Figure the parts to display for
    {                              // different digits
    case '0':
      cDisplay = Top | Bottom | TopLeft | TopRight | BotLeft | BotRight;
      break;
    case '1':
      cDisplay = TopRight | BotRight;
      break;
    case '2':
      cDisplay = Top | TopRight | Middle | BotLeft | Bottom;
      break;
    case '3':
      cDisplay = Top | TopRight | Middle | BotRight | Bottom;
      break;
    case '4':
      cDisplay = TopLeft | Middle | TopRight | BotRight;
      break;
    case '5':
      cDisplay = Top | TopLeft | Middle | BotRight | Bottom;
      break;
    case '6':
      cDisplay = TopLeft | BotLeft | Bottom | BotRight | Middle;
      break;
    case '7':
      cDisplay = Top | TopRight | BotRight;
      break;
    case '8':
      cDisplay = Top | Middle | Bottom | TopLeft | TopRight |
		      BotLeft | BotRight;
      break;
    case '9':
      cDisplay = Top | Middle | Bottom | TopLeft | TopRight |
		      BotRight;
      break;
    case 'a':
    case 'A':
      cDisplay = Top | Middle | TopLeft | TopRight |
		      BotLeft | BotRight;
      break;
    case 'b':
    case 'B':
      cDisplay = TopLeft | BotLeft | Bottom | BotRight | Middle;
      break;
    case 'c':
    case 'C':
      cDisplay = Middle | Bottom | BotLeft;
      break;
    case 'd':
    case 'D':
      cDisplay = Middle | Bottom | BotLeft | BotRight | TopRight;
      break;
    case 'e':
    case 'E':
      cDisplay = Top | Middle | Bottom | TopLeft | BotLeft;
      break;
    case 'f':
    case 'F':
      cDisplay = Top | Middle | TopLeft | BotLeft;
      break;
    case 'P':
      cDisplay = Top | Middle | TopLeft | TopRight | BotLeft;
      break;
    case '-':
      cDisplay = Middle;
      break;
    case '(':
      cDisplay = TopLeft | BotLeft;
      nXOffset += 4 * nP;
      break;
    case ')':
      cDisplay = TopRight | BotRight;
      nXOffset -= 4 * nP;
      break;
    default:
      cDisplay = 0;
      break;
    }
  HPEN   hPen,   hOldPen;                       // Pen Variables
  HBRUSH hBrush, hOldBrush;                     // Brush Variables
  HDC hDC = GetDC(HWindow);                     // grab the Device Context
  hPen      = CreatePen(PS_SOLID,1,DisplayColor); // Colored pen
  hOldPen   = (HPEN)SelectObject(hDC,hPen);     // use  pen
  hBrush    = (HBRUSH)CreateSolidBrush(DisplayColor); // Colored brush
  hOldBrush = (HBRUSH)SelectObject(hDC,hBrush); // use brush
  POINT apShape[6];                             // 6 parts for shapes
  if (cDisplay & Top)                           // display the top
    {                                           // polygon
    apShape[0].x = nP * 2 * 2 + nXOffset;
    apShape[0].y = nP * 2;
    apShape[1].x = nP * 17+ nXOffset;
    apShape[1].y = nP * 2;
    apShape[2].x = nP * 13+ nXOffset;
    apShape[2].y = nP * 5;
    apShape[3].x = nP * 4 * 2+ nXOffset;
    apShape[3].y = nP * 5;
    Polygon(hDC, apShape, 4);
    }
  if (cDisplay & Bottom)                        // Display the bottom
    {                                           // Polygon
    apShape[0].x = nP * 2 * 2+ nXOffset;
    apShape[0].y = nP * 22;
    apShape[1].x = nP * 17+ nXOffset;
    apShape[1].y = nP * 22;
    apShape[2].x = nP * 13+ nXOffset;
    apShape[2].y = nP * 19;
    apShape[3].x = nP * 8+ nXOffset;
    apShape[3].y = nP * 19;
    Polygon(hDC, apShape, 4);
    }
  if (cDisplay & Middle)
    {
    apShape[0].x = nP * 6+ nXOffset;              // Middle
    apShape[0].y = nP * 12;
    apShape[1].x = nP * 8+ nXOffset;
    apShape[1].y = nP * 11;
    apShape[2].x = nP * 13+ nXOffset;
    apShape[2].y = nP * 11;
    apShape[3].x = nP * 15+ nXOffset;
    apShape[3].y = nP * 12;
    apShape[4].x = nP * 13+ nXOffset;
    apShape[4].y = nP * 13;
    apShape[5].x = nP * 4 * 2+ nXOffset;
    apShape[5].y = nP * 13;
    Polygon(hDC, apShape, 6);
    }
  if (cDisplay & TopLeft)
    {
    apShape[0].x = nP * 2 * 2+ nXOffset;              // Top Left
    apShape[0].y = nP * 4;
    apShape[1].x = nP * 2 * 2+ nXOffset;
    apShape[1].y = nP * 12;
    apShape[2].x = nP * 7+ nXOffset;
    apShape[2].y = nP * 10;
    apShape[3].x = nP * 7+ nXOffset;
    apShape[3].y = nP * 6;
    Polygon(hDC, apShape, 4);
    }
  if (cDisplay & BotLeft)
    {
    apShape[0].x = nP * 2 * 2 + nXOffset;              // Bottom Left
    apShape[0].y = nP * 12;
    apShape[1].x = nP * 2 * 2+ nXOffset;
    apShape[1].y = nP * 20;
    apShape[2].x = nP * 7+ nXOffset;
    apShape[2].y = nP * 18;
    apShape[3].x = nP * 7+ nXOffset;
    apShape[3].y = nP * 14;
    Polygon(hDC, apShape, 4);
    }
  if (cDisplay & TopRight)
    {
    apShape[0].x = nP * 17+ nXOffset;              // Top Right
    apShape[0].y = nP * 4;
    apShape[1].x = nP * 17+ nXOffset;
    apShape[1].y = nP * 12;
    apShape[2].x = nP * 14+ nXOffset;
    apShape[2].y = nP * 10;
    apShape[3].x = nP * 14+ nXOffset;
    apShape[3].y = nP * 6;
    Polygon(hDC, apShape, 4);
    }
  if (cDisplay & BotRight)
    {
    apShape[0].x = nP * 17+ nXOffset;              // Bottom right
    apShape[0].y = nP * 12;
    apShape[1].x = nP * 17+ nXOffset;
    apShape[1].y = nP * 20;
    apShape[2].x = nP * 14+ nXOffset;
    apShape[2].y = nP * 18;
    apShape[3].x = nP * 14+ nXOffset;
    apShape[3].y = nP * 14;
    Polygon(hDC, apShape, 4);
    }
  switch (cDisplayChar)                    // Special characters
    {
    case ':':
      nMovePixel = nP * 5;
      Ellipse(hDC,nP * 3 + nXOffset, nP * 6,nP * 7 + nXOffset, nP * 10);
      Ellipse(hDC,nP * 3 + nXOffset, nP * 15,nP * 7 + nXOffset, nP * 19);
      break;
    case '.':
      nMovePixel = nP * 5;
      Ellipse(hDC,nP * 3 + nXOffset, nP * 19,nP * 7 + nXOffset, nP * 23);
      break;
    case ',':
      nMovePixel = nP * 5;
      Ellipse(hDC,nP * 3 + nXOffset, nP * 19,nP * 7 + nXOffset, nP * 23);
      apShape[0].x = nP * 5 + nXOffset;
      apShape[0].y = nP * 21;
      apShape[1].x = nP * 6 + nXOffset;
      apShape[1].y = nP * 22;
      apShape[2].x = nP * 3 + nXOffset;
      apShape[2].y = nP * 25;
      Polygon(hDC, apShape, 3);
      break;
    case '(':
      nMovePixel = nP * 12;
      apShape[0].x = nP * 2 * 2 + nXOffset;              // Top
      apShape[0].y = nP * 2;
      apShape[1].x = nP * 12 + nXOffset;
      apShape[1].y = nP * 2;
      apShape[2].x = nP * 8 + nXOffset;
      apShape[2].y = nP * 5;
      apShape[3].x = nP * 4 * 2+ nXOffset;
      apShape[3].y = nP * 5;
      Polygon(hDC, apShape, 4);
      apShape[0].x = nP * 2 * 2+ nXOffset;              // Bottom
      apShape[0].y = nP * 22;
      apShape[1].x = nP * 12 + nXOffset;
      apShape[1].y = nP * 22;
      apShape[2].x = nP * 8  + nXOffset;
      apShape[2].y = nP * 19;
      apShape[3].x = nP * 8+ nXOffset;
      apShape[3].y = nP * 19;
      Polygon(hDC, apShape, 4);
      break;
    case ')':
      nMovePixel = nP * 16;
      nXOffset += 4 * nP;
      apShape[0].x = nP * 2 * 2 + nXOffset;              // Top
      apShape[0].y = nP * 2;
      apShape[1].x = nP * 12 + nXOffset;
      apShape[1].y = nP * 2;
      apShape[2].x = nP * 8 + nXOffset;
      apShape[2].y = nP * 5;
      apShape[3].x = nP * 4 * 2+ nXOffset;
      apShape[3].y = nP * 5;
      Polygon(hDC, apShape, 4);
      apShape[0].x = nP * 2 * 2+ nXOffset;              // Bottom
      apShape[0].y = nP * 22;
      apShape[1].x = nP * 12 + nXOffset;
      apShape[1].y = nP * 22;
      apShape[2].x = nP * 8  + nXOffset;
      apShape[2].y = nP * 19;
      apShape[3].x = nP * 8+ nXOffset;
      apShape[3].y = nP * 19;
      Polygon(hDC, apShape, 4);
      break;
    case '$':
      apShape[0].x = nP * 2 * 2 + nXOffset;    // Top
      apShape[0].y = nP * 6;
      apShape[1].x = nP * 17+ nXOffset;
      apShape[1].y = nP * 6;
      apShape[2].x = nP * 13+ nXOffset;
      apShape[2].y = nP * 9;
      apShape[3].x = nP * 4 * 2+ nXOffset;
      apShape[3].y = nP * 9;
      Polygon(hDC, apShape, 4);
      apShape[0].x = nP * 2 * 2+ nXOffset;              // Bottom
      apShape[0].y = nP * 18;
      apShape[1].x = nP * 17+ nXOffset;
      apShape[1].y = nP * 18;
      apShape[2].x = nP * 13+ nXOffset;
      apShape[2].y = nP * 15;
      apShape[3].x = nP * 8+ nXOffset;
      apShape[3].y = nP * 15;
      Polygon(hDC, apShape, 4);
      apShape[0].x = nP * 6+ nXOffset;              // Middle
      apShape[0].y = nP * 12;
      apShape[1].x = nP * 8+ nXOffset;
      apShape[1].y = nP * 11;
      apShape[2].x = nP * 13+ nXOffset;
      apShape[2].y = nP * 11;
      apShape[3].x = nP * 15+ nXOffset;
      apShape[3].y = nP * 12;
      apShape[4].x = nP * 13+ nXOffset;
      apShape[4].y = nP * 13;
      apShape[5].x = nP * 4 * 2+ nXOffset;
      apShape[5].y = nP * 13;
      Polygon(hDC, apShape, 6);
      apShape[0].x = nP * 2 * 2+ nXOffset;              // Top Left
      apShape[0].y = nP * 8;
      apShape[1].x = nP * 2 * 2+ nXOffset;
      apShape[1].y = nP * 12;
      apShape[2].x = nP * 7+ nXOffset;
      apShape[2].y = nP * 10;
      apShape[3].x = nP * 7+ nXOffset;
      apShape[3].y = nP * 10;
      Polygon(hDC, apShape, 4);
      apShape[0].x = nP * 17+ nXOffset;              // Bottom right
      apShape[0].y = nP * 12;
      apShape[1].x = nP * 17+ nXOffset;
      apShape[1].y = nP * 16;
      apShape[2].x = nP * 14+ nXOffset;
      apShape[2].y = nP * 14;
      apShape[3].x = nP * 14+ nXOffset;
      apShape[3].y = nP * 14;
      Polygon(hDC, apShape, 4);
      Rectangle(hDC,nP * 9 + nXOffset, nP * 1,nP * 13 + nXOffset, nP * 5);
      Rectangle(hDC,nP * 9 + nXOffset, nP * 19,nP * 13 + nXOffset, nP * 23);
      break;
    default:
      break;
    }
  SelectObject(hDC,hOldBrush);                  // restore old brush
  DeleteObject(hBrush);                         // destroy new brush
  SelectObject(hDC,hOldPen);                    // restore pen
  DeleteObject(hPen);                           // destroy new pen
  ReleaseDC(HWindow,hDC);                       // release the Device Context
  return (nXOffset + nMovePixel);
  }
//------------------------------------------------------------------------
void TDigital::WMPaint(RTMessage Msg)
  {
  for (int nDisplayPos = 0, Count = 0;
       Count < lstrlen(szText);
       nDisplayPos = DisplayChar(szText[Count++],nDisplayPos));
  ValidateRect(HWindow,NULL);                   // Mark the window as painted
  Msg.Result = 0;                               // Success
  }
//------------------------------------------------------------------------
LPSTR TDigital::GetClassName()
  {
  return szClassName;
  }
//------------------------------------------------------------------------
LONG FAR PASCAL _export DigitalWndProc(HWND HWindow,  // Main process
					WORD wMsg,    // registered
					WORD wParam,  // in following
					LONG lParam)  // function
  {
  if (wMsg == WM_CREATE)    // if Called by non-OWL application (RW)
    {
    PTDigital PDigital =  // Create an instance
      new TDigital(CtlDtlModule->GetParentObject(GetParent(HWindow)),
		     GetWindowWord(HWindow, GWW_ID),
		     CtlDtlModule);
    CtlDtlModule->MakeWindow(PDigital); // hook module to a window
    }
  return DefWindowProc(HWindow, wMsg, wParam, lParam); // allow Windows
  }          // to handle messages prior to OWL hooking into the window
//------------------------------------------------------------------------
BOOL RegisterDigitalClass(HINSTANCE hInstance)  // Called by Libmain to
{                                           // register the Window Class
  WNDCLASS  wc;
  wc.style         = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS | CS_GLOBALCLASS;
  wc.lpfnWndProc   = (WNDPROC)DigitalWndProc;  // Registers Proc used by Class
  wc.cbClsExtra    = 0;
  wc.cbWndExtra    = 0;
  wc.hInstance     = hInstance;
  wc.hIcon         = NULL;
  wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
  wc.hbrBackground = (HBRUSH)(NULL_BRUSH);    //(Clear Background);
  wc.lpszMenuName  = NULL;
  wc.lpszClassName   = szClassName;
  return RegisterClass(&wc);
  }
//------------------------------------------------------------------------
_CLASSDEF(TDigitalDlg)              // Workshop Functions
class TDigitalDlg : public TDialog  // Dialog Class used by Workshop when
  {                               // The Control is double clicked
  protected:
    LPFNSTRTOID    StrToId;       // Pointers to items in workshop
    LPFNIDTOSTR    IdToStr;       // That are used in dialog
    LPCTLSTYLE     Style;
    PTEdit         pTitle;        // Control pointers
    PTEdit         pIdText;
    PTBStatic      pIdNum;
    PTEdit         pRed;
    PTEdit         pGreen;
    PTEdit         pBlue;
    char           szBuffer[80];  // Line Buffer
    WORD           wType;         // Control Type
    public:
    TDigitalDlg(PTWindowsObject AParent, LPSTR AName,
	      LPFNSTRTOID PStrToId, LPFNIDTOSTR PIdToStr,
	      LPCTLSTYLE  PStyle, PTModule AModule = NULL);
    int Parse(int StartChar);
    void SetupWindow();
    virtual void PaletteButton(RTMessage Msg) // button handler
      = [ID_FIRST + IDB_PALETTE];
    void Ok(RTMessage Msg) = [ID_FIRST + IDOK];
  };
//------------------------------------------------------------------------
TDigitalDlg::TDigitalDlg(PTWindowsObject AParent, LPSTR AName,
		     LPFNSTRTOID PStrToId, LPFNIDTOSTR PIdToStr,
		     LPCTLSTYLE  PStyle, PTModule AModule)
	  :TDialog(AParent, AName, AModule),    // Base Class
	   StrToId(PStrToId),                   // Three functions
	   IdToStr(PIdToStr),                   // in Worshop that
	   Style(PStyle)                        // are used
  {
  pTitle      = new TEdit(this,      IDD_TITLE, CTLTITLE, CtlDtlModule);
  pIdText     = new TEdit(this,      IDD_IDTEXT, 255, CtlDtlModule);
  pIdNum      = new TBStatic(this,   IDD_IDNUM,   18, CtlDtlModule);
  pRed        = new TEdit(this,      IDD_IDRED,    4, CtlDtlModule);
  pGreen      = new TEdit(this,      IDD_IDGREEN,  4, CtlDtlModule);
  pBlue       = new TEdit(this,      IDD_IDBLUE,   4, CtlDtlModule);
  }
//---------------------------------------------------------------------
// PARSE function used by SetupWindow to pull 4 text fields out of one
//       Title field delimited by the tilde character ~
int TDigitalDlg::Parse(int StartChar)
  {
  int Count = 0;
  while ((Style->szTitle[StartChar] != '~')&(Style->szTitle[StartChar] != NULL))
    {
    szBuffer[Count] = Style->szTitle[StartChar];
    StartChar++;
    Count++;
    };
  szBuffer[Count] = NULL;
  return StartChar;
  }
//---------------------------------------------------------------------
void TDigitalDlg::SetupWindow()
  {
  int   nCharCount = 0;
  char  buf[256];
  TDialog::SetupWindow();             // call base class
  nCharCount = Parse(nCharCount);     // Parse 4 fields out of title
  pTitle->SetText(szBuffer);          // and initialize controls
  nCharCount = Parse(nCharCount+1);
  pRed->SetText(szBuffer);
  nCharCount = Parse(nCharCount+1);
  pGreen->SetText(szBuffer);
  nCharCount = Parse(nCharCount+1);
  pBlue->SetText(szBuffer);

  IdToStr(Style->wId, buf, 255);      // Use Workshop to get ID
  pIdText->SetText(buf);              // String and store it
  itoa(Style->wId, buf, 10);          // Translate it to a Number
  pIdNum->SetText(buf);               // and Store Number
  wType = 0xFFFFL & LOWORD(Style->dwStyle); // Save control Type
  }
//----------------------------------------------------------------------
void TDigitalDlg:: PaletteButton(RTMessage)     // button activates
  {
  char szColorBuf[6];
  pRed->GetText(szColorBuf, 4);          // Get Red Mix
  int nRed  = atoi(szColorBuf);
  pGreen->GetText(szColorBuf, 4);        // Get Green Mix
  int nGreen  = atoi(szColorBuf);
  pBlue->GetText(szColorBuf, 4);         // Get Blue Mix
  int nBlue  = atoi(szColorBuf);
  DWORD dwNewColor = RGB(nRed,nGreen,nBlue); // Combine into a Color

  CtlDtlModule->ExecDialog(new TColorDialog(
			    CtlDtlModule->GetParentObject(HWindow),
			    &dwNewColor,"Color_Dialog",CtlDtlModule));

  wsprintf (szColorBuf,"%d",GetRValue(dwNewColor));
  pRed->SetText(szColorBuf);
  wsprintf (szColorBuf,"%d",GetGValue(dwNewColor));
  pGreen->SetText(szColorBuf);
  wsprintf (szColorBuf,"%d",GetBValue(dwNewColor));
  pBlue->SetText(szColorBuf);
  }
//----------------------------------------------------------------------
#pragma argsused
void TDigitalDlg::Ok(RTMessage Msg)      // OK Button pressed
  {
  char  szBuf[256];                   // Buffer for ID string
  LONG  lRetId;                       // Id by Value
  pIdText->GetText(szBuf, 255);       // Get the Text for the Control ID
  lRetId = StrToId(szBuf);            // Convert the define to its number
  if (LOWORD(lRetId) == 0)            // if the number is blank
    {
    pIdText->SetSelection(0, 32767);  // Select a default Number
    SetFocus(pIdText->HWindow);       // Set the focus to the Control
    Msg.Result = (LONG)TRUE;          // return(TRUE);
    return;                           // Return to Dialog for more input
    }
  Style->wId = HIWORD(lRetId);             // not blank - so set the wId
  pTitle->GetText(szBuf, CTLTITLE);        // Get the Title from control
  lstrcat(szBuf,"~");                      // Add delimiter
  pRed->GetText(szBuffer, 4);              // Get Red Mix
  lstrcat(szBuf,szBuffer);                 // Append to string
  lstrcat(szBuf,"~");                      // Add delimiter
  pGreen->GetText(szBuffer, 4);            // Get Green Mix
  lstrcat(szBuf,szBuffer);                 // Append to string
  lstrcat(szBuf,"~");                      // Add delimiter
  pBlue->GetText(szBuffer, 4);             // Get Blue Mix
  lstrcat(szBuf,szBuffer);                 // Append to string
  lstrcpy(Style->szTitle, szBuf);          // Copy to structure
  Style->dwStyle = WS_CHILD | WS_VISIBLE | wType ;
  CloseWindow(TRUE);                       // Close Window and update
  }                                        // Workshop Structure
//-------------------------------------------------------------------
#pragma argsused                  // displays dialog box in RW to allow
BOOL FAR PASCAL _export DigitalStyle(HWND HWindow,         // user to
				      HANDLE hCtlStyle,     // change
				      LPFNSTRTOID StrToId,  // control
				      LPFNIDTOSTR IdToStr)  // attributes
{
  PTDigitalDlg    PDlg;
  LPCTLSTYLE    PStyle  = (LPCTLSTYLE) GlobalLock(hCtlStyle);
  BOOL          fRetval = FALSE;
  if (PStyle)                // If Style locked OK
    {                        // then Display dialog box
      PDlg = new TDigitalDlg(CtlDtlModule->GetParentObject(HWindow),
			 (LPSTR)MAKEINTRESOURCE(CTLDTLDLG),
			 (LPFNSTRTOID)StrToId,
			 (LPFNIDTOSTR)IdToStr,
			 (LPCTLSTYLE)PStyle,
			 CtlDtlModule);
    fRetval = (IDOK == CtlDtlModule->ExecDialog(PDlg) );
    GlobalUnlock(hCtlStyle);  // cleanup
  }
  return fRetval;             // return Flag to RW
}
//-------------------------------------------------------------------
#pragma argsused                                   // Called by RW to
WORD FAR PASCAL _export DigitalFlags(DWORD dwStyle, // translate style
				      LPSTR szBuf,   // bits to text
				      WORD wbufLen)  // for clarity
  {
  wsprintf(szBuf,(LPSTR)"0");  // No Style bits so use
  return lstrlen(szBuf);       // the Character for zero
  }
//-------------------------------------------------------------------
HANDLE FAR PASCAL _export DigitalInfo(void)  // Info function for RW
{                                             // Default Control Settings
  HANDLE hInfo = GlobalAlloc(GMEM_SHARE | GMEM_ZEROINIT, sizeof(RWCTLINFO));
  if ( hInfo )
    {
    LPRWCTLINFO Info = (LPRWCTLINFO) GlobalLock(hInfo);
    Info->wVersion = 0x0100;             // Version 1.00 of DLL
    Info->wCtlTypes = 1;                 // Number of  controls in Function
    lstrcpy(Info->szClass, szClassName);  // for instance of control
    lstrcpy(Info->szTitle, "P12:55:00~255~0~0"); // Caption
					 // fill control structure
    Info->Type[0].wType   = 0;           // Microsoft requires 0
    Info->Type[0].wWidth  = 0x8000 | 140; // default width
    Info->Type[0].wHeight = 0x8000 | 28; // default height
    lstrcpy(Info->Type[0].szDescr, "Digital");//Must be different
    Info->Type[0].dwStyle = WS_VISIBLE | WS_CHILD ;
    Info->Type[0].hToolBit =            // Bitmap for Workshop palett
      LoadBitmap(CtlDtlModule->hInstance, "CTLDTLBMP");
    Info->Type[0].hDropCurs =           // Cursor for Workshop
      LoadCursor(CtlDtlModule->hInstance, "CTLDTLCUR");
    GlobalUnlock(hInfo);                // Unlock memory
    }
  return hInfo;                         // let RW have the memory
  }
//========================================================================
#pragma argsused            // Used by RW to define controls
extern "C" HANDLE FAR PASCAL _export ListClasses(LPSTR szAppName,
				      WORD wVersion,
				      LPFNLOADRES fnLoad,
				      LPFNEDITRES fnEdit)
{
    HANDLE hClasses = GlobalAlloc(GMEM_SHARE | GMEM_ZEROINIT,
	sizeof(int) + sizeof(RWCTLCLASS));
    if ( hClasses )
    {
	LPCTLCLASSLIST Classes = (LPCTLCLASSLIST) GlobalLock(hClasses);
	Classes->nClasses = 1;
	Classes->Classes[0].fnRWInfo  = DigitalInfo;  // Three functions
	Classes->Classes[0].fnRWStyle = DigitalStyle; // Workshop Calls
	Classes->Classes[0].fnFlags   = (LPFNFLAGS)DigitalFlags;
	lstrcpy(Classes->Classes[0].szClass, szClassName);
	GlobalUnlock(hClasses);
    }
    fInWorkshop = TRUE;
    return hClasses;
}
//------------------------------------------------------------------------
WORD FAR PASCAL _export CTLDTLGetVersion(void)
  {
  return 0x0100;
  }
//------------------------------------------------------------------------
int FAR PASCAL _export CTLDTLAbout(void)
  {
  return MessageBox(GetFocus(),"By Bob Bourbonnais",
		    "Custom Digital Control",MB_OK);
  }
//------------------------------------------------------------------------
#pragma argsused
extern "C" int FAR PASCAL _export WEP(int nParameter)
{
  return (1);
}
//------------------------------------------------------------------------
#pragma argsused
extern "C" int FAR PASCAL LibMain(HINSTANCE hInstance, WORD wDataSeg,
				 WORD cbHeapSize, LPSTR lpCmdLine)
{
  if (cbHeapSize > 0)
    UnlockData(0);
  CtlDtlModule = new TModule("DigitalMod", hInstance, lpCmdLine);
  RegisterDigitalClass(CtlDtlModule->hInstance);
  fInWorkshop = FALSE;
  return (1);
}
//=======================================================================//
