//----------------------------------------------------------------------
// Defines for Dialog Box that is displayed in workshop
#define CTLDTLDLG	    200
#define IDD_TITLE           210
#define IDD_IDTEXT          220
#define IDD_IDNUM           230
#define IDD_IDRED           240
#define IDD_IDGREEN         250
#define IDD_IDBLUE          260
#define IDB_PALETTE         270
///----------------------------------------------------------------------
// Define for Digital Control Messages
#define CR_COLOR            WM_USER + 0
//----------------------------------------------------------------------
extern "C" WORD FAR PASCAL _export CTLDTLGetVersion(void);
extern "C" int FAR PASCAL  _export CTLDTLAbout(void);
//----------------------------------------------------------------------
_CLASSDEF(TDigital)                  // New Custom Control Class
class TDigital : public TStatic      // To add a Digital Control to
  {                                  // Resource Workshop and allow
  public:                            // Control to be used as control
    TDigital(PTWindowsObject AParent, int AnId,
		     int X, int Y, int W, int H,
		     LPSTR ATitle = "A12:01~255~0~0~",
		     WORD  ATextLen = 15,
		     PTModule AModule = NULL);
    TDigital(PTWindowsObject AParent, int ResourceId,
		     PTModule AModule = NULL);
    int Parse(int StartChar);
    void SetupWindow();
    void Color(COLORREF NewColor);       //User callable interface funtion
    int DisplayChar(char cDisplayChar, int nXOffset);
    void WMColor(RTMessage Msg) = [CR_COLOR];
    void WMPaint(RTMessage Msg) = [WM_FIRST + WM_PAINT];
    LPSTR GetClassName();
  private:
    char           szBuffer[80];     // Line Buffer
    char           szTitle[255];     // Control Title
    char           szText[255];      // Display Text
    COLORREF       DisplayColor;     // Line Color
  };
//----------------------------------------------------------------------
