#include <owl.h>           // Ctlpct creates a DLL for a 256 Color
#include <bwcc.h>          // Custom control that can be used with
#include <custcntl.h>      // the resource workshop and as a stand
#include <control.h>       // Alone control.  The Title of the
#include <button.h>        // Control relates to the bitmap that
#include <edit.h>          // it displays.
#include <bstatic.h>       // Released to the Public Domain
#include "ctlpct.h"        // August 23, 1992 by Bob Bourbonnais
PTModule CtlPctModule;
static LPFNLOADRES lpfnLoadRes;  // Function to load resources from RW
//=====================================================================
char szClassName[]  = "PictRect";   // class for new custom control
TPictRect::TPictRect(PTWindowsObject AParent, int AnId,
		   LPSTR ATitle, int X, int Y, int W, int H,
		   BOOL IsDefault, PTModule AModule)
	  :TButton(AParent, AnId, ATitle, X, Y, W, H, IsDefault, AModule)
  { }
//---------------------------------------------------------------------
TPictRect::TPictRect(PTWindowsObject AParent, int AnId,
		     PTModule AModule)
	  :TButton(AParent, AnId, AModule)
  { }
//---------------------------------------------------------------------
TPictRect::~TPictRect()
  {
  if ( BitmapHandle )               // clean up any left over handles
    DeleteObject(BitmapHandle);
  if ( hNewPalette)
    DeleteObject( hNewPalette);
  }
//---------------------------------------------------------------------
void TPictRect::SetupWindow()
  {
  HGLOBAL hBitmap = NULL;             // Handle to the Bitmap
  hNewPalette     = NULL;             // reset the Palette Handle
  TButton::SetupWindow();             // call base class SetupWindow
  if (lpfnLoadRes)   // In Resource Workshop
    hBitmap = lpfnLoadRes((LPCSTR)RT_BITMAP,(LPSTR)Title);//Load Bitmap
  else               // In Executable
    hBitmap  = LoadResource(GetApplication()->hInstance,  //Load Bitmap
			    FindResource(GetApplication()->hInstance,
					(LPSTR)Title, RT_BITMAP));
  if ( hBitmap )     // If the bitmap loaded
    {
    LPBITMAPINFO pBits = (LPBITMAPINFO)GlobalLock(hBitmap); // Lock info
    HDC hDC = GetDC(HWindow);                               // Get Paint info
    if ( pBits->bmiHeader.biClrUsed)                        // Number of
      nColors = (int)pBits->bmiHeader.biClrUsed;            // Colors in
    else nColors = 1<<(pBits->bmiHeader.biBitCount);        // Palette
    LPLOGPALETTE lpDstPal;                                  // Palette info
    if ( nColors)
      {
      lpDstPal = (LPLOGPALETTE) GlobalLock( GlobalAlloc(
      GHND, sizeof(LOGPALETTE) + ( (nColors - 1) * sizeof(PALETTEENTRY) )));
      lpDstPal->palNumEntries = nColors;
      lpDstPal->palVersion    = 0x300;               // Windows 3.0 version
      RGBQUAD FAR  *pRgb;
      pRgb = pBits->bmiColors;
      short Count;                                   // Counter
      for (Count = 0; Count <= nColors; Count++)     // Transfer Colors
	{
	lpDstPal->palPalEntry[Count].peRed   = pRgb[Count].rgbRed;
	lpDstPal->palPalEntry[Count].peGreen = pRgb[Count].rgbGreen;
	lpDstPal->palPalEntry[Count].peBlue  = pRgb[Count].rgbBlue;
	lpDstPal->palPalEntry[Count].peFlags = 0;
	}
      }
    hNewPalette = CreatePalette(lpDstPal);         // Create a palette
    GlobalFree( (HANDLE) GlobalHandle( HIWORD( lpDstPal) ) ); // Cleanup
    HPALETTE hOldPalette = SelectPalette(hDC,hNewPalette,FALSE);// use
    RealizePalette(hDC);                           // New palette
    BitmapHandle = CreateDIBitmap(hDC,             // Create the Bitmap
		   (LPBITMAPINFOHEADER)pBits,
		   CBM_INIT, ((LPSTR) (pBits + 1)) +
		   (nColors * sizeof(RGBQUAD)), pBits, DIB_RGB_COLORS);
    SelectPalette(hDC,hOldPalette,FALSE);          // Reset palette
    FreeResource(hBitmap);                         // Cleanup
    ReleaseDC(HWindow,hDC);                        // Release Paint stuff
    }
  }
//---------------------------------------------------------------------
LPSTR TPictRect::GetClassName()
      {
      return szClassName;
      }
//---------------------------------------------------------------------
void TPictRect::WMPaint(RTMessage Msg)
  {
  HDC hDC = GetDC(HWindow);               // grab the Device Context
  HDC MemoryDC;                           // For temporary storage of bitmap
  HBITMAP  OldBitmapHandle;               // Temporary storage for old handle
  HPALETTE hOldPal;                       // Temporary storage of palette
  if ( BitmapHandle )                     // If we have a bitmap
    {
    MemoryDC = CreateCompatibleDC(hDC);   // Create a storage area
    OldBitmapHandle = (HBITMAP)SelectObject(MemoryDC, BitmapHandle);
    hOldPal = SelectPalette( hDC, hNewPalette, FALSE);
    SetBkColor(hDC, 0L);
    SetTextColor(hDC, 0xFFFFFFL);
    BitBlt(hDC, 0, 0, Attr.W, Attr.H,             // Move bitmap from temp
	     MemoryDC, 0, 0, SRCCOPY);            // Storage to screen
    SelectPalette( hDC, hOldPal, FALSE);          // restore palette
    SelectObject(MemoryDC, OldBitmapHandle);      // restore storage area
    DeleteDC(MemoryDC);                           // clean up storage area
    ValidateRect(HWindow,NULL);                   // Mark the window as painted
    Msg.Result = 0;                               // Success
    }
  }
//======================================================================
LONG FAR PASCAL _export PictRectWndProc(HWND HWindow, // Main process
					WORD wMsg,    // registered
					WORD wParam,  // in following
					LONG lParam)  // function
  {
  if (wMsg == WM_CREATE)    // if Called by non-OWL application (RW)
    {
    PTPictRect PPictRect =  // Create an instance
      new TPictRect(CtlPctModule->GetParentObject(GetParent(HWindow)),
		     GetWindowWord(HWindow, GWW_ID),
		     CtlPctModule);
    CtlPctModule->MakeWindow(PPictRect); // hook module to a window
    }
  return DefWindowProc(HWindow, wMsg, wParam, lParam); // allow Windows
  }          // to handle messages prior to OWL hooking into the window
//------------------------------------------------------------------------
BOOL RegisterPictRectClass(HINSTANCE hInstance)  // Called by Libmain to
{                                           // register the Window Class
  WNDCLASS  wc;
  wc.style         = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS
		     | CS_GLOBALCLASS |CS_BYTEALIGNWINDOW;
  wc.lpfnWndProc   = (WNDPROC)PictRectWndProc;// Registers Proc used by Class
  wc.cbClsExtra    = 0;
  wc.cbWndExtra    = 0;
  wc.hInstance     = hInstance;
  wc.hIcon         = NULL;
  wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
  wc.hbrBackground = (HBRUSH)(NULL_BRUSH);    // Clear Background
  wc.lpszMenuName  = NULL;
  wc.lpszClassName   = szClassName;
  return RegisterClass(&wc);
  }
//------------------------------------------------------------------------
_CLASSDEF(TPictRectDlg)              // Workshop Functions
class TPictRectDlg : public TDialog  // Dialog Class used by Workshop when
  {                               // The Control is double clicked
  protected:
    LPFNSTRTOID    StrToId;       // Pointers to items in workshop
    LPFNIDTOSTR    IdToStr;       // That are used in dialog
    LPCTLSTYLE     Style;
    PTEdit         pTitle;        // Control pointers
    PTEdit         pIdText;
    PTBStatic      pIdNum;
    char           szBuffer[80];  // Line Buffer
    WORD           wType;         // Control Type
    public:
    TPictRectDlg(PTWindowsObject AParent, LPSTR ATitle,
	      LPFNSTRTOID PStrToId, LPFNIDTOSTR PIdToStr,
	      LPCTLSTYLE  PStyle, PTModule AModule = NULL);
    void SetupWindow();
    void Ok(RTMessage Msg) = [ID_FIRST + IDOK];
  };
//------------------------------------------------------------------------
TPictRectDlg::TPictRectDlg(PTWindowsObject AParent, LPSTR ATitle,
		     LPFNSTRTOID PStrToId, LPFNIDTOSTR PIdToStr,
		     LPCTLSTYLE  PStyle, PTModule AModule)
	  :TDialog(AParent, ATitle, AModule),    // Base Class
	   StrToId(PStrToId),                   // Three functions
	   IdToStr(PIdToStr),                   // in Worshop that
	   Style(PStyle)                        // are used
  {
  pTitle      = new TEdit(this,      IDD_TITLE, CTLTITLE, CtlPctModule);
  pIdText     = new TEdit(this,      IDD_IDTEXT, 255, CtlPctModule);
  pIdNum      = new TBStatic(this,   IDD_IDNUM,   18, CtlPctModule);
  }
//---------------------------------------------------------------------
void TPictRectDlg::SetupWindow()
  {
  char  buf[256];
  TDialog::SetupWindow();             // call base class
  pTitle->SetText(Style->szTitle);    // and initialize controls
  IdToStr(Style->wId, buf, 255);      // Use Workshop to get ID
  pIdText->SetText(buf);              // String and store it
  itoa(Style->wId, buf, 10);          // Translate it to a Number
  pIdNum->SetText(buf);               // and Store Number
  wType = 0xFFFFL & LOWORD(Style->dwStyle); // Save control Type
  }
//----------------------------------------------------------------------
#pragma argsused
void TPictRectDlg::Ok(RTMessage Msg)      // OK Button pressed
  {
  char  szBuf[256];                   // Buffer for ID string
  LONG  lRetId;                       // Id by Value
  pIdText->GetText(szBuf, 255);       // Get the Text for the Control ID
  lRetId = StrToId(szBuf);            // Convert the define to its number
  if (LOWORD(lRetId) == 0)            // if the number is blank
    {
    pIdText->SetSelection(0, 32767);  // Select a default Number
    SetFocus(pIdText->HWindow);       // Set the focus to the Control
    Msg.Result = (LONG)TRUE;          // return(TRUE);
    return;                           // Return to Dialog for more input
    }
  Style->wId = HIWORD(lRetId);             // not blank - so set the wId
  pTitle->GetText(szBuf, CTLTITLE);        // Get the Title from control
  lstrcpy(Style->szTitle, szBuf);           // Copy to structure
  Style->dwStyle = WS_CHILD | WS_VISIBLE | wType ;
  CloseWindow(TRUE);                       // Close Window and update
  }                                        // Workshop Structure
//-------------------------------------------------------------------
#pragma argsused                  // displays dialog box in RW to allow
BOOL FAR PASCAL _export PictRectStyle(HWND HWindow,         // user to
				      HANDLE hCtlStyle,     // change
				      LPFNSTRTOID StrToId,  // control
				      LPFNIDTOSTR IdToStr)  // attributes
{
  PTPictRectDlg    PDlg;
  LPCTLSTYLE    PStyle  = (LPCTLSTYLE) GlobalLock(hCtlStyle);
  BOOL          fRetval = FALSE;
  if (PStyle)                // If Style locked OK
    {                        // then Display dialog box
      PDlg = new TPictRectDlg(CtlPctModule->GetParentObject(HWindow),
			 (LPSTR)MAKEINTRESOURCE(CTLPCTDLG),
			 (LPFNSTRTOID)StrToId,
			 (LPFNIDTOSTR)IdToStr,
			 (LPCTLSTYLE)PStyle,
			 CtlPctModule);
    fRetval = (IDOK == CtlPctModule->ExecDialog(PDlg) );
    GlobalUnlock(hCtlStyle);  // cleanup
  }
  return fRetval;             // return Flag to RW
}
//-------------------------------------------------------------------
#pragma argsused                                   // Called by RW to
WORD FAR PASCAL _export PictRectFlags(DWORD dwStyle, // translate style
				      LPSTR szBuf,   // bits to text
				      WORD wbufLen)  // for clarity
  {
  wsprintf(szBuf,(LPSTR)"0");  // No Style bits so use
  return lstrlen(szBuf);       // the Character for zero
  }
//-------------------------------------------------------------------
HANDLE FAR PASCAL _export PictRectInfo(void)  // Info function for RW
{                                             // Default Control Settings
  HANDLE hInfo = GlobalAlloc(GMEM_SHARE | GMEM_ZEROINIT, sizeof(RWCTLINFO));
  if ( hInfo )
    {
    LPRWCTLINFO Info = (LPRWCTLINFO) GlobalLock(hInfo);
    Info->wVersion = 0x0100;             // Version 1.00 of DLL
    Info->wCtlTypes = 1;                 // Number of  controls in Function
    lstrcpy(Info->szClass, szClassName); // for instance of control
    lstrcpy(Info->szTitle, "BITMAP_1");  // Caption
					 // fill control structure
    Info->Type[0].wType   = 0;           // Microsoft requires 0
    Info->Type[0].wWidth  = 0x8000 | 31; // default width
    Info->Type[0].wHeight = 0x8000 | 31; // default height
    lstrcpy(Info->Type[0].szDescr, "Pict Rectangle");//Must be different
    Info->Type[0].dwStyle = WS_VISIBLE | WS_CHILD ;
    Info->Type[0].hToolBit =            // Bitmap for Workshop palett
      LoadBitmap(CtlPctModule->hInstance, "CTLPCTBMP");
    Info->Type[0].hDropCurs =           // Cursor for Workshop
      LoadCursor(CtlPctModule->hInstance, "CTLPCTCUR");
    GlobalUnlock(hInfo);                // Unlock memory
    }
  return hInfo;                         // let RW have the memory
  }
//========================================================================
#pragma argsused            // Used by RW to define controls
extern "C" HANDLE FAR PASCAL _export ListClasses(LPSTR szAppTitle,
				      WORD wVersion,
				      LPFNLOADRES fnLoad,
				      LPFNEDITRES fnEdit)
{
    HANDLE hClasses = GlobalAlloc(GMEM_SHARE | GMEM_ZEROINIT,
	sizeof(int) + sizeof(RWCTLCLASS));

    lpfnLoadRes = fnLoad;        // Activates the Load Resource function
				 // And flags RW as active
    if ( hClasses )
    {
	LPCTLCLASSLIST Classes = (LPCTLCLASSLIST) GlobalLock(hClasses);
	Classes->nClasses = 1;
	Classes->Classes[0].fnRWInfo  = PictRectInfo;  // Three functions
	Classes->Classes[0].fnRWStyle = PictRectStyle; // Workshop Calls
	Classes->Classes[0].fnFlags   = (LPFNFLAGS)PictRectFlags;
	lstrcpy(Classes->Classes[0].szClass, szClassName);
	GlobalUnlock(hClasses);
    }
    return hClasses;
}
//------------------------------------------------------------------------
WORD FAR PASCAL _export CTLPCTGetVersion(void)
  {
  return 0x0100;
  }
//------------------------------------------------------------------------
int FAR PASCAL _export CTLPCTAbout(void)
  {
  return MessageBox(GetFocus(),"By Bob Bourbonnais",
		    "Picture Rectangle Custom Control",MB_OK);
  }
//------------------------------------------------------------------------
#pragma argsused
extern "C" int FAR PASCAL _export WEP(int nParameter)
{
  return (1);
}
//------------------------------------------------------------------------
#pragma argsused
extern "C" int FAR PASCAL LibMain(HINSTANCE hInstance, WORD wDataSeg,
				 WORD cbHeapSize, LPSTR lpCmdLine)
{
  if (cbHeapSize > 0)
    UnlockData(0);
  CtlPctModule = new TModule("PictRectMod", hInstance, lpCmdLine);
  RegisterPictRectClass(CtlPctModule->hInstance);
  lpfnLoadRes = NULL;  // Pointer initialized to NULL
  return (1);
}
//=======================================================================//
