/* **********************************************************
   ddelib.h - Dynamic Data Exchange Dynamic Link Library Include File

   Copyright Horizon Technologies Inc. 1990.  All Rights Reserved.

  ***revision history***
1 DDELIB.H 24-Jan-90,10:36:00,`JMH' Initial version
2 DDELIB.H 29-Jan-90,11:02:52,`JMH' Semi-stable version
3 DDELIB.H 25-Jun-90,14:44:22,`JMH' Version as of 6/25/90
4 DDELIB.H 5-Sep-90,14:09:54,`JMH' Version 1.3
  ***revision history***
********************************************************** */

/* Message values sent to callback functions */
#define DDE_INITIATE		0
#define DDE_TERMINATE		1
#define DDE_ADVISE		2
#define DDE_UNADVISE		3
#define DDE_ACK 		4
#define DDE_DATA		5
#define DDE_REQUEST		6
#define DDE_POKE		7
#define DDE_EXECUTE		8

/* Application return codes for bAppReturnCode in DDEACK structure */
#define DDE_OK			0
#define DDE_NACK		1
#define DDE_BADHANDLE		2
#define DDE_BADSTATE		3
#define DDE_MEMORY		4
#define DDE_BADITEM		5
#define DDE_BADTOPIC		6

#define MAX_ITEM_LEN		32

typedef WORD (FAR PASCAL *DDECALLBACK) (HWND, unsigned, LPSTR, HANDLE);

HWND FAR PASCAL DDEInitiate (HWND, LPSTR, LPSTR);
WORD FAR PASCAL DDEAdvise (HWND, LPSTR, DDEADVISE FAR *, DDECALLBACK);
WORD FAR PASCAL DDEUnadvise (HWND, LPSTR);
WORD FAR PASCAL DDERequest (HWND, LPSTR, WORD, DDECALLBACK);
WORD FAR PASCAL DDEPoke (HWND, LPSTR, HANDLE);
WORD FAR PASCAL DDEExecute (HWND, HANDLE);
WORD FAR PASCAL DDETerminate (HWND);

HWND FAR PASCAL DDERegisterTopic (HWND, LPSTR, LPSTR, DDECALLBACK);
ATOM FAR PASCAL DDEGetSessionAppAtom (HWND);
int FAR PASCAL DDEGetSessionAppName (HWND, LPSTR, int);
ATOM FAR PASCAL DDEGetSessionTopicAtom (HWND);
int FAR PASCAL DDEGetSessionTopicName (HWND, LPSTR, int);
WORD FAR PASCAL DDESendData (HWND, unsigned, LPSTR, HANDLE);
HANDLE FAR PASCAL DDERegisterAdvise (HANDLE, HWND, LPSTR, BOOL, BOOL, int);
HANDLE FAR PASCAL DDEUnregisterAdvise (HANDLE, HWND, LPSTR);
int FAR PASCAL DDEGetAdvise (HANDLE, int, HWND FAR *, LPSTR, int, BOOL FAR *,
			     BOOL FAR *, int FAR *);
WORD FAR PASCAL DDEUnregisterTopic (HWND);

typedef DDEACK near *PDDEACK;
typedef DDEACK near *NPDDEACK;
typedef DDEACK far *LPDDEACK;
typedef DDEADVISE near *PDDEADVISE;
typedef DDEADVISE near *NPDDEADVISE;
typedef DDEADVISE far *LPDDEADVISE;
typedef DDEDATA near *PDDEDATA;
typedef DDEDATA near *NPDDEDATA;
typedef DDEDATA far *LPDDEDATA;
typedef DDEPOKE near *PDDEPOKE;
typedef DDEPOKE near *NPDDEPOKE;
typedef DDEPOKE far *LPDDEPOKE;
