/*
 * FAULT.H
 *
 * Definitions and function prototypes for Fault.
 *
 * Copyright(c) Microsoft Corp. 1992 All Rights Reserved
 */


/*
 * Resource idetifiers and menu ID values.
 */

#define IDR_ICON    1
#define IDR_MENU    1

#define IDM_EXDIVIDEBYZERO  100
#define IDM_EXGPFAULT       101




/*
 * Structure holding the "global" variables.  Creating a structure with
 * has several advantages over separately declaring each field as a
 * global:
 *  1.  Keep source files clean.
 *  2.  Eliminates need for many "extern" declarations.
 *  3.  A single pointer to this structure can be passed throughout
 *      the application, hiding the fact that it's global.
 *  4.  Allows the variables to be allocated dynamically or from
 *      different memory than the application's stack.
 *  5.  Any reference to these variables will have a pointer or
 *      structure dereference, which points to where the variable
 *      actually is defined.  Separate globals are not distinguishable
 *      from locals, making code harder to read.
 */

typedef struct
    {
    HWND            hWnd;               //Top-level application window.
    HANDLE          hInst;              //Application instance handle.
    FARPROC         pfnInt;             //GP Fault Handler
    } GLOBALS;

typedef GLOBALS FAR * LPGLOBALS;


//External:
extern LPGLOBALS     pGlob;
extern CATCHBUF      cbEx;
extern LPCATCHBUF    pcbEx;
extern WORD          wException;


/*
 * Flag values to store in the wException global variable that tells
 * the handler what type of exceptions we specifically want.
 */

#define EXCEPTION_NONE          0x0000      //Turns handling off.
#define EXCEPTION_DIVIDEBYZERO  0x0001
#define EXCEPTION_GPFAULT       0x0002
#define EXCEPTION_ALL           0x0003      //Looks for all exceptions above.


/*
 * Function prototypes.
 */

//FAULT.C
LONG     FAR PASCAL FaultWndProc(HWND, UINT, UINT, LONG);
BOOL     FAR PASCAL FPerformCalculation(void);
HANDLE   FAR PASCAL HAllocateNumbers(void);

//HANDLER.ASM
void     FAR PASCAL ExceptionHandler(void);
