/* PORTMEM.C -- Memory allocation 
 */

#include "port.h"


/* -------- MACINTOSH 68k / POWER PC -------- */

#if ismac || isppc

void	portFatalError(rescode res, short where)
{
	Debugger();
} 

long	memGetMaxAlloc()
{
	long	siz;

	siz = MaxBlock();
	#if isdebug
		if (MemErr()) portFatalError(badmem, 0);
	#endif;
	return siz;
}

long	memGetStackSpace()
{
	long	siz;

	siz = StackSpace();
	#if isdebug
		if (!siz) portFatalError(badmem, 0);
	#endif
	return siz;
}

void	memClear(pmem p, long siz)
{
	memset(p, 0, siz);
	return;
}

void	memSet(pmem p, char c, long siz)
{
	memset(p, c, siz);
	return;
}

void	memCopy(pmem psrc, pmem pdest, long siz)
{
	memcpy(pdest, psrc, siz);
	return;
}

void	memMove(pmem psrc, pmem pdest, long siz)
{
	memmove(pdest, psrc, siz);
	return;
}

pmem		memNew(long siz)
{
	pmem		pdata;
	
	pdata = NewPtr(siz);
	if (LMGetMemErr()) portFatalError(badmem, 0);
	return pdata;
}

void	memDispose(pmem pdata)
{
	DisposPtr(pdata);
	#if isdebug
		if (LMGetMemErr()) portFatalError(badmem, 0);
	#endif
	return;
}

long	memGetSize(pmem pdata)
{
	long size;
	
	size = GetPtrSize(pdata);
	#if isdebug
		if (LMGetMemErr()) portFatalError(badmem, 0);
	#endif
	return size;
}

#endif	// if ismac || isppc


/* -------- WINDOWS 31/95/NT -------- */

#if	iswin

void portFatalError(rescode type, short num)
{
	char	*msg;
	char	msgs[80];

	switch (type) {
		case badsid:	msg="bad star id: %d";				break;
		case badsiz:	msg="bad star file size: %d";		break;
		case badmem:	msg="memory error: %d";				break;
		case badmat:	msg="bad star file version: %d";	break;
		case badfil:	msg="file error: %d";				break;
		case badtxt:	msg="text error: %d";				break;
		case badlok:	msg="bad lock use count: %d";		break;
		case badlog:	msg="logic error: %d";				break;
		default:		msg="undefined %d";					break;
	}
	sprintf(msgs, msg, num);
	#if istest
	DebugBreak();
	#else
	FatalAppExit(0, msgs);
	#endif
}

long	memGetMaxAlloc()
{
	MEMORYSTATUS	ms;
	DWORD			siz;
    
	ms.dwLength = sizeof(MEMORYSTATUS);
	GlobalMemoryStatus(&ms);
	siz = ms.dwAvailVirtual;
	if (ms.dwAvailPageFile < siz) siz = ms.dwAvailPageFile;
	return (long) siz;
}

long	memGetStackSpace()
{
	return memGetMaxAlloc();
}

void	memClear(pmem pdata, long siz)
{
	ZeroMemory((PVOID)pdata, (DWORD) siz);
	return;
}

void	memSet(pmem pdata, char c, long siz)
{
	FillMemory((PVOID)pdata, (DWORD)siz, (BYTE)c);
	return;
}

void	memCopy(pmem psrc, pmem pdest, long siz)
{
	CopyMemory((PVOID)pdest, (PVOID)psrc, (DWORD)siz);
	return;
}

void	memMove(pmem psrc, pmem pdest, long siz)
{
	MoveMemory((PVOID)pdest, (PVOID)psrc, (DWORD)siz);
	return;
}

pmem	memNew(long siz)
{
	LPSTR		p;
   
	if (siz <= 0) siz = 1;
	p = (LPSTR) GlobalAlloc(GMEM_FIXED, siz);
	if (!p) portFatalError(badmem, 0);
	return (pmem) p;
}

void	memDispose(pmem pdata)
{	
	HGLOBAL		res;	

	res = GlobalFree((HANDLE)pdata);
	#if isdebug
		if (res) portFatalError(badmem, 0);
	#endif
	return;
}

long	memGetSize(pmem pdata)
{
	DWORD	size;

	#if isdebug
		if (GlobalFlags((HANDLE)pdata) == GMEM_INVALID_HANDLE) 
			portFatalError(badmem, 0);
	#endif
	size = GlobalSize((HANDLE)pdata);
	#if isdebug
		if (!size) portFatalError(badmem, 0);
	#endif
	return (long) size;
}

#endif	// if iswin


