#include "port.h"

HINSTANCE globinst;
HWND hwndmain, hwnddlg;

waveRate	rate = waveRate22k;
waveBits	bits = waveBits8;
waveSpeak	speak = waveSpeakMono;
int			mixeropen = 0;
int			numchan = 0;
int			numchancur = 0;
int			chanloaded[9];
mixSound	chansound[9];
handle		chanhand[9];
int			chanmute[9];
int			chanloop[9];
DWORD		chanlooptrigms[9];
int			chanlooprate[9];
int			chanvol[9];
int			chanbal[9];

static void closemixer(void)
{
	if (!mixeropen) return;
	mixeropen = 0;
	mixClose();
}

static void setchannelmixvol(short num, short now);

static void openmixer(void)
{
	short	i;

	if (mixeropen) closemixer();
	mixOpen((short)numchan,speak,rate,bits);
	mixeropen = 1;
	for (i=0; i<numchan; i++)
  		setchannelmixvol(i+(short)1, (short)0);
}

static void setrate(waveRate r)
{
	switch (r)
	{
		case waveRate11k: CheckRadioButton(hwnddlg,2,4,2); break;
		case waveRate22k: CheckRadioButton(hwnddlg,2,4,3); break;
		case waveRate44k: CheckRadioButton(hwnddlg,2,4,4); break;
	}
	if (rate != r) {
		closemixer();
		rate = r;
		openmixer();
	}
}

static void setbits(waveBits b)
{
	switch (b)
	{
		case waveBits8:  CheckRadioButton(hwnddlg,5,6,5); break;
		case waveBits16: CheckRadioButton(hwnddlg,5,6,6); break;
	}
	if (bits != b) {
		closemixer();
		bits = b;
		openmixer();
	}
}

static void setspeak(waveSpeak s)
{
	switch (s)
	{
		case waveSpeakMono:   CheckRadioButton(hwnddlg,7,8,7); break;
		case waveSpeakStereo: CheckRadioButton(hwnddlg,7,8,8); break;
	}
	if (speak != s) {
		closemixer();
		speak = s;
		openmixer();
	}
}

typedef struct
{
	long	samplesleft;
	long	samplesize;
	long	blocksize;
} ourcodecData, *pourcodecData;

void ourcodecRend(pmem psrc, pmem pdst, pourcodecData ourdata)
{
	long	bytesthis;

	bytesthis = ourdata->samplesleft * ourdata->samplesize;
	if (bytesthis > ourdata->blocksize) bytesthis = ourdata->blocksize;
	memCopy(psrc, pdst, bytesthis);
	return;
}

void ourcodecInit(pmixSound pms, pourcodecData ourdata)
{
	ourdata->samplesleft = pms->samples;
	ourdata->samplesize = (long)pms->bits * (long)pms->speak;
	ourdata->blocksize = 256;
	return;
}

static void installourcodec()
{
	mixCodec mc;

	mc.type = mixCodecCyberflix;
	mc.blocksize = 256;
	mc.datasize = 16;
	mc.rendfn = ourcodecRend;
	mc.initfn = ourcodecInit;
	mixInstallCodec(&mc);
	return;
}

static short readwavefile(char *szFileName, int chan)
{
    HMMIO           hmmio;
    MMCKINFO        mmckinfoParent;
    MMCKINFO        mmckinfoSubchunk;
    DWORD           dwFmtSize;
    HANDLE          hFormat;
    WAVEFORMAT      *pFormat;
    DWORD           dwDataSize;
    HANDLE          hData       = NULL;
    HPSTR           lpData      = NULL;
	mixSound		ms;

    /* Open the given file for reading using buffered I/O.
     */
    if(!(hmmio = mmioOpen(szFileName, NULL, MMIO_READ | MMIO_ALLOCBUF)))
    {
        MessageBox(hwnddlg, "Failed to open file.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        return 1;
    }

    /* Locate a 'RIFF' chunk with a 'WAVE' form type
     * to make sure it's a WAVE file.
     */
    mmckinfoParent.fccType = mmioFOURCC('W', 'A', 'V', 'E');
    if (mmioDescend(hmmio, (LPMMCKINFO) &mmckinfoParent, NULL, MMIO_FINDRIFF))
    {
        MessageBox(hwnddlg, "This is not a WAVE file.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        mmioClose(hmmio, 0);
        return 1;
    }

    /* Now, find the format chunk (form type 'fmt '). It should be
     * a subchunk of the 'RIFF' parent chunk.
     */
    mmckinfoSubchunk.ckid = mmioFOURCC('f', 'm', 't', ' ');
    if (mmioDescend(hmmio, &mmckinfoSubchunk, &mmckinfoParent,
        MMIO_FINDCHUNK))
    {
        MessageBox(hwnddlg, "WAVE file is corrupted.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        mmioClose(hmmio, 0);
        return 1;
    }

    /* Get the size of the format chunk, allocate and lock memory for it.
     */
    dwFmtSize = mmckinfoSubchunk.cksize;
    hFormat = LocalAlloc(LMEM_MOVEABLE, LOWORD(dwFmtSize));
    if (!hFormat)
    {
        MessageBox(hwnddlg, "Out of memory.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        mmioClose(hmmio, 0);
        return 1;
    }
    pFormat = (WAVEFORMAT *) LocalLock(hFormat);
    if (!pFormat)
    {
        MessageBox(hwnddlg, "Failed to lock memory for format chunk.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        LocalFree( hFormat );
        mmioClose(hmmio, 0);
        return 1;
    }

    /* Read the format chunk.
     */
    if (mmioRead(hmmio, (HPSTR) pFormat, dwFmtSize) != (LONG) dwFmtSize)
    {
        MessageBox(hwnddlg, "Failed to read format chunk.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        LocalUnlock( hFormat );
        LocalFree( hFormat );
        mmioClose(hmmio, 0);
        return 1;
    }

    /* Make sure it's a PCM file.
     */
    if (pFormat->wFormatTag != WAVE_FORMAT_PCM)
    {
        LocalUnlock( hFormat );
        LocalFree( hFormat );
        mmioClose(hmmio, 0);
        MessageBox(hwnddlg, "The file is not a PCM file.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        return 1;
    }

    /* Ascend out of the format subchunk.
     */
    mmioAscend(hmmio, &mmckinfoSubchunk, 0);

    /* Find the data subchunk.
     */
    mmckinfoSubchunk.ckid = mmioFOURCC('d', 'a', 't', 'a');
    if (mmioDescend(hmmio, &mmckinfoSubchunk, &mmckinfoParent,
        MMIO_FINDCHUNK))
    {
        MessageBox(hwnddlg, "WAVE file has no data chunk.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        LocalUnlock( hFormat );
        LocalFree( hFormat );
        mmioClose(hmmio, 0);
        return 1;
    }

    /* Get the size of the data subchunk.
     */
    dwDataSize = mmckinfoSubchunk.cksize;
    if (dwDataSize == 0L)
    {
        MessageBox(hwnddlg, "The data chunk has no data.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        LocalUnlock( hFormat );
        LocalFree( hFormat );
        mmioClose(hmmio, 0);
        return 1;
    }

	switch (pFormat->nChannels)
	{
		case 1:
			ms.speak = waveSpeakMono; break;
		case 2:
			ms.speak = waveSpeakStereo; break;
	}								  
	switch (pFormat->nSamplesPerSec)
	{
		case 11025:
			ms.rate = waveRate11k; break;
		case 22050:
			ms.rate = waveRate22k; break;
		default:
		case 44100:
			ms.rate = waveRate44k; break;
	}
	switch (pFormat->nBlockAlign / pFormat->nChannels)
	{
		case 1:
			ms.bits = waveBits8; break;
		case 2:
			ms.bits = waveBits16; break;
	}

    /* We're done with the format header, free it.
     */
    LocalUnlock( hFormat );
    LocalFree( hFormat );

    /* Allocate and lock memory for the waveform data.
     */
    hData = GlobalAlloc(GMEM_MOVEABLE , dwDataSize );
                       /* GMEM_SHARE is not needed on 32 bits */
    if (!hData)
    {
        MessageBox(hwnddlg, "Out of memory.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        mmioClose(hmmio, 0);
        return 1;
    }
    lpData = GlobalLock(hData);
    if (!lpData)
    {
        MessageBox(hwnddlg, "Failed to lock memory for data chunk.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        GlobalFree( hData );
        mmioClose(hmmio, 0);
        return 1;
    }

    /* Read the waveform data subchunk.
     */
    if(mmioRead(hmmio, (HPSTR) lpData, dwDataSize) != (LONG) dwDataSize)
    {
        MessageBox(hwnddlg, "Failed to read data chunk.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        GlobalUnlock( hData );
        GlobalFree( hData );
        mmioClose(hmmio, 0);
        return 1;
    }

    /* We're done with the file, close it.
     */
    mmioClose(hmmio, 0);

	chanhand[chan] = hData;
	ms.pdata = lpData;
	ms.samples = dwDataSize / (long) (ms.bits*ms.speak);
	ms.type = mixCodecPCM;
	mixVolCreate(&ms.vol, 1.0, 1.0);
	chansound[chan] = ms;
	chanloaded[chan] = 1;
	return 0;
}

static void disablechannel(short num);
static void enablechannel(short num);

static void unloadchan(short num)
{
	if (!chanloaded[num]) return;
	chanloaded[num] = 0;
	mixUnplay(chansound[num].pdata);
	GlobalUnlock(chanhand[num]);
	GlobalFree(chanhand[num]);
	enablechannel(num);
}

static void setchannelmixvol(short num, short now)
{
	float	l,r;
	float	t,b;
	mixVol	mv;

	t = (float)chanvol[num] / (float)2048.0;
	b = (float)chanbal[num] / (float)4096.0;
	r = b * t;
	l = ((float)1.0 - b) * t;
	mixVolCreate(&mv, l*2.0,r*2.0);
	mixSetVolume((short)num-(short)1, &mv);
	return;
}

static void loadchan(short num)
{
	int err;
	OPENFILENAME ofn;
	unsigned char tempstring[256], charstring[256], thename[256];
	
	strcpy(tempstring, "");
	charstring[0] = 0;
	thename[0] = 0;
	memset(&ofn, 0, sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hwnddlg;
	ofn.lpstrFilter = "Wave files (.WAV)\0*.wav\0\0";
	ofn.nFilterIndex = 1;
	ofn.lpstrDefExt = "WAV";
	ofn.lpstrFile = thename;
	ofn.nMaxFile = 256;
	ofn.lpstrFileTitle = charstring;
	ofn.nMaxFileTitle = 256;
	ofn.lpstrInitialDir = tempstring;
	ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;
	err = GetOpenFileName(&ofn);
	if (!err) return;
	if (chanloaded[num]) unloadchan(num);
	err = readwavefile(thename, num);
	if (err) return;
	strupr(charstring);
	SetDlgItemText(hwnddlg, num*100+1, charstring);
	strcpy(tempstring, "");
	switch (chansound[num].rate)
	{
		case waveRate11k:  strcat(tempstring, "11kHz"); break;
		case waveRate22k:  strcat(tempstring, "22kHz"); break;
		case waveRate44k:  strcat(tempstring, "44kHz"); break;
	}
	switch (chansound[num].bits)
	{
		case waveBits8:		strcat(tempstring, " 8 bit"); break;
		case waveBits16:	strcat(tempstring, " 16 bit"); break;
	}
	switch (chansound[num].speak)
	{
		case waveSpeakMono:	strcat(tempstring, " mono"); break;
		case waveSpeakStereo: strcat(tempstring, " stereo"); break;
	}
	SetDlgItemText(hwnddlg, num*100+2, tempstring);
	CheckDlgButton(hwnddlg, num*100+3, FALSE);
	EnableWindow(GetDlgItem(hwnddlg,num*100+3), TRUE);
	chanloop[num] = 0;
	CheckDlgButton(hwnddlg, num*100+4, FALSE);
	EnableWindow(GetDlgItem(hwnddlg,num*100+4), TRUE);
	chanmute[num] = 0;

	SetScrollRange(GetDlgItem(hwnddlg,num*100+5), SB_CTL, 100,5000, FALSE);
	SetScrollPos(GetDlgItem(hwnddlg,num*100+5), SB_CTL, 1000, TRUE);
	EnableWindow(GetDlgItem(hwnddlg,num*100+5), TRUE);
	chanlooprate[num] = 1000;

	SetScrollRange(GetDlgItem(hwnddlg,num*100+6), SB_CTL, 0,4096, FALSE);
	SetScrollPos(GetDlgItem(hwnddlg,num*100+6), SB_CTL, 2048, TRUE);
	EnableWindow(GetDlgItem(hwnddlg,num*100+6), TRUE);
	chanvol[num] = 2048;

	SetScrollRange(GetDlgItem(hwnddlg,num*100+7), SB_CTL, 0,4096, FALSE);
	SetScrollPos(GetDlgItem(hwnddlg,num*100+7), SB_CTL, 2048, TRUE);
	EnableWindow(GetDlgItem(hwnddlg,num*100+7), TRUE);
	chanbal[num] = 2048;

	EnableWindow(GetDlgItem(hwnddlg,num*100+8), TRUE);
	EnableWindow(GetDlgItem(hwnddlg,num*100+9), TRUE);
	setchannelmixvol(num, 0);
 }

static void enablechannel(short num)
{
	SetDlgItemText(hwnddlg,num*100+1, "[NONE]");
	SetDlgItemText(hwnddlg,num*100+2, "");
	
	CheckDlgButton(hwnddlg, num*100+3, FALSE);
	EnableWindow(GetDlgItem(hwnddlg,num*100+3), FALSE);
	CheckDlgButton(hwnddlg, num*100+4, FALSE);
	EnableWindow(GetDlgItem(hwnddlg,num*100+4), FALSE);

	SetScrollRange(GetDlgItem(hwnddlg,num*100+5), SB_CTL, 0,0, TRUE);
	EnableWindow(GetDlgItem(hwnddlg,num*100+5), FALSE);
	SetScrollRange(GetDlgItem(hwnddlg,num*100+6), SB_CTL, 0,0, TRUE);
	EnableWindow(GetDlgItem(hwnddlg,num*100+6), FALSE);
	SetScrollRange(GetDlgItem(hwnddlg,num*100+7), SB_CTL, 0,0, TRUE);
	EnableWindow(GetDlgItem(hwnddlg,num*100+7), FALSE);

	EnableWindow(GetDlgItem(hwnddlg,num*100+8), TRUE);
	EnableWindow(GetDlgItem(hwnddlg,num*100+9), FALSE);
}

static void disablechannel(short num)
{
	SetDlgItemText(hwnddlg,num*100+1, "[UNUSED]");
	SetDlgItemText(hwnddlg,num*100+2, "");
	
	CheckDlgButton(hwnddlg, num*100+3, FALSE);
	EnableWindow(GetDlgItem(hwnddlg,num*100+3), FALSE);
	CheckDlgButton(hwnddlg, num*100+4, FALSE);
	EnableWindow(GetDlgItem(hwnddlg,num*100+4), FALSE);

	SetScrollRange(GetDlgItem(hwnddlg,num*100+5), SB_CTL, 0,0, FALSE);
	EnableWindow(GetDlgItem(hwnddlg,num*100+5), FALSE);
	SetScrollRange(GetDlgItem(hwnddlg,num*100+6), SB_CTL, 0,0, FALSE);
	EnableWindow(GetDlgItem(hwnddlg,num*100+6), FALSE);
	SetScrollRange(GetDlgItem(hwnddlg,num*100+7), SB_CTL, 0,0, FALSE);
	EnableWindow(GetDlgItem(hwnddlg,num*100+7), FALSE);

	EnableWindow(GetDlgItem(hwnddlg,num*100+8), FALSE);
	EnableWindow(GetDlgItem(hwnddlg,num*100+9), FALSE);
	chanloop[num] = 0;
	if (chanloaded[num]) unloadchan(num);
}

static void setnumchan(short num)
{
	short	i;

	SetScrollRange(GetDlgItem(hwnddlg,10), SB_CTL, 1,8, FALSE);
	SetScrollPos(GetDlgItem(hwnddlg,10), SB_CTL, num, FALSE);
	SetDlgItemInt(hwnddlg,9,num,TRUE);
	for (i=numchancur; i<num; i++)
		enablechannel((short)i+(short)1);
	for (i=num; i<8; i++)
		disablechannel((short)i+(short)1);
	numchancur = num;
	closemixer();
	numchan = num;
	openmixer();
}

static void chanreloop(short chan)
{
	if (chanloop[chan])
	{
		chanlooptrigms[chan] = 0;
	}
	chanloop[chan] = IsDlgButtonChecked(hwnddlg, 100*chan + 4);
	if (chanloop[chan])
	{
		chanlooptrigms[chan] = timeGetTime() + chanlooprate[chan];
	}
	return;
}

static void checkevents()
{
	short	i;
	DWORD	t;

	if (!mixeropen) return;
	t = timeGetTime();
	for (i=1; i<=numchan; i++)
		if (chanloop[i] && chanlooptrigms[i] && t>=chanlooptrigms[i])
		{
			mixPlay(i-(short)1, chansound+i);
			chanlooptrigms[i] = t + chanlooprate[i];
		}
	mixPump();
	return;
}

static void dialoginit(void)
{
	RECT	rdlg;
	int		w,h,i;

	ShowWindow(hwnddlg, SW_SHOW);
	ShowWindow(hwndmain, SW_SHOW);
	GetWindowRect(hwnddlg, &rdlg);
	AdjustWindowRectEx(&rdlg, WS_TILEDWINDOW, FALSE, 0);
	w = rdlg.right - rdlg.left;
	h = rdlg.bottom -rdlg.top;
	SetWindowPos(hwndmain, HWND_TOP, 0,0,w,h, SWP_NOMOVE|SWP_SHOWWINDOW);
	for (i=0; i<8; i++)
		chanloaded[i] = 0;
	setnumchan(4);
	setrate(waveRate22k);
	setbits(waveBits8);
	setspeak(waveSpeakMono);
	return;	
}

int handlescroll(WPARAM wp, LPARAM lp, int *pos, int mn, int mx)
{
	int nScrollCode = (int) LOWORD(wp);  // scroll bar value     
	short nPos = (short int) HIWORD(wp);   // scroll box position  
	HWND hwndScrollBar = (HWND) lp;       // handle of scroll bar
	int	x;
	  
	switch (nScrollCode)
	{
		case SB_BOTTOM:		x = mx; break;
		case SB_ENDSCROLL:	x = *pos; break;
		case SB_LINELEFT:	x = *pos - 1; break;
		case SB_LINERIGHT:	x = *pos + 1; break;
		case SB_PAGELEFT:	x = *pos - 1; break;
		case SB_PAGERIGHT:	x = *pos + 1; break;
		case SB_THUMBPOSITION:	x = nPos; break;
		case SB_THUMBTRACK:	x = *pos; break;
		case SB_TOP:		x = mn; break;
	}
	if (x<mn) x = mn;
	if (x>mx) x = mx;
	if (x == *pos) return 0;
	*pos = x;
	SetScrollPos(hwndScrollBar, SB_CTL, x, TRUE);
	return 1;
}

int	bsiz, bahead, ppos, pmix, cformat;
HWND hwndhw;
char *formatstr;

void updateradio()
{
	switch (((rate-1)<<2) | ((bits-1)<<1) | (speak-1))
	{
		case 0: CheckRadioButton(hwndhw,51,62,51); break;
		case 1: CheckRadioButton(hwndhw,51,62,52); break;
		case 2: CheckRadioButton(hwndhw,51,62,53); break;
		case 3: CheckRadioButton(hwndhw,51,62,54); break;
		case 4: CheckRadioButton(hwndhw,51,62,55); break;
		case 5: CheckRadioButton(hwndhw,51,62,56); break;
		case 6: CheckRadioButton(hwndhw,51,62,57); break;
		case 7: CheckRadioButton(hwndhw,51,62,58); break;
		case 12: CheckRadioButton(hwndhw,51,62,59); break;
		case 13: CheckRadioButton(hwndhw,51,62,60); break;
		case 14: CheckRadioButton(hwndhw,51,62,61); break;
		case 15: CheckRadioButton(hwndhw,51,62,62); break;
	}
	switch (bsiz)
	{
		case 512: CheckRadioButton(hwndhw,21,26,21); break;
		case 1024: CheckRadioButton(hwndhw,21,26,22); break;
		case 2048: CheckRadioButton(hwndhw,21,26,23); break;
		case 4096: CheckRadioButton(hwndhw,21,26,24); break;
		case 8192: CheckRadioButton(hwndhw,21,26,25); break;
		case 16384: CheckRadioButton(hwndhw,21,26,26); break;
	}
	switch (bahead)
	{
		case 1: CheckRadioButton(hwndhw, 11,18,11); break;
		case 2: CheckRadioButton(hwndhw, 11,18,12); break;
		case 3: CheckRadioButton(hwndhw, 11,18,13); break;
		case 4: CheckRadioButton(hwndhw, 11,18,14); break;
		case 5: CheckRadioButton(hwndhw, 11,18,15); break;
		case 6: CheckRadioButton(hwndhw, 11,18,16); break;
		case 7: CheckRadioButton(hwndhw, 11,18,17); break;
		case 8: CheckRadioButton(hwndhw, 11,18,18); break;
	}
	if (pmix) CheckRadioButton(hwndhw, 31,32,31);
	else CheckRadioButton(hwndhw, 31,32,32);
	if (ppos) CheckRadioButton(hwndhw, 41,42,41);
	else CheckRadioButton(hwndhw, 41,42,42);
	return;
}

#define inifile		"portwave.ini"
#define bakfile		"portwave.bak"
extern char	drivername[32];
extern UINT outdev;

void getcurhw()
{
	char	formatstr[32];
	char	datastr[32];
	char	verstr[32];
	WAVEOUTCAPS		woc;

	sprintf(formatstr, "%dbit%dkhz%s", bits==waveBits8 ? 8 :16,
			11 * (int)rate, speak==waveSpeakMono ? "mono" : "stereo");
	GetPrivateProfileString(drivername, formatstr, "", datastr,
			sizeof(datastr), inifile); 
	if (4 != sscanf(datastr, "%d %d %d %d", &bsiz, &bahead, 
		&pmix, &ppos))
	{
		GetPrivateProfileString("default", formatstr, "", datastr,
				sizeof(datastr), inifile); 
		if (4 != sscanf(datastr, "%d %d %d %d", &bsiz, &bahead, 
			&pmix, &ppos)) portFatalError(badlog, 0);
		waveOutGetDevCaps(outdev, &woc, sizeof(WAVEOUTCAPS));
		WritePrivateProfileString(drivername, "name", woc.szPname, inifile);
		sprintf(verstr, "%d.%d", (int)HIBYTE(woc.vDriverVersion), 
			(int)LOBYTE(woc.vDriverVersion));
		WritePrivateProfileString(drivername, "version", verstr, inifile);
		WritePrivateProfileString(drivername, "whatversion", "thishilo", inifile);
		WritePrivateProfileString(drivername, formatstr, datastr, inifile);
	}
	updateradio();
}

void setcurhw()
{
	char	formatstr[32];
	char	datastr[32];
	char	windir[128], bakfil[128];

	GetWindowsDirectory(windir, 128);
	strcpy(bakfil, windir);
	strcat(windir, "\\" inifile);
	strcat(bakfil, "\\" bakfile);	
	CopyFile(windir, bakfil, FALSE);
	sprintf(formatstr, "%dbit%dkhz%s", bits==waveBits8 ? 8 :16,
			11 * (int)rate, speak==waveSpeakMono ? "mono" : "stereo");
	sprintf(datastr, "%d %d %d %d", bsiz, bahead, pmix, ppos);
	WritePrivateProfileString(drivername, formatstr, datastr, inifile);
	updateradio();
}

void copycurhw()
{
}


BOOL CALLBACK hwdlgproc(HWND hwnd, UINT msg, WPARAM wp, LPARAM lp)
{
	WORD	ncod;
	WORD	id;
	HWND	hctl;

	switch (msg)
	{
		case WM_INITDIALOG:
			hwndhw = hwnd;
			getcurhw();
			return TRUE;
		case WM_COMMAND:
			ncod = HIWORD(wp);
			id = LOWORD(wp);
			hctl = (HWND) lp;
			switch (ncod)
			{
				case BN_CLICKED:	  
					switch (id/10)
					{
						case 1: bahead = id%10; setcurhw(); break;
						case 2: bsiz = (1<<(id%10))*256; setcurhw(); break;
						case 3: pmix = (id%10)==1; setcurhw(); break;
						case 4: ppos = (id%10)==1; setcurhw(); break;
						case 5:
						case 6: 
							switch (id-50)
							{
								case 1: rate=waveRate11k; bits=waveBits8;
										speak=waveSpeakMono; break;
								case 2: rate=waveRate11k; bits=waveBits8;
										speak=waveSpeakStereo; break;
								case 3: rate=waveRate11k; bits=waveBits16;
										speak=waveSpeakMono; break;
								case 4: rate=waveRate11k; bits=waveBits16;
										speak=waveSpeakStereo; break;
								case 5: rate=waveRate22k; bits=waveBits8;
										speak=waveSpeakMono; break;
								case 6: rate=waveRate22k; bits=waveBits8;
										speak=waveSpeakStereo; break;
								case 7: rate=waveRate22k; bits=waveBits16;
										speak=waveSpeakMono; break;
								case 8: rate=waveRate22k; bits=waveBits16;
										speak=waveSpeakStereo; break;
								case 9: rate=waveRate44k; bits=waveBits8;
										speak=waveSpeakMono; break;
								case 10:rate=waveRate44k; bits=waveBits8;
										speak=waveSpeakStereo; break;
								case 11:rate=waveRate44k; bits=waveBits16;
										speak=waveSpeakMono; break;
								case 12:rate=waveRate44k; bits=waveBits16;
										speak=waveSpeakStereo; break;
							}
							getcurhw();
							break;
						case 7: copycurhw(); break;
						case 0:	
							EndDialog(hwnd, 0);
							break;
					}
					break;
			
			}
			return TRUE;
		default:
			return FALSE;
	}
	return TRUE;
}

BOOL CALLBACK dialogfn(HWND hwnd, UINT msg, WPARAM wp, LPARAM lp)
{
	WORD	ncod;
	WORD	id;
	HWND	hctl;
	short	chan;

	switch (msg)
	{
		case WM_INITDIALOG:
			hwnddlg = hwnd;
			dialoginit();
			return TRUE;
		case WM_HSCROLL:
		{
			int id = GetDlgCtrlID((HWND)lp);
			int chan;

			chan = id / 100;
			id = id % 100;
			if (chan==0)
			{
				if (handlescroll(wp,lp, &numchan, 1,8))
				 	setnumchan(numchan);
			}
			else switch (id)
			{
				case 5:
					if (handlescroll(wp,lp, &chanlooprate[chan], 50,5000))
					 	chanreloop(chan);
					break;
				case 6:
					if (handlescroll(wp,lp, &chanvol[chan], 0,4096))
					 	setchannelmixvol(chan, 0);
					break;
				case 7:
					if (handlescroll(wp,lp, &chanbal[chan], 0,4096))
					 	setchannelmixvol(chan, 0);
					break;
			}
			return TRUE;
		}
		case WM_COMMAND:
			ncod = HIWORD(wp);
			id = LOWORD(wp);
			hctl = (HWND) lp;
			chan = id / 100;
			id = id % 100;
			if (chan==0)
				switch (ncod)
				{
					case BN_CLICKED:
						switch (id)
						{
							case 1:
								EndDialog(hwnd, 0);
								PostQuitMessage(0);
								break;
							case 2:
								setrate(waveRate11k); break;
							case 3:
								setrate(waveRate22k); break;
							case 4:
								setrate(waveRate44k); break;
							case 5:
								setbits(waveBits8); break;
							case 6:
								setbits(waveBits16); break;
							case 7:
								setspeak(waveSpeakMono); break;
							case 8:
								setspeak(waveSpeakStereo); break;
							case 11:
								closemixer();
								DialogBox(globinst, MAKEINTRESOURCE(2), hwnd, hwdlgproc);
								setrate(rate);
								setbits(bits);
								setspeak(speak);
								openmixer();
								break;  
						}
						break;
				
				}
			else
				switch (ncod)
				{
					case BN_CLICKED:
						switch (id)
						{
							case 3:
								break;
							case 4:
								chanreloop(chan);
								break;
							case 8:
								loadchan(chan);		
								break;
							case 9:
								mixPlay(chan-1, chansound + chan);
								break;
						}
				}
			return TRUE;
		default:
			return FALSE;
	}
	return TRUE;
}

LRESULT CALLBACK wndproc(HWND hwnd, UINT msg, WPARAM wp, LPARAM lp)
{
	switch (msg)
	{
		case WM_DESTROY:
			closemixer();
			return 0;
//		case WM_TIMER:
//			checkevents();
//			break;
		case WM_CREATE:
			return 0;
		default:
			return DefWindowProc(hwnd, msg, wp, lp);
	}
	return 0;
}


int WINAPI WinMain(HINSTANCE hinst, HINSTANCE hinstprev, LPSTR cmdline, int cshow)
{
	WNDCLASS	wc;
	MSG			msg;

	globinst = hinst;

	wc.style = CS_PARENTDC;
    wc.lpfnWndProc = wndproc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hinst;
    wc.hIcon = LoadIcon(0,IDI_APPLICATION);
    wc.hCursor = LoadCursor(0,IDC_ARROW);
    wc.hbrBackground = GetStockObject(GRAY_BRUSH);
    wc.lpszMenuName = 0;
    wc.lpszClassName = "MIXTEST";

	RegisterClass(&wc);
	hwndmain = CreateWindow("MIXTEST", "Mixer Test", WS_TILEDWINDOW, 
		CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, 
		0, 0, hinst, 0);
	ShowWindow(hwndmain, SW_SHOW);
	CreateDialog(globinst, MAKEINTRESOURCE(1), hwndmain, dialogfn);

	while (1) 
	{
		if (PeekMessage(&msg, NULL, 0,0, PM_REMOVE))
		{
			if (msg.message == WM_QUIT) break;
		   	TranslateMessage(&msg);
			DispatchMessage(&msg); 
		}
		checkevents();
	}

	return 0;
}
