/*
 *    Graybutt Graying Buttons Demo
 *
 *    Kraig Brockschmidt
 *    Microsoft WinSDK Suport
 *
 *    (c)1990 Kraig Brockschmidt
 *    All rights reserved.
 *
 */

#include <windows.h>
#include "graybutt.h"


HBRUSH      hBrush;
HBITMAP     hBitmap;
WORD        rgwBricks[]={0x0f, 0x8B, 0xDD, 0xB8, 0x70, 0xE8, 0xDD, 0x8E};
char        szAppName[]="GrayButt";



int PASCAL WinMain (hInstance, hPrevInstance, lpszCmdLine, nCmdShow)
    HANDLE	hInstance, hPrevInstance;
    LPSTR	lpszCmdLine;
    int 	nCmdShow;
    {
    HWND        hWnd;
    HWND        hWndEdit;
    MSG         msg;
    WNDCLASS	wndclass;


    if (!hPrevInstance)
        {
        wndclass.style          = CS_HREDRAW | CS_VREDRAW;
        wndclass.lpfnWndProc    = GrayWndProc;
        wndclass.cbClsExtra     = 0;
        wndclass.cbWndExtra     = 0;
        wndclass.hInstance      = hInstance;
        wndclass.hIcon          = LoadIcon(NULL, IDI_ASTERISK);
        wndclass.hCursor        = LoadCursor(NULL, IDC_ARROW);
        wndclass.hbrBackground  = GetStockObject(WHITE_BRUSH);
        wndclass.lpszMenuName   = NULL;
        wndclass.lpszClassName  = szAppName;

        if (!RegisterClass(&wndclass))
            return FALSE;
        }

    hWnd=CreateDialog(hInstance, szAppName, 0, NULL);

    /*
     * This has to go here since Windows bombs if an edit is in a
     * dialog statment and we use CreateDialog for the main Window.
     */
    hWndEdit=CreateWindow("edit", "Edit",
                          WS_CHILD | ES_LEFT | WS_VISIBLE | WS_BORDER,
                           7, 4, 50, 20, hWnd,
                          ID_EDIT, hInstance, NULL);

    hBitmap=CreateBitmap(8,8,1,1, (LPSTR)rgwBricks);
    hBrush=CreatePatternBrush(hBitmap);


    ShowWindow(hWnd, nCmdShow);

    while (GetMessage(&msg, NULL, 0,0 ))
        {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
        }

    DeleteObject(hBitmap);
    DeleteObject(hBrush);

    return msg.wParam;
    }



long FAR PASCAL GrayWndProc (hWnd, iMessage, wParam, lParam)
    HWND          hWnd;
    unsigned	  iMessage;
    WORD          wParam;
    LONG          lParam;
    {
    short         nIndex;
    static BOOL   bFirstPaint=TRUE;



    switch (iMessage)
        {
        case WM_DESTROY:
            PostQuitMessage(0);
            break;

        case WM_COMMAND:
            if (wParam==ID_RADIO)
                {
                for (nIndex=ID_CHECK; nIndex<=ID_AUTO; nIndex++)
                    EnableWindow(GetDlgItem(hWnd, nIndex), FALSE);
                }

            break;

        case WM_CTLCOLOR:
            if (HIWORD(lParam)==CTLCOLOR_LISTBOX && bFirstPaint)
                {
                CheckDlgButton(hWnd, ID_RADIO, 2);
                CheckDlgButton(hWnd, ID_CHECK, 2);
                CheckDlgButton(hWnd, ID_AUTO,  0);
                bFirstPaint=FALSE;
                return (GetStockObject(LTGRAY_BRUSH));
                }
            else
                if (HIWORD(lParam)==CTLCOLOR_SCROLLBAR)
                    return hBrush;

            return (GetStockObject(WHITE_BRUSH));


        default:
            return (DefWindowProc(hWnd, iMessage, wParam, lParam));
        }
    return 0L;
    }
