/*
	DEFKEYS.CPP - Eine allgemeine Windows Klasse
	(C) 1990 by Joachim Kainz 'On a mission from Bhudda'
*/
	#include "windows.hpp"

	METHOD WINDOW::WndKeyProc (WORD wMsg, WORD wParam, long lParam)
	{
		switch (wMsg) {

		  case WM_KEYDOWN:
			return WMKeyDown	(
						wParam,
						LOWORD (lParam),
						HIWORD (lParam)
				   );

		  case WM_KEYUP:
			return WMKeyUp			(
						wParam,
						LOWORD (lParam),
						HIWORD (lParam)
				   );

		  case WM_CHAR:
			return WMChar				(
						wParam,
						LOWORD (lParam),
						HIWORD (lParam)
				   );

		  case WM_DEADCHAR:
			return WMDeadChar			(
						wParam,
						LOWORD (lParam),
						HIWORD (lParam)
				   );

		  case WM_SYSKEYDOWN:
			return WMSysKeyDown		(
						wParam,
						LOWORD (lParam),
						HIWORD (lParam)
				   );

		  case WM_SYSKEYUP:
			return WMSysKeyUp			(
						wParam,
						LOWORD (lParam),
						HIWORD (lParam)
				   );

		  case WM_SYSCHAR:
			return WMSysChar			(
						wParam,
						LOWORD (lParam),
						HIWORD (lParam)
				   );

		  case WM_SYSDEADCHAR:
			return WMSysDeadChar		(
						wParam,
						LOWORD (lParam),
						HIWORD (lParam)
				   );

		}

		return DefWindowProc (GetWindowHandle (), wMsg, wParam, lParam);
	}

	METHOD WINDOW::WMKeyDown (WORD wKey, WORD wRepeat, WORD wExtended)
	{
		return DefWindowProc (
					GetWindowHandle (),
					WM_KEYDOWN,
					wKey,
					MAKELONG (wRepeat, wExtended)
			   );
	}

	METHOD WINDOW::WMKeyUp (WORD wKey, WORD wRepeat, WORD wExtended)
	{
		return DefWindowProc (
					GetWindowHandle (),
					WM_KEYUP,
					wKey,
					MAKELONG (wRepeat, wExtended)
			   );
	}

	METHOD WINDOW::WMSysKeyDown (WORD wKey, WORD wRepeat, WORD wExtended)
	{
		return DefWindowProc (
					GetWindowHandle (),
					WM_SYSKEYDOWN,
					wKey,
					MAKELONG (wRepeat, wExtended)
			   );
	}

	METHOD WINDOW::WMSysKeyUp (WORD wKey, WORD wRepeat, WORD wExtended)
	{
		return DefWindowProc (
					GetWindowHandle (),
					WM_SYSKEYUP,
					wKey,
					MAKELONG (wRepeat, wExtended)
			   );
	}

	METHOD WINDOW::WMSysChar (WORD wKey, WORD wRepeat, WORD wExtended)
	{
		return DefWindowProc (
					GetWindowHandle (),
					WM_SYSCHAR,
					wKey,
					MAKELONG (wRepeat, wExtended)
			   );
	}
