/*
	DEFNC.CPP - Eine allgemeine Windows Klasse
	(C) 1990 by Joachim Kainz 'On a mission from Bhudda'
*/
	#include "windows.hpp"

	METHOD WINDOW::WndNCProc (WORD wMsg, WORD wParam, long lParam)
	{
		switch (wMsg) {

		  case WM_NCCREATE:
			return WMNCCreate (wParam, (LPCREATESTRUCT) lParam);

		  case WM_NCDESTROY:
			return WMNCDestroy ();

		  case WM_NCCALCSIZE:
			return WMNCCalcSize ((LPRECT) lParam);

		  case WM_NCHITTEST:
			return WMNCHitTest (MAKEPOINT (lParam));

		  case WM_NCPAINT:
			return WMNCPaint (wParam);

		  case WM_NCACTIVATE:
			return WMNCActivate (wParam);

		  case WM_GETDLGCODE:
			return WMGetDlgCode ();

		  case WM_NCMOUSEMOVE:
			return WMNCMouseMove (wParam, MAKEPOINT (lParam));

		  case WM_NCLBUTTONDOWN:
			return WMNCLButtonDown (wParam, MAKEPOINT (lParam));

		  case WM_NCLBUTTONUP:
			return WMNCLButtonUp (wParam, MAKEPOINT (lParam));

		  case WM_NCLBUTTONDBLCLK:
			return WMNCLButtonDblClk (wParam, MAKEPOINT (lParam));

		  case WM_NCRBUTTONDOWN:
			return WMNCRButtonDown (wParam, MAKEPOINT (lParam));

		  case WM_NCRBUTTONUP:
			return WMNCRButtonUp	(wParam, MAKEPOINT (lParam));

		  case WM_NCRBUTTONDBLCLK:
			return WMNCRButtonDblClk (wParam, MAKEPOINT (lParam));

		  case WM_NCMBUTTONDOWN:
			return WMNCMButtonDown (wParam, MAKEPOINT (lParam));

		  case WM_NCMBUTTONUP:
			return WMNCMButtonUp (wParam, MAKEPOINT (lParam));

		  case WM_NCMBUTTONDBLCLK:
			return WMNCMButtonDblClk (wParam, MAKEPOINT (lParam));

		}

		return DefWindowProc (GetWindowHandle (), wMsg, wParam, lParam);
	}

	METHOD WINDOW::WMNCCreate(HWND hNew, LPCREATESTRUCT lpCreate)
	{
		return DefWindowProc(
					GetWindowHandle (),
					WM_NCCREATE,
					hNew,
					(long) lpCreate
			   );
	}

	METHOD WINDOW::WMNCDestroy()
	{
		return DefWindowProc(GetWindowHandle (), WM_NCDESTROY, NULL, NULL);
	}

	METHOD WINDOW::WMNCCalcSize(LPRECT lprt)
	{
		return DefWindowProc(
					GetWindowHandle (),
					WM_NCCALCSIZE,
					NULL,
					(long) lprt
			   );
	}

	METHOD WINDOW::WMNCHitTest (POINT pt)
	{
		return DefWindowProc (
					GetWindowHandle (),
					WM_NCHITTEST,
					NULL,
					*  (long *) &pt
			   );
	}

	METHOD WINDOW::WMNCPaint (HRGN hRgn)
	{
		return DefWindowProc (GetWindowHandle (), WM_NCPAINT, hRgn, NULL);
	}

	METHOD WINDOW::WMNCActivate (BOOL bActive)
	{
		return DefWindowProc (GetWindowHandle (), WM_NCACTIVATE, bActive, NULL);
	}

	METHOD WINDOW::WMNCMouseMove (WORD wNCHitTest, POINT pt)
	{
		return DefWindowProc (
					GetWindowHandle (),
					WM_NCMOUSEMOVE,
					wNCHitTest,
					*  (long*) &pt
			   );
	}

	METHOD WINDOW::WMNCLButtonDown (WORD wNCHitTest, POINT pt)
	{
		return DefWindowProc (
					GetWindowHandle (),
					WM_NCLBUTTONDOWN,
					wNCHitTest,
					*  (long*) &pt
			   );
	}

	METHOD WINDOW::WMNCLButtonUp (WORD wNCHitTest, POINT pt)
	{
		return DefWindowProc (
					GetWindowHandle (),
					WM_NCLBUTTONUP,
					wNCHitTest,
					*  (long*) &pt
			   );
	}

	METHOD WINDOW::WMNCLButtonDblClk (WORD wNCHitTest, POINT pt)
	{
		return DefWindowProc (
					GetWindowHandle (),
					WM_NCLBUTTONDBLCLK,
					wNCHitTest,
					*  (long*) &pt
			   );
	}

