// BITMAP.C
// Copyright (C) 1991 by Borland International, Inc.  All Rights Reserved

//...........................................................................
// FUNCTION TO DO ALL THE HARD WORK ASSOCIATED WITH DRAWING A BITMAP

void FAR PASCAL DrawBitmap(HDC hDC, HBITMAP hBitmap, short x, short y,
    DWORD dwRop)
{
  BITMAP	bm;
  HDC		hdcMem;
  POINT	ptSize, ptOrg;

  hdcMem = CreateCompatibleDC(hDC);
  SelectObject(hdcMem, hBitmap);
  SetMapMode(hdcMem, GetMapMode(hDC));

  GetObject(hBitmap, sizeof(BITMAP), (LPSTR) &bm);
  ptSize.x = bm.bmWidth;
  ptSize.y = bm.bmHeight;
  DPtoLP(hDC, &ptSize, 1);

  ptOrg.x = 0;
  ptOrg.y = 0;
  DPtoLP(hdcMem, &ptOrg, 1);

  BitBlt(hDC, x, y, ptSize.x, ptSize.y, hdcMem,
  			ptOrg.x, ptOrg.y, dwRop);

  DeleteDC(hdcMem);
}

//...........................................................................
// SAMPLE FUNCTION TO BE CALLED DURING A WM_PAINT MESSAGE TO DRAW BITMAP

void FAR PASCAL PaintHandler(HWND hWnd, WORD wParam, LONG lParam)
{
    HDC hDC;
    PAINTSTRUCT ps;
    HBITMAP hBitmap;
    HANDLE hInst;
    int x, y;
    DWORD RopCode;

    x = 0;                  // X Coordinate in window for bitmap
    y = 0;                  // Y Coordinate in window for bitmap
    RopCode = SRCCOPY;      // How Windows is to draw bitmap on window

    // Start Paint Sequence
    hDC = BeginPaint(hWnd, &ps);

    // Get hInstace of Bitmap (from main window for .EXE file)
    hInst = GetWindowWord(hWnd, GWW_HINSTANCE);

    // Load bitmap using hInstance and resource id
    hBitmap = LoadBitmap(hInst, MAKEINTRESOURCE(SOME_POUND_DEFINE));

    // Call function to actually paint the bitmap into the window
    DrawBitmap(hDC, hBitmap, x, y, RopCode);

    // End the paint sequence
    EndPaint(hWnd, &ps);

    // Free resources used by bitmap
    DeleteObject(hBitmap);
}

/* The bitmap must be in the .EXE file.  This can be done in the
   resource script, or by using WRT to load the bitmap into the .EXE
   file.  You must associate a number (#define) with the bitmap in the
   .EXE file (WRT allows you to do this too).

*/

//............................................................................




