//..........................................................................
// MAKECUR.CPP
// Copyright (c) 1992 Borland International, Inc.  All Rights Reserved.
//..........................................................................
// $id: ssvcid cursor.cpp 1.1 May 6, 1992 7:02:59 PM$
//..........................................................................
// Author:    Kevin Kahl
// Date  :    11-15-91
//..........................................................................

//..........................................................................

HCURSOR MakeCursor(HWND hWnd, HBITMAP hBitmap, POINT *pPoint)
{
  HDC hDCColor, hDCMono;
  HDC hDC;
  HBITMAP   hBmpOld;
  HBITMAP   hAndBmp;
  HBITMAP   hXorBmp;
  HCURSOR   hNewCursor;
  BITMAP    bm;
  DWORD     dwBytes;
  NPSTR     andBits;
  NPSTR     xorBits;

  hDC = GetDC(hWnd);
  hDCColor = CreateCompatibleDC(hDC);
  hDCMono = CreateCompatibleDC(hDC);
  hAndBmp = CreateCompatibleBitmap(hDCMono, 32, 32);
  hXorBmp = CreateCompatibleBitmap(hDCMono, 32, 32);

  hBmpOld = SelectObject(hDCColor, hBitmap);
  SelectObject(hDCMono, hAndBmp);
  SetBkColor(hDCColor, RGB(191, 191, 191));

  BitBlt(hDCMono, 0, 0, 32, 32, hDCColor, 0, 0, SRCCOPY);

  // Now we have the AND Mask

  GetObject(hAndBmp, sizeof(BITMAP), (LPSTR) &bm);
  dwBytes = (bm.bmWidthBytes * bm.bmHeight);
  andBits = (NPSTR) LocalAlloc(LPTR, dwBytes);
  GetBitmapBits(hAndBmp, dwBytes, andBits);

  SelectObject(hDCMono, hXorBmp);
  SetBkColor(hDCColor, RGB(0, 0, 0));

  BitBlt(hDCMono, 0, 0, 32, 32, hDCColor, 0, 0, SRCCOPY);

  // Now we have the XOR Mask

  GetObject(hXorBmp, sizeof(BITMAP), (LPSTR) &bm);
  dwBytes = (bm.bmWidthBytes * bm.bmHeight);
  xorBits = (NPSTR) LocalAlloc(LPTR, dwBytes);
  GetBitmapBits(hXorBmp, dwBytes, xorBits);

  if (pPoint->x > 32)
    pPoint->x = 32;
  if (pPoint->y > 32)
    pPoint->y = 32;

  hNewCursor = CreateCursor(GetWindowWord(hWnd, GWW_HINSTANCE),
                            pPoint->x, pPoint->y, 32, 32, andBits, xorBits);

  SelectObject(hDCColor, hBmpOld);
  SelectObject(hDCMono, hBmpOld);
  DeleteDC(hDCColor);
  DeleteDC(hDCMono);
  DeleteObject(hAndBmp);
  DeleteObject(hXorBmp);
  ReleaseDC(hWnd, hDC);
  LocalUnlock(LocalHandle((WORD) andBits));
  LocalUnlock(LocalHandle((WORD) xorBits));
  LocalFree(LocalHandle((WORD) andBits));
  LocalFree(LocalHandle((WORD) xorBits));
  return hNewCursor;
}
