#define _APP_C
//----------------------------------------------------------------- 
// APP.C - <description> 
// 
// MAKEMDI adaptation of Windows 3.1 SDK MAKEAPP system. 
// 
// MDI application design based on Chapter 7 of	 
// "Windows 3: A Developer's Guide" by Jeffrey Richter. 
// 
// Adaptation developed with permission of the author by  
// John F. Holliday, Technisoft Corporation 
// Telephone: (515) 472-9803, CompuServe: 71271,634 
//
// [DMM]	25-Nov-1992: Fixed crashing on exit
//			Also tabified file to tabsize of 4
//
//			David M. Miller, Business Visions, Inc.
//			Telephone: (212) 747-6118
//			CompuServe: 72676,327
//			internet: dmiller@hera.sbi.com
//----------------------------------------------------------------- 
#include "makemdi.h"


APP				g_app;


int PASCAL		WinMain(HINSTANCE hinst, HINSTANCE hinstPrev,
										LPSTR lpszCmdLine, int cmdShow)
{
	int				exitCode = 1;

	// Initialize the APP structure 
	// 
	g_app.hinst = hinst;
	g_app.hinstPrev = hinstPrev;
	g_app.lpszCmdLine = lpszCmdLine;
	g_app.cmdShow = cmdShow;
	g_app.hWndFrame = NULL;

	// Initialize, run, and terminate the application 
	// 

	if (App_Initialize(&g_app)) {
		exitCode = App_Main(&g_app);
		App_Terminate(&g_app, FALSE);
	}

	return exitCode;
}




int				App_Main(APP * papp)
{
	while (TRUE) {
		MSG				msg;

		// If a message exists in the queue, translate and dispatch it. 
		// 
		if (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE)) {
			// If it's time to quit, return exit code 
			// 
			if (msg.message == WM_QUIT)
				return (int) msg.wParam;

			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		else {
			// No messages: do idle processing. 
			// If the app is idle, just wait for another message. 
			// 
			if (App_Idle(papp))
				WaitMessage();
		}
	}
}




BOOL			App_Initialize(APP * papp)
{
	BOOL			bResult = FALSE;

	if (papp->hinstPrev) {
		// Only one instance allowed. 

		HWND			hWnd, hWnd1;

		hWnd = FindWindow(CLASS_FRAME, NULL);

		if (IsWindow(hWnd)) {
			hWnd1 = GetLastActivePopup(hWnd);

			if (IsWindow(hWnd1))
				hWnd = hWnd1;

			BringWindowToTop(hWnd);

			if (IsIconic(hWnd))
				ShowWindow(hWnd, SW_RESTORE);

			SetFocus(hWnd);
		}

		return FALSE;
	}

	// Initialize the frame class and all MDI child window classes 
	// before creating and showing the top level frame instance. 

	if (Frame_Initialize(papp) && Client_Initialize(papp)) {
		LoadString(papp->hinst, IDS_APPNAME, papp->szName, sizeof(papp->szName));
		LoadString(papp->hinst, IDS_APPCAPTION, papp->szBuf, sizeof(papp->szBuf));

		papp->hWndFrame = Frame_CreateWindow(
												papp->szBuf,
												CW_USEDEFAULT, CW_USEDEFAULT,
												CW_USEDEFAULT, CW_USEDEFAULT,
												papp->hinst);

		if (papp->hWndFrame != NULL) {
			bResult = TRUE;
			ShowWindow(papp->hWndFrame, papp->cmdShow);
		}
	}

	return bResult;
}




void			App_Terminate(APP * papp, BOOL fEndSession)
//----------------------------------------------------------------- 
// Flush any caches and buffers to disk, if necessary. 
// 
// If fEndSession is TRUE, it is not necessary to 
// destroy windows, GDI objects, or free memory. 
//----------------------------------------------------------------- 
{
	if (!fEndSession) {
		Client_Terminate(papp);
		Frame_Terminate(papp);
	}
}




BOOL			App_Idle(APP * papp)
//----------------------------------------------------------------- 
// Return TRUE if the app is idle, FALSE if there is more work to do. 
// 
// NOTE: To implement background processing, perform the next chunk 
// of the pending background process now, then return FALSE if there 
// is more background processing to be done.  Return TRUE only if 
// all background processing is completed. 
//----------------------------------------------------------------- 
{
	return TRUE;
}
