#ifndef _INC_APP
#define _INC_APP
#pragma comment (user,"Compiled on " __DATE__ " at " __TIME__)
// ==========================================================Purpose 
// APP.H 
// 
// MAKEMDI adaptation of Windows 3.1 SDK MAKEAPP system. 
// 
// MDI application design based on Chapter 7 of	 
// "Windows 3: A Developer's Guide" by Jeffrey Richter. 
// 
// Adaptation developed with permission of the author by  
// John F. Holliday, Technisoft Corporation 
// Telephone: (515) 472-9803, CompuServe: 71271,634 
//
// [DMM]	25-Nov-1992: Fixed crashing on exit
//			Also tabified file to tabsize of 4
//
//			David M. Miller, Business Visions, Inc.
//			Telephone: (212) 747-6118
//			CompuServe: 72676,327
//			internet: dmiller@hera.sbi.com
// ==========================================================Private 

typedef struct tagAPP {
	MSG				msg;				// message buffer 
	HINSTANCE		hinst;				// current instance handle 
	HINSTANCE		hinstPrev;			// previous instance handle 
	HANDLE			hAccelTable;		// Handle to active accelerator table. 
	LPSTR			lpszCmdLine;		// command line arguments 
	int				cmdShow;			// initial ShowWindow style 
	HWND			hWndFrame;			// frame window handle 
	char			szName[100];		// application name 
	char			szBuf[255];			// scratch buffer 
	char			szFmt[100];			// format buffer 
	char			szCap[100];			// caption buffer 
}				APP;


BOOL			App_Initialize(APP * papp);
int				App_Main(APP * papp);
VOID			App_Terminate(APP * papp, BOOL fEndSession);
BOOL			App_Idle(APP * papp);

//-Messages-------------------------------------------------------- 

#define FW_MDICHILDDESTROY	  (WM_USER + 0)		// Frame messages 
#define FW_RESIZEMDICLIENT	  (WM_USER + 1)
#define FW_GETSTATBARRECT	  (WM_USER + 2)
#define FW_SETMENUHELP		  (WM_USER + 3)
#define FW_GETMENUHELP		  (WM_USER + 4)
#define FW_DRAWSTATUSDIVIDE	  (WM_USER + 5)

#define AW_PAINTMENUHELP	  (WM_USER + 100)	// Application messages 


#define AC_PAINTSTATBAR		  (WM_USER + 200)	// MDI child messages 



//-----------------------------------------------------------Public 

int PASCAL		WinMain(HINSTANCE, HINSTANCE, LPSTR, int);


//----------------------------------------------------------Globals 

extern APP		g_app;

//--------------------------------------------------------------End 
#endif							// !_INC_APP 
