#ifndef CLASS_CHART
#define CLASS_CHART "MakeMDI_Chart"
// ==========================================================Purpose 
// CHART.H - MDI Chart window managment. 
// 
// MAKEMDI adaptation of Windows 3.1 SDK MAKEAPP system. 
// 
// MDI application design based on Chapter 7 of	 
// "Windows 3: A Developer's Guide" by Jeffrey Richter. 
// 
// Adaptation developed with permission of the author by  
// John F. Holliday, Technisoft Corporation 
// Telephone: (515) 472-9803, CompuServe: 71271,634 
//
// [DMM]	25-Nov-1992: Fixed crashing on exit
//			Also tabified file to tabsize of 4
//
//			David M. Miller, Business Visions, Inc.
//			Telephone: (212) 747-6118
//			CompuServe: 72676,327
//			internet: dmiller@hera.sbi.com
// ==========================================================Private 

// Window procedure 

LRESULT CALLBACK _export Chart_WndProc(HWND, UINT, WPARAM, LPARAM);


// Default message handler 

#define Chart_DefProc				DefMDIChildProc


// Instance data structure 

typedef struct tagCHART {
	HWND			hWnd;
	HWND			hWndPrevChild;
	HMENU			hMenu;
	HANDLE			hAccelTable;
	COLORREF		clrText;
	LPCSTR			lpszText;
}				CHART;


// Instance data pointer access functions 

#if defined(M_I86SM) | defined(M_I86MM)
#define Chart_GetPtr(hWnd)			   (CHART*)GetWindowWord((hWnd), 0)
#define Chart_SetPtr(hWnd, pchart)	   (CHART*)SetWindowWord((hWnd), 0, (WORD)(pchart))
#else
#define Chart_GetPtr(hWnd)			   (CHART*)GetWindowLong((hWnd), 0)
#define Chart_SetPtr(hWnd, pchart)	   (CHART*)SetWindowLong((hWnd), 0, (LONG)(pchart))
#endif

// Message handler functions 

BOOL			Chart_OnCreate(CHART *, CREATESTRUCT FAR *);
int				Chart_OnMouseActivate(CHART *, HWND, UINT, UINT);
void			Chart_OnMenuSelect(CHART *, HMENU, int, HMENU, UINT);
void			Chart_OnEnterIdle(CHART *, UINT, HWND);
BOOL			Chart_OnSetCursor(CHART *, HWND, UINT, UINT);
void			Chart_OnLButtonDown(CHART *, BOOL, int, int, UINT);
void			Chart_OnClose(CHART *);

void			Chart_OnMdiActivate(CHART *, BOOL, HWND, HWND);
void			Chart_OnDestroy(CHART *);
void			Chart_OnPaint(CHART *);
BOOL			Chart_OnEraseBkgnd(CHART *, HDC);
BOOL			Chart_OnQueryEndSession(CHART *);
void			Chart_OnEndSession(CHART *, BOOL);
void			Chart_OnCommand(CHART *, int, HWND, UINT);
void			Chart_OnPaintStatBar(CHART *, HDC, LPPAINTSTRUCT);
void			Chart_OnPaintMenuHelp(CHART *, LPPAINTSTRUCT);


// ===========================================================Public 

BOOL			Chart_Initialize(APP * papp);
void			Chart_Terminate(APP * papp);

HWND			Chart_CreateWindow(HWND hWndParent, int x, int y, int cx, int cy, BOOL fVisible, COLORREF clrText, LPCSTR lpszText);

// ==============================================================End 
#endif							// !CLASS_CHART
